/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.Util;
import java.sql.Timestamp;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import ome.conditions.InternalException;
import ome.io.nio.OriginalFilesService;
import ome.model.IObject;
import ome.model.enums.Format;
import ome.model.internal.Permissions;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.FileMaker;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import omero.ServerError;
import omero.ValidationException;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.ThumbnailStorePrx;
import omero.grid.RepositoryPrx;
import omero.grid.RepositoryPrxHelper;
import omero.grid._InternalRepositoryDisp;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.transaction.annotation.Transactional;

public class LegacyRepositoryI
extends _InternalRepositoryDisp {
    private static final Log log = LogFactory.getLog(LegacyRepositoryI.class);
    private final ObjectAdapter oa;
    private final Registry reg;
    private final Executor ex;
    private final Principal p;
    private final OriginalFilesService fs;
    private final FileMaker fileMaker;
    private OriginalFile description;
    private RepositoryPrx proxy;
    private String repoUuid;
    private volatile AtomicReference<State> state = new AtomicReference();

    public LegacyRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, String sessionUuid, String repoDir) {
        this(oa, reg, ex, sessionUuid, new FileMaker(repoDir));
    }

    public LegacyRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, String sessionUuid, FileMaker fileMaker) {
        this.state.set(State.EAGER);
        this.p = new Principal(sessionUuid, "system", "Internal");
        this.oa = oa;
        this.ex = ex;
        this.reg = reg;
        this.fileMaker = fileMaker;
        this.fs = new OriginalFilesService(fileMaker.getDir());
        log.info((Object)("Initializing repository in " + fileMaker.getDir()));
    }

    public boolean takeover() {
        if (!this.state.compareAndSet(State.EAGER, State.WAITING)) {
            log.debug((Object)"Skipping takeover");
            return false;
        }
        Object rv = null;
        try {
            rv = this.ex.execute(this.p, (Executor.Work)new GetOrCreateRepo(this));
            if (rv == null) {
                if (!this.state.compareAndSet(State.WAITING, State.ACTIVE)) {
                    log.debug((Object)"Could not set state to ACTIVE");
                }
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error in called executor", (Throwable)e);
        }
        log.error((Object)"Failed during repository takeover", (Throwable)((Exception)rv));
        this.state.compareAndSet(State.WAITING, State.EAGER);
        return false;
    }

    public void close() {
        this.state.set(State.CLOSED);
        log.info((Object)("Releasing " + this.fileMaker.getDir()));
        this.fileMaker.close();
    }

    public Communicator getCommunicator() {
        return this.oa.getCommunicator();
    }

    public ObjectAdapter getObjectAdapter() {
        return this.oa;
    }

    public OriginalFile getDescription(Current __current) {
        return this.description;
    }

    public RepositoryPrx getProxy(Current __current) {
        return this.proxy;
    }

    public String getFilePath(final OriginalFile file, Current __current) throws ServerError {
        if (file == null || file.getId() == null) {
            throw new ValidationException(null, null, "Unmanaged file");
        }
        Integer count = (Integer)this.ex.executeStateless((Executor.StatelessWork)new Executor.SimpleStatelessWork(this, "getFileUrl"){

            @Transactional(readOnly=true)
            public Object doWork(SimpleJdbcOperations jdbc) {
                return jdbc.queryForInt("select count(*) from originalfile where id = ? and url is null", new Object[]{file.getId().getValue()});
            }
        });
        if (count == 0) {
            throw new ValidationException(null, null, "Does not belong to this repository");
        }
        return this.fs.getFilesPath(Long.valueOf(file.getId().getValue()));
    }

    public RawFileStorePrx createRawFileStore(OriginalFile file, Current __current) {
        return null;
    }

    public RawPixelsStorePrx createRawPixelsStore(OriginalFile file, Current __current) {
        return null;
    }

    public RenderingEnginePrx createRenderingEngine(OriginalFile file, Current __current) {
        return null;
    }

    public ThumbnailStorePrx createThumbnailStore(OriginalFile file, Current __current) {
        return null;
    }

    class GetOrCreateRepo
    extends Executor.SimpleWork {
        LegacyRepositoryI repo;

        public GetOrCreateRepo(LegacyRepositoryI repo) {
            super((Object)repo, "takeover", new Object[0]);
            this.repo = repo;
        }

        @Transactional(readOnly=false)
        public Object doWork(Session session, ServiceFactory sf) {
            try {
                ome.model.core.OriginalFile r;
                String line;
                if (LegacyRepositoryI.this.fileMaker.needsInit()) {
                    LegacyRepositoryI.this.fileMaker.init(sf.getConfigService().getDatabaseUuid());
                }
                if ((line = LegacyRepositoryI.this.fileMaker.getLine()) == null) {
                    LegacyRepositoryI.this.repoUuid = UUID.randomUUID().toString();
                    r = new ome.model.core.OriginalFile();
                    r.setSha1(LegacyRepositoryI.this.repoUuid);
                    r.setName(LegacyRepositoryI.this.fileMaker.getDir());
                    r.setPath("/");
                    Timestamp t = new Timestamp(System.currentTimeMillis());
                    r.setAtime(t);
                    r.setMtime(t);
                    r.setCtime(t);
                    r.setFormat(new Format("Directory"));
                    r.setSize(Long.valueOf(0L));
                    r.getDetails().setPermissions(Permissions.WORLD_IMMUTABLE);
                    r = (ome.model.core.OriginalFile)sf.getUpdateService().saveAndReturnObject((IObject)r);
                    LegacyRepositoryI.this.description = new OriginalFileI(r.getId(), false);
                    LegacyRepositoryI.this.fileMaker.writeLine(LegacyRepositoryI.this.repoUuid);
                    log.info((Object)("Registered new repository: " + LegacyRepositoryI.this.repoUuid));
                } else {
                    LegacyRepositoryI.this.repoUuid = line;
                    r = (ome.model.core.OriginalFile)sf.getQueryService().findByString(ome.model.core.OriginalFile.class, "sha1", LegacyRepositoryI.this.repoUuid);
                    if (r == null) {
                        throw new InternalException("Can't find repository object: " + line);
                    }
                    if (!r.getDetails().getPermissions().isGranted(Permissions.Role.WORLD, Permissions.Right.READ)) {
                        log.warn((Object)"Making repository readable...");
                        r.getDetails().setPermissions(Permissions.WORLD_IMMUTABLE);
                        sf.getUpdateService().saveObject((IObject)r);
                    }
                    LegacyRepositoryI.this.description = new OriginalFileI(r.getId(), false);
                    log.info((Object)("Opened repository: " + LegacyRepositoryI.this.repoUuid));
                }
                PublicRepositoryI pr = new PublicRepositoryI(LegacyRepositoryI.this.description.getId().getValue(), LegacyRepositoryI.this.ex, LegacyRepositoryI.this.p);
                Identity internal = Util.stringToIdentity((String)("InternalRepository-" + LegacyRepositoryI.this.repoUuid));
                Identity external = Util.stringToIdentity((String)("PublicRepository-" + LegacyRepositoryI.this.repoUuid));
                ObjectPrx internalObj = LegacyRepositoryI.this.oa.add((Ice.Object)this.repo, internal);
                ObjectPrx externalObj = LegacyRepositoryI.this.oa.add((Ice.Object)pr, external);
                LegacyRepositoryI.this.reg.addObject(internalObj);
                LegacyRepositoryI.this.reg.addObject(externalObj);
                LegacyRepositoryI.this.proxy = RepositoryPrxHelper.uncheckedCast(externalObj);
                LegacyRepositoryI.this.oa.activate();
                log.info((Object)"Repository now active");
                return null;
            }
            catch (Exception e) {
                LegacyRepositoryI.this.fileMaker.close();
                return e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ACTIVE,
        EAGER,
        WAITING,
        CLOSED;

    }
}

