/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import java.util.List;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import omero.RTime;
import omero.ServerError;
import omero.ValidationException;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.ThumbnailStorePrx;
import omero.grid.RepositoryPrx;
import omero.grid._RepositoryDisp;
import omero.model.Format;
import omero.model.OriginalFileI;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicRepositoryI
extends _RepositoryDisp {
    private static final Log log = LogFactory.getLog(PublicRepositoryI.class);
    private final long id;
    private final Executor executor;
    private final Principal principal;

    public PublicRepositoryI(long repoObjectId, Executor executor, Principal principal) throws Exception {
        this.id = repoObjectId;
        this.executor = executor;
        this.principal = principal;
    }

    @Override
    public omero.model.OriginalFile root(Current __current) throws ServerError {
        return new OriginalFileI(this.id, false);
    }

    @Override
    public omero.model.OriginalFile register(String path, Format fmt, Current __current) throws ServerError {
        if (path == null || fmt == null || fmt.getId() == null && fmt.getValue() == null) {
            throw new ValidationException(null, null, "path and fmt are required arguments");
        }
        OriginalFileI file = new OriginalFileI();
        file.setPath(rtypes.rstring(path));
        file.setFormat(fmt);
        RTime creation = rtypes.rtime(System.currentTimeMillis());
        file.setCtime(creation);
        file.setAtime(creation);
        file.setMtime(creation);
        file.setSha1(rtypes.rstring("UNKNOWN"));
        file.setName(rtypes.rstring(path));
        file.setPath(rtypes.rstring(path));
        file.setSize(rtypes.rlong(0L));
        IceMapper mapper = new IceMapper();
        final OriginalFile f = (OriginalFile)mapper.reverse((Object)file);
        Long id = (Long)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "saveNewOriginalFile", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return ((OriginalFile)sf.getUpdateService().saveAndReturnObject((IObject)f)).getId();
            }
        });
        file.setId(rtypes.rlong(id));
        file.unload();
        return file;
    }

    @Override
    public void delete(String path, Current __current) throws ServerError {
    }

    @Override
    public List<String> list(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public List<String> listDirs(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public List<String> listFiles(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public omero.model.OriginalFile load(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public RawPixelsStorePrx pixels(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public RawFileStorePrx read(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public void rename(String path, Current __current) throws ServerError {
    }

    @Override
    public RenderingEnginePrx render(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public ThumbnailStorePrx thumbs(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public void transfer(String srcPath, RepositoryPrx target, String targetPath, Current __current) throws ServerError {
    }

    @Override
    public RawFileStorePrx write(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public List<omero.model.OriginalFile> listKnown(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public List<omero.model.OriginalFile> listKnownDirs(String path, Current __current) throws ServerError {
        return null;
    }

    @Override
    public List<omero.model.OriginalFile> listKnownFiles(String path, Current __current) throws ServerError {
        return null;
    }
}

