/*
 * Decompiled with CFR 0.152.
 */
package ome.services.scripts;

import java.io.File;
import java.sql.Timestamp;
import java.util.List;
import ome.api.RawFileStore;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.enums.Format;
import ome.model.internal.Permissions;
import ome.parameters.Parameters;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.Utils;
import omero.model.OriginalFileI;
import omero.model.ScriptJob;
import omero.model.ScriptJobI;
import omero.rtypes;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptUploader {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Principal principal;
    private final Executor ex;
    private final File source;
    private final Object[] mutex = new Object[0];
    private OriginalFile file = null;

    public ScriptUploader(String uuid, Executor executor, File source) {
        this(new Principal(uuid, "system", "Internal"), executor, source);
    }

    public ScriptUploader(Principal principal, Executor executor, File source) {
        this.principal = principal;
        this.ex = executor;
        this.source = source;
        if (!this.source.exists()) {
            this.log.error((Object)("SERVER IMPROPERLY CONFIGURED - CANNOT FIND " + source.getAbsolutePath()));
            return;
        }
        this.init();
    }

    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            if (this.file != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                final byte[] buf = FileUtils.readFileToByteArray((File)this.source);
                final String sha1 = Utils.bufferToSha1((byte[])buf);
                this.log.info((Object)("Script found: " + sha1));
                this.file = (OriginalFile)this.ex.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, this.getName(), new Object[0]){

                    @Transactional(readOnly=false)
                    public Object doWork(Session session, ServiceFactory sf) {
                        Parameters p = new Parameters();
                        p.addString("sha1", sha1);
                        p.addString("name", ScriptUploader.this.getName());
                        List<OriginalFile> files = ScriptUploader.this.loadScripts(sf, p);
                        if (files.size() < 1) {
                            ScriptUploader.this.log.info((Object)"Creating script");
                            return ScriptUploader.this.createScript(buf, sha1, sf);
                        }
                        if (files.size() > 1) {
                            ScriptUploader.this.log.warn((Object)"Multiple scripts found");
                        }
                        return files.get(0);
                    }
                });
                if (!this.file.getDetails().getPermissions().isGranted(Permissions.Role.WORLD, Permissions.Right.READ)) {
                    this.log.warn((Object)"Making script readable...");
                    this.ex.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "chmodScript", new Object[0]){

                        @Transactional(readOnly=false)
                        public Object doWork(Session session, ServiceFactory sf) {
                            sf.getAdminService().changePermissions((IObject)ScriptUploader.this.file, Permissions.WORLD_IMMUTABLE);
                            return null;
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register script", e);
            }
            return;
        }
    }

    protected List<OriginalFile> loadScripts(ServiceFactory sf, Parameters p) {
        List files = sf.getQueryService().findAllByQuery("select f from OriginalFile f where f.sha1 = :sha1 and f.name = :name and f.format.value = 'text/x-python'", p);
        return files;
    }

    protected OriginalFile createScript(byte[] buf, String sha1, ServiceFactory sf) {
        OriginalFile file = new OriginalFile();
        file.setName(this.getName());
        file.setSha1(sha1);
        Timestamp t = new Timestamp(System.currentTimeMillis());
        file.setAtime(t);
        file.setCtime(t);
        file.setMtime(t);
        file.setPath("lib/python/" + this.getName());
        file.setSize(Long.valueOf(buf.length));
        file.setFormat(new Format("text/x-python"));
        file.getDetails().setPermissions(Permissions.WORLD_IMMUTABLE);
        file = (OriginalFile)sf.getUpdateService().saveAndReturnObject((IObject)file);
        RawFileStore rfs = sf.createRawFileStore();
        rfs.setFileId(file.getId().longValue());
        rfs.write(buf, 0L, buf.length);
        rfs.close();
        return file;
    }

    public ScriptJob createJob() {
        ScriptJobI job = new ScriptJobI();
        job.linkOriginalFile(new OriginalFileI(this.file.getId(), false));
        job.setDescription(rtypes.rstring(this.getName()));
        return job;
    }
}

