/*
 * Decompiled with CFR 0.152.
 */
package ome.services.throttling;

import ome.conditions.OverUsageException;
import ome.services.messages.stats.AbstractStatsMessage;
import ome.services.messages.stats.ObjectsReadStatsMessage;
import ome.services.messages.stats.ObjectsWrittenStatsMessage;
import ome.services.throttling.ThrottlingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractThrottlingStrategy
implements ThrottlingStrategy {
    protected final Log log = LogFactory.getLog(this.getClass());

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ObjectsReadStatsMessage) {
            ObjectsReadStatsMessage read = (ObjectsReadStatsMessage)event;
            this.handle((AbstractStatsMessage)read, read.getObjectsRead() + " objects read.");
        } else if (event instanceof ObjectsWrittenStatsMessage) {
            ObjectsWrittenStatsMessage written = (ObjectsWrittenStatsMessage)event;
            this.handle((AbstractStatsMessage)written, written.getObjectsWritten() + " objects written.");
        }
    }

    private void handle(AbstractStatsMessage event, String msg) {
        if (event.isHard()) {
            throw new OverUsageException(String.format("Aborting execution: Reason = \"%s\"", msg));
        }
        this.log.info((Object)("Blocking for 5 seconds: " + msg));
        while (System.currentTimeMillis() < event.getTimestamp() + 5000L) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

