/*
 * Decompiled with CFR 0.152.
 */
package ome.services.throttling;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.services.throttling.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Queue {
    private static final Log log = LogFactory.getLog(Queue.class);
    private final BlockingQueue<Callback> q = new LinkedBlockingQueue<Callback>();
    private final AtomicBoolean done = new AtomicBoolean();

    public Queue() {
        this.done.set(false);
    }

    public void put(Callback callback) {
        block4: {
            boolean cont;
            boolean bl = cont = !this.done.get();
            if (cont) {
                while (true) {
                    try {
                        this.q.put(callback);
                        break block4;
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)"Queue interrupted during put");
                        continue;
                    }
                    break;
                }
            }
            callback.exception(new CancelledException());
        }
    }

    public Callback take() {
        Callback cb = null;
        try {
            cb = this.q.take();
        }
        catch (InterruptedException e) {
            log.warn((Object)"Queue interrupted during take");
        }
        return cb;
    }

    public void destroy() {
        boolean wasDone = this.done.getAndSet(true);
        if (!wasDone) {
            for (Callback cb : this.q) {
                cb.exception(new CancelledException());
            }
        }
    }

    static class CancelledException
    extends Exception {
        CancelledException() {
        }
    }
}

