/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import loci.common.LogTools;
import loci.formats.FormatException;

public class ClassList {
    private Class base;
    private Vector classes;

    public ClassList(Class base) {
        this.base = base;
        this.classes = new Vector();
    }

    public ClassList(String file, Class base) throws IOException {
        this(file, base, ClassList.class);
    }

    public ClassList(String file, Class base, Class location) throws IOException {
        this.base = base;
        this.classes = new Vector();
        if (file == null) {
            return;
        }
        BufferedReader in = null;
        in = location == null ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader(location.getResourceAsStream(file)));
        while (true) {
            String line = null;
            line = in.readLine();
            if (line == null) break;
            int ndx = line.indexOf("#");
            if (ndx >= 0) {
                line = line.substring(0, ndx);
            }
            if ((line = line.trim()).equals("")) continue;
            Class<?> c = null;
            try {
                c = Class.forName(line);
            }
            catch (ClassNotFoundException exc) {
                LogTools.traceDebug(exc);
            }
            catch (NoClassDefFoundError err) {
                LogTools.traceDebug(err);
            }
            catch (ExceptionInInitializerError err) {
                LogTools.traceDebug(err);
            }
            catch (RuntimeException exc) {
                String msg = exc.getMessage();
                if (msg != null && msg.indexOf("ClassNotFound") < 0) {
                    throw exc;
                }
                LogTools.traceDebug(exc);
            }
            if (c == null || base != null && !base.isAssignableFrom(c)) {
                LogTools.println("Error: \"" + line + "\" is not valid.");
                continue;
            }
            this.classes.add(c);
        }
        in.close();
    }

    public void addClass(Class c) throws FormatException {
        if (this.base != null && !this.base.isAssignableFrom(c)) {
            throw new FormatException("Class is not assignable to the base class");
        }
        this.classes.add(c);
    }

    public void removeClass(Class c) {
        this.classes.remove(c);
    }

    public Class[] getClasses() {
        Object[] c = new Class[this.classes.size()];
        this.classes.copyInto(c);
        return c;
    }
}

