/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.LocalException;
import IceInternal.Instance;
import IceInternal.Time;
import IceInternal.TimerTask;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;

public final class ConnectionMonitor
implements TimerTask {
    private Instance _instance;
    private Set<ConnectionI> _connections = new HashSet<ConnectionI>();

    public synchronized void destroy() {
        assert (this._instance != null);
        this._instance = null;
        this._connections = null;
    }

    public synchronized void add(ConnectionI connection) {
        assert (this._instance != null);
        this._connections.add(connection);
    }

    public synchronized void remove(ConnectionI connection) {
        assert (this._instance != null);
        this._connections.remove(connection);
    }

    ConnectionMonitor(Instance instance, int interval) {
        assert (interval > 0);
        this._instance = instance;
        this._instance.timer().scheduleRepeated(this, interval * 1000);
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._instance == null);
        Assert.FinalizerAssert(this._connections == null);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTimerTask() {
        HashSet<ConnectionI> connections = new HashSet<ConnectionI>();
        ConnectionMonitor connectionMonitor = this;
        synchronized (connectionMonitor) {
            if (this._instance == null) {
                return;
            }
            connections.clear();
            connections.addAll(this._connections);
        }
        long now = Time.currentMonotonicTimeMillis();
        for (ConnectionI connection : connections) {
            String s;
            PrintWriter pw;
            StringWriter sw;
            ConnectionMonitor connectionMonitor2;
            try {
                connection.monitor(now);
            }
            catch (LocalException ex) {
                connectionMonitor2 = this;
                synchronized (connectionMonitor2) {
                    if (this._instance == null) {
                        return;
                    }
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    s = "exception in connection monitor:\n" + sw.toString();
                    this._instance.initializationData().logger.error(s);
                }
            }
            catch (Exception ex) {
                connectionMonitor2 = this;
                synchronized (connectionMonitor2) {
                    if (this._instance == null) {
                        return;
                    }
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    s = "unknown exception in connection monitor:\n" + sw.toString();
                    this._instance.initializationData().logger.error(s);
                }
            }
        }
    }
}

