/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Detector;
import ome.model.enums.Binning;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="detectorsettings_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="detectorsettings_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="detectorsettings_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="detectorsettings_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="detectorsettings_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="detectorsettings_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="detectorsettings_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="detectorsettings_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="detectorsettings", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_detectorsettings", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_detectorsettings"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class DetectorSettings
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "detectorsettings_owner_filter";
    public static final String GROUP_FILTER = "detectorsettings_group_filter";
    public static final String EVENT_FILTER = "detectorsettings_event_filter";
    public static final String PERMS_FILTER = "detectorsettings_perms_filter";
    public static final String ID = "ome.model.acquisition.DetectorSettings_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.DetectorSettings_version";
    protected Integer version = 0;
    protected Double voltage = null;
    protected Double gain = null;
    protected Double offsetValue = null;
    protected Double readOutRate = null;
    protected Binning binning = null;
    protected Detector detector = null;
    protected ome.model.internal.Details details = new Details();
    public static final String VOLTAGE = "ome.model.acquisition.DetectorSettings_voltage";
    public static final String GAIN = "ome.model.acquisition.DetectorSettings_gain";
    public static final String OFFSETVALUE = "ome.model.acquisition.DetectorSettings_offsetValue";
    public static final String READOUTRATE = "ome.model.acquisition.DetectorSettings_readOutRate";
    public static final String BINNING = "ome.model.acquisition.DetectorSettings_binning";
    public static final String DETECTOR = "ome.model.acquisition.DetectorSettings_detector";
    public static final String DETAILS = "ome.model.acquisition.DetectorSettings_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public DetectorSettings() {
        this(null, true);
    }

    protected DetectorSettings(Long id) {
        this(id, true);
    }

    public DetectorSettings(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public DetectorSettings(Detector _detector) {
        this(null, true);
        this.setDetector(_detector);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_detectorsettings")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="voltage", updatable=true)
    public Double getVoltage() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.voltage;
    }

    public void setVoltage(Double voltage) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.voltage = voltage;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="gain", updatable=true)
    public Double getGain() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.gain;
    }

    public void setGain(Double gain) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.gain = gain;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="offsetValue", updatable=true)
    public Double getOffsetValue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.offsetValue;
    }

    public void setOffsetValue(Double offsetValue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.offsetValue = offsetValue;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="readOutRate", updatable=true)
    public Double getReadOutRate() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.readOutRate;
    }

    public void setReadOutRate(Double readOutRate) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.readOutRate = readOutRate;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Binning.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="binning", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKdetectorsettings_binning_binning")
    public Binning getBinning() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.binning;
    }

    public void setBinning(Binning binning) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.binning = binning;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Detector.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="detector", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKdetectorsettings_detector_detector")
    public Detector getDetector() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.detector;
    }

    public void setDetector(Detector detector) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.detector = detector;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public DetectorSettings newInstance() {
        return new DetectorSettings();
    }

    public DetectorSettings proxy() {
        return new DetectorSettings(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.voltage = (Double)__filter.filter(VOLTAGE, this.voltage);
            this.gain = (Double)__filter.filter(GAIN, this.gain);
            this.offsetValue = (Double)__filter.filter(OFFSETVALUE, this.offsetValue);
            this.readOutRate = (Double)__filter.filter(READOUTRATE, this.readOutRate);
            this.binning = (Binning)__filter.filter(BINNING, this.binning);
            this.detector = (Detector)__filter.filter(DETECTOR, this.detector);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(VOLTAGE)) {
            return this.getVoltage();
        }
        if (field.equals(GAIN)) {
            return this.getGain();
        }
        if (field.equals(OFFSETVALUE)) {
            return this.getOffsetValue();
        }
        if (field.equals(READOUTRATE)) {
            return this.getReadOutRate();
        }
        if (field.equals(BINNING)) {
            return this.getBinning();
        }
        if (field.equals(DETECTOR)) {
            return this.getDetector();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(VOLTAGE)) {
            this.setVoltage((Double)value);
        } else if (field.equals(GAIN)) {
            this.setGain((Double)value);
        } else if (field.equals(OFFSETVALUE)) {
            this.setOffsetValue((Double)value);
        } else if (field.equals(READOUTRATE)) {
            this.setReadOutRate((Double)value);
        } else if (field.equals(BINNING)) {
            this.setBinning((Binning)value);
        } else if (field.equals(DETECTOR)) {
            this.setDetector((Detector)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.voltage = null;
        this.gain = null;
        this.offsetValue = null;
        this.readOutRate = null;
        this.binning = null;
        this.detector = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(VOLTAGE);
        raw.add(GAIN);
        raw.add(OFFSETVALUE);
        raw.add(READOUTRATE);
        raw.add(BINNING);
        raw.add(DETECTOR);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKdetectorsettings_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKdetectorsettings_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKdetectorsettings_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKdetectorsettings_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKdetectorsettings_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

