/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.LogicalChannel;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.roi.Roi;
import ome.util.CBlock;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="shape_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="shape_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="shape_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="shape_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="shape_owner_filter_CHANNELS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="shape_group_filter_CHANNELS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="shape_event_filter_CHANNELS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="shape_perms_filter_CHANNELS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="shape_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="shape_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="shape_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="shape_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="shape", uniqueConstraints={@UniqueConstraint(columnNames={"roi", "roi_index"})})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorValue(value="")
@DiscriminatorColumn(name="discriminator", discriminatorType=DiscriminatorType.STRING)
@GenericGenerator(name="seq_shape", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_shape"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public abstract class Shape
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "shape_owner_filter";
    public static final String GROUP_FILTER = "shape_group_filter";
    public static final String EVENT_FILTER = "shape_event_filter";
    public static final String PERMS_FILTER = "shape_perms_filter";
    public static final String ID = "ome.model.roi.Shape_id";
    protected Long id;
    public static final String VERSION = "ome.model.roi.Shape_version";
    protected Integer version = 0;
    protected Integer theZ = null;
    protected Integer theT = null;
    protected Set<LogicalChannel> channels = new HashSet<LogicalChannel>();
    public static final String OWNER_FILTER_CHANNELS = "shape_owner_filter_CHANNELS";
    public static final String GROUP_FILTER_CHANNELS = "shape_group_filter_CHANNELS";
    public static final String EVENT_FILTER_CHANNELS = "shape_event_filter_CHANNELS";
    public static final String PERMS_FILTER_CHANNELS = "shape_perms_filter_CHANNELS";
    protected Roi roi = null;
    protected Boolean locked = null;
    protected String g = null;
    protected String transform = null;
    protected String vectorEffect = null;
    protected Boolean visibility = null;
    protected String fillColor = null;
    protected Float fillOpacity = null;
    protected String fillRule = null;
    protected String strokeColor = null;
    protected String strokeDashArray = null;
    protected Integer strokeDashOffset = null;
    protected String strokeLineCap = null;
    protected String strokeLineJoin = null;
    protected Integer strokeMiterLimit = null;
    protected Float strokeOpacity = null;
    protected Integer strokeWidth = null;
    protected ome.model.internal.Details details = new Details();
    public static final String THEZ = "ome.model.roi.Shape_theZ";
    public static final String THET = "ome.model.roi.Shape_theT";
    public static final String CHANNELS = "ome.model.roi.Shape_channels";
    public static final String ROI = "ome.model.roi.Shape_roi";
    public static final String LOCKED = "ome.model.roi.Shape_locked";
    public static final String G = "ome.model.roi.Shape_g";
    public static final String TRANSFORM = "ome.model.roi.Shape_transform";
    public static final String VECTOREFFECT = "ome.model.roi.Shape_vectorEffect";
    public static final String VISIBILITY = "ome.model.roi.Shape_visibility";
    public static final String FILLCOLOR = "ome.model.roi.Shape_fillColor";
    public static final String FILLOPACITY = "ome.model.roi.Shape_fillOpacity";
    public static final String FILLRULE = "ome.model.roi.Shape_fillRule";
    public static final String STROKECOLOR = "ome.model.roi.Shape_strokeColor";
    public static final String STROKEDASHARRAY = "ome.model.roi.Shape_strokeDashArray";
    public static final String STROKEDASHOFFSET = "ome.model.roi.Shape_strokeDashOffset";
    public static final String STROKELINECAP = "ome.model.roi.Shape_strokeLineCap";
    public static final String STROKELINEJOIN = "ome.model.roi.Shape_strokeLineJoin";
    public static final String STROKEMITERLIMIT = "ome.model.roi.Shape_strokeMiterLimit";
    public static final String STROKEOPACITY = "ome.model.roi.Shape_strokeOpacity";
    public static final String STROKEWIDTH = "ome.model.roi.Shape_strokeWidth";
    public static final String DETAILS = "ome.model.roi.Shape_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Shape() {
        this(null, true);
    }

    protected Shape(Long id) {
        this(id, true);
    }

    public Shape(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Shape(Roi _roi) {
        this(null, true);
        this.setRoi(_roi);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_shape")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="theZ", updatable=true)
    public Integer getTheZ() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.theZ;
    }

    public void setTheZ(Integer theZ) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.theZ = theZ;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="theT", updatable=true)
    public Integer getTheT() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.theT;
    }

    public void setTheT(Integer theT) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.theT = theT;
    }

    @OneToMany(mappedBy="shapes", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="shape_owner_filter_CHANNELS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="shape_group_filter_CHANNELS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="shape_event_filter_CHANNELS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="shape_perms_filter_CHANNELS", condition=":permsStr = permissions")})
    protected Set<LogicalChannel> getChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.channels;
    }

    protected void setChannels(Set<LogicalChannel> channels) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.channels = channels;
    }

    public int sizeOfChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.channels == null ? -1 : this.channels.size();
    }

    public Iterator<LogicalChannel> iterateChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            return new EmptyIterator<LogicalChannel>();
        }
        return this.getChannels().iterator();
    }

    public Collection<LogicalChannel> unmodifiableChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getChannels());
    }

    public <E> List<E> collectChannels(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<LogicalChannel> it = this.iterateChannels();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addLogicalChannel(LogicalChannel target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().add(target);
        target.setShapes(this);
    }

    public void addLogicalChannelSet(Collection<LogicalChannel> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().addAll(targets);
        for (LogicalChannel target : targets) {
            target.setShapes(this);
        }
    }

    public void removeLogicalChannel(LogicalChannel target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().remove(target);
        target.setShapes(null);
    }

    public void removeLogicalChannelSet(Collection<LogicalChannel> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().removeAll(targets);
        for (LogicalChannel target : targets) {
            target.setShapes(null);
        }
    }

    public void clearChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().clear();
        Iterator<LogicalChannel> it = this.iterateChannels();
        while (it.hasNext()) {
            LogicalChannel target = it.next();
            target.setShapes(null);
        }
    }

    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Roi.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="roi", nullable=false, unique=false, insertable=false, updatable=false)
    @ForeignKey(name="FKshape_roi_roi")
    public Roi getRoi() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.roi;
    }

    public void setRoi(Roi roi) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.roi = roi;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="locked", updatable=true)
    public Boolean getLocked() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.locked = locked;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="g", updatable=true)
    public String getG() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.g;
    }

    public void setG(String g) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.g = g;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="transform", updatable=true)
    public String getTransform() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.transform;
    }

    public void setTransform(String transform) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.transform = transform;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="vectorEffect", updatable=true)
    public String getVectorEffect() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.vectorEffect;
    }

    public void setVectorEffect(String vectorEffect) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.vectorEffect = vectorEffect;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="visibility", updatable=true)
    public Boolean getVisibility() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.visibility;
    }

    public void setVisibility(Boolean visibility) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.visibility = visibility;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="fillColor", updatable=true)
    public String getFillColor() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.fillColor = fillColor;
    }

    @Column(columnDefinition="double precision", nullable=true, unique=false, name="fillOpacity", updatable=true)
    public Float getFillOpacity() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.fillOpacity;
    }

    public void setFillOpacity(Float fillOpacity) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.fillOpacity = fillOpacity;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="fillRule", updatable=true)
    public String getFillRule() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.fillRule;
    }

    public void setFillRule(String fillRule) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.fillRule = fillRule;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="strokeColor", updatable=true)
    public String getStrokeColor() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.strokeColor;
    }

    public void setStrokeColor(String strokeColor) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.strokeColor = strokeColor;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="strokeDashArray", updatable=true)
    public String getStrokeDashArray() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.strokeDashArray;
    }

    public void setStrokeDashArray(String strokeDashArray) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.strokeDashArray = strokeDashArray;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="strokeDashOffset", updatable=true)
    public Integer getStrokeDashOffset() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.strokeDashOffset;
    }

    public void setStrokeDashOffset(Integer strokeDashOffset) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.strokeDashOffset = strokeDashOffset;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="strokeLineCap", updatable=true)
    public String getStrokeLineCap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.strokeLineCap;
    }

    public void setStrokeLineCap(String strokeLineCap) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.strokeLineCap = strokeLineCap;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="strokeLineJoin", updatable=true)
    public String getStrokeLineJoin() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.strokeLineJoin;
    }

    public void setStrokeLineJoin(String strokeLineJoin) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.strokeLineJoin = strokeLineJoin;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="strokeMiterLimit", updatable=true)
    public Integer getStrokeMiterLimit() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.strokeMiterLimit;
    }

    public void setStrokeMiterLimit(Integer strokeMiterLimit) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.strokeMiterLimit = strokeMiterLimit;
    }

    @Column(columnDefinition="double precision", nullable=true, unique=false, name="strokeOpacity", updatable=true)
    public Float getStrokeOpacity() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.strokeOpacity;
    }

    public void setStrokeOpacity(Float strokeOpacity) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.strokeOpacity = strokeOpacity;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="strokeWidth", updatable=true)
    public Integer getStrokeWidth() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.strokeWidth;
    }

    public void setStrokeWidth(Integer strokeWidth) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.strokeWidth = strokeWidth;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.theZ = (Integer)__filter.filter(THEZ, this.theZ);
            this.theT = (Integer)__filter.filter(THET, this.theT);
            this.channels = (Set)__filter.filter(CHANNELS, this.channels);
            this.roi = (Roi)__filter.filter(ROI, this.roi);
            this.locked = (Boolean)__filter.filter(LOCKED, this.locked);
            this.g = (String)__filter.filter(G, this.g);
            this.transform = (String)__filter.filter(TRANSFORM, this.transform);
            this.vectorEffect = (String)__filter.filter(VECTOREFFECT, this.vectorEffect);
            this.visibility = (Boolean)__filter.filter(VISIBILITY, this.visibility);
            this.fillColor = (String)__filter.filter(FILLCOLOR, this.fillColor);
            this.fillOpacity = (Float)__filter.filter(FILLOPACITY, this.fillOpacity);
            this.fillRule = (String)__filter.filter(FILLRULE, this.fillRule);
            this.strokeColor = (String)__filter.filter(STROKECOLOR, this.strokeColor);
            this.strokeDashArray = (String)__filter.filter(STROKEDASHARRAY, this.strokeDashArray);
            this.strokeDashOffset = (Integer)__filter.filter(STROKEDASHOFFSET, this.strokeDashOffset);
            this.strokeLineCap = (String)__filter.filter(STROKELINECAP, this.strokeLineCap);
            this.strokeLineJoin = (String)__filter.filter(STROKELINEJOIN, this.strokeLineJoin);
            this.strokeMiterLimit = (Integer)__filter.filter(STROKEMITERLIMIT, this.strokeMiterLimit);
            this.strokeOpacity = (Float)__filter.filter(STROKEOPACITY, this.strokeOpacity);
            this.strokeWidth = (Integer)__filter.filter(STROKEWIDTH, this.strokeWidth);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(THEZ)) {
            return this.getTheZ();
        }
        if (field.equals(THET)) {
            return this.getTheT();
        }
        if (field.equals(CHANNELS)) {
            return this.getChannels();
        }
        if (field.equals(ROI)) {
            return this.getRoi();
        }
        if (field.equals(LOCKED)) {
            return this.getLocked();
        }
        if (field.equals(G)) {
            return this.getG();
        }
        if (field.equals(TRANSFORM)) {
            return this.getTransform();
        }
        if (field.equals(VECTOREFFECT)) {
            return this.getVectorEffect();
        }
        if (field.equals(VISIBILITY)) {
            return this.getVisibility();
        }
        if (field.equals(FILLCOLOR)) {
            return this.getFillColor();
        }
        if (field.equals(FILLOPACITY)) {
            return this.getFillOpacity();
        }
        if (field.equals(FILLRULE)) {
            return this.getFillRule();
        }
        if (field.equals(STROKECOLOR)) {
            return this.getStrokeColor();
        }
        if (field.equals(STROKEDASHARRAY)) {
            return this.getStrokeDashArray();
        }
        if (field.equals(STROKEDASHOFFSET)) {
            return this.getStrokeDashOffset();
        }
        if (field.equals(STROKELINECAP)) {
            return this.getStrokeLineCap();
        }
        if (field.equals(STROKELINEJOIN)) {
            return this.getStrokeLineJoin();
        }
        if (field.equals(STROKEMITERLIMIT)) {
            return this.getStrokeMiterLimit();
        }
        if (field.equals(STROKEOPACITY)) {
            return this.getStrokeOpacity();
        }
        if (field.equals(STROKEWIDTH)) {
            return this.getStrokeWidth();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(THEZ)) {
            this.setTheZ((Integer)value);
        } else if (field.equals(THET)) {
            this.setTheT((Integer)value);
        } else if (field.equals(CHANNELS)) {
            this.setChannels((Set)value);
        } else if (field.equals(ROI)) {
            this.setRoi((Roi)value);
        } else if (field.equals(LOCKED)) {
            this.setLocked((Boolean)value);
        } else if (field.equals(G)) {
            this.setG((String)value);
        } else if (field.equals(TRANSFORM)) {
            this.setTransform((String)value);
        } else if (field.equals(VECTOREFFECT)) {
            this.setVectorEffect((String)value);
        } else if (field.equals(VISIBILITY)) {
            this.setVisibility((Boolean)value);
        } else if (field.equals(FILLCOLOR)) {
            this.setFillColor((String)value);
        } else if (field.equals(FILLOPACITY)) {
            this.setFillOpacity((Float)value);
        } else if (field.equals(FILLRULE)) {
            this.setFillRule((String)value);
        } else if (field.equals(STROKECOLOR)) {
            this.setStrokeColor((String)value);
        } else if (field.equals(STROKEDASHARRAY)) {
            this.setStrokeDashArray((String)value);
        } else if (field.equals(STROKEDASHOFFSET)) {
            this.setStrokeDashOffset((Integer)value);
        } else if (field.equals(STROKELINECAP)) {
            this.setStrokeLineCap((String)value);
        } else if (field.equals(STROKELINEJOIN)) {
            this.setStrokeLineJoin((String)value);
        } else if (field.equals(STROKEMITERLIMIT)) {
            this.setStrokeMiterLimit((Integer)value);
        } else if (field.equals(STROKEOPACITY)) {
            this.setStrokeOpacity((Float)value);
        } else if (field.equals(STROKEWIDTH)) {
            this.setStrokeWidth((Integer)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.theZ = null;
        this.theT = null;
        this.channels = null;
        this.roi = null;
        this.locked = null;
        this.g = null;
        this.transform = null;
        this.vectorEffect = null;
        this.visibility = null;
        this.fillColor = null;
        this.fillOpacity = null;
        this.fillRule = null;
        this.strokeColor = null;
        this.strokeDashArray = null;
        this.strokeDashOffset = null;
        this.strokeLineCap = null;
        this.strokeLineJoin = null;
        this.strokeMiterLimit = null;
        this.strokeOpacity = null;
        this.strokeWidth = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(THEZ);
        raw.add(THET);
        raw.add(CHANNELS);
        raw.add(ROI);
        raw.add(LOCKED);
        raw.add(G);
        raw.add(TRANSFORM);
        raw.add(VECTOREFFECT);
        raw.add(VISIBILITY);
        raw.add(FILLCOLOR);
        raw.add(FILLOPACITY);
        raw.add(FILLRULE);
        raw.add(STROKECOLOR);
        raw.add(STROKEDASHARRAY);
        raw.add(STROKEDASHOFFSET);
        raw.add(STROKELINECAP);
        raw.add(STROKELINEJOIN);
        raw.add(STROKEMITERLIMIT);
        raw.add(STROKEOPACITY);
        raw.add(STROKEWIDTH);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKshape_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKshape_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKshape_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKshape_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKshape_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

