/*
 * Decompiled with CFR 0.152.
 */
package ome.model.screen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.PlateAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.screen.Screen;
import ome.model.screen.ScreenPlateLink;
import ome.model.screen.Well;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="plate_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="plate_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="plate_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="plate_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="plate_owner_filter_SCREENLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="plate_group_filter_SCREENLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="plate_event_filter_SCREENLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="plate_perms_filter_SCREENLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="plate_owner_filter_WELLS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="plate_group_filter_WELLS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="plate_event_filter_WELLS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="plate_perms_filter_WELLS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="plate_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="plate_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="plate_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="plate_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="plate_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="plate_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="plate_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="plate_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="plate", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_plate", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_plate"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Plate
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "plate_owner_filter";
    public static final String GROUP_FILTER = "plate_group_filter";
    public static final String EVENT_FILTER = "plate_event_filter";
    public static final String PERMS_FILTER = "plate_perms_filter";
    public static final String ID = "ome.model.screen.Plate_id";
    protected Long id;
    public static final String VERSION = "ome.model.screen.Plate_version";
    protected Integer version = 0;
    protected Integer defaultSample = null;
    protected String columnNamingConvention = null;
    protected String rowNamingConvention = null;
    protected Double wellOriginX = null;
    protected Double wellOriginY = null;
    protected String status = null;
    protected String externalIdentifier = null;
    protected Set<ScreenPlateLink> screenLinks = new HashSet<ScreenPlateLink>();
    public static final String OWNER_FILTER_SCREENLINKS = "plate_owner_filter_SCREENLINKS";
    public static final String GROUP_FILTER_SCREENLINKS = "plate_group_filter_SCREENLINKS";
    public static final String EVENT_FILTER_SCREENLINKS = "plate_event_filter_SCREENLINKS";
    public static final String PERMS_FILTER_SCREENLINKS = "plate_perms_filter_SCREENLINKS";
    private Map<Long, Long> screenLinksCountPerOwner = null;
    protected Set<Well> wells = new HashSet<Well>();
    public static final String OWNER_FILTER_WELLS = "plate_owner_filter_WELLS";
    public static final String GROUP_FILTER_WELLS = "plate_group_filter_WELLS";
    public static final String EVENT_FILTER_WELLS = "plate_event_filter_WELLS";
    public static final String PERMS_FILTER_WELLS = "plate_perms_filter_WELLS";
    protected Set<PlateAnnotationLink> annotationLinks = new HashSet<PlateAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "plate_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "plate_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "plate_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "plate_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String name = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String DEFAULTSAMPLE = "ome.model.screen.Plate_defaultSample";
    public static final String COLUMNNAMINGCONVENTION = "ome.model.screen.Plate_columnNamingConvention";
    public static final String ROWNAMINGCONVENTION = "ome.model.screen.Plate_rowNamingConvention";
    public static final String WELLORIGINX = "ome.model.screen.Plate_wellOriginX";
    public static final String WELLORIGINY = "ome.model.screen.Plate_wellOriginY";
    public static final String STATUS = "ome.model.screen.Plate_status";
    public static final String EXTERNALIDENTIFIER = "ome.model.screen.Plate_externalIdentifier";
    public static final String SCREENLINKSCOUNTPEROWNER = "ome.model.screen.Plate_screenLinksCountPerOwner";
    public static final String SCREENLINKS = "ome.model.screen.Plate_screenLinks";
    public static final String WELLS = "ome.model.screen.Plate_wells";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.screen.Plate_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.screen.Plate_annotationLinks";
    public static final String NAME = "ome.model.screen.Plate_name";
    public static final String DESCRIPTION = "ome.model.screen.Plate_description";
    public static final String DETAILS = "ome.model.screen.Plate_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Plate() {
        this(null, true);
    }

    protected Plate(Long id) {
        this(id, true);
    }

    public Plate(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Plate(String _name) {
        this(null, true);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_plate")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="defaultSample", updatable=true)
    public Integer getDefaultSample() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.defaultSample;
    }

    public void setDefaultSample(Integer defaultSample) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.defaultSample = defaultSample;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="columnNamingConvention", updatable=true)
    public String getColumnNamingConvention() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.columnNamingConvention;
    }

    public void setColumnNamingConvention(String columnNamingConvention) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.columnNamingConvention = columnNamingConvention;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="rowNamingConvention", updatable=true)
    public String getRowNamingConvention() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.rowNamingConvention;
    }

    public void setRowNamingConvention(String rowNamingConvention) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.rowNamingConvention = rowNamingConvention;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="wellOriginX", updatable=true)
    public Double getWellOriginX() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellOriginX;
    }

    public void setWellOriginX(Double wellOriginX) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.wellOriginX = wellOriginX;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="wellOriginY", updatable=true)
    public Double getWellOriginY() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellOriginY;
    }

    public void setWellOriginY(Double wellOriginY) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.wellOriginY = wellOriginY;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="status", updatable=true)
    public String getStatus() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.status;
    }

    public void setStatus(String status) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.status = status;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="externalIdentifier", updatable=true)
    public String getExternalIdentifier() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.externalIdentifier = externalIdentifier;
    }

    @OneToMany(mappedBy="child", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="plate_owner_filter_SCREENLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="plate_group_filter_SCREENLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="plate_event_filter_SCREENLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="plate_perms_filter_SCREENLINKS", condition=":permsStr = permissions")})
    protected Set<ScreenPlateLink> getScreenLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.screenLinks;
    }

    protected void setScreenLinks(Set<ScreenPlateLink> screenLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.screenLinks = screenLinks;
    }

    public int sizeOfScreenLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.screenLinks == null ? -1 : this.screenLinks.size();
    }

    public Iterator<ScreenPlateLink> iterateScreenLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            return new EmptyIterator<ScreenPlateLink>();
        }
        return this.getScreenLinks().iterator();
    }

    public Collection<ScreenPlateLink> unmodifiableScreenLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getScreenLinks());
    }

    public <E> List<E> collectScreenLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ScreenPlateLink> it = this.iterateScreenLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addScreenPlateLink(ScreenPlateLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            this.throwNullCollectionException("ScreenLinks");
        }
        this.getScreenLinks().add(target);
        target.setChild(this);
    }

    public void addScreenPlateLinkSet(Collection<ScreenPlateLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            this.throwNullCollectionException("ScreenLinks");
        }
        this.getScreenLinks().addAll(targets);
        for (ScreenPlateLink target : targets) {
            target.setChild(this);
        }
    }

    public void removeScreenPlateLink(ScreenPlateLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            this.throwNullCollectionException("ScreenLinks");
        }
        this.getScreenLinks().remove(target);
        target.setChild(null);
    }

    public void removeScreenPlateLinkSet(Collection<ScreenPlateLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            this.throwNullCollectionException("ScreenLinks");
        }
        this.getScreenLinks().removeAll(targets);
        for (ScreenPlateLink target : targets) {
            target.setChild(null);
        }
    }

    public ScreenPlateLink linkScreen(Screen addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ScreenPlateLink link = new ScreenPlateLink();
        link.link(addition, this);
        this.addScreenPlateLink(link, true);
        return link;
    }

    public void addScreenPlateLink(ScreenPlateLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            this.throwNullCollectionException("ScreenLinks");
        }
        this.getScreenLinks().add(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().addScreenPlateLink(link, false);
        }
    }

    public Iterator<Screen> linkedScreenIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            return new EmptyIterator<Screen>();
        }
        final Iterator<ScreenPlateLink> it = this.getScreenLinks().iterator();
        return new Iterator<Screen>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Screen next() {
                if (it == null) {
                    throw new NoSuchElementException("screenLinks is null; no elements.");
                }
                ScreenPlateLink link = (ScreenPlateLink)it.next();
                return link.parent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ScreenPlateLink> findScreenPlateLink(Screen target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ScreenPlateLink> it = this.iterateScreenLinks();
        HashSet<ScreenPlateLink> result = new HashSet<ScreenPlateLink>();
        while (it.hasNext()) {
            ScreenPlateLink link = it.next();
            if (link.parent() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Screen> linkedScreenList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Screen> it = this.linkedScreenIterator();
        ArrayList<Screen> list = new ArrayList<Screen>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedScreen(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Screen> it = this.linkedScreenIterator();
        while (it.hasNext()) {
            Screen obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkScreen(Screen removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ScreenPlateLink> toRemove = this.findScreenPlateLink(removal);
        Iterator<ScreenPlateLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenPlateLink(it.next(), true);
        }
    }

    public void removeScreenPlateLink(ScreenPlateLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getScreenLinks() == null) {
            this.throwNullCollectionException("ScreenLinks");
        }
        this.getScreenLinks().remove(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().removeScreenPlateLink(link, false);
        }
    }

    public void clearScreenLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ScreenPlateLink> list = new ArrayList<ScreenPlateLink>(this.getScreenLinks());
        for (ScreenPlateLink link : list) {
            this.removeScreenPlateLink(link, true);
        }
    }

    protected void setScreenLinksCountPerOwner(Map<Long, Long> map) {
        this.screenLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Plate_screenLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Plate_screenLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getScreenLinksCountPerOwner() {
        return this.screenLinksCountPerOwner;
    }

    @OneToMany(mappedBy="plate", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="plate_owner_filter_WELLS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="plate_group_filter_WELLS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="plate_event_filter_WELLS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="plate_perms_filter_WELLS", condition=":permsStr = permissions")})
    protected Set<Well> getWells() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wells;
    }

    protected void setWells(Set<Well> wells) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.wells = wells;
    }

    public int sizeOfWells() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wells == null ? -1 : this.wells.size();
    }

    public Iterator<Well> iterateWells() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWells() == null) {
            return new EmptyIterator<Well>();
        }
        return this.getWells().iterator();
    }

    public Collection<Well> unmodifiableWells() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWells() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getWells());
    }

    public <E> List<E> collectWells(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Well> it = this.iterateWells();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addWell(Well target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWells() == null) {
            this.throwNullCollectionException("Wells");
        }
        this.getWells().add(target);
        target.setPlate(this);
    }

    public void addWellSet(Collection<Well> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWells() == null) {
            this.throwNullCollectionException("Wells");
        }
        this.getWells().addAll(targets);
        for (Well target : targets) {
            target.setPlate(this);
        }
    }

    public void removeWell(Well target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWells() == null) {
            this.throwNullCollectionException("Wells");
        }
        this.getWells().remove(target);
        target.setPlate(null);
    }

    public void removeWellSet(Collection<Well> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWells() == null) {
            this.throwNullCollectionException("Wells");
        }
        this.getWells().removeAll(targets);
        for (Well target : targets) {
            target.setPlate(null);
        }
    }

    public void clearWells() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWells() == null) {
            this.throwNullCollectionException("Wells");
        }
        this.getWells().clear();
        Iterator<Well> it = this.iterateWells();
        while (it.hasNext()) {
            Well target = it.next();
            target.setPlate(null);
        }
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="plate_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="plate_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="plate_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="plate_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<PlateAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<PlateAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<PlateAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<PlateAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<PlateAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<PlateAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addPlateAnnotationLink(PlateAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        target.setParent(this);
    }

    public void addPlateAnnotationLinkSet(Collection<PlateAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (PlateAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    public void removePlateAnnotationLink(PlateAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removePlateAnnotationLinkSet(Collection<PlateAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (PlateAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public PlateAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        PlateAnnotationLink link = new PlateAnnotationLink();
        link.link(this, addition);
        this.addPlateAnnotationLink(link, true);
        return link;
    }

    public void addPlateAnnotationLink(PlateAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<PlateAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                PlateAnnotationLink link = (PlateAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<PlateAnnotationLink> findPlateAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<PlateAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<PlateAnnotationLink> result = new HashSet<PlateAnnotationLink>();
        while (it.hasNext()) {
            PlateAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<PlateAnnotationLink> toRemove = this.findPlateAnnotationLink(removal);
        Iterator<PlateAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removePlateAnnotationLink(it.next(), true);
        }
    }

    public void removePlateAnnotationLink(PlateAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<PlateAnnotationLink> list = new ArrayList<PlateAnnotationLink>(this.getAnnotationLinks());
        for (PlateAnnotationLink link : list) {
            this.removePlateAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Plate_annotationLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Plate_annotationLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Plate newInstance() {
        return new Plate();
    }

    public Plate proxy() {
        return new Plate(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.defaultSample = (Integer)__filter.filter(DEFAULTSAMPLE, this.defaultSample);
            this.columnNamingConvention = (String)__filter.filter(COLUMNNAMINGCONVENTION, this.columnNamingConvention);
            this.rowNamingConvention = (String)__filter.filter(ROWNAMINGCONVENTION, this.rowNamingConvention);
            this.wellOriginX = (Double)__filter.filter(WELLORIGINX, this.wellOriginX);
            this.wellOriginY = (Double)__filter.filter(WELLORIGINY, this.wellOriginY);
            this.status = (String)__filter.filter(STATUS, this.status);
            this.externalIdentifier = (String)__filter.filter(EXTERNALIDENTIFIER, this.externalIdentifier);
            this.screenLinksCountPerOwner = __filter.filter(SCREENLINKSCOUNTPEROWNER, this.screenLinksCountPerOwner);
            this.screenLinks = (Set)__filter.filter(SCREENLINKS, this.screenLinks);
            this.wells = (Set)__filter.filter(WELLS, this.wells);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.name = (String)__filter.filter(NAME, this.name);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(DEFAULTSAMPLE)) {
            return this.getDefaultSample();
        }
        if (field.equals(COLUMNNAMINGCONVENTION)) {
            return this.getColumnNamingConvention();
        }
        if (field.equals(ROWNAMINGCONVENTION)) {
            return this.getRowNamingConvention();
        }
        if (field.equals(WELLORIGINX)) {
            return this.getWellOriginX();
        }
        if (field.equals(WELLORIGINY)) {
            return this.getWellOriginY();
        }
        if (field.equals(STATUS)) {
            return this.getStatus();
        }
        if (field.equals(EXTERNALIDENTIFIER)) {
            return this.getExternalIdentifier();
        }
        if (field.equals(SCREENLINKSCOUNTPEROWNER)) {
            return this.getScreenLinksCountPerOwner();
        }
        if (field.equals(SCREENLINKS)) {
            return this.getScreenLinks();
        }
        if (field.equals(WELLS)) {
            return this.getWells();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(DEFAULTSAMPLE)) {
            this.setDefaultSample((Integer)value);
        } else if (field.equals(COLUMNNAMINGCONVENTION)) {
            this.setColumnNamingConvention((String)value);
        } else if (field.equals(ROWNAMINGCONVENTION)) {
            this.setRowNamingConvention((String)value);
        } else if (field.equals(WELLORIGINX)) {
            this.setWellOriginX((Double)value);
        } else if (field.equals(WELLORIGINY)) {
            this.setWellOriginY((Double)value);
        } else if (field.equals(STATUS)) {
            this.setStatus((String)value);
        } else if (field.equals(EXTERNALIDENTIFIER)) {
            this.setExternalIdentifier((String)value);
        } else if (field.equals(SCREENLINKSCOUNTPEROWNER)) {
            this.setScreenLinksCountPerOwner((Map)value);
        } else if (field.equals(SCREENLINKS)) {
            this.setScreenLinks((Set)value);
        } else if (field.equals(WELLS)) {
            this.setWells((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.defaultSample = null;
        this.columnNamingConvention = null;
        this.rowNamingConvention = null;
        this.wellOriginX = null;
        this.wellOriginY = null;
        this.status = null;
        this.externalIdentifier = null;
        this.screenLinksCountPerOwner = null;
        this.screenLinks = null;
        this.wells = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.name = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(DEFAULTSAMPLE);
        raw.add(COLUMNNAMINGCONVENTION);
        raw.add(ROWNAMINGCONVENTION);
        raw.add(WELLORIGINX);
        raw.add(WELLORIGINY);
        raw.add(STATUS);
        raw.add(EXTERNALIDENTIFIER);
        raw.add(SCREENLINKSCOUNTPEROWNER);
        raw.add(SCREENLINKS);
        raw.add(WELLS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKplate_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKplate_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKplate_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKplate_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKplate_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

