/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import ome.formats.importer.Main;
import ome.formats.importer.util.GuiCommonElements;
import ome.formats.importer.util.HtmlMessenger;
import ome.formats.importer.util.IniFileLoader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugMessenger
extends JDialog
implements ActionListener {
    private Log log = LogFactory.getLog(DebugMessenger.class);
    private static final long serialVersionUID = -1026712513033611084L;
    IniFileLoader ini = IniFileLoader.getIniFileLoader();
    private Preferences userPrefs = Preferences.userNodeForPackage(Main.class);
    private String userEmail = this.userPrefs.get("userEmail", "");
    boolean debug = false;
    String url = "http://users.openmicroscopy.org.uk/~brain/omero/bugcollector.php";
    private static final String ICON = "gfx/nuvola_error64.png";
    GuiCommonElements gui = new GuiCommonElements();
    JPanel mainPanel;
    JPanel commentPanel;
    JPanel debugPanel;
    JButton cancelBtn;
    JButton sendBtn;
    JButton ignoreBtn;
    JButton copyBtn;
    JTextField emailTextField;
    String emailText = "";
    JTextArea commentTextArea;
    String commentText = "";
    JTextPane debugTextPane;
    StyledDocument debugDocument;
    Style debugStyle;

    DebugMessenger(JFrame owner, String title, Boolean modal, Throwable e) {
        super(owner);
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(true);
        this.setSize(new Dimension(680, 400));
        this.setLocationRelativeTo(owner);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String debugText = sw.toString();
        double[][] mainTable = new double[][]{{10.0, 150.0, -1.0, 100.0, 5.0, 100.0, 10.0}, {-1.0, 40.0}};
        this.mainPanel = this.gui.addMainPanel(this, mainTable, 10, 10, 10, 10, this.debug);
        this.cancelBtn = this.gui.addButton(this.mainPanel, "Cancel", 67, "Cancel your message", "3, 1, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.sendBtn = this.gui.addButton(this.mainPanel, "Send", 83, "Send your comment to the development team", "5, 1, f, c", this.debug);
        this.sendBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.sendBtn);
        this.gui.enterPressesWhenFocused(this.sendBtn);
        JTabbedPane tPane = new JTabbedPane();
        tPane.setOpaque(false);
        if (this.debug) {
            tPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), tPane.getBorder()));
        }
        ImageIcon icon = this.gui.getImageIcon(ICON);
        int iconSpace = 0;
        if (icon != null) {
            iconSpace = icon.getIconWidth() + 10;
        }
        double[][] commentTable = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {100.0, 30.0, -1.0}};
        this.commentPanel = this.gui.addMainPanel(this, commentTable, 10, 10, 10, 10, this.debug);
        tPane.addTab("Comments", null, this.commentPanel, "Your comments go here.");
        String message = "An error message has been generated by the application.\n\nTo help us improve our software, please fill out the following form. Your personal details are purely optional, and will only be used for development purposes.\n\nPlease note that your application may need to be restarted to work properly.";
        JLabel iconLabel = new JLabel(icon);
        this.commentPanel.add((Component)iconLabel, "0,0, l, c");
        JTextPane instructions = this.gui.addTextPane(this.commentPanel, message, "1,0,2,0", this.debug);
        this.emailTextField = this.gui.addTextField(this.commentPanel, "Email: ", this.emailText, 69, "Input your email address here.", "(Optional)", -2.0, "0, 1, 2, 1", this.debug);
        this.emailTextField.setText(this.userEmail);
        this.commentTextArea = this.gui.addTextArea(this.commentPanel, "What you were doing when you crashed?", "", 87, "0, 2, 2, 2", this.debug);
        double[][] debugTable = new double[][]{{-1.0}, {-1.0, 32.0}};
        this.debugPanel = this.gui.addMainPanel(this, debugTable, 10, 10, 10, 10, this.debug);
        this.debugTextPane = this.gui.addTextPane((Container)this.debugPanel, "", "", 87, "0, 0", this.debug);
        this.debugTextPane.setEditable(false);
        this.debugDocument = (StyledDocument)this.debugTextPane.getDocument();
        this.debugStyle = this.debugDocument.addStyle("StyleName", null);
        StyleConstants.setForeground(this.debugStyle, Color.black);
        StyleConstants.setFontFamily(this.debugStyle, "SansSerif");
        StyleConstants.setFontSize(this.debugStyle, 12);
        StyleConstants.setBold(this.debugStyle, false);
        this.gui.appendTextToDocument(this.debugDocument, this.debugStyle, debugText);
        this.copyBtn = this.gui.addButton(this.debugPanel, "Copy to Clipboard", 67, "Copy the Exception Message to the clipboard", "0, 1, c, b", this.debug);
        this.copyBtn.addActionListener(this);
        tPane.addTab("Error Message", null, this.debugPanel, "The Exception Message.");
        this.mainPanel.add((Component)tPane, "0, 0, 6, 0");
        this.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelBtn) {
            this.dispose();
        }
        if (source == this.sendBtn) {
            this.emailText = this.emailTextField.getText();
            this.commentText = this.commentTextArea.getText();
            String debugText = this.debugTextPane.getText();
            this.userPrefs.put("userEmail", this.emailText);
            this.sendRequest(this.emailText, this.commentText, debugText, "Extra data goes here.");
        }
        if (source == this.ignoreBtn) {
            this.dispose();
        }
        if (source == this.copyBtn) {
            this.debugTextPane.selectAll();
            this.debugTextPane.copy();
        }
    }

    private void sendRequest(String email, String comment, String error, String extra) {
        HashMap<String, String> map = new HashMap<String, String>();
        extra = "(" + this.ini.getVersionNumber() + ") " + extra;
        map.put("email", email);
        map.put("comment", comment);
        map.put("error", error);
        map.put("extra", extra);
        map.put("type", "importer_bugs");
        map.put("java_version", System.getProperty("java.version"));
        map.put("java_class_path", System.getProperty("java.class.path"));
        map.put("os_name", System.getProperty("os.name"));
        map.put("os_arch", System.getProperty("os.arch"));
        map.put("os_version", System.getProperty("os.version"));
        try {
            HtmlMessenger messenger = new HtmlMessenger(this.url, map);
            String serverReply = messenger.executePost();
            JEditorPane reply = new JEditorPane("text/html", serverReply);
            reply.setEditable(false);
            reply.setOpaque(false);
            JOptionPane.showMessageDialog(this, reply);
            this.dispose();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while sending debug information.", (Throwable)e);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String debugText = sw.toString();
            this.gui.appendTextToDocument(this.debugDocument, this.debugStyle, "----\n" + debugText);
            String internalURL = "Sorry, but due to an error we were not able to automatically \n send your debug information. \n\nYou can still send us the error message by clicking on the \nerror message tab, copying the error message to the clipboard, \nand sending it to <a href='mailto:comments@openmicroscopy.org.uk'>.";
            try {
                JEditorPane message = new JEditorPane(internalURL);
                JOptionPane.showMessageDialog(this, message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        try {
            HttpClient client = new HttpClient();
            PostMethod method = new PostMethod("blarg");
            client.executeMethod((HttpMethod)method);
        }
        catch (Exception e) {
            new DebugMessenger(null, "Error Dialog Test", (Boolean)true, e);
        }
    }
}

