/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.util.Actions;
import omero.ServerError;
import omero.model.IObject;
import omero.model.Pixels;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportLibrary
implements IObservable {
    ArrayList<IObserver> observers = new ArrayList();
    private boolean dumpPixels = false;
    private static Log log = LogFactory.getLog(ImportLibrary.class);
    private IObject target;
    private OMEROMetadataStoreClient store;
    private OMEROWrapper reader;
    private ImportContainer[] fads;
    private int sizeZ;
    private int sizeT;
    private int sizeC;
    private int sizeX;
    private int sizeY;
    private int zSize;
    private int tSize;
    private int wSize;

    public ImportLibrary(OMEROMetadataStoreClient store, OMEROWrapper reader) {
        if (store == null || reader == null) {
            throw new NullPointerException("All arguments to ImportLibrary() must be non-null.");
        }
        this.store = store;
        this.reader = reader;
    }

    public void setTarget(IObject target) {
        this.target = target;
    }

    public IObject getTarget() {
        return this.target;
    }

    public ImportContainer[] getFilesAndDatasets() {
        return this.fads;
    }

    public List<Pixels> getRoot() {
        return (List)this.store.getRoot();
    }

    public void open(String fileName) throws IOException, FormatException {
        this.reader.close();
        this.reader.setMetadataStore(this.store);
        this.reader.setMinMaxStore(this.store);
        this.reader.setId(fileName);
        this.store.setReader((IFormatReader)this.reader.getImageReader());
        log.debug((Object)("Image Count: " + this.reader.getImageCount()));
    }

    public int calculateImageCount(String fileName, Pixels pixels) {
        this.sizeZ = pixels.getSizeZ().getValue();
        this.sizeC = pixels.getSizeC().getValue();
        this.sizeT = pixels.getSizeT().getValue();
        this.sizeX = pixels.getSizeX().getValue();
        this.sizeY = pixels.getSizeY().getValue();
        int imageCount = this.sizeZ * this.sizeC * this.sizeT;
        this.setOffsetInfo(fileName);
        return imageCount;
    }

    private List<Pixels> importMetadata(String imageName, String imageDescription, boolean archive, Double[] userPixels) throws FormatException, IOException {
        log.debug((Object)"Post-processing metadata.");
        this.store.setArchive(archive);
        this.store.setUserSpecifiedImageName(imageName);
        this.store.setUserSpecifiedImageDescription(imageDescription);
        if (userPixels != null) {
            this.store.setUserSpecifiedPhysicalPixelSizes(userPixels[0], userPixels[1], userPixels[2]);
        }
        this.store.setUserSpecifiedTarget(this.target);
        this.store.postProcess();
        log.debug((Object)"Saving pixels to DB.");
        List<Pixels> pixelsList = this.store.saveToDB();
        return pixelsList;
    }

    private int getBytesPerPixel(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + type + "'");
    }

    public List<Pixels> importImage(File file, int index, int numDone, int total, String imageName, String imageDescription, boolean archive, Double[] userPixels) throws FormatException, IOException, ServerError {
        String fileName = file.getAbsolutePath();
        String shortName = file.getName();
        Object[] args = new Object[9];
        args[0] = shortName;
        args[1] = index;
        args[2] = numDone;
        args[3] = total;
        this.notifyObservers("loading_image", args);
        this.open(file.getAbsolutePath());
        this.notifyObservers("loaded_image", args);
        String formatString = this.reader.getImageReader().getReader().getClass().toString();
        formatString = formatString.replace("class loci.formats.in.", "");
        formatString = formatString.replace("Reader", "");
        try {
            if (formatString.equals("Micromanager")) {
                shortName = imageName = new File(file.getParent()).getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Pixels> pixList = this.importMetadata(imageName, imageDescription, archive, userPixels);
        ArrayList<Long> pixelsIds = new ArrayList<Long>(pixList.size());
        for (Pixels pixels : pixList) {
            pixelsIds.add(pixels.getId().getValue());
        }
        this.store.preparePixelsStore(pixelsIds);
        int seriesCount = this.reader.getSeriesCount();
        boolean saveSha1 = false;
        int series = 0;
        while (series < seriesCount) {
            int count = this.calculateImageCount(fileName, pixList.get(series));
            Pixels pixels = pixList.get(series);
            long pixId = pixels.getId().getValue();
            args[4] = this.getTarget();
            args[5] = pixId;
            args[6] = count;
            args[7] = series;
            this.notifyObservers("dataset_stored", args);
            MessageDigest md = this.importData(pixId, fileName, series, new Step(){

                public void step(int series, int step) {
                    Object[] args2 = new Object[]{series, step, ImportLibrary.this.reader.getSeriesCount()};
                    ImportLibrary.this.notifyObservers("import_step", args2);
                }
            });
            if (md != null) {
                String s = OMEROMetadataStoreClient.byteArrayToHexString(md.digest());
                pixels.setSha1(this.store.toRType(s));
                saveSha1 = true;
            }
            this.notifyObservers("data_stored", args);
            ++series;
        }
        if (archive) {
            this.notifyObservers(Actions.IMPORT_ARCHIVING, args);
            String[] fileNameList = this.reader.getUsedFiles();
            File[] files = new File[fileNameList.length];
            int i = 0;
            while (i < fileNameList.length) {
                files[i] = new File(fileNameList[i]);
                ++i;
            }
            this.store.writeFilesToFileStore(files, pixList.get(0));
        }
        if (saveSha1) {
            this.store.updatePixels(pixList);
        }
        if (!this.reader.isMinMaxSet()) {
            this.store.populateMinMax();
        }
        this.notifyObservers("import_done", args);
        return pixList;
    }

    public MessageDigest importData(Long pixId, String fileName, int series, Step step) throws FormatException, IOException, ServerError {
        MessageDigest md;
        int i = 1;
        int bytesPerPixel = this.getBytesPerPixel(this.reader.getPixelType());
        byte[] arrayBuf = new byte[this.sizeX * this.sizeY * bytesPerPixel];
        this.reader.setSeries(series);
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        AbstractInterruptibleChannel wChannel = null;
        if (this.dumpPixels) {
            File f = new File("pixeldump");
            boolean append = true;
            wChannel = new FileOutputStream(f, append).getChannel();
        }
        int t = 0;
        while (t < this.sizeT) {
            int c = 0;
            while (c < this.sizeC) {
                int z = 0;
                while (z < this.sizeZ) {
                    int planeNumber = this.reader.getIndex(z, c, t);
                    ByteBuffer buf = this.reader.openPlane2D(fileName, planeNumber, arrayBuf).getData();
                    arrayBuf = this.swapIfRequired(buf, fileName);
                    try {
                        md.update(arrayBuf);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    step.step(series, i);
                    this.store.setPlane(pixId, arrayBuf, z, c, t);
                    if (this.dumpPixels) {
                        ((FileChannel)wChannel).write(buf);
                    }
                    ++i;
                    ++z;
                }
                ++c;
            }
            ++t;
        }
        if (this.dumpPixels) {
            wChannel.close();
        }
        return md;
    }

    private void setOffsetInfo(String fileName) {
        int order = 0;
        order = this.getSequenceNumber(this.reader.getDimensionOrder());
        this.setOffsetInfo(order, this.sizeZ, this.sizeC, this.sizeT);
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = 1;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
                break;
            }
            case 3: {
                this.tSize = smallOffset;
                this.wSize = this.tSize * numTimes;
                this.zSize = this.wSize * numWaves;
                break;
            }
            case 4: {
                this.wSize = smallOffset;
                this.tSize = this.wSize * numWaves;
                this.zSize = this.tSize * numTimes;
                break;
            }
            case 5: {
                this.tSize = smallOffset;
                this.zSize = this.wSize * numTimes;
                this.wSize = this.tSize * numZSections;
            }
        }
    }

    private int getSequenceNumber(String dimOrder) {
        if (dimOrder.equals("XYZTC")) {
            return 0;
        }
        if (dimOrder.equals("XYCZT")) {
            return 1;
        }
        if (dimOrder.equals("XYZCT")) {
            return 2;
        }
        if (dimOrder.equals("XYTCZ")) {
            return 3;
        }
        if (dimOrder.equals("XYCTZ")) {
            return 4;
        }
        if (dimOrder.equals("XYTZC")) {
            return 5;
        }
        throw new RuntimeException(String.valueOf(dimOrder) + " not represented in " + "getSequenceNumber");
    }

    public boolean isLittleEndian(String fileName) throws FormatException, IOException {
        return this.reader.isLittleEndian();
    }

    private byte[] swapIfRequired(ByteBuffer buffer, String fileName) throws FormatException, IOException {
        int pixelType = this.reader.getPixelType();
        int bytesPerPixel = this.getBytesPerPixel(pixelType);
        if (bytesPerPixel == 1) {
            return buffer.array();
        }
        if (this.isLittleEndian(fileName)) {
            if (bytesPerPixel == 2) {
                ShortBuffer buf = buffer.asShortBuffer();
                int length = buffer.capacity() / 2;
                int i = 0;
                while (i < length) {
                    short x = buf.get(i);
                    buf.put(i, (short)(x << 8 | x >> 8 & 0xFF));
                    ++i;
                }
            } else if (bytesPerPixel == 4) {
                IntBuffer buf = buffer.asIntBuffer();
                int length = buffer.capacity() / 4;
                int i = 0;
                while (i < length) {
                    buf.put(i, DataTools.swap((int)buf.get(i)));
                    ++i;
                }
            } else if (bytesPerPixel == 8) {
                LongBuffer buf = buffer.asLongBuffer();
                int length = buffer.capacity() / 8;
                int i = 0;
                while (i < length) {
                    buf.put(i, DataTools.swap((long)buf.get(i)));
                    ++i;
                }
            } else {
                throw new FormatException("Unsupported sample bit width: '" + bytesPerPixel + "'");
            }
        }
        return buffer.array();
    }

    @Override
    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    @Override
    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    @Override
    public void notifyObservers(Object message, Object[] args) {
        for (IObserver observer : this.observers) {
            observer.update(this, message, args);
        }
    }

    public static abstract class Step {
        public abstract void step(int var1, int var2);
    }
}

