/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.AddScreenDialog;
import ome.formats.importer.ScreenItem;
import ome.formats.importer.util.GuiCommonElements;
import omero.RLong;
import omero.model.Screen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SPWDialog
extends JDialog
implements ActionListener {
    boolean debug = false;
    private GuiCommonElements gui;
    private Integer dialogHeight = 200;
    private Integer dialogWidth = 400;
    private JTabbedPane tabbedPane;
    private JPanel importPanel;
    private JPanel sPanel;
    String addIcon = "gfx/add_text.png";
    public JCheckBox archiveImage;
    private JButton addScreenBtn;
    private JButton cancelBtn;
    private JButton importBtn;
    private JComboBox sbox;
    public Screen screen;
    public ScreenItem[] screenItems = null;
    public boolean cancelled = true;
    private boolean ARCHIVE_ENABLED = true;
    private static Log log = LogFactory.getLog(SPWDialog.class);
    public OMEROMetadataStoreClient store;
    private Preferences userPrefs = Preferences.userNodeForPackage(SPWDialog.class);
    private Long savedScreen = this.userPrefs.getLong("savedScreen", 0L);

    SPWDialog(JFrame owner, String title, boolean modal, OMEROMetadataStoreClient store) {
        super(owner);
        this.store = store;
        if (store != null) {
            this.screenItems = ScreenItem.createScreenItem(store.getScreens());
        }
        this.setLocation(200, 200);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(false);
        this.setSize(new Dimension(this.dialogWidth, this.dialogHeight));
        this.setLocationRelativeTo(owner);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.gui = new GuiCommonElements();
        double[][] mainTable = new double[][]{{-1.0, 120.0, 5.0, 160.0, -1.0}, {-2.0, 5.0, -2.0, -1.0, 40.0, 30.0}};
        this.importPanel = this.gui.addMainPanel(this.tabbedPane, mainTable, 5, 10, 0, 10, this.debug);
        String message = "Import this plate into which screen?";
        this.gui.addTextPane(this.importPanel, message, "0, 0, 4, 0", this.debug);
        double[][] pdTable = new double[][]{{-1.0, 5.0, 40.0}, {35.0}};
        this.sPanel = this.gui.addMainPanel(this.importPanel, pdTable, 0, 0, 0, 0, this.debug);
        this.sbox = this.gui.addComboBox(this.sPanel, "Screen: ", this.screenItems, 80, "Select dataset to use for this import.", 50.0, "0,0,f,c", this.debug);
        String offsetButtons = ",c";
        int addBtnSize = 60;
        if (this.gui.getIsMac()) {
            addBtnSize = 20;
        }
        this.addScreenBtn = this.gui.addIconButton(this.sPanel, "", this.addIcon, 20, addBtnSize, null, null, "2,0,f" + offsetButtons, this.debug);
        this.addScreenBtn.addActionListener(this);
        this.importPanel.add((Component)this.sPanel, "0, 2, 4, 2");
        this.cancelBtn = this.gui.addButton(this.importPanel, "Cancel", 76, "Cancel", "1, 5, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.importBtn = this.gui.addButton(this.importPanel, "Add to Queue", 81, "Import", "3, 5, f, c", this.debug);
        this.importBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.importBtn);
        this.gui.enterPressesWhenFocused(this.importBtn);
        this.archiveImage = this.gui.addCheckBox(this.importPanel, "Archive the original imported file(s) to the server.", "0,4,4,t", this.debug);
        this.archiveImage.setSelected(false);
        if (this.ARCHIVE_ENABLED) {
            this.archiveImage.setVisible(true);
        } else {
            this.archiveImage.setVisible(false);
        }
        this.add(this.tabbedPane);
        this.tabbedPane.addTab("Import Settings", null, this.importPanel, "Import Settings");
        this.importBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(this.importBtn);
        this.cancelBtn.addActionListener(this);
        this.importBtn.addActionListener(this);
        this.sbox.addActionListener(this);
        this.buildScreens();
        this.setVisible(true);
    }

    private void buildScreens() {
        if (this.savedScreen != 0L && this.screenItems != null) {
            int i = 0;
            while (i < this.screenItems.length) {
                RLong pId = this.screenItems[i].getScreen().getId();
                if (pId != null && pId.getValue() == this.savedScreen.longValue()) {
                    this.sbox.setSelectedIndex(i);
                }
                ++i;
            }
        }
    }

    private void refreshAndSetProject() {
        if (this.store != null) {
            this.screenItems = ScreenItem.createScreenItem(this.store.getScreens());
            this.savedScreen = this.userPrefs.getLong("savedScreen", 0L);
            int k = 0;
            while (k < this.screenItems.length) {
                RLong pId = this.screenItems[k].getScreen().getId();
                if (pId != null && pId.getValue() == this.savedScreen.longValue()) {
                    this.sbox.insertItemAt(this.screenItems[k], k);
                    this.sbox.setSelectedIndex(k);
                }
                ++k;
            }
            this.buildScreens();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addScreenBtn) {
            new AddScreenDialog((Window)this, "Add a new Screen", (Boolean)true, this.store);
            this.refreshAndSetProject();
        }
        if (e.getSource() == this.cancelBtn) {
            this.cancelled = true;
            this.dispose();
        }
        if (e.getSource() == this.importBtn) {
            this.cancelled = false;
            this.importBtn.requestFocus();
            this.screen = ((ScreenItem)this.sbox.getSelectedItem()).getScreen();
            this.userPrefs.putLong("savedScreen", ((ScreenItem)this.sbox.getSelectedItem()).getScreen().getId().getValue());
            this.dispose();
        }
        if (e.getSource() == this.sbox) {
            this.cancelled = false;
            if (this.sbox.getSelectedIndex() == 0) {
                this.importBtn.setEnabled(false);
            } else {
                this.importBtn.setEnabled(true);
            }
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(laf) + " not supported.");
        }
        SPWDialog dialog = new SPWDialog(null, "Plate Import Dialog", true, null);
        if (dialog != null) {
            System.exit(0);
        }
    }
}

