/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.DetectorSettings;
import omero.model.LightSettings;
import omero.model.ObjectiveSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReferenceProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(ReferenceProcessor.class);

    public void process(IObjectContainerStore store) throws ModelException {
        HashMap<String, String> referenceStringCache = new HashMap<String, String>();
        Map<LSID, LSID> referenceCache = store.getReferenceCache();
        Map<LSID, IObjectContainer> containerCache = store.getContainerCache();
        try {
            for (LSID target : referenceCache.keySet()) {
                LSID reference = referenceCache.get(target);
                IObjectContainer container = containerCache.get(target);
                if (container == null) {
                    Class targetClass = target.getJavaClass();
                    LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
                    int[] indexArray = target.getIndexes();
                    if (targetClass == null) {
                        this.log.warn((Object)("Unknown target class for LSID: " + target));
                        referenceStringCache.put(target.toString(), reference.toString());
                        continue;
                    }
                    if (targetClass.equals(DetectorSettings.class)) {
                        indexes.put("imageIndex", indexArray[0]);
                        indexes.put("logicalChannelIndex", indexArray[1]);
                    } else if (targetClass.equals(LightSettings.class)) {
                        indexes.put("imageIndex", indexArray[0]);
                        indexes.put("logicalChannelIndex", indexArray[1]);
                    } else if (targetClass.equals(ObjectiveSettings.class)) {
                        indexes.put("imageIndex", indexArray[0]);
                    } else {
                        throw new RuntimeException(String.format("Unable to synchronize reference %s --> %s", reference, target));
                    }
                    container = store.getIObjectContainer(targetClass, indexes);
                }
                referenceStringCache.put(container.LSID, reference.toString());
            }
            store.setReferenceStringCache(referenceStringCache);
        }
        catch (Exception e) {
            throw new ModelException("Error processing references.", null, e);
        }
    }
}

