/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Catalog;
import Freeze.CatalogIndexList;
import Freeze.Connection;
import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.IndexNotFoundException;
import Freeze.KeyCodec;
import Freeze.LinkedList;
import Freeze.MapDb;
import Freeze.NoSuchElementException;
import Freeze.NotFoundException;
import Freeze.SubMap;
import Freeze.Transaction;
import Freeze.Util;
import Ice.Communicator;
import Ice.Properties;
import com.sleepycat.db.BtreeStats;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.StatsConfig;
import java.io.FileNotFoundException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class Map
extends AbstractMap
implements SortedMap,
KeyCodec {
    protected ConnectionI _connection;
    private final Comparator _comparator;
    private final String _dbName;
    protected Iterator _token;
    protected MapDb _db;
    protected String _errorPrefix;
    protected int _trace;
    private Set _entrySet;
    private LinkedList _iteratorList = new LinkedList();
    private java.util.Map<String, Index> _indexMap = new HashMap<String, Index>();

    public abstract byte[] encodeValue(Object var1, Communicator var2);

    public abstract Object decodeValue(byte[] var1, Communicator var2);

    protected Map(Connection connection, String dbName, String key, String value, boolean createDb, java.util.Comparator comparator) {
        this._connection = (ConnectionI)connection;
        this._dbName = dbName;
        this._comparator = comparator == null ? null : new Comparator(comparator);
        this._errorPrefix = "Freeze DB DbEnv(\"" + this._connection.envName() + "\") Db(\"" + dbName + "\"): ";
        this._trace = this._connection.trace();
        this.init(null, dbName, key, value, createDb, null);
    }

    protected Map(Connection connection, String dbName, java.util.Comparator comparator) {
        this._connection = (ConnectionI)connection;
        this._dbName = dbName;
        this._comparator = comparator == null ? null : new Comparator(comparator);
        this._errorPrefix = "Freeze DB DbEnv(\"" + this._connection.envName() + "\") Db(\"" + dbName + "\"): ";
        this._trace = this._connection.trace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void recreate(Map map, String dbName, String key, String value, Index[] indices, java.util.Map indexComparators) {
        Transaction tx;
        ConnectionI connection = map._connection;
        String envName = connection.dbEnv().getEnvName();
        if (dbName.equals(Util.catalogName()) || dbName.equals(Util.catalogIndexListName())) {
            throw new DatabaseException(Map.errorPrefix(envName, dbName) + "You cannot recreate the \"" + dbName + "\" database");
        }
        if (connection.trace() >= 1) {
            connection.communicator().getLogger().trace("Freeze.Map", "Recreating \"" + dbName + "\"");
        }
        boolean ownTx = (tx = connection.currentTransaction()) == null;
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry valueEntry = new DatabaseEntry();
        Database oldDb = null;
        MapDb newDb = null;
        while (true) {
            com.sleepycat.db.DatabaseException dx2222;
            DatabaseException de2222;
            Object var23_18;
            block52: {
                CatalogIndexList catalogIndexList;
                String[] oldIndices;
                if (ownTx) {
                    tx = null;
                    tx = connection.beginTransaction();
                }
                com.sleepycat.db.Transaction txn = connection.dbTxn();
                if (connection.trace() >= 2) {
                    connection.communicator().getLogger().trace("Freeze.Map", "Removing all existing indices for \"" + dbName + "\"");
                }
                if ((oldIndices = (String[])(catalogIndexList = new CatalogIndexList((Connection)connection, Util.catalogIndexListName(), true)).remove(dbName)) != null) {
                    for (int i = 0; i < oldIndices.length; ++i) {
                        try {
                            connection.removeMapIndex(dbName, oldIndices[i]);
                            continue;
                        }
                        catch (IndexNotFoundException e) {
                            // empty catch block
                        }
                    }
                }
                String oldDbName = dbName + ".old-" + Ice.Util.generateUUID().replace(':', '-');
                if (connection.trace() >= 2) {
                    connection.communicator().getLogger().trace("Freeze.Map", "Renaming \"" + dbName + "\" to \"" + oldDbName + "\"");
                }
                connection.dbEnv().getEnv().renameDatabase(txn, dbName, null, oldDbName);
                DatabaseConfig oldDbConfig = new DatabaseConfig();
                oldDbConfig.setType(DatabaseType.BTREE);
                oldDb = connection.dbEnv().getEnv().openDatabase(txn, oldDbName, null, oldDbConfig);
                newDb = new MapDb(connection, dbName, key, value, map._comparator, indices, indexComparators, true);
                map.init(newDb, indices);
                if (connection.trace() >= 2) {
                    connection.communicator().getLogger().trace("Freeze.Map", "Writing contents of \"" + oldDbName + "\" to fresh \"" + dbName + "\"");
                }
                Cursor dbc = null;
                try {
                    dbc = oldDb.openCursor(txn, null);
                    while (dbc.getNext(keyEntry, valueEntry, null) == OperationStatus.SUCCESS) {
                        newDb.db().put(txn, keyEntry, valueEntry);
                    }
                }
                finally {
                    if (dbc != null) {
                        dbc.close();
                    }
                }
                if (connection.trace() >= 2) {
                    connection.communicator().getLogger().trace("Freeze.Map", "Transfer complete; removing \"" + oldDbName + "\"");
                }
                connection.dbEnv().getEnv().removeDatabase(txn, oldDbName, null);
                if (ownTx) {
                    try {
                        tx.commit();
                    }
                    finally {
                        tx = null;
                    }
                }
                var23_18 = null;
                if (!ownTx || tx == null) break block52;
                try {
                    tx.rollback();
                }
                catch (DatabaseException de2222) {
                    // empty catch block
                }
            }
            try {
                if (newDb != null) {
                    newDb.close();
                }
                if (oldDb == null) break;
                try {
                    oldDb.close();
                    break;
                }
                catch (com.sleepycat.db.DatabaseException dx2222) {
                    DatabaseException ex = new DatabaseException(Map.errorPrefix(envName, dbName) + "Map.recreate: " + dx2222.getMessage());
                    ex.initCause(dx2222);
                    throw ex;
                }
            }
            finally {
                newDb = null;
                oldDb = null;
            }
            {
                catch (com.sleepycat.db.DeadlockException dx3) {
                    if (ownTx) {
                        if (connection.deadlockWarning()) {
                            connection.communicator().getLogger().warning("Deadlock in Freeze.Map.recreate on Db \"" + dbName + "\"; retrying ...");
                        }
                    } else {
                        DeadlockException ex = new DeadlockException(Map.errorPrefix(envName, dbName) + "Map.recreate: " + dx3.getMessage(), tx);
                        ex.initCause(dx3);
                        throw ex;
                    }
                    var23_18 = null;
                    if (ownTx && tx != null) {
                        try {
                            tx.rollback();
                        }
                        catch (DatabaseException de2222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (newDb != null) {
                            newDb.close();
                        }
                        if (oldDb == null) continue;
                        try {
                            oldDb.close();
                            continue;
                        }
                        catch (com.sleepycat.db.DatabaseException dx2222) {
                            DatabaseException ex = new DatabaseException(Map.errorPrefix(envName, dbName) + "Map.recreate: " + dx2222.getMessage());
                            ex.initCause(dx2222);
                            throw ex;
                        }
                    }
                    finally {
                        newDb = null;
                        oldDb = null;
                        continue;
                    }
                }
                catch (com.sleepycat.db.DatabaseException dx4) {
                    DatabaseException ex = new DatabaseException(Map.errorPrefix(envName, dbName) + "Map.recreate: " + dx4.getMessage());
                    ex.initCause(dx4);
                    throw ex;
                }
                catch (FileNotFoundException fne) {
                    DatabaseException ex = new DatabaseException(Map.errorPrefix(envName, dbName) + "Map.recreate: " + fne.getMessage());
                    ex.initCause(fne);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                block54: {
                    var23_18 = null;
                    if (ownTx && tx != null) {
                        try {
                            tx.rollback();
                        }
                        catch (DatabaseException de2222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (newDb != null) {
                            newDb.close();
                        }
                        if (oldDb == null) break block54;
                        try {
                            oldDb.close();
                        }
                        catch (com.sleepycat.db.DatabaseException dx2222) {
                            DatabaseException ex = new DatabaseException(Map.errorPrefix(envName, dbName) + "Map.recreate: " + dx2222.getMessage());
                            ex.initCause(dx2222);
                            throw ex;
                        }
                    }
                    finally {
                        newDb = null;
                        oldDb = null;
                    }
                }
                throw throwable;
            }
            break;
        }
    }

    protected void init(Index[] indices, String dbName, String key, String value, boolean createDb, java.util.Map indexComparators) {
        this.init(this._connection.dbEnv().getSharedMapDb(dbName, key, value, this._comparator, indices, indexComparators, createDb), indices);
    }

    protected void init(MapDb db, Index[] indices) {
        this._db = db;
        this._token = this._connection.registerMap(this);
        if (indices != null) {
            for (int i = 0; i < indices.length; ++i) {
                this._indexMap.put(indices[i].name(), indices[i]);
            }
        }
    }

    public void close() {
        this.close(false);
    }

    public void closeDb() {
        this.close(false);
        this._connection.dbEnv().removeSharedMapDb(this._dbName);
    }

    public Connection getConnection() {
        return this._connection;
    }

    public java.util.Comparator comparator() {
        if (this._comparator == null) {
            return null;
        }
        return this._comparator.comparator();
    }

    public Object firstKey() {
        return this.firstKey(null, null);
    }

    public Object lastKey() {
        return this.lastKey(null, null);
    }

    Object firstKey(Object fromKey, Object toKey) {
        byte[] fk = fromKey == null ? null : this.encodeKey(fromKey, this._connection.communicator());
        byte[] k = this.getFirstOrLastKey(this._db.db(), this._db.dbName(), fk, true);
        if (k == null) {
            throw new NoSuchElementException();
        }
        Object key = this.decodeKey(k, this._connection.communicator());
        if (toKey != null && this.comparator().compare(key, toKey) >= 0) {
            throw new NoSuchElementException();
        }
        return key;
    }

    Object lastKey(Object fromKey, Object toKey) {
        byte[] tk = toKey == null ? null : this.encodeKey(toKey, this._connection.communicator());
        byte[] k = this.getFirstOrLastKey(this._db.db(), this._db.dbName(), tk, false);
        if (k == null) {
            throw new NoSuchElementException();
        }
        Object key = this.decodeKey(k, this._connection.communicator());
        if (fromKey != null && this.comparator().compare(fromKey, key) > 0) {
            throw new NoSuchElementException();
        }
        return key;
    }

    public SortedMap headMap(Object toKey) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        if (this._comparator == null) {
            throw new UnsupportedOperationException();
        }
        return new SubMap(this, null, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        if (this._comparator == null) {
            throw new UnsupportedOperationException();
        }
        return new SubMap(this, fromKey, null);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        if (this._comparator == null) {
            throw new UnsupportedOperationException();
        }
        return new SubMap(this, fromKey, toKey);
    }

    public SortedMap headMapForIndex(String indexName, Object toKey) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        Index index = this._indexMap.get(indexName);
        if (index == null) {
            throw new IllegalArgumentException("Can't find index '" + indexName + "'");
        }
        if (index.comparator() == null) {
            throw new IllegalArgumentException("Index '" + indexName + "' has no user-defined comparator");
        }
        return new SubMap(index, null, toKey);
    }

    public SortedMap tailMapForIndex(String indexName, Object fromKey) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        Index index = this._indexMap.get(indexName);
        if (index == null) {
            throw new IllegalArgumentException("Can't find index '" + indexName + "'");
        }
        if (index.comparator() == null) {
            throw new IllegalArgumentException("Index '" + indexName + "' has no user-defined comparator");
        }
        return new SubMap(index, fromKey, null);
    }

    public SortedMap subMapForIndex(String indexName, Object fromKey, Object toKey) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        Index index = this._indexMap.get(indexName);
        if (index == null) {
            throw new IllegalArgumentException("Can't find index '" + indexName + "'");
        }
        if (index.comparator() == null) {
            throw new IllegalArgumentException("Index '" + indexName + "' has no user-defined comparator");
        }
        return new SubMap(index, fromKey, toKey);
    }

    public SortedMap mapForIndex(String indexName) {
        Index index = this._indexMap.get(indexName);
        if (index == null) {
            throw new IllegalArgumentException("Can't find index '" + indexName + "'");
        }
        if (index.comparator() == null) {
            throw new IllegalArgumentException("Index '" + indexName + "' has no user-defined comparator");
        }
        return new SubMap(index, null, null);
    }

    public int size() {
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        try {
            StatsConfig config = new StatsConfig();
            BtreeStats s = (BtreeStats)this._db.db().getStats(null, config);
            return s.getNumData();
        }
        catch (com.sleepycat.db.DatabaseException e) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(e);
            ex.message = this._errorPrefix + "Db.stat: " + e.getMessage();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        while (true) {
            EntryIterator p = null;
            try {
                Entry e;
                p = (EntryIterator)this.entrySet().iterator();
                if (value == null) {
                    while (p.hasNext()) {
                        e = (Entry)p.next();
                        if (e.getValue() != null) continue;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    while (p.hasNext()) {
                        e = (Entry)p.next();
                        if (!value.equals(e.getValue())) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean e2 = false;
                return e2;
            }
            catch (DeadlockException e) {
                if (this._connection.dbTxn() != null) {
                    throw e;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.containsValue while iterating over Db \"" + this._db.dbName() + "\"; retrying...");
                continue;
            }
            finally {
                if (p == null) continue;
                p.close();
                continue;
            }
            break;
        }
    }

    public boolean containsKey(Object key) {
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        byte[] k = this.encodeKey(key, this._connection.communicator());
        DatabaseEntry dbKey = new DatabaseEntry(k);
        DatabaseEntry dbValue = new DatabaseEntry();
        dbValue.setPartial(true);
        if (this._trace >= 2) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "checking key in Db \"" + this._db.dbName() + "\"");
        }
        while (true) {
            try {
                return this._db.db().get(this._connection.dbTxn(), dbKey, dbValue, null) == OperationStatus.SUCCESS;
            }
            catch (com.sleepycat.db.DeadlockException e) {
                if (this._connection.dbTxn() != null) {
                    DeadlockException ex = new DeadlockException(this._errorPrefix + "Db.get: " + e.getMessage(), this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.containsKey while reading Db \"" + this._db.dbName() + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.get: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    public Object get(Object key) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        DatabaseEntry dbKey = new DatabaseEntry(k);
        byte[] v = this.getImpl(dbKey);
        if (v == null) {
            return null;
        }
        return this.decodeValue(v, this._connection.communicator());
    }

    public Object put(Object key, Object value) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        DatabaseEntry dbKey = new DatabaseEntry(k);
        byte[] v = this.getImpl(dbKey);
        Object o = null;
        if (v != null) {
            o = this.decodeValue(v, this._connection.communicator());
        }
        this.putImpl(dbKey, value);
        return o;
    }

    public Object remove(Object key) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        DatabaseEntry dbKey = new DatabaseEntry(k);
        byte[] v = this.getImpl(dbKey);
        if (v != null && this.removeImpl(dbKey)) {
            return this.decodeValue(v, this._connection.communicator());
        }
        return null;
    }

    public void fastPut(Object key, Object value) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        DatabaseEntry dbKey = new DatabaseEntry(k);
        this.putImpl(dbKey, value);
    }

    public boolean fastRemove(Object key) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        DatabaseEntry dbKey = new DatabaseEntry(k);
        return this.removeImpl(dbKey);
    }

    public void clear() {
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        com.sleepycat.db.Transaction txn = this._connection.dbTxn();
        while (true) {
            try {
                this._db.db().truncate(txn, false);
            }
            catch (com.sleepycat.db.DeadlockException e) {
                if (txn != null) {
                    DeadlockException ex = new DeadlockException(this._errorPrefix + "Db.truncate: " + e.getMessage(), this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.clear on Db \"" + this._db.dbName() + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.truncate: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    public Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new EntryIteratorImpl(null, null, null, false, false);
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    Object value = entry.getValue();
                    byte[] v = Map.this.getImpl(entry.getDbKey());
                    return v != null && Map.valEquals(Map.this.decodeValue(v, Map.this._connection.communicator()), value);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    Object value = entry.getValue();
                    byte[] v = Map.this.getImpl(entry.getDbKey());
                    if (v != null && Map.valEquals(Map.this.decodeValue(v, Map.this._connection.communicator()), value)) {
                        return Map.this.removeImpl(entry.getDbKey());
                    }
                    return false;
                }

                public int size() {
                    return Map.this.size();
                }

                public void clear() {
                    Map.this.clear();
                }
            };
        }
        return this._entrySet;
    }

    public void closeAllIterators() {
        this.closeAllIteratorsExcept(null, false);
    }

    public void destroy() {
        if (this._db == null) {
            throw new DatabaseException(this._errorPrefix + "This map is closed");
        }
        String dbName = this._db.dbName();
        if (dbName.equals(Util.catalogName()) || dbName.equals(Util.catalogIndexListName())) {
            throw new DatabaseException(this._errorPrefix + "You cannot destroy the \"" + dbName + "\" database");
        }
        if (this._connection.currentTransaction() != null) {
            throw new DatabaseException(this._errorPrefix + "You cannot destroy a database within an active transaction");
        }
        if (this._trace >= 1) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "destroying \"" + dbName + "\"");
        }
        this.closeDb();
        while (true) {
            Transaction tx = null;
            try {
                tx = this._connection.beginTransaction();
                com.sleepycat.db.Transaction txn = this._connection.dbTxn();
                Catalog catalog = new Catalog((Connection)this._connection, Util.catalogName(), true);
                catalog.remove(dbName);
                CatalogIndexList catalogIndexList = new CatalogIndexList((Connection)this._connection, Util.catalogIndexListName(), true);
                catalogIndexList.remove(dbName);
                this._connection.dbEnv().getEnv().removeDatabase(txn, dbName, null);
                for (String index : this._indexMap.keySet()) {
                    this._connection.removeMapIndex(dbName, index);
                }
                tx.commit();
            }
            catch (FileNotFoundException dx) {
                try {
                    tx.rollback();
                }
                catch (DatabaseException e) {
                    // empty catch block
                }
                DatabaseException e = new DatabaseException(this._errorPrefix + "file not found");
                e.initCause(dx);
                throw e;
            }
            catch (com.sleepycat.db.DeadlockException dx) {
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.destroy on Db \"" + dbName + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                try {
                    tx.rollback();
                }
                catch (DatabaseException e) {
                    // empty catch block
                }
                DatabaseException e = new DatabaseException(this._errorPrefix + dx.getMessage());
                e.initCause(dx);
                throw e;
            }
            catch (RuntimeException rx) {
                try {
                    tx.rollback();
                }
                catch (DatabaseException e) {
                    // empty catch block
                }
                throw rx;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllIteratorsExcept(Object except, boolean finalizing) {
        LinkedList linkedList = this._iteratorList;
        synchronized (linkedList) {
            Iterator p = this._iteratorList.iterator();
            while (p.hasNext()) {
                Object obj = p.next();
                if (obj == except) continue;
                ((EntryIteratorImpl)obj).close(finalizing);
            }
        }
    }

    protected void finalize() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean finalizing) {
        ConnectionI connectionI = this._connection;
        synchronized (connectionI) {
            if (this._db != null) {
                try {
                    this.closeAllIteratorsExcept(null, finalizing);
                }
                finally {
                    this._db = null;
                    this._connection.unregisterMap(this._token);
                    this._token = null;
                }
            }
        }
    }

    EntryIterator createIterator(Index index, Object fromKey, Object toKey) {
        KeyCodec codec = index == null ? this : index;
        Communicator communicator = this._connection.getCommunicator();
        return new EntryIteratorImpl(index, fromKey == null ? null : codec.encodeKey(fromKey, communicator), toKey == null ? null : codec.encodeKey(toKey, communicator), false, true);
    }

    ConnectionI connection() {
        return this._connection;
    }

    private static String errorPrefix(String envName, String dbName) {
        return "Freeze DB DbEnv(\"" + envName + "\") Db(\"" + dbName + "\"): ";
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private byte[] getFirstOrLastKey(Database db, String dbName, byte[] key, boolean first) {
        if (db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + dbName + "\" has been closed";
            throw ex;
        }
        if (this._trace >= 2) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "searching Db \"" + dbName + "\"");
        }
        DatabaseEntry dbKey = key == null ? new DatabaseEntry() : new DatabaseEntry(key);
        DatabaseEntry dbValue = new DatabaseEntry();
        dbValue.setPartial(true);
        block16: while (true) {
            try {
                while (true) {
                    Cursor dbc = null;
                    try {
                        OperationStatus status;
                        dbc = db.openCursor(this._connection.dbTxn(), null);
                        if (key == null) {
                            status = first ? dbc.getFirst(dbKey, dbValue, null) : dbc.getLast(dbKey, dbValue, null);
                        } else if (first) {
                            status = dbc.getSearchKeyRange(dbKey, dbValue, null);
                        } else {
                            status = dbc.getSearchKeyRange(dbKey, dbValue, null);
                            if (status == OperationStatus.SUCCESS) {
                                status = dbc.getPrevNoDup(dbKey, dbValue, null);
                            } else if (status == OperationStatus.NOTFOUND) {
                                status = dbc.getLast(dbKey, dbValue, null);
                            }
                        }
                        if (status == OperationStatus.SUCCESS) {
                            byte[] byArray = dbKey.getData();
                            return byArray;
                        }
                        byte[] byArray = null;
                        return byArray;
                    }
                    catch (com.sleepycat.db.DeadlockException dx) {
                        if (this._connection.dbTxn() != null) {
                            DeadlockException ex = new DeadlockException(this._errorPrefix + "Dbc.getXXX: " + dx.getMessage(), this._connection.currentTransaction());
                            ex.initCause(dx);
                            throw ex;
                        }
                        if (!this._connection.deadlockWarning()) continue block16;
                        this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map while searching \"" + db.getDatabaseName() + "\"; retrying...");
                        continue block16;
                    }
                    finally {
                        if (dbc == null) continue;
                        try {
                            dbc.close();
                            continue block16;
                        }
                        catch (com.sleepycat.db.DeadlockException dx) {}
                    }
                    break;
                }
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._errorPrefix + "Db.openCursor/Dbc.getXXX: " + dx.getMessage();
                throw ex;
            }
        }
    }

    private byte[] getImpl(DatabaseEntry dbKey) {
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        DatabaseEntry dbValue = new DatabaseEntry();
        if (this._trace >= 2) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "reading value from Db \"" + this._db.dbName() + "\"");
        }
        while (true) {
            try {
                OperationStatus rc = this._db.db().get(this._connection.dbTxn(), dbKey, dbValue, null);
                if (rc == OperationStatus.SUCCESS) {
                    return dbValue.getData();
                }
                return null;
            }
            catch (com.sleepycat.db.DeadlockException e) {
                if (this._connection.dbTxn() != null) {
                    DeadlockException ex = new DeadlockException(this._errorPrefix + "Db.get: " + e.getMessage(), this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.getImpl while reading Db \"" + this._db.dbName() + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.get: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    private void putImpl(DatabaseEntry dbKey, Object value) {
        com.sleepycat.db.Transaction txn;
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        byte[] v = this.encodeValue(value, this._connection.communicator());
        DatabaseEntry dbValue = new DatabaseEntry(v);
        if (this._trace >= 2) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "writing value in Db \"" + this._db.dbName() + "\"");
        }
        if ((txn = this._connection.dbTxn()) == null) {
            this.closeAllIterators();
        }
        while (true) {
            try {
                this._db.db().put(txn, dbKey, dbValue);
            }
            catch (com.sleepycat.db.DeadlockException e) {
                if (txn != null) {
                    DeadlockException ex = new DeadlockException(this._errorPrefix + "Db.put: " + e.getMessage(), this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.putImpl while writing into Db \"" + this._db.dbName() + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.put: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    private boolean removeImpl(DatabaseEntry dbKey) {
        com.sleepycat.db.Transaction txn;
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        if (this._trace >= 2) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "deleting value from Db \"" + this._db.dbName() + "\"");
        }
        if ((txn = this._connection.dbTxn()) == null) {
            this.closeAllIterators();
        }
        while (true) {
            try {
                OperationStatus rc = this._db.db().delete(txn, dbKey);
                return rc == OperationStatus.SUCCESS;
            }
            catch (com.sleepycat.db.DeadlockException e) {
                if (txn != null) {
                    DeadlockException ex = new DeadlockException(this._errorPrefix + "Db.del: " + e.getMessage(), this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.removeImpl while writing into Db \"" + this._db.dbName() + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.del: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    public static class Patcher
    implements IceInternal.Patcher {
        public String type;
        public Ice.Object value;

        public Patcher(String type) {
            this.type = type;
        }

        public void patch(Ice.Object v) {
            this.value = v;
        }

        public String type() {
            return this.type;
        }

        public Ice.Object value() {
            return this.value;
        }
    }

    static class Entry
    implements Map.Entry {
        private EntryIteratorImpl _iterator;
        private Map _map;
        private Communicator _communicator;
        private DatabaseEntry _dbKey;
        private byte[] _valueBytes;
        private byte[] _indexBytes;
        private Object _key;
        private boolean _haveKey = false;
        private Object _value;
        private boolean _haveValue = false;

        public Entry(EntryIteratorImpl iterator, Map map, Communicator communicator, DatabaseEntry dbKey, byte[] valueBytes, byte[] indexBytes) {
            this._iterator = iterator;
            this._map = map;
            this._communicator = communicator;
            this._dbKey = dbKey;
            this._valueBytes = valueBytes;
            this._indexBytes = indexBytes;
        }

        public Object getKey() {
            if (!this._haveKey) {
                assert (this._dbKey != null);
                this._key = this._map.decodeKey(this._dbKey.getData(), this._communicator);
                this._haveKey = true;
            }
            return this._key;
        }

        public Object getValue() {
            if (!this._haveValue) {
                assert (this._valueBytes != null);
                this._value = this._map.decodeValue(this._valueBytes, this._communicator);
                this._haveValue = true;
                this._valueBytes = null;
            }
            return this._value;
        }

        public byte[] getIndexBytes() {
            return this._indexBytes;
        }

        public Object setValue(Object value) {
            Object old = this.getValue();
            this._iterator.setValue(this, value);
            this._value = value;
            this._haveValue = true;
            return old;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.eq(this.getKey(), e.getKey()) && this.eq(this.getValue(), e.getValue());
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        DatabaseEntry getDbKey() {
            return this._dbKey;
        }

        private boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    class EntryIteratorImpl
    implements EntryIterator {
        private com.sleepycat.db.Transaction _txn;
        private Cursor _cursor;
        private Entry _current;
        private Entry _lastReturned;
        private Iterator _iteratorListToken;
        private final Index _index;
        private final byte[] _fromKey;
        private final byte[] _toKey;
        private final boolean _onlyFromKeyDups;
        private final boolean _skipDups;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntryIteratorImpl(Index index, byte[] fromKey, byte[] toKey, boolean onlyFromKeyDups, boolean skipDups) {
            this._index = index;
            this._fromKey = fromKey;
            this._toKey = toKey;
            this._onlyFromKeyDups = onlyFromKeyDups;
            this._skipDups = skipDups;
            try {
                com.sleepycat.db.Transaction txn = Map.this._connection.dbTxn();
                if (txn == null) {
                    this._txn = txn = Map.this._connection.dbEnv().getEnv().beginTransaction(null, null);
                    if (Map.this._connection.txTrace() >= 1) {
                        String txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
                        Map.this._connection.communicator().getLogger().trace("Freeze.Map", Map.this._errorPrefix + "started transaction " + txnId + " for cursor");
                    }
                }
                this._cursor = index == null ? Map.this._db.db().openCursor(txn, null) : index.db().openSecondaryCursor(txn, null);
            }
            catch (com.sleepycat.db.DeadlockException dx) {
                this.dead();
                DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "EntryIterator constructor: " + dx.getMessage(), Map.this._connection.currentTransaction());
                ex.initCause(dx);
                throw ex;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                this.dead();
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = Map.this._errorPrefix + "EntryIterator constructor: " + dx.getMessage();
                throw ex;
            }
            LinkedList linkedList = Map.this._iteratorList;
            synchronized (linkedList) {
                Map.this._iteratorList.addFirst(this);
                Iterator p = Map.this._iteratorList.iterator();
                p.next();
                this._iteratorListToken = p;
            }
        }

        public boolean hasNext() {
            if (this._current == null || this._current == this._lastReturned) {
                DatabaseEntry dbKey = new DatabaseEntry();
                DatabaseEntry dbValue = new DatabaseEntry();
                DatabaseEntry dbIKey = new DatabaseEntry();
                OperationStatus status = null;
                try {
                    if (this._index != null) {
                        SecondaryCursor c = (SecondaryCursor)this._cursor;
                        if (this._current == null) {
                            if (this._fromKey != null) {
                                dbIKey.setData(this._fromKey);
                                status = c.getSearchKey(dbIKey, dbKey, dbValue, null);
                            } else {
                                status = c.getFirst(dbIKey, dbKey, dbValue, null);
                            }
                        } else {
                            status = this._onlyFromKeyDups ? c.getNextDup(dbIKey, dbKey, dbValue, null) : (this._skipDups ? c.getNextNoDup(dbIKey, dbKey, dbValue, null) : c.getNext(dbIKey, dbKey, dbValue, null));
                        }
                    } else if (this._current == null && this._fromKey != null) {
                        dbKey.setData(this._fromKey);
                        status = this._cursor.getSearchKey(dbKey, dbValue, null);
                    } else {
                        status = this._cursor.getNext(dbKey, dbValue, null);
                    }
                }
                catch (com.sleepycat.db.DeadlockException dx) {
                    this.dead();
                    DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "Dbc.get: " + dx.getMessage(), Map.this._connection.currentTransaction());
                    ex.initCause(dx);
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    this.dead();
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = Map.this._errorPrefix + "Dbc.get: " + dx.getMessage();
                    throw ex;
                }
                if (status == OperationStatus.SUCCESS) {
                    boolean inRange = true;
                    if (this._toKey != null) {
                        if (this._index != null) {
                            inRange = this._index.compare(dbIKey.getData(), this._toKey) < 0;
                        } else {
                            boolean bl = inRange = Map.this._comparator.compare(dbKey.getData(), this._toKey) < 0;
                        }
                    }
                    if (inRange) {
                        this._current = new Entry(this, Map.this, Map.this._connection.communicator(), dbKey, dbValue.getData(), dbIKey.getData());
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.hasNext()) {
                this._lastReturned = this._current;
                return this._lastReturned;
            }
            throw new java.util.NoSuchElementException();
        }

        public void remove() {
            block17: {
                if (this._txn != null) {
                    Map.this.closeAllIteratorsExcept(this, false);
                }
                if (this._lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (this._lastReturned == this._current) {
                    try {
                        if (this._cursor.delete() == OperationStatus.KEYEMPTY) {
                            throw new IllegalStateException();
                        }
                        break block17;
                    }
                    catch (com.sleepycat.db.DeadlockException e) {
                        this.dead();
                        DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "Dbc.del: " + e.getMessage(), Map.this._connection.currentTransaction());
                        ex.initCause(e);
                        throw ex;
                    }
                    catch (com.sleepycat.db.DatabaseException e) {
                        DatabaseException ex = new DatabaseException();
                        ex.initCause(e);
                        ex.message = Map.this._errorPrefix + "Dbc.del: " + e.getMessage();
                        throw ex;
                    }
                }
                if (this._index != null) {
                    throw new UnsupportedOperationException();
                }
                Cursor clone = null;
                try {
                    clone = this._cursor.dup(true);
                    DatabaseEntry dbValue = new DatabaseEntry();
                    dbValue.setPartial(true);
                    OperationStatus rc = clone.getSearchKey(this._lastReturned.getDbKey(), dbValue, null);
                    if (rc == OperationStatus.NOTFOUND) {
                        throw new IllegalStateException();
                    }
                    if (clone.delete() == OperationStatus.KEYEMPTY) {
                        throw new IllegalStateException();
                    }
                }
                catch (com.sleepycat.db.DeadlockException e) {
                    this.dead();
                    DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "EntryIterator.remove: " + e.getMessage(), Map.this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException e) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "EntryIterator.remove: " + e.getMessage();
                    throw ex;
                }
                finally {
                    if (clone != null) {
                        this.closeCursor(clone);
                    }
                }
            }
        }

        public void close() {
            this.close(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void close(boolean finalizing) {
            if (finalizing && (this._cursor != null || this._txn != null) && Map.this._connection.closeInFinalizeWarning()) {
                Map.this._connection.communicator().getLogger().warning("finalize() closing a live iterator on Map \"" + Map.this._db.dbName() + "\"; the application " + "should have closed it earlier by calling Map.EntryIterator.close(), " + "Map.closeAllIterators(), Map.close(), Connection.close(), or (if also " + "leaking a transaction) Transaction.commit() or Transaction.rollback()");
            }
            if (this._iteratorListToken != null) {
                LinkedList linkedList = Map.this._iteratorList;
                synchronized (linkedList) {
                    this._iteratorListToken.remove();
                    this._iteratorListToken = null;
                }
            }
            if (this._cursor != null) {
                Cursor cursor = this._cursor;
                this._cursor = null;
                this.closeCursor(cursor);
            }
            if (this._txn != null) {
                String txnId = null;
                try {
                    if (Map.this._connection.txTrace() >= 1) {
                        txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
                    }
                    this._txn.commit();
                    if (Map.this._connection.txTrace() >= 1) {
                        Map.this._connection.communicator().getLogger().trace("Freeze.Map", Map.this._errorPrefix + "committed transaction " + txnId);
                    }
                }
                catch (com.sleepycat.db.DeadlockException e) {
                    if (Map.this._connection.txTrace() >= 1) {
                        Map.this._connection.communicator().getLogger().trace("Freeze.Map", Map.this._errorPrefix + "failed to commit transaction " + txnId + ": " + e.getMessage());
                    }
                    DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "DbTxn.commit: " + e.getMessage(), Map.this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException e) {
                    if (Map.this._connection.txTrace() >= 1) {
                        Map.this._connection.communicator().getLogger().trace("Freeze.Map", Map.this._errorPrefix + "failed to commit transaction " + txnId + ": " + e.getMessage());
                    }
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "DbTxn.commit: " + e.getMessage();
                    throw ex;
                }
                finally {
                    this._txn = null;
                }
            }
        }

        public void destroy() {
            this.close();
        }

        protected void finalize() {
            this.close(true);
        }

        void setValue(Entry entry, Object value) {
            if (this._index != null) {
                throw new UnsupportedOperationException(Map.this._errorPrefix + "Cannot set an iterator retrieved through an index");
            }
            if (this._txn != null) {
                Map.this.closeAllIteratorsExcept(this, false);
            }
            if (this._current == entry) {
                byte[] v = Map.this.encodeValue(value, Map.this._connection.communicator());
                DatabaseEntry dbValue = new DatabaseEntry(v);
                try {
                    this._cursor.putCurrent(dbValue);
                }
                catch (com.sleepycat.db.DeadlockException e) {
                    this.dead();
                    DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "Dbc.put: " + e.getMessage(), Map.this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException e) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "Dbc.put: " + e.getMessage();
                    throw ex;
                }
            }
            Cursor clone = null;
            try {
                clone = this._cursor.dup(true);
                DatabaseEntry dummy = new DatabaseEntry();
                dummy.setPartial(true);
                OperationStatus rc = clone.getSearchKey(entry.getDbKey(), dummy, null);
                if (rc == OperationStatus.NOTFOUND) {
                    NotFoundException ex = new NotFoundException();
                    ex.message = Map.this._errorPrefix + "Dbc.get: DB_NOTFOUND";
                    throw ex;
                }
                byte[] v = Map.this.encodeValue(value, Map.this._connection.communicator());
                DatabaseEntry dbValue = new DatabaseEntry(v);
                clone.putCurrent(dbValue);
            }
            catch (com.sleepycat.db.DeadlockException e) {
                this.dead();
                DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "EntryIterator.setValue: " + e.getMessage(), Map.this._connection.currentTransaction());
                ex.initCause(e);
                throw ex;
            }
            catch (com.sleepycat.db.DatabaseException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = Map.this._errorPrefix + "EntryIterator.setValue: " + e.getMessage();
                throw ex;
            }
            finally {
                if (clone != null) {
                    this.closeCursor(clone);
                }
            }
        }

        private void closeCursor(Cursor cursor) {
            try {
                cursor.close();
            }
            catch (com.sleepycat.db.DeadlockException e) {
                this.dead();
                DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "Dbc.close: " + e.getMessage(), Map.this._connection.currentTransaction());
                ex.initCause(e);
                throw ex;
            }
            catch (com.sleepycat.db.DatabaseException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = Map.this._errorPrefix + "Dbc.close: " + e.getMessage();
                throw ex;
            }
        }

        private void dead() {
            if (this._cursor != null) {
                Cursor cursor = this._cursor;
                this._cursor = null;
                this.closeCursor(cursor);
            }
            if (this._txn != null) {
                String txnId = null;
                try {
                    if (Map.this._connection.txTrace() >= 1) {
                        txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
                    }
                    this._txn.abort();
                    if (Map.this._connection.txTrace() >= 1) {
                        Map.this._connection.communicator().getLogger().trace("Freeze.Map", Map.this._errorPrefix + "rolled back transaction " + txnId);
                    }
                }
                catch (com.sleepycat.db.DeadlockException e) {
                    if (Map.this._connection.txTrace() >= 1) {
                        Map.this._connection.communicator().getLogger().trace("Freeze.Map", Map.this._errorPrefix + "failed to roll back transaction " + txnId + ": " + e.getMessage());
                    }
                    DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "DbTxn.abort: " + e.getMessage(), Map.this._connection.currentTransaction());
                    ex.initCause(e);
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException e) {
                    if (Map.this._connection.txTrace() >= 1) {
                        Map.this._connection.communicator().getLogger().trace("Freeze.Map", Map.this._errorPrefix + "failed to roll back transaction " + txnId + ": " + e.getMessage());
                    }
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "DbTxn.abort: " + e.getMessage();
                    throw ex;
                }
                finally {
                    this._txn = null;
                }
            }
        }
    }

    public static interface EntryIterator
    extends Iterator {
        public void close();

        public void destroy();
    }

    public abstract class Index
    implements SecondaryKeyCreator,
    java.util.Comparator,
    KeyCodec {
        protected java.util.Comparator _comparator;
        private String _name;
        private String _dbName;
        private SecondaryDatabase _db;

        public boolean createSecondaryKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry value, DatabaseEntry result) throws com.sleepycat.db.DatabaseException {
            Communicator communicator = Map.this._connection.getCommunicator();
            byte[] secondaryKey = this.marshalKey(value.getData());
            assert (secondaryKey != null);
            result.setData(secondaryKey);
            result.setSize(secondaryKey.length);
            return true;
        }

        SecondaryDatabase db() {
            return this._db;
        }

        String name() {
            return this._name;
        }

        protected Index(String name) {
            this._name = name;
        }

        void associate(String dbName, Database db, com.sleepycat.db.Transaction txn, boolean createDb, java.util.Comparator comparator) throws com.sleepycat.db.DatabaseException, FileNotFoundException {
            int pageSize;
            boolean checksum;
            this._dbName = dbName + "." + this._name;
            this._comparator = comparator;
            assert (txn != null);
            assert (this._db == null);
            SecondaryConfig config = new SecondaryConfig();
            config.setAllowCreate(createDb);
            config.setAllowPopulate(true);
            config.setSortedDuplicates(true);
            config.setType(DatabaseType.BTREE);
            if (this._comparator != null) {
                config.setBtreeComparator((java.util.Comparator)this);
            }
            config.setKeyCreator((SecondaryKeyCreator)this);
            Properties properties = Map.this._connection.communicator().getProperties();
            String propPrefix = "Freeze.Map." + this._dbName + ".";
            int btreeMinKey = properties.getPropertyAsInt(propPrefix + "BtreeMinKey");
            if (btreeMinKey > 2) {
                if (Map.this._trace >= 1) {
                    Map.this._connection.communicator().getLogger().trace("Freeze.Map", "Setting \"" + this._dbName + "\"'s btree minkey to " + btreeMinKey);
                }
                config.setBtreeMinKey(btreeMinKey);
            }
            boolean bl = checksum = properties.getPropertyAsInt(propPrefix + "Checksum") > 0;
            if (checksum) {
                if (Map.this._trace >= 1) {
                    Map.this._connection.communicator().getLogger().trace("Freeze.Map", "Turning checksum on for \"" + this._dbName + "\"");
                }
                config.setChecksum(true);
            }
            if ((pageSize = properties.getPropertyAsInt(propPrefix + "PageSize")) > 0) {
                if (Map.this._trace >= 1) {
                    Map.this._connection.communicator().getLogger().trace("Freeze.Map", "Setting \"" + this._dbName + "\"'s pagesize to " + pageSize);
                }
                config.setPageSize(pageSize);
            }
            this._db = Map.this._connection.dbEnv().getEnv().openSecondaryDatabase(txn, this._dbName, null, db, config);
        }

        void init(Index from) {
            assert (this._name.equals(from._name));
            assert (this._db == null);
            this._dbName = from._dbName;
            this._db = from._db;
            this._comparator = from._comparator;
        }

        java.util.Comparator comparator() {
            return this._comparator;
        }

        Map parent() {
            return Map.this;
        }

        Object firstKey(Object fromKey, Object toKey) {
            byte[] fk = fromKey == null ? null : this.encodeKey(fromKey, Map.this._connection.communicator());
            byte[] k = Map.this.getFirstOrLastKey((Database)this._db, this._dbName, fk, true);
            if (k == null) {
                throw new NoSuchElementException();
            }
            Object key = this.decodeKey(k, Map.this._connection.communicator());
            if (toKey != null && this._comparator.compare(key, toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return key;
        }

        Object lastKey(Object fromKey, Object toKey) {
            byte[] tk = toKey == null ? null : this.encodeKey(toKey, Map.this._connection.communicator());
            byte[] k = Map.this.getFirstOrLastKey((Database)this._db, this._dbName, tk, false);
            if (k == null) {
                throw new NoSuchElementException();
            }
            Object key = this.decodeKey(k, Map.this._connection.communicator());
            if (fromKey != null && this._comparator.compare(fromKey, key) > 0) {
                throw new NoSuchElementException();
            }
            return key;
        }

        void close() {
            if (this._db != null) {
                try {
                    this._db.close();
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = Map.this._errorPrefix + "Db.close for index \"" + this._dbName + "\": " + dx.getMessage();
                    throw ex;
                }
                this._db = null;
            }
        }

        public EntryIterator untypedFind(Object key, boolean onlyDups) {
            byte[] k = this.encodeKey(key, Map.this._connection.communicator());
            return new EntryIteratorImpl(this, k, null, onlyDups, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public int untypedCount(Object key) {
            byte[] k = this.encodeKey(key, Map.this._connection.communicator());
            DatabaseEntry dbKey = new DatabaseEntry(k);
            DatabaseEntry dbValue = new DatabaseEntry();
            dbKey.setPartial(true);
            dbValue.setPartial(true);
            block16: while (true) {
                try {
                    while (true) {
                        Cursor dbc = null;
                        try {
                            dbc = this._db.openCursor(null, null);
                            if (dbc.getSearchKey(dbKey, dbValue, null) == OperationStatus.SUCCESS) {
                                int n = dbc.count();
                                return n;
                            }
                            int n = 0;
                            return n;
                        }
                        catch (com.sleepycat.db.DeadlockException dx) {
                            if (!Map.this._connection.deadlockWarning()) continue block16;
                            Map.this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.Index.untypedCount while iterating over index \"" + this._dbName + "\"; retrying...");
                            continue block16;
                        }
                        finally {
                            if (dbc == null) continue;
                            try {
                                dbc.close();
                                continue block16;
                            }
                            catch (com.sleepycat.db.DeadlockException dx) {}
                        }
                        break;
                    }
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = Map.this._errorPrefix + "Db.cursor for index \"" + this._dbName + "\": " + dx.getMessage();
                    throw ex;
                }
            }
        }

        boolean containsKey(Object key) {
            byte[] k = this.encodeKey(key, Map.this._connection.communicator());
            DatabaseEntry dbKey = new DatabaseEntry(k);
            DatabaseEntry dbValue = new DatabaseEntry();
            dbValue.setPartial(true);
            if (Map.this._trace >= 2) {
                Map.this._connection.communicator().getLogger().trace("Freeze.Map.Index", "checking key in Db \"" + this._dbName + "\"");
            }
            while (true) {
                try {
                    return this._db.get(Map.this._connection.dbTxn(), dbKey, dbValue, null) == OperationStatus.SUCCESS;
                }
                catch (com.sleepycat.db.DeadlockException e) {
                    if (Map.this._connection.dbTxn() != null) {
                        DeadlockException ex = new DeadlockException(Map.this._errorPrefix + "Db.get: " + e.getMessage(), Map.this._connection.currentTransaction());
                        ex.initCause(e);
                        throw ex;
                    }
                    if (!Map.this._connection.deadlockWarning()) continue;
                    Map.this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.Index.containsKey while reading Db \"" + this._dbName + "\"; retrying...");
                    continue;
                }
                catch (com.sleepycat.db.DatabaseException e) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "Db.get: " + e.getMessage();
                    throw ex;
                }
                break;
            }
        }

        public abstract Object extractKey(Object var1);

        protected byte[] marshalKey(byte[] value) {
            Object decodedValue = Map.this.decodeValue(value, Map.this._connection.communicator());
            return this.encodeKey(this.extractKey(decodedValue), Map.this._connection.communicator());
        }
    }

    private class Comparator
    implements java.util.Comparator {
        private final java.util.Comparator _comparator;

        Comparator(java.util.Comparator comparator) {
            this._comparator = comparator;
        }

        public java.util.Comparator comparator() {
            return this._comparator;
        }

        public int compare(Object o1, Object o2) {
            byte[] d1 = (byte[])o1;
            byte[] d2 = (byte[])o2;
            Communicator communicator = Map.this._connection.communicator();
            return this._comparator.compare(Map.this.decodeKey(d1, communicator), Map.this.decodeKey(d2, communicator));
        }
    }
}

