/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.util.Random;
import loci.common.LogTools;
import loci.formats.codec.BitBuffer;

public class BitWriter {
    private byte[] buf;
    private int index;
    private int bit;

    public BitWriter() {
        this(10);
    }

    public BitWriter(int size) {
        this.buf = new byte[size];
    }

    public void write(int value, int numBits) {
        int i;
        byte[] bits = new byte[numBits];
        for (i = 0; i < numBits; ++i) {
            bits[i] = (byte)(value & 1);
            value >>= 1;
        }
        for (i = numBits - 1; i >= 0; --i) {
            int b = bits[i] << 7 - this.bit;
            int n = this.index++;
            this.buf[n] = (byte)(this.buf[n] | b);
            ++this.bit;
            if (this.bit <= 7) continue;
            this.bit = 0;
            if (this.index < this.buf.length) continue;
            byte[] newBuf = new byte[this.buf.length * 2];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    public void write(String bitString) {
        for (int i = 0; i < bitString.length(); ++i) {
            if ('1' == bitString.charAt(i)) {
                int b = 1 << 7 - this.bit;
                int n = this.index;
                this.buf[n] = (byte)(this.buf[n] | b);
            } else if ('0' != bitString.charAt(i)) {
                throw new IllegalArgumentException(bitString.charAt(i) + "found at character " + i + "; 0 or 1 expected. Write only partially completed.");
            }
            ++this.bit;
            if (this.bit <= 7) continue;
            this.bit = 0;
            ++this.index;
            if (this.index < this.buf.length) continue;
            byte[] newBuf = new byte[this.buf.length * 2];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    public byte[] toByteArray() {
        int size = this.index;
        if (this.bit > 0) {
            ++size;
        }
        byte[] b = new byte[size];
        System.arraycopy(this.buf, 0, b, 0, size);
        return b;
    }

    public static void main(String[] args) {
        int i;
        int max = 50000;
        LogTools.println("Generating random list of " + max + " values");
        int[] values = new int[max];
        int[] bits = new int[max];
        double log2 = Math.log(2.0);
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = (int)(50000.0 * Math.random()) + 1;
            int minBits = (int)Math.ceil(Math.log(values[i2] + 1) / log2);
            bits[i2] = (int)(10.0 * Math.random()) + minBits;
        }
        LogTools.println("Writing values to byte array");
        BitWriter out = new BitWriter();
        for (int i3 = 0; i3 < values.length; ++i3) {
            out.write(values[i3], bits[i3]);
        }
        LogTools.println("Reading values from byte array");
        BitBuffer bb = new BitBuffer(out.toByteArray());
        for (int i4 = 0; i4 < values.length; ++i4) {
            int value = bb.getBits(bits[i4]);
            if (value == values[i4]) continue;
            LogTools.println("Value #" + i4 + " does not match (got " + value + "; expected " + values[i4] + "; " + bits[i4] + " bits)");
        }
        Random r = new Random();
        LogTools.println("Generating 5000 random bits for String test");
        StringBuffer sb = new StringBuffer(5000);
        for (i = 0; i < 5000; ++i) {
            sb.append(r.nextInt(2));
        }
        out = new BitWriter();
        LogTools.println("Writing values to byte array");
        out.write(sb.toString());
        LogTools.println("Reading values from byte array");
        bb = new BitBuffer(out.toByteArray());
        for (i = 0; i < 5000; ++i) {
            int expected;
            int value = bb.getBits(1);
            int n = expected = sb.charAt(i) == '1' ? 1 : 0;
            if (value == expected) continue;
            LogTools.println("Bit #" + i + " does not match (got " + value + "; expected " + expected + ".");
        }
    }
}

