/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MDBParser;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;

public class APLReader
extends FormatReader {
    private String[] tiffFiles;
    private String[] xmlFiles;
    private MinimalTiffReader[] tiffReaders;
    private Vector<String> used;

    public APLReader() {
        super("Olympus APL", new String[]{"apl", "tnb", "mtb"});
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.addAll(this.used);
        if (this.getSeries() < this.xmlFiles.length) {
            files.add(this.xmlFiles[this.getSeries()]);
        }
        if (!noPixels && this.getSeries() < this.tiffFiles.length) {
            files.add(this.tiffFiles[this.getSeries()]);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.tiffReaders[this.series].openBytes(no, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiffReaders != null) {
            for (MinimalTiffReader reader : this.tiffReaders) {
                reader.close(fileOnly);
            }
        }
        if (!fileOnly) {
            this.tiffReaders = null;
            this.tiffFiles = null;
            this.xmlFiles = null;
            this.used = null;
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Object[] columnNames;
        this.debug("APLReader.initFile(" + id + ")");
        super.initFile(id);
        String name = id.toLowerCase();
        if (!name.endsWith(".mtb")) {
            String mtbFile;
            int underscore;
            int separator = id.lastIndexOf(File.separator);
            if (separator < 0) {
                separator = 0;
            }
            if ((underscore = id.lastIndexOf("_")) < separator) {
                underscore = id.lastIndexOf(".");
            }
            if (!new Location(mtbFile = id.substring(0, underscore) + "_d.mtb").exists()) {
                throw new FormatException(".mtb file not found");
            }
            this.currentId = new Location(mtbFile).getAbsolutePath();
        }
        String mtb = new Location(this.currentId).getAbsolutePath();
        Vector<String[]> rows = MDBParser.parseDatabase(mtb)[0];
        Object[] tmpNames = columnNames = rows.get(0);
        columnNames = new String[tmpNames.length - 1];
        System.arraycopy(tmpNames, 1, columnNames, 0, columnNames.length);
        for (int i2 = 1; i2 < rows.size(); ++i2) {
            String[] row = rows.get(i2);
            for (int q = 0; q < row.length; ++q) {
                this.addGlobalMeta((String)columnNames[q] + " " + i2, row[q]);
            }
        }
        this.used = new Vector();
        this.used.add(id);
        if (!id.equals(mtb)) {
            this.used.add(mtb);
        }
        int calibrationUnit = DataTools.indexOf(columnNames, "Calibration Unit");
        int colorChannels = DataTools.indexOf(columnNames, "Color Channels");
        int frames = DataTools.indexOf(columnNames, "Frames");
        int calibratedHeight = DataTools.indexOf(columnNames, "Height");
        int calibratedWidth = DataTools.indexOf(columnNames, "Width");
        int path = DataTools.indexOf(columnNames, "Image Path");
        int filename = DataTools.indexOf(columnNames, "File Name");
        int magnification = DataTools.indexOf(columnNames, "Magnification");
        int width = DataTools.indexOf(columnNames, "X-Resolution");
        int height = DataTools.indexOf(columnNames, "Y-Resolution");
        int imageName = DataTools.indexOf(columnNames, "Image Name");
        int zLayers = DataTools.indexOf(columnNames, "Z-Layers");
        String parentDirectory = mtb.substring(0, mtb.lastIndexOf(File.separator));
        Location dir = new Location(parentDirectory);
        String[] list = dir.list(true);
        String topDirectory = null;
        for (String f : list) {
            Location file = new Location(dir, f);
            if (!file.isDirectory() || !f.endsWith("_DocumentFiles")) continue;
            topDirectory = file.getAbsolutePath();
        }
        if (topDirectory == null) {
            throw new FormatException("Could not find a directory with TIFF files.");
        }
        Vector<Integer> seriesIndexes = new Vector<Integer>();
        for (int i3 = 1; i3 < rows.size(); ++i3) {
            String file = rows.get(i3)[filename].trim();
            if (file.equals("") || !new Location(file = topDirectory + File.separator + file).exists() || !file.toLowerCase().endsWith(".tif")) continue;
            seriesIndexes.add(new Integer(i3));
        }
        int seriesCount = seriesIndexes.size();
        this.core = new CoreMetadata[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            this.core[i] = new CoreMetadata();
        }
        this.tiffFiles = new String[seriesCount];
        this.xmlFiles = new String[seriesCount];
        this.tiffReaders = new MinimalTiffReader[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            int secondRow = (Integer)seriesIndexes.get(i);
            int firstRow = secondRow - 1;
            String[] row2 = rows.get(firstRow);
            String[] row3 = rows.get(secondRow);
            try {
                this.core[i].sizeT = Integer.parseInt(row3[frames]);
            }
            catch (NumberFormatException e) {
                this.core[i].sizeT = 1;
            }
            try {
                this.core[i].sizeZ = Integer.parseInt(row3[zLayers]);
            }
            catch (NumberFormatException e) {
                this.core[i].sizeZ = 1;
            }
            try {
                this.core[i].sizeC = Integer.parseInt(row3[colorChannels]);
            }
            catch (NumberFormatException e) {
                this.core[i].sizeC = 1;
            }
            this.core[i].dimensionOrder = "XYCZT";
            if (this.core[i].sizeZ == 0) {
                this.core[i].sizeZ = 1;
            }
            if (this.core[i].sizeC == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.core[i].sizeT == 0) {
                this.core[i].sizeT = 1;
            }
            this.xmlFiles[i] = topDirectory + File.separator + row2[filename];
            this.tiffFiles[i] = topDirectory + File.separator + row3[filename];
            this.tiffReaders[i] = new MinimalTiffReader();
            this.tiffReaders[i].setId(this.tiffFiles[i]);
            this.core[i].sizeX = this.tiffReaders[i].getSizeX();
            this.core[i].sizeY = this.tiffReaders[i].getSizeY();
            this.core[i].rgb = this.tiffReaders[i].isRGB();
            this.core[i].pixelType = this.tiffReaders[i].getPixelType();
            this.core[i].littleEndian = this.tiffReaders[i].isLittleEndian();
            this.core[i].indexed = this.tiffReaders[i].isIndexed();
            this.core[i].falseColor = this.tiffReaders[i].isFalseColor();
            this.core[i].imageCount = this.tiffReaders[i].getImageCount();
            if (this.core[i].sizeZ * this.core[i].sizeT * (this.core[i].rgb ? 1 : this.core[i].sizeC) == this.core[i].imageCount) continue;
            this.core[i].sizeT = this.core[i].imageCount / (this.core[i].rgb ? 1 : this.core[i].sizeC);
            this.core[i].sizeZ = 1;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        for (int i4 = 0; i4 < seriesCount; ++i4) {
            String[] row = rows.get((Integer)seriesIndexes.get(i4));
            MetadataTools.setDefaultCreationDate(store, mtb, i4);
            store.setImageName(row[imageName], i4);
            float realWidth = Float.parseFloat(row[calibratedWidth]);
            float realHeight = Float.parseFloat(row[calibratedHeight]);
            String units = row[calibrationUnit];
            float px = realWidth / (float)this.core[i4].sizeX;
            float py = realHeight / (float)this.core[i4].sizeY;
            if (units.equals("mm")) {
                px *= 1000.0f;
                py *= 1000.0f;
            }
            store.setDimensionsPhysicalSizeX(new Float(px), i4, 0);
            store.setDimensionsPhysicalSizeY(new Float(py), i4, 0);
        }
    }
}

