/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.zip.GZIPInputStream;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class LiFlimReader
extends FormatReader {
    public static final String VERSION_KEY = "FLIMIMAGE: INFO - version";
    public static final String COMPRESSION_KEY = "FLIMIMAGE: INFO - compression";
    public static final String DATATYPE_KEY = "FLIMIMAGE: LAYOUT - datatype";
    public static final String C_KEY = "FLIMIMAGE: LAYOUT - channels";
    public static final String X_KEY = "FLIMIMAGE: LAYOUT - x";
    public static final String Y_KEY = "FLIMIMAGE: LAYOUT - y";
    public static final String Z_KEY = "FLIMIMAGE: LAYOUT - z";
    public static final String P_KEY = "FLIMIMAGE: LAYOUT - phases";
    public static final String F_KEY = "FLIMIMAGE: LAYOUT - frequencies";
    public static final String T_KEY = "FLIMIMAGE: LAYOUT - timestamps";
    public static final String[] KNOWN_VERSIONS = new String[]{"1.0"};
    public static final String COMPRESSION_NONE = "0";
    public static final String COMPRESSION_GZIP = "1";
    public static final String DATATYPE_UINT8 = "UINT8";
    public static final String DATATYPE_INT8 = "INT8";
    public static final String DATATYPE_UINT16 = "UINT16";
    public static final String DATATYPE_INT16 = "INT16";
    public static final String DATATYPE_UINT32 = "UINT32";
    public static final String DATATYPE_INT32 = "INT32";
    public static final String DATATYPE_REAL32 = "REAL32";
    public static final String DATATYPE_REAL64 = "REAL64";
    private long dataOffset;
    private IniList ini;
    private String version;
    private String compression;
    private String datatype;
    private String channels;
    private String xLen;
    private String yLen;
    private String zLen;
    private String phases;
    private String frequencies;
    private String timestamps;
    private boolean gzip;
    private DataInputStream gz;
    private int gzPos;

    public LiFlimReader() {
        super("LI-FLIM", "fli");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int sizeX = this.getSizeX();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int bytesPerPlane = this.getSizeX() * this.getSizeY() * bpp;
        int size = bpp * w * h;
        if (this.gzip) {
            this.prepareGZipStream(no);
            byte[] bytes = new byte[bytesPerPlane];
            this.gz.readFully(bytes);
            if (w == sizeX) {
                System.arraycopy(bytes, sizeX * y, buf, 0, buf.length);
            } else {
                for (int r = 0; r < h; ++r) {
                    int bytesIndex = bpp * (sizeX * (r + y) + x);
                    int bufIndex = bpp * w * r;
                    System.arraycopy(bytes, bytesIndex, buf, bufIndex, bpp * w);
                }
            }
        } else if (w == sizeX) {
            int scan = bpp * sizeX;
            this.in.seek(this.dataOffset + (long)(bytesPerPlane * no) + (long)(scan * y));
            this.in.readFully(buf, 0, size);
        } else {
            int scan = bpp * sizeX;
            this.in.seek(this.dataOffset + (long)(bytesPerPlane * no) + (long)(scan * y) + (long)(bpp * x));
            int read = bpp * w;
            for (int i = 0; i < size; i += read) {
                this.in.readFully(buf, i, read);
                this.in.skipBytes(scan - read);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.dataOffset = 0L;
            this.ini = null;
            this.gzip = false;
            if (this.gz != null) {
                this.gz.close();
            }
            this.gz = null;
            this.gzPos = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("LiFlimReader.initFile(" + id + ")");
        super.initFile(id);
        this.status("Parsing header");
        this.in = new RandomAccessInputStream(id);
        this.parseHeader();
        this.status("Parsing metadata");
        this.initOriginalMetadata();
        this.initCoreMetadata();
        this.initOMEMetadata();
    }

    private void parseHeader() throws IOException {
        String headerData = this.in.findString("{END}");
        this.dataOffset = this.in.getFilePointer();
        IniParser parser = new IniParser();
        this.ini = parser.parseINI(new BufferedReader(new StringReader(headerData)));
    }

    private void initOriginalMetadata() {
        for (IniTable table : this.ini) {
            String name = (String)table.get("header");
            for (String key : table.keySet()) {
                if (key.equals("header")) continue;
                String value = (String)table.get(key);
                String metaKey = name + " - " + key;
                this.addGlobalMeta(metaKey, value);
                if (metaKey.equals(VERSION_KEY)) {
                    this.version = value;
                    continue;
                }
                if (metaKey.equals(COMPRESSION_KEY)) {
                    this.compression = value;
                    continue;
                }
                if (metaKey.equals(DATATYPE_KEY)) {
                    this.datatype = value;
                    continue;
                }
                if (metaKey.equals(C_KEY)) {
                    this.channels = value;
                    continue;
                }
                if (metaKey.equals(X_KEY)) {
                    this.xLen = value;
                    continue;
                }
                if (metaKey.equals(Y_KEY)) {
                    this.yLen = value;
                    continue;
                }
                if (metaKey.equals(Z_KEY)) {
                    this.zLen = value;
                    continue;
                }
                if (metaKey.equals(P_KEY)) {
                    this.phases = value;
                    continue;
                }
                if (metaKey.equals(F_KEY)) {
                    this.frequencies = value;
                    continue;
                }
                if (!metaKey.equals(T_KEY)) continue;
                this.timestamps = value;
            }
        }
    }

    private void initCoreMetadata() throws FormatException {
        int pixelType;
        if (DataTools.indexOf(KNOWN_VERSIONS, this.version) < 0) {
            LogTools.warnDebug("Warning: unknown LI-FLIM version: " + this.version);
        }
        if (COMPRESSION_NONE.equals(this.compression)) {
            this.gzip = false;
        } else if (COMPRESSION_GZIP.equals(this.compression)) {
            this.gzip = true;
        } else {
            throw new FormatException("Unknown compression type: " + this.compression);
        }
        if (DATATYPE_UINT8.equals(this.datatype)) {
            pixelType = 1;
        } else if (DATATYPE_INT8.equals(this.datatype)) {
            pixelType = 0;
        } else if (DATATYPE_UINT16.equals(this.datatype)) {
            pixelType = 3;
        } else if (DATATYPE_INT16.equals(this.datatype)) {
            pixelType = 2;
        } else if (DATATYPE_UINT32.equals(this.datatype)) {
            pixelType = 5;
        } else if (DATATYPE_INT32.equals(this.datatype)) {
            pixelType = 4;
        } else if (DATATYPE_REAL32.equals(this.datatype)) {
            pixelType = 6;
        } else if (DATATYPE_REAL64.equals(this.datatype)) {
            pixelType = 7;
        } else {
            throw new FormatException("Unknown data type: " + this.datatype);
        }
        int sizeC = Integer.parseInt(this.channels);
        int sizeX = Integer.parseInt(this.xLen);
        int sizeY = Integer.parseInt(this.yLen);
        int sizeZ = Integer.parseInt(this.zLen);
        int sizeT = Integer.parseInt(this.timestamps);
        int sizeP = Integer.parseInt(this.phases);
        if (sizeP > 1) {
            throw new FormatException("Sorry, multiple phases not supported");
        }
        int sizeF = Integer.parseInt(this.frequencies);
        if (sizeF > 1) {
            throw new FormatException("Sorry, multiple frequences not supported");
        }
        int imageCount = sizeC * sizeZ * sizeP * sizeF * sizeT;
        this.core[0].sizeX = sizeX;
        this.core[0].sizeY = sizeY;
        this.core[0].sizeZ = sizeZ;
        this.core[0].sizeC = sizeC;
        this.core[0].sizeT = sizeT;
        this.core[0].imageCount = imageCount;
        this.core[0].rgb = false;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].pixelType = pixelType;
        this.core[0].littleEndian = true;
    }

    private void initOMEMetadata() {
        String stampValue;
        int times = this.timestamps == null ? 0 : Integer.parseInt(this.timestamps);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, times > 0);
        long firstStamp = 0L;
        for (int t = 0; t < times && (stampValue = (String)this.getGlobalMeta("FLIMIMAGE: TIMESTAMPS - t" + t)) != null; ++t) {
            Float deltaT;
            String[] stampWords = stampValue.split(" ");
            long stampHi = Long.parseLong(stampWords[0]);
            long stampLo = Long.parseLong(stampWords[1]);
            long stamp = DateTools.getMillisFromTicks(stampHi, stampLo);
            if (t == 0) {
                String date = DateTools.convertDate(stamp, 1);
                store.setImageCreationDate(date, 0);
                firstStamp = stamp;
                deltaT = new Float(0.0f);
            } else {
                long ms = stamp - firstStamp;
                deltaT = new Float((float)ms / 1000.0f);
            }
            for (int c = 0; c < this.core[0].sizeC; ++c) {
                for (int z = 0; z < this.core[0].sizeZ; ++z) {
                    int index = this.getIndex(z, c, t);
                    store.setPlaneTimingDeltaT(deltaT, 0, 0, index);
                }
            }
        }
        if (firstStamp == 0L) {
            MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        }
        StringBuilder points = new StringBuilder();
        String numRegionsValue = (String)this.getGlobalMeta("ROI: INFO - numregions");
        int numRegions = numRegionsValue == null ? 0 : Integer.parseInt(numRegionsValue);
        for (int roi = 0; roi < numRegions; ++roi) {
            String roiPrefix = "ROI: ROI" + roi + " - ";
            String roiName = (String)this.getGlobalMeta(roiPrefix + "name");
            String numPointsValue = (String)this.getGlobalMeta(roiPrefix + "numpoints");
            int numPoints = numPointsValue == null ? 0 : Integer.parseInt(numPointsValue);
            points.setLength(0);
            for (int p = 0; p < numPoints; ++p) {
                String point = (String)this.getGlobalMeta(roiPrefix + "p" + p);
                if (point == null) continue;
                if (p > 0) {
                    points.append(" ");
                }
                points.append(point.replaceAll(" ", ","));
            }
            store.setPolygonPoints(points.toString(), 0, roi, 0);
        }
    }

    private void prepareGZipStream(int no) throws IOException {
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int bytesPerPlane = this.getSizeX() * this.getSizeY() * bpp;
        if (this.gz == null || no < this.gzPos) {
            if (this.gz != null) {
                this.gz.close();
            }
            String path = Location.getMappedId(this.currentId);
            FileInputStream fis = new FileInputStream(path);
            this.skip(fis, this.dataOffset);
            this.gz = new DataInputStream(new GZIPInputStream(fis));
            this.gzPos = 0;
        }
        this.skip(this.gz, bytesPerPlane * (no - this.gzPos));
        this.gzPos = no + 1;
    }

    private void skip(InputStream is, long num) throws IOException {
        long skip;
        for (long skipLeft = num; skipLeft > 0L; skipLeft -= skip) {
            skip = is.skip(skipLeft);
            if (skip > 0L) continue;
            throw new IOException("Cannot skip bytes");
        }
    }
}

