/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz;

import java.io.File;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import org.apache.commons.io.FileUtils;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.transaction.annotation.Transactional;

public class DbCreate
implements Runnable {
    private final File f;
    private final Executor ex;

    public DbCreate(String[] args) {
        try {
            File dbFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-db")) continue;
                dbFile = new File(args[i + 1]);
                break;
            }
            if (dbFile == null) {
                throw new RuntimeException("Usage: -db filename");
            }
            OmeroContext ctx = new OmeroContext(new String[]{"classpath:ome/services/datalayer.xml", "classpath:ome/services/sec-primitives.xml"});
            this.ex = (Executor)ctx.getBean("executor");
            this.f = dbFile;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize DbCreate", e);
        }
    }

    public DbCreate(File f, Executor ex) {
        this.f = f;
        this.ex = ex;
    }

    public void run() {
        try {
            final String sql = FileUtils.readFileToString((File)this.f);
            this.ex.executeStateless((Executor.StatelessWork)new Executor.SimpleStatelessWork(this, "DbCreate"){

                @Transactional(readOnly=false)
                public Object doWork(SimpleJdbcOperations jdbc) {
                    jdbc.update(sql, new Object[0]);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create database", e);
        }
    }
}

