/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz;

import Ice.Communicator;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.Util;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import ome.services.blitz.DbCreate;
import ome.services.blitz.Status;
import ome.system.OmeroContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.util.ResourceUtils;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Entry {
    private static final Log log = LogFactory.getLog(Entry.class);
    int status = -1;
    final String name;
    final ReentrantLock lock = new ReentrantLock();
    volatile OmeroContext ctx = null;
    volatile Communicator ic = null;

    public static void main(String[] args) {
        Entry.configureLogging();
        String name = "OMERO.blitz";
        if (args != null && args.length > 0) {
            if ("-s".equals(args[0])) {
                try {
                    new Status(args).run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(1);
                }
                System.exit(0);
            } else if ("-db".equals(args[0])) {
                try {
                    new DbCreate(args).run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(2);
                }
            }
            for (String string : args) {
                if (string.startsWith("--Ice.Config")) {
                    System.setProperty("ICE_CONFIG", string.substring(13));
                    continue;
                }
                name = string;
            }
        }
        final Entry instance = new Entry(name);
        SignalHandler handler = new SignalHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Signal sig) {
                log.info((Object)(sig.getName() + ": Shutdown requested."));
                instance.lock.lock();
                instance.status = sig.getNumber();
                instance.shutdown(true);
            }
        };
        Signal.handle(new Signal("INT"), handler);
        Signal.handle(new Signal("TERM"), handler);
        instance.start();
    }

    public Entry(String name) {
        this.name = name;
    }

    public static void configureLogging() {
        try {
            String log4j_xml = System.getProperty("log4j.configuration", "");
            if (log4j_xml.length() == 0) {
                File file = ResourceUtils.getFile((String)"classpath:log4j.xml");
                log4j_xml = file.getAbsolutePath();
            }
            DOMConfigurator.configureAndWatch((String)log4j_xml);
        }
        catch (Exception e) {
            String msg = "CANNOT INITIALIZE LOGGING";
            throw new RuntimeException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            log.info((Object)("Creating " + this.name + ". Please wait..."));
            String ICE_CONFIG = System.getProperty("ICE_CONFIG");
            InitializationData id = new InitializationData();
            id.properties = Util.createProperties();
            if (ICE_CONFIG != null) {
                id.properties.load(ICE_CONFIG);
                for (String k : id.properties.getPropertiesForPrefix("omero").keySet()) {
                    System.setProperty(k, id.properties.getProperty(k));
                }
            }
            this.ctx = OmeroContext.getInstance((String)this.name);
            if (this.ctx.containsBean("Ice.Communicator")) {
                this.ic = (Communicator)this.ctx.getBean("Ice.Communicator");
            } else {
                this.ic = Util.initialize((InitializationData)id);
                ObjectAdapter oa = this.ic.createObjectAdapter("IndexerAdapter");
                oa.activate();
            }
            log.info((Object)(this.name + " now accepting connections."));
            this.ic.waitForShutdown();
            this.status = 0;
        }
        catch (LocalException e) {
            log.error((Object)"Error on startup.", (Throwable)e);
            this.status = 1;
        }
        catch (Exception e) {
            log.error((Object)"Error on startup.", (Throwable)e);
            this.status = 2;
        }
        System.out.flush();
        System.err.flush();
        this.lock.lock();
        try {
            this.shutdown(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int status() {
        return this.status;
    }

    public void shutdown(boolean callSystemExit) {
        if (this.ctx != null) {
            try {
                log.info((Object)("Calling close on context " + this.name));
                OmeroContext forClose = this.ctx;
                this.ctx = null;
                forClose.closeAll();
                log.info((Object)"Finished shutdown.");
            }
            catch (Exception e) {
                log.error((Object)("Error shutting down " + this.name), (Throwable)e);
                this.status = 3;
            }
        }
        if (callSystemExit) {
            System.exit(this.status);
        }
    }
}

