/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.EvictorI;
import Freeze.EvictorIterator;
import Freeze.NoSuchElementException;
import Freeze.ObjectStore;
import Freeze.TransactionI;
import Ice.Communicator;
import Ice.Identity;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class EvictorIteratorI
implements EvictorIterator {
    private final ObjectStore _store;
    private final TransactionI _tx;
    private final int _batchSize;
    private Iterator _batchIterator;
    private final DatabaseEntry _key = new DatabaseEntry();
    private final DatabaseEntry _value = new DatabaseEntry();
    private List _batch = null;
    private boolean _more = true;

    public boolean hasNext() {
        if (this._batchIterator != null && this._batchIterator.hasNext()) {
            return true;
        }
        this._batchIterator = this.nextBatch();
        return this._batchIterator != null;
    }

    public Identity next() {
        if (this.hasNext()) {
            return (Identity)this._batchIterator.next();
        }
        throw new NoSuchElementException();
    }

    EvictorIteratorI(ObjectStore store, TransactionI tx, int batchSize) {
        this._store = store;
        this._more = store != null;
        this._batchSize = batchSize;
        this._tx = tx;
        assert (batchSize > 0);
        this._key.setReuseBuffer(true);
        this._value.setPartial(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator nextBatch() {
        EvictorI.DeactivateController deactivateController = this._store.evictor().deactivateController();
        deactivateController.lock();
        Transaction txn = this._tx == null ? null : this._tx.dbTxn();
        try {
            ListIterator listIterator;
            if (!this._more) {
                Iterator iterator = null;
                return iterator;
            }
            Object evictorElements = null;
            Communicator communicator = this._store.communicator();
            byte[] firstKey = null;
            if (this._key.getSize() > 0) {
                firstKey = new byte[this._key.getSize()];
                System.arraycopy(this._key.getData(), 0, firstKey, 0, firstKey.length);
            }
            while (true) {
                Cursor dbc = null;
                this._batch = new ArrayList();
                try {
                    boolean range = false;
                    if (firstKey != null) {
                        range = true;
                    }
                    dbc = this._store.db().openCursor(txn, null);
                    boolean done = false;
                    do {
                        OperationStatus status = range ? dbc.getSearchKeyRange(this._key, this._value, null) : dbc.getNext(this._key, this._value, null);
                        boolean bl = this._more = status == OperationStatus.SUCCESS;
                        if (!this._more) continue;
                        range = false;
                        if (this._batch.size() < this._batchSize) {
                            Identity ident = ObjectStore.unmarshalKey(this._key.getData(), communicator);
                            this._batch.add(ident);
                            continue;
                        }
                        done = true;
                    } while (!done && this._more);
                }
                catch (com.sleepycat.db.DeadlockException dx) {
                    if (this._store.evictor().deadlockWarning()) {
                        communicator.getLogger().warning("Deadlock in Freeze.EvictorIteratorI.load while iterating over Db \"" + this._store.evictor().filename() + "/" + this._store.dbName() + "\"");
                    }
                    if (this._tx == null) {
                        if (firstKey != null) {
                            assert (this._key.getData().length >= firstKey.length);
                            System.arraycopy(firstKey, 0, this._key.getData(), 0, firstKey.length);
                            this._key.setSize(firstKey.length);
                            continue;
                        }
                        this._key.setSize(0);
                        continue;
                    }
                    DeadlockException ex = new DeadlockException(this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage(), this._tx);
                    ex.initCause(dx);
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage();
                    throw ex;
                }
                finally {
                    if (dbc == null) continue;
                    try {
                        dbc.close();
                    }
                    catch (com.sleepycat.db.DeadlockException dx) {
                        if (this._tx == null) continue;
                        DeadlockException ex = new DeadlockException(this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage(), this._tx);
                        ex.initCause(dx);
                        throw ex;
                    }
                    catch (com.sleepycat.db.DatabaseException dx) {}
                    continue;
                }
                break;
            }
            if (this._batch.size() == 0) {
                listIterator = null;
                return listIterator;
            }
            listIterator = this._batch.listIterator();
            return listIterator;
        }
        finally {
            deactivateController.unlock();
        }
    }
}

