/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EndpointSelectionType;
import Ice.FixedProxyException;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import Ice.RouterPrx;
import IceInternal.BasicStream;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedReference
extends Reference {
    private ConnectionI _fixedConnection;

    public FixedReference(Instance instance, Communicator communicator, Identity identity, Map<String, String> context, String facet, int mode, boolean secure, ConnectionI connection) {
        super(instance, communicator, identity, context, facet, mode, secure);
        this._fixedConnection = connection;
    }

    @Override
    public EndpointI[] getEndpoints() {
        return new EndpointI[0];
    }

    @Override
    public String getAdapterId() {
        return "";
    }

    @Override
    public LocatorInfo getLocatorInfo() {
        return null;
    }

    @Override
    public RouterInfo getRouterInfo() {
        return null;
    }

    @Override
    public boolean getCollocationOptimized() {
        return false;
    }

    @Override
    public final boolean getCacheConnection() {
        return false;
    }

    @Override
    public boolean getPreferSecure() {
        return false;
    }

    @Override
    public final EndpointSelectionType getEndpointSelection() {
        return EndpointSelectionType.Random;
    }

    @Override
    public int getLocatorCacheTimeout() {
        return 0;
    }

    @Override
    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeAdapterId(String newAdapterId) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeLocator(LocatorPrx newLocator) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeRouter(RouterPrx newRouter) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeCollocationOptimized(boolean newCollocationOptimized) {
        throw new FixedProxyException();
    }

    @Override
    public final Reference changeCacheConnection(boolean newCache) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changePreferSecure(boolean prefSec) {
        throw new FixedProxyException();
    }

    @Override
    public final Reference changeEndpointSelection(EndpointSelectionType newType) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeLocatorCacheTimeout(int newTimeout) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeTimeout(int newTimeout) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeConnectionId(String connectionId) {
        throw new FixedProxyException();
    }

    @Override
    public boolean isIndirect() {
        return false;
    }

    @Override
    public boolean isWellKnown() {
        return false;
    }

    @Override
    public void streamWrite(BasicStream s) throws MarshalException {
        throw new FixedProxyException();
    }

    @Override
    public String toString() throws MarshalException {
        throw new FixedProxyException();
    }

    @Override
    public ConnectionI getConnection(BooleanHolder compress) {
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                if (!this._fixedConnection.endpoint().datagram()) break;
                throw new NoEndpointException("");
            }
            case 3: 
            case 4: {
                if (this._fixedConnection.endpoint().datagram()) break;
                throw new NoEndpointException("");
            }
        }
        DefaultsAndOverrides defaultsAndOverrides = this.getInstance().defaultsAndOverrides();
        boolean secure = defaultsAndOverrides.overrideSecure ? defaultsAndOverrides.overrideSecureValue : this.getSecure();
        if (secure && !this._fixedConnection.endpoint().secure()) {
            throw new NoEndpointException("");
        }
        this._fixedConnection.throwException();
        compress.value = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : (this._overrideCompress ? this._compress : this._fixedConnection.endpoint().compress());
        return this._fixedConnection;
    }

    @Override
    public void getConnection(Reference.GetConnectionCallback callback) {
        try {
            BooleanHolder compress = new BooleanHolder();
            ConnectionI connection = this.getConnection(compress);
            callback.setConnection(connection, compress.value);
        }
        catch (LocalException ex) {
            callback.setException(ex);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedReference)) {
            return false;
        }
        FixedReference rhs = (FixedReference)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        return this._fixedConnection.equals(rhs._fixedConnection);
    }
}

