/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.DispatchInterceptorAsyncCallback;
import Ice.LocalException;
import Ice.ResponseSentException;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.Incoming;
import IceInternal.IncomingBase;

public class IncomingAsync
extends IncomingBase {
    private final boolean _retriable;
    private boolean _active = false;

    public IncomingAsync(Incoming in) {
        super(in);
        this._retriable = in.isRetriable();
        if (this._retriable) {
            in.setActive(this);
            this._active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __deactivate(Incoming in) {
        assert (this._retriable);
        IncomingAsync incomingAsync = this;
        synchronized (incomingAsync) {
            if (!this._active) {
                throw new ResponseSentException();
            }
            this._active = false;
        }
        in.adopt(this);
    }

    protected final void __response(boolean ok) {
        try {
            if (!this.__servantLocatorFinished()) {
                return;
            }
            if (this._response) {
                this._os.endWriteEncaps();
                int save = this._os.pos();
                this._os.pos(18);
                if (ok) {
                    this._os.writeByte((byte)0);
                } else {
                    this._os.writeByte((byte)1);
                }
                this._os.pos(save);
                this._connection.sendResponse(this._os, this._compress);
            } else {
                this._connection.sendNoResponse();
            }
        }
        catch (LocalException ex) {
            this._connection.invokeException(ex, 1);
        }
    }

    protected final void __exception(Exception exc) {
        try {
            if (!this.__servantLocatorFinished()) {
                return;
            }
            this.__handleException(exc);
        }
        catch (LocalException ex) {
            this._connection.invokeException(ex, 1);
        }
    }

    private final boolean __servantLocatorFinished() {
        try {
            if (this._locator != null && this._servant != null) {
                try {
                    this._locator.finished(this._current, this._servant, this._cookie.value);
                }
                catch (UserException ex) {
                    if (this._response) {
                        this._os.endWriteEncaps();
                        this._os.resize(18, false);
                        this._os.writeByte((byte)1);
                        this._os.startWriteEncaps();
                        this._os.writeUserException(ex);
                        this._os.endWriteEncaps();
                        this._connection.sendResponse(this._os, this._compress);
                    } else {
                        this._connection.sendNoResponse();
                    }
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            this.__handleException(ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean __validateResponse(boolean ok) {
        if (!this._retriable) {
            return true;
        }
        try {
            if (this._interceptorAsyncCallbackList != null) {
                for (DispatchInterceptorAsyncCallback cb : this._interceptorAsyncCallbackList) {
                    if (cb.response(ok)) continue;
                    return false;
                }
            }
        }
        catch (RuntimeException ex) {
            return false;
        }
        IncomingAsync incomingAsync = this;
        synchronized (incomingAsync) {
            if (this._active) {
                this._active = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean __validateException(Exception exc) {
        if (!this._retriable) {
            return true;
        }
        try {
            if (this._interceptorAsyncCallbackList != null) {
                for (DispatchInterceptorAsyncCallback cb : this._interceptorAsyncCallbackList) {
                    if (cb.exception(exc)) continue;
                    return false;
                }
            }
        }
        catch (RuntimeException ex) {
            return false;
        }
        IncomingAsync incomingAsync = this;
        synchronized (incomingAsync) {
            if (this._active) {
                this._active = false;
                return true;
            }
            return false;
        }
    }

    protected final BasicStream __os() {
        return this._os;
    }
}

