/*
 * Decompiled with CFR 0.152.
 */
package omero.grid;

import Glacier2.SessionControlPrx;
import Ice.Current;
import Ice.Identity;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ome.model.core.OriginalFile;
import ome.model.meta.Session;
import ome.parameters.Parameters;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import omero.ApiUsageException;
import omero.InternalException;
import omero.RMap;
import omero.RType;
import omero.ServerError;
import omero.grid.JobParams;
import omero.grid.ProcessPrx;
import omero.grid.ProcessPrxHelper;
import omero.grid.ProcessorPrx;
import omero.grid._InteractiveProcessorDisp;
import omero.model.Job;
import omero.model.OriginalFileI;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveProcessorI
extends _InteractiveProcessorDisp {
    private static Session UNINITIALIZED = new Session();
    private static Log log = LogFactory.getLog(InteractiveProcessorI.class);
    private final SessionManager mgr;
    private final ProcessorPrx prx;
    private final Executor ex;
    private final Job job;
    private final long timeout;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Principal principal;
    private final SessionControlPrx control;
    private boolean detach = false;
    private boolean obtainResults = false;
    private boolean stop = false;
    private ProcessPrx currentProcess = null;
    private Session session;
    private static final String stdfile_query = "select file from Job job join job.originalFileLinks links join links.child file where file.name = :name and job.id = :id";

    public InteractiveProcessorI(Principal p, SessionManager mgr, Executor ex, ProcessorPrx prx, Job job, long timeout, SessionControlPrx control) {
        this.principal = p;
        this.ex = ex;
        this.mgr = mgr;
        this.prx = prx;
        this.job = job;
        this.timeout = timeout;
        this.control = control;
        this.session = UNINITIALIZED;
    }

    @Override
    public JobParams params(Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            if (this.stop) {
                throw new ApiUsageException(null, null, "This processor is stopped.");
            }
            if (this.session == UNINITIALIZED) {
                this.session = this.newSession(__current);
            }
            try {
                JobParams jobParams = this.prx.parseJob(this.session.getUuid(), this.job);
                return jobParams;
            }
            catch (ServerError se) {
                log.debug((Object)"Error while parsing job", (Throwable)se);
                throw se;
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessPrx execute(RMap inputs, Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            ProcessPrx processPrx;
            if (this.currentProcess != null) {
                throw new ApiUsageException(null, null, "Process currently running.");
            }
            if (this.obtainResults) {
                throw new ApiUsageException(null, null, "Please retrieve results.");
            }
            if (this.stop) {
                throw new ApiUsageException(null, null, "This processor is stopped.");
            }
            if (this.session == UNINITIALIZED) {
                this.session = this.newSession(__current);
            }
            if (inputs != null && inputs.getValue() != null) {
                for (String key : inputs.getValue().keySet()) {
                    this.mgr.setInput(this.session.getUuid(), key, (Object)inputs.get(key));
                }
            }
            try {
                this.currentProcess = this.prx.processJob(this.session.getUuid(), this.job);
                this.control.identities().add(new Identity[]{this.currentProcess.ice_getIdentity()});
            }
            catch (ServerError se) {
                log.debug((Object)"Error while processing job", (Throwable)se);
                throw se;
            }
            if (this.currentProcess == null) {
                processPrx = null;
                return processPrx;
            }
            this.obtainResults = true;
            processPrx = this.currentProcess;
            return processPrx;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMap getResults(ProcessPrx proc, Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            this.finishedOrThrow();
            RMap output = rtypes.rmap(new HashMap<String, RType>());
            Map env = this.mgr.outputEnvironment(this.session.getUuid());
            IceMapper mapper = new IceMapper();
            for (String key : env.keySet()) {
                RType rt = mapper.toRType(env.get(key));
                output.put(key, rt);
            }
            this.optionallyLoadFile(output.getValue(), "stdout");
            this.optionallyLoadFile(output.getValue(), "stderr");
            this.currentProcess = null;
            this.obtainResults = false;
            RMap rMap = output;
            return rMap;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public long expires(Current __current) {
        return this.timeout;
    }

    @Override
    public Job getJob(Current __current) {
        return this.job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDetach(boolean detach, Current __current) {
        this.rwl.writeLock().lock();
        try {
            boolean old = this.detach;
            this.detach = detach;
            boolean bl = old;
            return bl;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        if (this.stop) {
            return;
        }
        try {
            if (this.detach) {
                if (this.currentProcess != null) {
                    log.info((Object)("Detaching from " + this.currentProcess));
                }
            } else {
                this.doStop();
            }
            this.stop = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    protected void doStop() throws ServerError {
        Exception pException = null;
        Exception sException = null;
        if (this.currentProcess != null) {
            try {
                ProcessPrx p = ProcessPrxHelper.uncheckedCast(this.currentProcess.ice_oneway());
                p.shutdown();
                this.currentProcess = null;
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to stop process", (Throwable)ex);
                pException = ex;
            }
        }
        if (this.session != null && this.session != UNINITIALIZED) {
            try {
                while (this.mgr.close(this.session.getUuid()) > 0) {
                }
                this.session = null;
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to close session " + this.session.getUuid()), (Throwable)ex);
                sException = ex;
            }
        }
        if (pException != null || sException != null) {
            InternalException ie = new InternalException();
            StringBuilder sb = new StringBuilder();
            if (pException != null) {
                sb.append("Failed to shutdown process: " + pException.getMessage());
            }
            if (sException != null) {
                sb.append("Failed to close session: " + sException.getMessage());
            }
            ie.message = sb.toString();
            throw ie;
        }
    }

    private void finishedOrThrow() throws ServerError {
        if (this.currentProcess == null) {
            throw new ApiUsageException(null, null, "No current process.");
        }
        if (this.currentProcess.poll() == null) {
            throw new ApiUsageException(null, null, "Process still running.");
        }
    }

    private void optionallyLoadFile(final Map<String, RType> val, final String name) {
        this.ex.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "optionallyLoadFile", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                OriginalFile file = (OriginalFile)sf.getQueryService().findByQuery(InteractiveProcessorI.stdfile_query, new Parameters().addId(Long.valueOf(InteractiveProcessorI.this.job.getId().getValue())).addString("name", name));
                if (file != null) {
                    val.put(name, rtypes.robject(new OriginalFileI(file.getId(), false)));
                }
                return null;
            }
        });
    }

    private Session newSession(Current __current) {
        EventContext ec = this.mgr.getEventContext(this.principal);
        Session newSession = this.mgr.create(new Principal(ec.getCurrentUserName(), ec.getCurrentGroupName(), "Processing"));
        newSession.setTimeToIdle(Long.valueOf(0L));
        newSession.setTimeToLive(Long.valueOf(this.timeout));
        newSession = this.mgr.update(newSession, true);
        return newSession;
    }
}

