/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Binning;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Detector;
import omero.model.DetectorSettings;
import omero.model.IObject;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorSettingsI
extends DetectorSettings
implements ModelBased {
    public static final String VOLTAGE = "ome.model.acquisition.DetectorSettings_voltage";
    public static final String GAIN = "ome.model.acquisition.DetectorSettings_gain";
    public static final String OFFSETVALUE = "ome.model.acquisition.DetectorSettings_offsetValue";
    public static final String READOUTRATE = "ome.model.acquisition.DetectorSettings_readOutRate";
    public static final String BINNING = "ome.model.acquisition.DetectorSettings_binning";
    public static final String DETECTOR = "ome.model.acquisition.DetectorSettings_detector";
    public static final String DETAILS = "ome.model.acquisition.DetectorSettings_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public DetectorSettingsI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public DetectorSettingsI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public DetectorSettingsI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadVoltage();
        this.unloadGain();
        this.unloadOffsetValue();
        this.unloadReadOutRate();
        this.unloadBinning();
        this.unloadDetector();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        DetectorSettingsI copy = new DetectorSettingsI();
        copy.id = this.id;
        copy.version = this.version;
        copy.voltage = this.voltage;
        copy.gain = this.gain;
        copy.offsetValue = this.offsetValue;
        copy.readOutRate = this.readOutRate;
        copy.binning = this.binning == null ? null : (Binning)this.binning.proxy();
        copy.detector = this.detector == null ? null : (Detector)this.detector.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new DetectorSettingsI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadVoltage() {
        this.voltage = null;
    }

    @Override
    public RDouble getVoltage(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.voltage;
    }

    @Override
    public void setVoltage(RDouble voltage, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.voltage = voltage;
    }

    private void copyVoltage(ome.model.acquisition.DetectorSettings source, IceMapper mapper) {
        this.voltage = source.getVoltage() == null ? null : rtypes.rdouble(source.getVoltage());
    }

    private void fillVoltage(ome.model.acquisition.DetectorSettings target, IceMapper mapper) {
        try {
            target.setVoltage((Double)mapper.fromRType(this.getVoltage()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadGain() {
        this.gain = null;
    }

    @Override
    public RDouble getGain(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.gain;
    }

    @Override
    public void setGain(RDouble gain, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.gain = gain;
    }

    private void copyGain(ome.model.acquisition.DetectorSettings source, IceMapper mapper) {
        this.gain = source.getGain() == null ? null : rtypes.rdouble(source.getGain());
    }

    private void fillGain(ome.model.acquisition.DetectorSettings target, IceMapper mapper) {
        try {
            target.setGain((Double)mapper.fromRType(this.getGain()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadOffsetValue() {
        this.offsetValue = null;
    }

    @Override
    public RDouble getOffsetValue(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.offsetValue;
    }

    @Override
    public void setOffsetValue(RDouble offsetValue, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.offsetValue = offsetValue;
    }

    private void copyOffsetValue(ome.model.acquisition.DetectorSettings source, IceMapper mapper) {
        this.offsetValue = source.getOffsetValue() == null ? null : rtypes.rdouble(source.getOffsetValue());
    }

    private void fillOffsetValue(ome.model.acquisition.DetectorSettings target, IceMapper mapper) {
        try {
            target.setOffsetValue((Double)mapper.fromRType(this.getOffsetValue()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadReadOutRate() {
        this.readOutRate = null;
    }

    @Override
    public RDouble getReadOutRate(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.readOutRate;
    }

    @Override
    public void setReadOutRate(RDouble readOutRate, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.readOutRate = readOutRate;
    }

    private void copyReadOutRate(ome.model.acquisition.DetectorSettings source, IceMapper mapper) {
        this.readOutRate = source.getReadOutRate() == null ? null : rtypes.rdouble(source.getReadOutRate());
    }

    private void fillReadOutRate(ome.model.acquisition.DetectorSettings target, IceMapper mapper) {
        try {
            target.setReadOutRate((Double)mapper.fromRType(this.getReadOutRate()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadBinning() {
        this.binning = null;
    }

    @Override
    public Binning getBinning(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.binning;
    }

    @Override
    public void setBinning(Binning binning, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.binning = binning;
    }

    private void copyBinning(ome.model.acquisition.DetectorSettings source, IceMapper mapper) {
        this.binning = (Binning)mapper.findTarget(source.getBinning());
    }

    private void fillBinning(ome.model.acquisition.DetectorSettings target, IceMapper mapper) {
        target.putAt(BINNING, (Object)mapper.reverse((ModelBased)((Object)this.getBinning())));
    }

    public void unloadDetector() {
        this.detector = null;
    }

    @Override
    public Detector getDetector(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.detector;
    }

    @Override
    public void setDetector(Detector detector, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.detector = detector;
    }

    private void copyDetector(ome.model.acquisition.DetectorSettings source, IceMapper mapper) {
        this.detector = (Detector)mapper.findTarget(source.getDetector());
    }

    private void fillDetector(ome.model.acquisition.DetectorSettings target, IceMapper mapper) {
        target.putAt(DETECTOR, (Object)mapper.reverse((ModelBased)((Object)this.getDetector())));
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.DetectorSettings) {
            ome.model.acquisition.DetectorSettings source = (ome.model.acquisition.DetectorSettings)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyVoltage(source, mapper);
                this.copyGain(source, mapper);
                this.copyOffsetValue(source, mapper);
                this.copyReadOutRate(source, mapper);
                this.copyBinning(source, mapper);
                this.copyDetector(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("DetectorSettings cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.DetectorSettings target = new ome.model.acquisition.DetectorSettings();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillVoltage(target, mapper);
            this.fillGain(target, mapper);
            this.fillOffsetValue(target, mapper);
            this.fillReadOutRate(target, mapper);
            this.fillBinning(target, mapper);
            this.fillDetector(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<DetectorSettingsI> cast(List list) {
        return list;
    }
}

