/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ScreenAcquisition;
import omero.model.ScreenAcquisitionWellSampleLink;
import omero.model.ScreenAcquisitionWellSampleLinkI;
import omero.model.Well;
import omero.model.WellSample;
import omero.model.WellSampleAnnotationLink;
import omero.model.WellSampleAnnotationLinkI;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WellSampleI
extends WellSample
implements ModelBased {
    public static final String POSX = "ome.model.screen.WellSample_posX";
    public static final String POSY = "ome.model.screen.WellSample_posY";
    public static final String TIMEPOINT = "ome.model.screen.WellSample_timepoint";
    public static final String WELL = "ome.model.screen.WellSample_well";
    public static final String IMAGE = "ome.model.screen.WellSample_image";
    public static final String SCREENACQUISITIONLINKS = "ome.model.screen.WellSample_screenAcquisitionLinks";
    public static final String ANNOTATIONLINKS = "ome.model.screen.WellSample_annotationLinks";
    public static final String DETAILS = "ome.model.screen.WellSample_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.screenAcquisitionLinksSeq = new ArrayList();
            this.screenAcquisitionLinksLoaded = true;
        } else {
            this.screenAcquisitionLinksSeq = null;
            this.screenAcquisitionLinksLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public WellSampleI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public WellSampleI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public WellSampleI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadPosX();
        this.unloadPosY();
        this.unloadTimepoint();
        this.unloadWell();
        this.unloadImage();
        this.unloadScreenAcquisitionLinks();
        this.unloadAnnotationLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        WellSampleI copy = new WellSampleI();
        copy.id = this.id;
        copy.version = this.version;
        copy.posX = this.posX;
        copy.posY = this.posY;
        copy.timepoint = this.timepoint;
        copy.well = this.well == null ? null : (Well)this.well.proxy();
        Image image = copy.image = this.image == null ? null : (Image)this.image.proxy();
        if (!this.screenAcquisitionLinksLoaded) {
            copy.screenAcquisitionLinksLoaded = false;
            copy.screenAcquisitionLinksSeq = null;
        } else {
            copy.screenAcquisitionLinksLoaded = true;
            copy.screenAcquisitionLinksSeq = new ArrayList<ScreenAcquisitionWellSampleLink>();
            for (IObject item : this.screenAcquisitionLinksSeq) {
                copy.screenAcquisitionLinksSeq.add(item == null ? null : (ScreenAcquisitionWellSampleLink)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<WellSampleAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (WellSampleAnnotationLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new WellSampleI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadPosX() {
        this.posX = null;
    }

    @Override
    public RDouble getPosX(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.posX;
    }

    @Override
    public void setPosX(RDouble posX, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.posX = posX;
    }

    private void copyPosX(ome.model.screen.WellSample source, IceMapper mapper) {
        this.posX = source.getPosX() == null ? null : rtypes.rdouble(source.getPosX());
    }

    private void fillPosX(ome.model.screen.WellSample target, IceMapper mapper) {
        try {
            target.setPosX((Double)mapper.fromRType(this.getPosX()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPosY() {
        this.posY = null;
    }

    @Override
    public RDouble getPosY(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.posY;
    }

    @Override
    public void setPosY(RDouble posY, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.posY = posY;
    }

    private void copyPosY(ome.model.screen.WellSample source, IceMapper mapper) {
        this.posY = source.getPosY() == null ? null : rtypes.rdouble(source.getPosY());
    }

    private void fillPosY(ome.model.screen.WellSample target, IceMapper mapper) {
        try {
            target.setPosY((Double)mapper.fromRType(this.getPosY()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadTimepoint() {
        this.timepoint = null;
    }

    @Override
    public RInt getTimepoint(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.timepoint;
    }

    @Override
    public void setTimepoint(RInt timepoint, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.timepoint = timepoint;
    }

    private void copyTimepoint(ome.model.screen.WellSample source, IceMapper mapper) {
        this.timepoint = source.getTimepoint() == null ? null : rtypes.rint(source.getTimepoint());
    }

    private void fillTimepoint(ome.model.screen.WellSample target, IceMapper mapper) {
        try {
            target.setTimepoint((Integer)mapper.fromRType(this.getTimepoint()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadWell() {
        this.well = null;
    }

    @Override
    public Well getWell(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.well;
    }

    @Override
    public void setWell(Well well, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.well = well;
    }

    private void copyWell(ome.model.screen.WellSample source, IceMapper mapper) {
        this.well = (Well)mapper.findTarget(source.getWell());
    }

    private void fillWell(ome.model.screen.WellSample target, IceMapper mapper) {
        target.putAt(WELL, (Object)mapper.reverse((ModelBased)((Object)this.getWell())));
    }

    public void unloadImage() {
        this.image = null;
    }

    @Override
    public Image getImage(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.image;
    }

    @Override
    public void setImage(Image image, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.image = image;
    }

    private void copyImage(ome.model.screen.WellSample source, IceMapper mapper) {
        this.image = (Image)mapper.findTarget(source.getImage());
    }

    private void fillImage(ome.model.screen.WellSample target, IceMapper mapper) {
        target.putAt(IMAGE, (Object)mapper.reverse((ModelBased)((Object)this.getImage())));
    }

    @Override
    public void unloadScreenAcquisitionLinks(Current current) {
        this.screenAcquisitionLinksLoaded = false;
        this.screenAcquisitionLinksSeq = null;
    }

    protected List getScreenAcquisitionLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.screenAcquisitionLinksSeq;
    }

    protected void setScreenAcquisitionLinks(List screenAcquisitionLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.screenAcquisitionLinksSeq = screenAcquisitionLinks == null ? new ArrayList() : new ArrayList(screenAcquisitionLinks);
        this.screenAcquisitionLinksLoaded = screenAcquisitionLinks != null;
    }

    private void copyScreenAcquisitionLinks(ome.model.screen.WellSample source, IceMapper mapper) {
        this.setScreenAcquisitionLinks((List)mapper.findCollection((Collection)source.retrieve(SCREENACQUISITIONLINKS)), null);
        this.screenAcquisitionLinksCountPerOwner = source.getScreenAcquisitionLinksCountPerOwner();
    }

    private void fillScreenAcquisitionLinks(ome.model.screen.WellSample target, IceMapper mapper) {
        if (this.screenAcquisitionLinksLoaded) {
            target.putAt(SCREENACQUISITIONLINKS, (Object)mapper.reverse(this.screenAcquisitionLinksSeq, Set.class));
        } else {
            target.putAt(SCREENACQUISITIONLINKS, null);
        }
    }

    public boolean isScreenAcquisitionLinksLoaded() {
        return this.screenAcquisitionLinksLoaded;
    }

    @Override
    public int sizeOfScreenAcquisitionLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            return -1;
        }
        return this.screenAcquisitionLinksSeq.size();
    }

    public List copyScreenAcquisitionLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        ArrayList result = new ArrayList(this.screenAcquisitionLinksSeq);
        return result;
    }

    public Iterator iterateScreenAcquisitionLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        return this.screenAcquisitionLinksSeq.iterator();
    }

    @Override
    public void addScreenAcquisitionWellSampleLink(ScreenAcquisitionWellSampleLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        this.screenAcquisitionLinksSeq.add(target);
        target.setChild(this);
    }

    @Override
    public void addAllScreenAcquisitionWellSampleLinkSet(List<ScreenAcquisitionWellSampleLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        this.screenAcquisitionLinksSeq.addAll(targets);
        for (ScreenAcquisitionWellSampleLink target : targets) {
            target.setChild(this);
        }
    }

    @Override
    public void removeScreenAcquisitionWellSampleLink(ScreenAcquisitionWellSampleLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        this.screenAcquisitionLinksSeq.remove(target);
        target.setChild(null);
    }

    @Override
    public void removeAllScreenAcquisitionWellSampleLinkSet(List<ScreenAcquisitionWellSampleLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        for (ScreenAcquisitionWellSampleLink elt : targets) {
            elt.setChild(null);
            this.screenAcquisitionLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearScreenAcquisitionLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        for (ScreenAcquisitionWellSampleLink elt : this.screenAcquisitionLinksSeq) {
            elt.setChild(null);
        }
        this.screenAcquisitionLinksSeq.clear();
    }

    @Override
    public void reloadScreenAcquisitionLinks(WellSample toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.screenAcquisitionLinksLoaded) {
            throw new ClientError("Cannot reload active collection: screenAcquisitionLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ScreenAcquisitionWellSampleLink> copy = toCopy.copyScreenAcquisitionLinks();
        for (ScreenAcquisitionWellSampleLink elt : copy) {
            elt.setChild(this);
        }
        this.screenAcquisitionLinksSeq = new ArrayList<ScreenAcquisitionWellSampleLink>(copy);
        toCopy.unloadScreenAcquisitionLinks();
        this.screenAcquisitionLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getScreenAcquisitionLinksCountPerOwner(Current current) {
        return this.screenAcquisitionLinksCountPerOwner;
    }

    @Override
    public ScreenAcquisitionWellSampleLink linkScreenAcquisition(ScreenAcquisition addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        ScreenAcquisitionWellSampleLinkI link = new ScreenAcquisitionWellSampleLinkI();
        link.link(addition, this);
        this.addScreenAcquisitionWellSampleLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addScreenAcquisitionWellSampleLinkToBoth(ScreenAcquisitionWellSampleLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        this.screenAcquisitionLinksSeq.add(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().addScreenAcquisitionWellSampleLinkToBoth(link, false);
        }
    }

    @Override
    public List<ScreenAcquisitionWellSampleLink> findScreenAcquisitionWellSampleLink(ScreenAcquisition removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        ArrayList<ScreenAcquisitionWellSampleLink> result = new ArrayList<ScreenAcquisitionWellSampleLink>();
        for (ScreenAcquisitionWellSampleLink link : this.screenAcquisitionLinksSeq) {
            if (link.getParent() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkScreenAcquisition(ScreenAcquisition removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        List<ScreenAcquisitionWellSampleLink> toRemove = this.findScreenAcquisitionWellSampleLink(removal);
        Iterator<ScreenAcquisitionWellSampleLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenAcquisitionWellSampleLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeScreenAcquisitionWellSampleLinkFromBoth(ScreenAcquisitionWellSampleLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("screenAcquisitionLinksSeq");
        }
        this.screenAcquisitionLinksSeq.remove(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().removeScreenAcquisitionWellSampleLinkFromBoth(link, false);
        }
    }

    @Override
    public List<ScreenAcquisition> linkedScreenAcquisitionList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLinksLoaded) {
            this.throwNullCollectionException("ScreenAcquisitionLinks");
        }
        ArrayList<ScreenAcquisition> linked = new ArrayList<ScreenAcquisition>();
        for (ScreenAcquisitionWellSampleLink link : this.screenAcquisitionLinksSeq) {
            linked.add(link.getParent());
        }
        return linked;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.screen.WellSample source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.screen.WellSample target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addWellSampleAnnotationLink(WellSampleAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllWellSampleAnnotationLinkSet(List<WellSampleAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (WellSampleAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeWellSampleAnnotationLink(WellSampleAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllWellSampleAnnotationLinkSet(List<WellSampleAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (WellSampleAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (WellSampleAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(WellSample toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<WellSampleAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (WellSampleAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<WellSampleAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public WellSampleAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        WellSampleAnnotationLinkI link = new WellSampleAnnotationLinkI();
        link.link(this, addition);
        this.addWellSampleAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addWellSampleAnnotationLinkToBoth(WellSampleAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<WellSampleAnnotationLink> findWellSampleAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<WellSampleAnnotationLink> result = new ArrayList<WellSampleAnnotationLink>();
        for (WellSampleAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<WellSampleAnnotationLink> toRemove = this.findWellSampleAnnotationLink(removal);
        Iterator<WellSampleAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeWellSampleAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeWellSampleAnnotationLinkFromBoth(WellSampleAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (WellSampleAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.screen.WellSample) {
            ome.model.screen.WellSample source = (ome.model.screen.WellSample)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyPosX(source, mapper);
                this.copyPosY(source, mapper);
                this.copyTimepoint(source, mapper);
                this.copyWell(source, mapper);
                this.copyImage(source, mapper);
                this.copyScreenAcquisitionLinks(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("WellSample cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.screen.WellSample target = new ome.model.screen.WellSample();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillPosX(target, mapper);
            this.fillPosY(target, mapper);
            this.fillTimepoint(target, mapper);
            this.fillWell(target, mapper);
            this.fillImage(target, mapper);
            this.fillScreenAcquisitionLinks(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<WellSampleI> cast(List list) {
        return list;
    }
}

