/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionI;
import Ice.EndpointSelectionType;
import Ice.LocalException;
import Ice.ObjectAdapter;
import IceInternal.Connector;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.EndpointI_connectors;
import IceInternal.Instance;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutgoingConnectionFactory {
    private final Instance _instance;
    private boolean _destroyed;
    private Map<ConnectorInfo, List<ConnectionI>> _connections = new HashMap<ConnectorInfo, List<ConnectionI>>();
    private Map<EndpointI, List<ConnectionI>> _connectionsByEndpoint = new HashMap<EndpointI, List<ConnectionI>>();
    private Map<ConnectorInfo, HashSet<ConnectCallback>> _pending = new HashMap<ConnectorInfo, HashSet<ConnectCallback>>();
    private int _pendingConnectCount = 0;

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        for (List<ConnectionI> connectionList : this._connections.values()) {
            for (ConnectionI connection : connectionList) {
                connection.destroy(1);
            }
        }
        this._destroyed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        HashMap<ConnectorInfo, List<ConnectionI>> connections = null;
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            while (!this._destroyed || !this._pending.isEmpty() || this._pendingConnectCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this._connections != null) {
                connections = new HashMap<ConnectorInfo, List<ConnectionI>>(this._connections);
            }
        }
        for (List connectionList : connections.values()) {
            for (ConnectionI connection : connectionList) {
                connection.waitUntilFinished();
            }
        }
        OutgoingConnectionFactory outgoingConnectionFactory2 = this;
        synchronized (outgoingConnectionFactory2) {
            this._connections = null;
            this._connectionsByEndpoint = null;
        }
    }

    public ConnectionI create(EndpointI[] endpts, boolean hasMore, EndpointSelectionType selType, BooleanHolder compress) {
        assert (endpts.length > 0);
        List<EndpointI> endpoints = this.applyOverrides(endpts);
        ConnectionI connection = this.findConnectionByEndpoint(endpoints, compress);
        if (connection != null) {
            return connection;
        }
        LocalException exception = null;
        ArrayList<ConnectorInfo> connectors = new ArrayList<ConnectorInfo>();
        Iterator<EndpointI> p = endpoints.iterator();
        while (p.hasNext()) {
            EndpointI endpoint = p.next();
            try {
                List<Connector> cons = endpoint.connectors();
                assert (cons.size() > 0);
                if (selType == EndpointSelectionType.Random) {
                    Collections.shuffle(cons);
                }
                Iterator<Connector> q = cons.iterator();
                while (q.hasNext()) {
                    connectors.add(new ConnectorInfo(q.next(), endpoint));
                }
            }
            catch (LocalException ex) {
                exception = ex;
                this.handleException(exception, hasMore || p.hasNext());
            }
        }
        if (connectors.isEmpty()) {
            assert (exception != null);
            throw exception;
        }
        connection = this.getConnection(connectors, null, compress);
        if (connection != null) {
            return connection;
        }
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        Iterator q = connectors.iterator();
        ConnectorInfo ci = null;
        while (q.hasNext()) {
            ci = (ConnectorInfo)q.next();
            try {
                connection = this.createConnection(ci.connector.connect(), ci);
                connection.start(null);
                compress.value = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : ci.endpoint.compress();
                connection.activate();
                break;
            }
            catch (CommunicatorDestroyedException ex) {
                exception = ex;
                this.handleException(exception, ci, connection, hasMore || p.hasNext());
                connection = null;
                break;
            }
            catch (LocalException ex) {
                exception = ex;
                this.handleException(exception, ci, connection, hasMore || p.hasNext());
                connection = null;
            }
        }
        if (connection != null) {
            this.finishGetConnection(connectors, ci, connection, null);
        } else {
            this.finishGetConnection(connectors, exception, null);
        }
        if (connection == null) {
            assert (exception != null);
            throw exception;
        }
        return connection;
    }

    public void create(EndpointI[] endpts, boolean hasMore, EndpointSelectionType selType, CreateConnectionCallback callback) {
        assert (endpts.length > 0);
        List<EndpointI> endpoints = this.applyOverrides(endpts);
        try {
            BooleanHolder compress = new BooleanHolder();
            ConnectionI connection = this.findConnectionByEndpoint(endpoints, compress);
            if (connection != null) {
                callback.setConnection(connection, compress.value);
                return;
            }
        }
        catch (LocalException ex) {
            callback.setException(ex);
            return;
        }
        ConnectCallback cb = new ConnectCallback(this, endpoints, hasMore, callback, selType);
        cb.getConnectors();
    }

    public synchronized void setRouterInfo(RouterInfo routerInfo) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        assert (routerInfo != null);
        ObjectAdapter adapter = routerInfo.getAdapter();
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        EndpointI[] endpoints = routerInfo.getClientEndpoints();
        for (int i = 0; i < endpoints.length; ++i) {
            EndpointI endpoint = endpoints[i];
            if (defaultsAndOverrides.overrideTimeout) {
                endpoint = endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
            }
            endpoint = endpoint.compress(false);
            for (List<ConnectionI> connectionList : this._connections.values()) {
                for (ConnectionI connection : connectionList) {
                    if (connection.endpoint() != endpoint) continue;
                    connection.setAdapter(adapter);
                }
            }
        }
    }

    public synchronized void removeAdapter(ObjectAdapter adapter) {
        if (this._destroyed) {
            return;
        }
        for (List<ConnectionI> connectionList : this._connections.values()) {
            for (ConnectionI connection : connectionList) {
                if (connection.getAdapter() != adapter) continue;
                connection.setAdapter(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        LinkedList<ConnectionI> c = new LinkedList<ConnectionI>();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            for (List<ConnectionI> connectionList : this._connections.values()) {
                Iterator<ConnectionI> q = connectionList.iterator();
                while (q.hasNext()) {
                    c.add(q.next());
                }
            }
        }
        for (ConnectionI conn : c) {
            try {
                conn.flushBatchRequests();
            }
            catch (LocalException ex) {}
        }
    }

    OutgoingConnectionFactory(Instance instance) {
        this._instance = instance;
        this._destroyed = false;
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._destroyed);
        Assert.FinalizerAssert(this._connections == null);
        Assert.FinalizerAssert(this._connectionsByEndpoint == null);
        Assert.FinalizerAssert(this._pendingConnectCount == 0);
        Assert.FinalizerAssert(this._pending.isEmpty());
        super.finalize();
    }

    private List<EndpointI> applyOverrides(EndpointI[] endpts) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        for (int i = 0; i < endpts.length; ++i) {
            if (defaultsAndOverrides.overrideTimeout) {
                endpoints.add(endpts[i].timeout(defaultsAndOverrides.overrideTimeoutValue));
                continue;
            }
            endpoints.add(endpts[i]);
        }
        return endpoints;
    }

    private synchronized ConnectionI findConnectionByEndpoint(List<EndpointI> endpoints, BooleanHolder compress) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        assert (!endpoints.isEmpty());
        for (EndpointI endpoint : endpoints) {
            List<ConnectionI> connectionList = this._connectionsByEndpoint.get(endpoint);
            if (connectionList == null) continue;
            for (ConnectionI connection : connectionList) {
                if (!connection.isActiveOrHolding()) continue;
                compress.value = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : endpoint.compress();
                return connection;
            }
        }
        return null;
    }

    private ConnectionI findConnection(List<ConnectorInfo> connectors, BooleanHolder compress) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        for (ConnectorInfo ci : connectors) {
            List<ConnectionI> connectionList;
            if (this._pending.containsKey(ci) || (connectionList = this._connections.get(ci)) == null) continue;
            for (ConnectionI connection : connectionList) {
                if (!connection.isActiveOrHolding()) continue;
                if (!connection.endpoint().equals(ci.endpoint)) {
                    List<ConnectionI> conList = this._connectionsByEndpoint.get(ci.endpoint);
                    if (conList == null) {
                        conList = new LinkedList<ConnectionI>();
                        this._connectionsByEndpoint.put(ci.endpoint, conList);
                    }
                    conList.add(connection);
                }
                compress.value = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : ci.endpoint.compress();
                return connection;
            }
        }
        return null;
    }

    private synchronized void incPendingConnectCount() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        ++this._pendingConnectCount;
    }

    private synchronized void decPendingConnectCount() {
        --this._pendingConnectCount;
        assert (this._pendingConnectCount >= 0);
        if (this._destroyed && this._pendingConnectCount == 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionI getConnection(List<ConnectorInfo> connectors, ConnectCallback cb, BooleanHolder compress) {
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            block14: {
                ConnectionI con;
                Iterator<ConnectionI> q;
                List<ConnectionI> connectionList;
                if (this._destroyed) {
                    throw new CommunicatorDestroyedException();
                }
                Iterator<List<ConnectionI>> p = this._connections.values().iterator();
                while (p.hasNext()) {
                    connectionList = p.next();
                    q = connectionList.iterator();
                    while (q.hasNext()) {
                        con = q.next();
                        if (!con.isFinished()) continue;
                        q.remove();
                    }
                    if (!connectionList.isEmpty()) continue;
                    p.remove();
                }
                p = this._connectionsByEndpoint.values().iterator();
                while (p.hasNext()) {
                    connectionList = p.next();
                    q = connectionList.iterator();
                    while (q.hasNext()) {
                        con = q.next();
                        if (!con.isFinished()) continue;
                        q.remove();
                    }
                    if (!connectionList.isEmpty()) continue;
                    p.remove();
                }
                while (true) {
                    if (this._destroyed) {
                        throw new CommunicatorDestroyedException();
                    }
                    ConnectionI connection = this.findConnection(connectors, compress);
                    if (connection != null) {
                        return connection;
                    }
                    if (!this.addToPending(cb, connectors)) break block14;
                    if (cb != null) break;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                return null;
            }
        }
        if (cb != null) {
            cb.nextConnector();
        }
        return null;
    }

    private synchronized ConnectionI createConnection(Transceiver transceiver, ConnectorInfo ci) {
        assert (this._pending.containsKey(ci) && transceiver != null);
        try {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            ConnectionI connection = new ConnectionI(this._instance, transceiver, ci.endpoint.compress(false), null);
            List<ConnectionI> connectionList = this._connections.get(ci);
            if (connectionList == null) {
                connectionList = new LinkedList<ConnectionI>();
                this._connections.put(ci, connectionList);
            }
            connectionList.add(connection);
            connectionList = this._connectionsByEndpoint.get(ci.endpoint);
            if (connectionList == null) {
                connectionList = new LinkedList<ConnectionI>();
                this._connectionsByEndpoint.put(ci.endpoint, connectionList);
            }
            connectionList.add(connection);
            return connection;
        }
        catch (LocalException ex) {
            try {
                transceiver.close();
            }
            catch (LocalException exc) {
                // empty catch block
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishGetConnection(List<ConnectorInfo> connectors, ConnectorInfo ci, ConnectionI connection, ConnectCallback cb) {
        HashSet<ConnectCallback> connectionCallbacks = new HashSet<ConnectCallback>();
        if (cb != null) {
            connectionCallbacks.add(cb);
        }
        HashSet<ConnectCallback> callbacks = new HashSet<ConnectCallback>();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            for (ConnectorInfo c : connectors) {
                Set cbs = this._pending.remove(c);
                if (cbs == null) continue;
                for (ConnectCallback cc : cbs) {
                    if (cc.hasConnector(ci)) {
                        connectionCallbacks.add(cc);
                        continue;
                    }
                    callbacks.add(cc);
                }
            }
            for (ConnectCallback cc : connectionCallbacks) {
                cc.removeFromPending();
                callbacks.remove(cc);
            }
            for (ConnectCallback cc : callbacks) {
                cc.removeFromPending();
            }
            this.notifyAll();
        }
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        boolean compress = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : ci.endpoint.compress();
        for (ConnectCallback cc : callbacks) {
            cc.getConnection();
        }
        for (ConnectCallback cc : connectionCallbacks) {
            cc.setConnection(connection, compress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishGetConnection(List<ConnectorInfo> connectors, LocalException ex, ConnectCallback cb) {
        HashSet<ConnectCallback> failedCallbacks = new HashSet<ConnectCallback>();
        if (cb != null) {
            failedCallbacks.add(cb);
        }
        HashSet<ConnectCallback> callbacks = new HashSet<ConnectCallback>();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            for (ConnectorInfo c : connectors) {
                Set cbs = this._pending.remove(c);
                if (cbs == null) continue;
                for (ConnectCallback cc : cbs) {
                    if (cc.removeConnectors(connectors)) {
                        failedCallbacks.add(cc);
                        continue;
                    }
                    callbacks.add(cc);
                }
            }
            for (ConnectCallback cc : callbacks) {
                assert (!failedCallbacks.contains(cc));
                cc.removeFromPending();
            }
            this.notifyAll();
        }
        for (ConnectCallback cc : callbacks) {
            cc.getConnection();
        }
        for (ConnectCallback cc : failedCallbacks) {
            cc.setException(ex);
        }
    }

    private boolean addToPending(ConnectCallback cb, List<ConnectorInfo> connectors) {
        Iterator<ConnectorInfo> p = connectors.iterator();
        boolean found = false;
        while (p.hasNext()) {
            Set cbs = this._pending.get(p.next());
            if (cbs == null) continue;
            found = true;
            if (cb == null) continue;
            cbs.add(cb);
        }
        if (found) {
            return true;
        }
        for (ConnectorInfo obj : connectors) {
            if (this._pending.containsKey(obj)) continue;
            this._pending.put(obj, new HashSet());
        }
        return false;
    }

    private void removeFromPending(ConnectCallback cb, List<ConnectorInfo> connectors) {
        Iterator<ConnectorInfo> p = connectors.iterator();
        while (p.hasNext()) {
            Set cbs = this._pending.get(p.next());
            if (cbs == null) continue;
            cbs.remove(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(LocalException ex, ConnectorInfo ci, ConnectionI connection, boolean hasMore) {
        TraceLevels traceLevels = this._instance.traceLevels();
        if (traceLevels.retry >= 2) {
            StringBuilder s = new StringBuilder(128);
            s.append("connection to endpoint failed");
            if (ex instanceof CommunicatorDestroyedException) {
                s.append("\n");
            } else if (hasMore) {
                s.append(", trying next endpoint\n");
            } else {
                s.append(" and no more endpoints to try\n");
            }
            s.append(ex.toString());
            this._instance.initializationData().logger.trace(traceLevels.retryCat, s.toString());
        }
        if (connection != null && connection.isFinished()) {
            OutgoingConnectionFactory outgoingConnectionFactory = this;
            synchronized (outgoingConnectionFactory) {
                List<ConnectionI> connectionList = this._connections.get(ci);
                if (connectionList != null) {
                    connectionList.remove(connection);
                    if (connectionList.isEmpty()) {
                        this._connections.remove(ci);
                    }
                }
                if ((connectionList = this._connectionsByEndpoint.get(ci.endpoint)) != null) {
                    connectionList.remove(connection);
                    if (connectionList.isEmpty()) {
                        this._connectionsByEndpoint.remove(ci.endpoint);
                    }
                }
            }
        }
    }

    private void handleException(LocalException ex, boolean hasMore) {
        TraceLevels traceLevels = this._instance.traceLevels();
        if (traceLevels.retry >= 2) {
            StringBuilder s = new StringBuilder(128);
            s.append("couldn't resolve endpoint host");
            if (ex instanceof CommunicatorDestroyedException) {
                s.append("\n");
            } else if (hasMore) {
                s.append(", trying next endpoint\n");
            } else {
                s.append(" and no more endpoints to try\n");
            }
            s.append(ex.toString());
            this._instance.initializationData().logger.trace(traceLevels.retryCat, s.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectCallback
    implements ConnectionI.StartCallback,
    EndpointI_connectors {
        private final OutgoingConnectionFactory _factory;
        private final boolean _hasMore;
        private final CreateConnectionCallback _callback;
        private final List<EndpointI> _endpoints;
        private final EndpointSelectionType _selType;
        private Iterator<EndpointI> _endpointsIter;
        private EndpointI _currentEndpoint;
        private List<ConnectorInfo> _connectors = new ArrayList<ConnectorInfo>();
        private Iterator<ConnectorInfo> _iter;
        private ConnectorInfo _current;

        ConnectCallback(OutgoingConnectionFactory f, List<EndpointI> endpoints, boolean more, CreateConnectionCallback cb, EndpointSelectionType selType) {
            this._factory = f;
            this._endpoints = endpoints;
            this._hasMore = more;
            this._callback = cb;
            this._selType = selType;
            this._endpointsIter = this._endpoints.iterator();
        }

        @Override
        public void connectionStartCompleted(ConnectionI connection) {
            connection.activate();
            this._factory.finishGetConnection(this._connectors, this._current, connection, this);
        }

        @Override
        public void connectionStartFailed(ConnectionI connection, LocalException ex) {
            assert (this._current != null);
            this._factory.handleException(ex, this._current, connection, this._hasMore || this._iter.hasNext());
            if (ex instanceof CommunicatorDestroyedException) {
                this._factory.finishGetConnection(this._connectors, ex, this);
            } else if (this._iter.hasNext()) {
                this.nextConnector();
            } else {
                this._factory.finishGetConnection(this._connectors, ex, this);
            }
        }

        @Override
        public void connectors(List<Connector> cons) {
            if (this._selType == EndpointSelectionType.Random) {
                Collections.shuffle(cons);
            }
            Iterator<Connector> q = cons.iterator();
            while (q.hasNext()) {
                this._connectors.add(new ConnectorInfo(q.next(), this._currentEndpoint));
            }
            if (this._endpointsIter.hasNext()) {
                this.nextEndpoint();
            } else {
                assert (!this._connectors.isEmpty());
                this._iter = this._connectors.iterator();
                this.getConnection();
            }
        }

        @Override
        public void exception(LocalException ex) {
            this._factory.handleException(ex, this._hasMore || this._endpointsIter.hasNext());
            if (this._endpointsIter.hasNext()) {
                this.nextEndpoint();
            } else if (!this._connectors.isEmpty()) {
                this._iter = this._connectors.iterator();
                this.getConnection();
            } else {
                this._callback.setException(ex);
                this._factory.decPendingConnectCount();
            }
        }

        public void setConnection(ConnectionI connection, boolean compress) {
            this._callback.setConnection(connection, compress);
            this._factory.decPendingConnectCount();
        }

        public void setException(LocalException ex) {
            this._callback.setException(ex);
            this._factory.decPendingConnectCount();
        }

        public boolean hasConnector(ConnectorInfo ci) {
            return this._connectors.contains(ci);
        }

        public boolean removeConnectors(List<ConnectorInfo> connectors) {
            this._connectors.removeAll(connectors);
            this._iter = this._connectors.iterator();
            return this._connectors.isEmpty();
        }

        public void removeFromPending() {
            this._factory.removeFromPending(this, this._connectors);
        }

        void getConnectors() {
            try {
                this._factory.incPendingConnectCount();
            }
            catch (LocalException ex) {
                this._callback.setException(ex);
                return;
            }
            this.nextEndpoint();
        }

        void nextEndpoint() {
            try {
                assert (this._endpointsIter.hasNext());
                this._currentEndpoint = this._endpointsIter.next();
                this._currentEndpoint.connectors_async(this);
            }
            catch (LocalException ex) {
                this.exception(ex);
            }
        }

        void getConnection() {
            try {
                BooleanHolder compress = new BooleanHolder();
                ConnectionI connection = this._factory.getConnection(this._connectors, this, compress);
                if (connection == null) {
                    return;
                }
                this._callback.setConnection(connection, compress.value);
                this._factory.decPendingConnectCount();
            }
            catch (LocalException ex) {
                this._callback.setException(ex);
                this._factory.decPendingConnectCount();
            }
        }

        void nextConnector() {
            ConnectionI connection = null;
            try {
                assert (this._iter.hasNext());
                this._current = this._iter.next();
                connection = this._factory.createConnection(this._current.connector.connect(), this._current);
                connection.start(this);
            }
            catch (LocalException ex) {
                this.connectionStartFailed(connection, ex);
            }
        }
    }

    private static class ConnectorInfo {
        public Connector connector;
        public EndpointI endpoint;

        public ConnectorInfo(Connector c, EndpointI e) {
            this.connector = c;
            this.endpoint = e;
        }

        public boolean equals(Object obj) {
            ConnectorInfo r = (ConnectorInfo)obj;
            return ((Object)this.connector).equals(r.connector);
        }

        public int hashCode() {
            return this.connector.hashCode();
        }
    }

    static interface CreateConnectionCallback {
        public void setConnection(ConnectionI var1, boolean var2);

        public void setException(LocalException var1);
    }
}

