/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.RString;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.model.ScreenPlateLink;
import omero.rtypes;
import pojos.DataObject;
import pojos.PlateData;
import pojos.SetMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenData
extends DataObject {
    public static final String NAME = "ome.model.screen.Screen_name";
    public static final String DESCRIPTION = "ome.model.screen.Screen_description";
    public static final String PLATE_LINKS = "ome.model.screen.Screen_plateLinks";
    private Set plates;

    public ScreenData() {
        this.setDirty(true);
        this.setValue(new ScreenI());
    }

    public ScreenData(Screen screen) {
        if (screen == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(screen);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asScreen().setName(rtypes.rstring(name));
    }

    public String getName() {
        RString n = this.asScreen().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null.");
        }
        return n.getValue();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asScreen().setDescription(rtypes.rstring(description));
    }

    public String getDescription() {
        RString d = this.asScreen().getDescription();
        return d == null ? null : d.getValue();
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asScreen().getAnnotationLinksCountPerOwner();
    }

    public Set<PlateData> getPlates() {
        if (this.plates == null && this.asScreen().sizeOfPlateLinks() >= 0) {
            this.plates = new HashSet();
            List<ScreenPlateLink> links = this.asScreen().copyPlateLinks();
            for (ScreenPlateLink link : links) {
                this.plates.add(new PlateData(link.getChild()));
            }
        }
        return this.plates == null ? null : new HashSet(this.plates);
    }

    public void setPlates(Set<PlateData> value) {
        Set<PlateData> currentValue = this.getPlates();
        SetMutator<PlateData> m = new SetMutator<PlateData>(currentValue, value);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asScreen().unlinkPlate(m.nextDeletion().asPlate());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asScreen().linkPlate(m.nextAddition().asPlate());
        }
        this.plates = new HashSet<PlateData>(m.result());
    }

    public String getProtocolDescription() {
        RString d = this.asScreen().getProtocolDescription();
        return d == null ? "" : d.getValue();
    }

    public String getProtocolIdentifier() {
        RString d = this.asScreen().getProtocolIdentifier();
        return d == null ? "" : d.getValue();
    }

    public String getReagentSetDescripion() {
        RString d = this.asScreen().getReagentSetDescription();
        return d == null ? "" : d.getValue();
    }

    public String getReagentSetIdentifier() {
        RString d = this.asScreen().getReagentSetIdentifier();
        return d == null ? "" : d.getValue();
    }
}

