/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import java.util.Arrays;
import java.util.List;
import loci.formats.MetadataTools;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.IEnumerationProvider;
import loci.formats.enums.handler.HandlerFactory;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationProvider
implements IEnumerationProvider {
    private String schema;

    public EnumerationProvider() {
        this(MetadataTools.getLatestVersion());
    }

    public EnumerationProvider(String schemaVersion) {
        this.schema = schemaVersion;
    }

    @Override
    public <T extends Enumeration> T getEnumeration(Class<T> entity, String value) throws EnumerationException {
        return this.getEnumeration(entity, value, this.schema);
    }

    @Override
    public <T extends Enumeration> T getEnumeration(Class<T> entity, String value, String schemaVersion) throws EnumerationException {
        IEnumerationHandler handler = HandlerFactory.getHandler(entity);
        return (T)handler.getEnumeration(value);
    }

    @Override
    public <T extends Enumeration> List<T> getEnumerations(Class<T> entity) throws EnumerationException {
        return this.getEnumerations(entity, this.schema);
    }

    @Override
    public <T extends Enumeration> List<T> getEnumerations(Class<T> entity, String schemaVersion) throws EnumerationException {
        return Arrays.asList(entity.getEnumConstants());
    }
}

