/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IlluminationType implements Enumeration
{
    TRANSMITTED("Transmitted"),
    EPIFLUORESCENCE("Epifluorescence"),
    OBLIQUE("Oblique"),
    NONLINEAR("NonLinear"),
    OTHER("Other");

    private final String value;

    private IlluminationType(String value) {
        this.value = value;
    }

    public static IlluminationType fromString(String value) throws EnumerationException {
        if ("Transmitted".equals(value)) {
            return TRANSMITTED;
        }
        if ("Epifluorescence".equals(value)) {
            return EPIFLUORESCENCE;
        }
        if ("Oblique".equals(value)) {
            return OBLIQUE;
        }
        if ("NonLinear".equals(value)) {
            return NONLINEAR;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, IlluminationType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

