/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import java.util.Hashtable;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.LaserType;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaserTypeEnumHandler
implements IEnumerationHandler {
    private static final Hashtable<String, String> patterns = LaserTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Excimer\\s*", "Excimer");
        p.put("^\\s*Gas\\s*", "Gas");
        p.put("^\\s*MetalVapor\\s*", "MetalVapor");
        p.put("^\\s*SolidState\\s*", "SolidState");
        p.put("^\\s*Dye\\s*", "Dye");
        p.put("^\\s*Semiconductor\\s*", "Semiconductor");
        p.put("^\\s*FreeElectron\\s*", "FreeElectron");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        for (String pattern : patterns.keySet()) {
            if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
            String v = patterns.get(pattern);
            return LaserType.fromString(v);
        }
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return LaserType.class;
    }
}

