/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffRational;

public abstract class BaseTiffReader
extends MinimalTiffReader {
    public static final String[] DATE_FORMATS = new String[]{"yyyy:MM:dd HH:mm:ss", "dd/MM/yyyy HH:mm:ss.SS", "MM/dd/yyyy hh:mm:ss.SSS aa"};
    private static final int EXIF_VERSION = 36864;
    private static final int FLASH_PIX_VERSION = 40960;
    private static final int COLOR_SPACE = 40961;
    private static final int COMPONENTS_CONFIGURATION = 37121;
    private static final int COMPRESSED_BITS_PER_PIXEL = 37122;
    private static final int PIXEL_X_DIMENSION = 40962;
    private static final int PIXEL_Y_DIMENSION = 40963;
    private static final int MAKER_NOTE = 37500;
    private static final int USER_COMMENT = 37510;
    private static final int RELATED_SOUND_FILE = 40964;
    private static final int DATE_TIME_ORIGINAL = 36867;
    private static final int DATE_TIME_DIGITIZED = 36868;
    private static final int SUB_SEC_TIME = 37520;
    private static final int SUB_SEC_TIME_ORIGINAL = 37521;
    private static final int SUB_SEC_TIME_DIGITIZED = 37522;
    private static final int EXPOSURE_TIME = 33434;
    private static final int F_NUMBER = 33437;
    private static final int EXPOSURE_PROGRAM = 34850;
    private static final int SPECTRAL_SENSITIVITY = 34852;
    private static final int ISO_SPEED_RATINGS = 34855;
    private static final int OECF = 34856;
    private static final int SHUTTER_SPEED_VALUE = 37377;
    private static final int APERTURE_VALUE = 37378;
    private static final int BRIGHTNESS_VALUE = 37379;
    private static final int EXPOSURE_BIAS_VALUE = 37380;
    private static final int MAX_APERTURE_VALUE = 37381;
    private static final int SUBJECT_DISTANCE = 37382;
    private static final int METERING_MODE = 37383;
    private static final int LIGHT_SOURCE = 37384;
    private static final int FLASH = 37385;
    private static final int FOCAL_LENGTH = 37386;
    private static final int FLASH_ENERGY = 41483;
    private static final int SPATIAL_FREQUENCY_RESPONSE = 41484;
    private static final int FOCAL_PLANE_X_RESOLUTION = 41486;
    private static final int FOCAL_PLANE_Y_RESOLUTION = 41487;
    private static final int FOCAL_PLANE_RESOLUTION_UNIT = 41488;
    private static final int SUBJECT_LOCATION = 41492;
    private static final int EXPOSURE_INDEX = 41493;
    private static final int SENSING_METHOD = 41495;
    private static final int FILE_SOURCE = 41728;
    private static final int SCENE_TYPE = 41729;
    private static final int CFA_PATTERN = 41730;

    public BaseTiffReader(String name, String suffix) {
        super(name, suffix);
    }

    public BaseTiffReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    protected void initMetadata() throws FormatException, IOException {
        this.initStandardMetadata();
        this.initMetadataStore();
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        IFD exif;
        IFD firstIFD = (IFD)this.ifds.get(0);
        this.put("ImageWidth", firstIFD, 256);
        this.put("ImageLength", firstIFD, 257);
        this.put("BitsPerSample", firstIFD, 258);
        long exifOffset = firstIFD.getIFDLongValue(34665, false, 0L);
        if (exifOffset != 0L && (exif = this.tiffParser.getIFD(1L, exifOffset)) != null) {
            for (Integer key : exif.keySet()) {
                int k = key;
                this.addGlobalMeta(BaseTiffReader.getExifTagName(k), exif.get(key));
            }
        }
        int comp = firstIFD.getCompression();
        this.put("Compression", TiffCompression.getCodecName(comp));
        int photo = firstIFD.getPhotometricInterpretation();
        String photoInterp = PhotoInterp.getPIName(photo);
        String metaDataPhotoInterp = PhotoInterp.getPIMeta(photo);
        this.put("PhotometricInterpretation", photoInterp);
        this.put("MetaDataPhotometricInterpretation", metaDataPhotoInterp);
        this.putInt("CellWidth", firstIFD, 264);
        this.putInt("CellLength", firstIFD, 265);
        int or = firstIFD.getIFDIntValue(274);
        if (or == 8) {
            this.put("ImageWidth", firstIFD, 257);
            this.put("ImageLength", firstIFD, 256);
        }
        String orientation = null;
        switch (or) {
            case 1: {
                orientation = "1st row -> top; 1st column -> left";
                break;
            }
            case 2: {
                orientation = "1st row -> top; 1st column -> right";
                break;
            }
            case 3: {
                orientation = "1st row -> bottom; 1st column -> right";
                break;
            }
            case 4: {
                orientation = "1st row -> bottom; 1st column -> left";
                break;
            }
            case 5: {
                orientation = "1st row -> left; 1st column -> top";
                break;
            }
            case 6: {
                orientation = "1st row -> right; 1st column -> top";
                break;
            }
            case 7: {
                orientation = "1st row -> right; 1st column -> bottom";
                break;
            }
            case 8: {
                orientation = "1st row -> left; 1st column -> bottom";
            }
        }
        this.put("Orientation", orientation);
        this.putInt("SamplesPerPixel", firstIFD, 277);
        this.put("Software", firstIFD, 305);
        this.put("Instrument Make", firstIFD, 271);
        this.put("Instrument Model", firstIFD, 272);
        this.put("Document Name", firstIFD, 269);
        this.put("DateTime", firstIFD, 306);
        this.put("Artist", firstIFD, 315);
        this.put("HostComputer", firstIFD, 316);
        this.put("Copyright", firstIFD, 33432);
        this.put("NewSubfileType", firstIFD, 254);
        int thresh = firstIFD.getIFDIntValue(263);
        String threshholding = null;
        switch (thresh) {
            case 1: {
                threshholding = "No dithering or halftoning";
                break;
            }
            case 2: {
                threshholding = "Ordered dithering or halftoning";
                break;
            }
            case 3: {
                threshholding = "Randomized error diffusion";
            }
        }
        this.put("Threshholding", threshholding);
        int fill = firstIFD.getIFDIntValue(266);
        String fillOrder = null;
        switch (fill) {
            case 1: {
                fillOrder = "Pixels with lower column values are stored in the higher order bits of a byte";
                break;
            }
            case 2: {
                fillOrder = "Pixels with lower column values are stored in the lower order bits of a byte";
            }
        }
        this.put("FillOrder", fillOrder);
        this.putInt("Make", firstIFD, 271);
        this.putInt("Model", firstIFD, 272);
        this.putInt("MinSampleValue", firstIFD, 280);
        this.putInt("MaxSampleValue", firstIFD, 281);
        this.putInt("XResolution", firstIFD, 282);
        this.putInt("YResolution", firstIFD, 283);
        int planar = firstIFD.getIFDIntValue(284);
        String planarConfig = null;
        switch (planar) {
            case 1: {
                planarConfig = "Chunky";
                break;
            }
            case 2: {
                planarConfig = "Planar";
            }
        }
        this.put("PlanarConfiguration", planarConfig);
        this.putInt("XPosition", firstIFD, 286);
        this.putInt("YPosition", firstIFD, 287);
        this.putInt("FreeOffsets", firstIFD, 288);
        this.putInt("FreeByteCounts", firstIFD, 289);
        this.putInt("GrayResponseUnit", firstIFD, 290);
        this.putInt("GrayResponseCurve", firstIFD, 291);
        this.putInt("T4Options", firstIFD, 292);
        this.putInt("T6Options", firstIFD, 293);
        int res = firstIFD.getIFDIntValue(296);
        String resUnit = null;
        switch (res) {
            case 1: {
                resUnit = "None";
                break;
            }
            case 2: {
                resUnit = "Inch";
                break;
            }
            case 3: {
                resUnit = "Centimeter";
            }
        }
        this.put("ResolutionUnit", resUnit);
        this.putInt("PageNumber", firstIFD, 297);
        this.putInt("TransferFunction", firstIFD, 301);
        int predict = firstIFD.getIFDIntValue(317);
        String predictor = null;
        switch (predict) {
            case 1: {
                predictor = "No prediction scheme";
                break;
            }
            case 2: {
                predictor = "Horizontal differencing";
            }
        }
        this.put("Predictor", predictor);
        this.putInt("WhitePoint", firstIFD, 318);
        this.putInt("PrimaryChromacities", firstIFD, 319);
        this.putInt("HalftoneHints", firstIFD, 321);
        this.putInt("TileWidth", firstIFD, 322);
        this.putInt("TileLength", firstIFD, 323);
        this.putInt("TileOffsets", firstIFD, 324);
        this.putInt("TileByteCounts", firstIFD, 325);
        int ink = firstIFD.getIFDIntValue(332);
        String inkSet = null;
        switch (ink) {
            case 1: {
                inkSet = "CMYK";
                break;
            }
            case 2: {
                inkSet = "Other";
            }
        }
        this.put("InkSet", inkSet);
        this.putInt("InkNames", firstIFD, 333);
        this.putInt("NumberOfInks", firstIFD, 334);
        this.putInt("DotRange", firstIFD, 336);
        this.put("TargetPrinter", firstIFD, 337);
        this.putInt("ExtraSamples", firstIFD, 338);
        int fmt = firstIFD.getIFDIntValue(339);
        String sampleFormat = null;
        switch (fmt) {
            case 1: {
                sampleFormat = "unsigned integer";
                break;
            }
            case 2: {
                sampleFormat = "two's complement signed integer";
                break;
            }
            case 3: {
                sampleFormat = "IEEE floating point";
                break;
            }
            case 4: {
                sampleFormat = "undefined";
            }
        }
        this.put("SampleFormat", sampleFormat);
        this.putInt("SMinSampleValue", firstIFD, 340);
        this.putInt("SMaxSampleValue", firstIFD, 341);
        this.putInt("TransferRange", firstIFD, 342);
        int jpeg = firstIFD.getIFDIntValue(512);
        String jpegProc = null;
        switch (jpeg) {
            case 1: {
                jpegProc = "baseline sequential process";
                break;
            }
            case 14: {
                jpegProc = "lossless process with Huffman coding";
            }
        }
        this.put("JPEGProc", jpegProc);
        this.putInt("JPEGInterchangeFormat", firstIFD, 513);
        this.putInt("JPEGRestartInterval", firstIFD, 515);
        this.putInt("JPEGLosslessPredictors", firstIFD, 517);
        this.putInt("JPEGPointTransforms", firstIFD, 518);
        this.putInt("JPEGQTables", firstIFD, 519);
        this.putInt("JPEGDCTables", firstIFD, 520);
        this.putInt("JPEGACTables", firstIFD, 521);
        this.putInt("YCbCrCoefficients", firstIFD, 529);
        int ycbcr = firstIFD.getIFDIntValue(530);
        String subSampling = null;
        switch (ycbcr) {
            case 1: {
                subSampling = "chroma image dimensions = luma image dimensions";
                break;
            }
            case 2: {
                subSampling = "chroma image dimensions are half the luma image dimensions";
                break;
            }
            case 4: {
                subSampling = "chroma image dimensions are 1/4 the luma image dimensions";
            }
        }
        this.put("YCbCrSubSampling", subSampling);
        this.putInt("YCbCrPositioning", firstIFD, 531);
        this.putInt("ReferenceBlackWhite", firstIFD, 532);
        int[] q = firstIFD.getBitsPerSample();
        int bps = q[0];
        int numC = q.length;
        if (photo == 3 || photo == 32803) {
            numC = 3;
        }
        this.put("BitsPerSample", bps);
        this.put("NumberOfChannels", numC);
        int samples = firstIFD.getSamplesPerPixel();
        this.core[0].rgb = samples > 1 || photo == 2;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = firstIFD.isLittleEndian();
        this.core[0].sizeX = (int)firstIFD.getImageWidth();
        this.core[0].sizeY = (int)firstIFD.getImageLength();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? samples : 1;
        this.core[0].sizeT = this.ifds.size();
        this.core[0].metadataComplete = true;
        boolean bl = this.core[0].indexed = photo == 3 && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        if (this.getSizeC() == 1 && !this.isIndexed()) {
            this.core[0].rgb = false;
        }
        this.core[0].falseColor = false;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = firstIFD.getPixelType();
    }

    protected void initMetadataStore() throws FormatException {
        this.status("Populating OME metadata");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        IFD firstIFD = (IFD)this.ifds.get(0);
        String artist = firstIFD.getIFDTextValue(315);
        if (artist != null) {
            String firstName = null;
            String lastName = null;
            int ndx = artist.indexOf(" ");
            if (ndx < 0) {
                lastName = artist;
            } else {
                firstName = artist.substring(0, ndx);
                lastName = artist.substring(ndx + 1);
            }
            String email = firstIFD.getIFDStringValue(316, false);
            store.setExperimenterFirstName(firstName, 0);
            store.setExperimenterLastName(lastName, 0);
            store.setExperimenterEmail(email, 0);
        }
        String creationDate = this.getImageCreationDate();
        String date = DateTools.formatDate(creationDate, DATE_FORMATS);
        if (creationDate != null && date == null) {
            this.warnDebug("unknown creation date format: " + creationDate);
        }
        if ((creationDate = date) != null) {
            store.setImageCreationDate(creationDate, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.getCurrentFile(), 0);
        }
        store.setImageDescription(firstIFD.getComment(), 0);
        int resolutionUnit = firstIFD.getIFDIntValue(296);
        TiffRational xResolution = firstIFD.getIFDRationalValue(282, false);
        TiffRational yResolution = firstIFD.getIFDRationalValue(283, false);
        float pixX = xResolution == null ? 0.0f : 1.0f / xResolution.floatValue();
        float pixY = yResolution == null ? 0.0f : 1.0f / yResolution.floatValue();
        switch (resolutionUnit) {
            case 2: {
                pixX *= 25400.0f;
                pixY *= 25400.0f;
                break;
            }
            case 3: {
                pixX *= 10000.0f;
                pixY *= 10000.0f;
            }
        }
        store.setDimensionsPhysicalSizeX(new Double(pixX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Double(pixY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Double(0.0), 0, 0);
    }

    protected String getImageCreationDate() {
        Object o = ((IFD)this.ifds.get(0)).getIFDValue(306);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof String[]) {
            return ((String[])o)[0];
        }
        return null;
    }

    protected void put(String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        this.addGlobalMeta(key, value);
    }

    protected void put(String key, int value) {
        if (value == -1) {
            return;
        }
        this.addGlobalMeta(key, value);
    }

    protected void put(String key, boolean value) {
        this.put(key, new Boolean(value));
    }

    protected void put(String key, byte value) {
        this.put(key, new Byte(value));
    }

    protected void put(String key, char value) {
        this.put(key, new Character(value));
    }

    protected void put(String key, double value) {
        this.put(key, new Double(value));
    }

    protected void put(String key, float value) {
        this.put(key, new Float(value));
    }

    protected void put(String key, long value) {
        this.put(key, new Long(value));
    }

    protected void put(String key, short value) {
        this.put(key, new Short(value));
    }

    protected void put(String key, IFD ifd, int tag) {
        this.put(key, ifd.getIFDValue(tag));
    }

    protected void putInt(String key, IFD ifd, int tag) {
        this.put(key, ifd.getIFDIntValue(tag));
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("BaseTiffReader.initFile(" + id + ")");
        super.initFile(id);
        this.initMetadata();
    }

    public static String getExifTagName(int tag) {
        switch (tag) {
            case 36864: {
                return "EXIF Version";
            }
            case 40960: {
                return "FlashPix Version";
            }
            case 40961: {
                return "Color Space";
            }
            case 37121: {
                return "Components Configuration";
            }
            case 37122: {
                return "Compressed Bits Per Pixel";
            }
            case 40962: {
                return "Image width";
            }
            case 40963: {
                return "Image height";
            }
            case 37500: {
                return "Maker Note";
            }
            case 37510: {
                return "User comment";
            }
            case 40964: {
                return "Related sound file";
            }
            case 36867: {
                return "Original date/time";
            }
            case 36868: {
                return "Date/time digitized";
            }
            case 37520: {
                return "Date/time subseconds";
            }
            case 37521: {
                return "Original date/time subseconds";
            }
            case 37522: {
                return "Digitized date/time subseconds";
            }
            case 33434: {
                return "Exposure time";
            }
            case 33437: {
                return "F Number";
            }
            case 34850: {
                return "Exposure program";
            }
            case 34852: {
                return "Spectral sensitivity";
            }
            case 34855: {
                return "ISO speed ratings";
            }
            case 34856: {
                return "Optoelectric conversion factor";
            }
            case 37377: {
                return "Shutter speed";
            }
            case 37378: {
                return "Aperture value";
            }
            case 37379: {
                return "Brightness value";
            }
            case 37380: {
                return "Exposure Bias value";
            }
            case 37381: {
                return "Max aperture value";
            }
            case 37382: {
                return "Subject distance";
            }
            case 37383: {
                return "Metering mode";
            }
            case 37384: {
                return "Light source";
            }
            case 37385: {
                return "Flash";
            }
            case 37386: {
                return "Focal length";
            }
            case 41483: {
                return "Flash energy";
            }
            case 41484: {
                return "Spatial frequency response";
            }
            case 41486: {
                return "Focal plane X resolution";
            }
            case 41487: {
                return "Focal plane Y resolution";
            }
            case 41488: {
                return "Focal plane resolution unit";
            }
            case 41492: {
                return "Subject location";
            }
            case 41493: {
                return "Exposure index";
            }
            case 41495: {
                return "Sensing method";
            }
            case 41728: {
                return "File source";
            }
            case 41729: {
                return "Scene type";
            }
            case 41730: {
                return "CFA Pattern";
            }
        }
        return null;
    }
}

