/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.POITools;
import loci.formats.meta.FilterMetadata;

public class TillVisionReader
extends FormatReader {
    private static final byte[] MARKER_0 = new byte[]{-128, 3, 0};
    private static final byte[] MARKER_1 = new byte[]{-127, 3, 0};
    private static final String[] DATE_FORMATS = new String[]{"mm/dd/yy HH:mm:ss aa", "mm/dd/yy HH:mm:ss.SSS aa", "mm/dd/yy", "HH:mm:ss aa", "HH:mm:ss.SSS aa"};
    private RandomAccessInputStream[] pixelsStream;
    private Hashtable<Integer, Double> exposureTimes;
    private boolean embeddedImages;
    private int embeddedOffset;

    public TillVisionReader() {
        super("TillVision", "vws");
        this.domains = new String[]{"Light Microscopy"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int plane = FormatTools.getPlaneSize(this);
        if (this.embeddedImages) {
            this.in.seek(this.embeddedOffset + no * plane);
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            this.pixelsStream[this.series].seek(no * plane);
            this.readPlane(this.pixelsStream[this.series], x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.pixelsStream != null) {
                for (RandomAccessInputStream stream : this.pixelsStream) {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            this.pixelsStream = null;
            this.embeddedOffset = 0;
            this.embeddedImages = false;
            this.exposureTimes = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String[] lines;
        this.debug("TillVisionReader.initFile(" + id + ")");
        super.initFile(id);
        this.exposureTimes = new Hashtable();
        POITools poi = new POITools(id);
        Vector<String> documents = poi.getDocumentList();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        Vector<String> imageNames = new Vector<String>();
        Vector<String> waves = new Vector<String>();
        Vector<String> types = new Vector<String>();
        Vector<String> dates = new Vector<String>();
        int nImages = 0;
        Hashtable tmpSeriesMetadata = new Hashtable();
        block2: for (int i2 = 0; i2 < documents.size(); ++i2) {
            String name = documents.get(i2);
            this.debug("Reading " + name);
            if (!name.equals("Root Entry" + File.separator + "Contents")) continue;
            RandomAccessInputStream s = poi.getDocumentStream(name);
            byte[] b = new byte[(int)s.length()];
            s.read(b);
            boolean pos = false;
            boolean nFound = false;
            this.embeddedImages = b[0] == 1;
            this.debug("Images are " + (this.embeddedImages ? "" : "not ") + "embedded");
            if (this.embeddedImages) {
                int len = DataTools.bytesToShort(b, 13, 2, true);
                String type = new String(b, 15, len);
                if (!type.equals("CImage")) {
                    this.embeddedImages = false;
                    continue;
                }
                int offset = 27;
                len = b[offset++] & 0xFF;
                while (len != 0) {
                    offset += len;
                    len = b[offset++] & 0xFF;
                }
                this.core[0].sizeX = DataTools.bytesToInt(b, offset += 1243, 4, true);
                this.core[0].sizeY = DataTools.bytesToInt(b, offset += 4, 4, true);
                this.core[0].sizeZ = DataTools.bytesToInt(b, offset += 4, 4, true);
                this.core[0].sizeC = DataTools.bytesToInt(b, offset += 4, 4, true);
                this.core[0].sizeT = DataTools.bytesToInt(b, offset += 4, 4, true);
                this.core[0].pixelType = this.convertPixelType(DataTools.bytesToInt(b, offset += 4, 4, true));
                this.embeddedOffset = offset + 32;
                this.in = poi.getDocumentStream(name);
                ++nImages;
                break;
            }
            byte[] marker = this.getMarker(b);
            if (marker == null) {
                throw new FormatException("Could not find known marker.");
            }
            this.debug("Marker: " + marker[0] + ", " + marker[1] + ", " + marker[2]);
            s.seek(0L);
            while (s.getFilePointer() < s.length() - 2L) {
                this.debug("  Looking for image at " + s.getFilePointer());
                s.order(false);
                s.seek(this.findNextOffset(b, marker, (int)s.getFilePointer()));
                if (s.getFilePointer() < 0L) continue block2;
                s.skipBytes(3);
                short len = s.readShort();
                if (len <= 0) continue;
                imageNames.add(s.readString(len));
                s.skipBytes(6);
                s.order(true);
                len = s.readShort();
                if (len < 0 || len > 4096) continue;
                String description = s.readString(len);
                this.debug("Description: " + description);
                String dateTime = "";
                for (String line : lines = description.split("[\r\n]")) {
                    int colon = (line = line.trim()).indexOf(":");
                    if (colon == -1 || line.startsWith(";")) continue;
                    String key = line.substring(0, colon).trim();
                    String value = line.substring(colon + 1).trim();
                    String metaKey = "Series " + nImages + " " + key;
                    this.addMeta(metaKey, value, tmpSeriesMetadata);
                    if (key.equals("Start time of experiment")) {
                        dateTime = dateTime + " " + value;
                        continue;
                    }
                    if (key.equals("Date")) {
                        dateTime = value + " " + dateTime;
                        continue;
                    }
                    if (key.equals("Exposure time [ms]")) {
                        double exp = Double.parseDouble(value) / 1000.0;
                        this.exposureTimes.put(new Integer(nImages), new Double(exp));
                        continue;
                    }
                    if (key.equals("Image type")) {
                        types.add(value);
                        continue;
                    }
                    if (key.equals("Monochromator wavelength [nm]") || !key.equals("Monochromator wavelength increment[nm]")) continue;
                    waves.add(value);
                }
                if (!(dateTime = dateTime.trim()).equals("")) {
                    boolean success = false;
                    for (String format : DATE_FORMATS) {
                        try {
                            dateTime = DateTools.formatDate(dateTime, format);
                            success = true;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    dates.add(success ? dateTime : "");
                }
                ++nImages;
            }
        }
        Location directory = new Location(this.currentId).getAbsoluteFile().getParentFile();
        Object[] pixelsFile = new String[nImages];
        if (!this.embeddedImages) {
            if (nImages == 0) {
                throw new FormatException("No images found.");
            }
            this.core = new CoreMetadata[nImages];
            String[] files = directory.list();
            int nextFile = 0;
            for (int i3 = 0; i3 < files.length; ++i3) {
                if (!files[i3].endsWith(".pst")) continue;
                Location pst = new Location(directory, files[i3]);
                if (pst.isDirectory()) {
                    String[] subfiles = pst.list();
                    for (int q = 0; q < subfiles.length; ++q) {
                        if (!subfiles[q].endsWith(".pst") || nextFile >= nImages) continue;
                        pixelsFile[nextFile++] = files[i3] + File.separator + subfiles[q];
                    }
                    continue;
                }
                if (nextFile >= nImages) continue;
                pixelsFile[nextFile++] = files[i3];
            }
            if (nextFile == 0) {
                throw new FormatException("No image files found.");
            }
        }
        Arrays.sort(pixelsFile);
        this.pixelsStream = new RandomAccessInputStream[this.getSeriesCount()];
        Object[] metadataKeys = tmpSeriesMetadata.keySet().toArray();
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (!this.embeddedImages) {
                this.core[i] = new CoreMetadata();
                Object file2 = pixelsFile[i];
                file2 = ((String)file2).replace('/', File.separatorChar);
                Object oldFile = file2 = ((String)file2).replace('\\', File.separatorChar);
                Location f = new Location(directory, (String)oldFile);
                if (!f.exists() && !(f = new Location(directory, (String)(oldFile = ((String)oldFile).substring(((String)oldFile).lastIndexOf(File.separator) + 1)))).exists()) {
                    throw new FormatException("Could not find pixels file '" + (String)file2);
                }
                file2 = f.getAbsolutePath();
                this.pixelsStream[i] = new RandomAccessInputStream((String)file2);
                int dot = ((String)file2).lastIndexOf(".");
                String infFile = ((String)file2).substring(0, dot) + ".inf";
                String data = DataTools.readFile(infFile);
                lines = new StringTokenizer(data);
                while (lines.hasMoreTokens()) {
                    String line = lines.nextToken().trim();
                    if (line.startsWith("[") || line.indexOf("=") == -1) continue;
                    int equal = line.indexOf("=");
                    String key = line.substring(0, equal).trim();
                    String value = line.substring(equal + 1).trim();
                    this.addGlobalMeta(key, value);
                    if (key.equals("Width")) {
                        this.core[i].sizeX = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("Height")) {
                        this.core[i].sizeY = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("Bands")) {
                        this.core[i].sizeC = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("Slices")) {
                        this.core[i].sizeZ = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("Frames")) {
                        this.core[i].sizeT = Integer.parseInt(value);
                        continue;
                    }
                    if (!key.equals("Datatype")) continue;
                    this.core[i].pixelType = this.convertPixelType(Integer.parseInt(value));
                }
            }
            this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeC * this.core[i].sizeT;
            this.core[i].rgb = false;
            this.core[i].littleEndian = true;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].seriesMetadata = new Hashtable();
            for (Object key : metadataKeys) {
                String keyName = key.toString();
                if (!keyName.startsWith("Series " + i + " ")) continue;
                keyName = keyName.replaceAll("Series " + i + " ", "");
                this.core[i].seriesMetadata.put(keyName, tmpSeriesMetadata.get(key));
            }
        }
        tmpSeriesMetadata = null;
        MetadataTools.populatePixels(store, this, true);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            int waveIncrement;
            String date;
            if (i < imageNames.size()) {
                store.setImageName((String)imageNames.get(i), i);
            }
            String string = date = i < dates.size() ? (String)dates.get(i) : "";
            if (date != null && !date.equals("")) {
                store.setImageCreationDate(date, i);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            for (int q = 0; q < this.core[i].imageCount; ++q) {
                store.setPlaneTimingExposureTime(this.exposureTimes.get(new Integer(i)), i, 0, q);
            }
            if (i < waves.size() && (waveIncrement = Integer.parseInt((String)waves.get(i))) > 0) {
                store.setDimensionsWaveIncrement(new Integer(waveIncrement), i, 0);
            }
            if (i >= types.size()) continue;
            store.setExperimentType((String)types.get(i), i);
        }
    }

    private int convertPixelType(int type) throws FormatException {
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        throw new FormatException("Unsupported data type: " + type);
    }

    private byte[] getMarker(byte[] s) throws IOException {
        int offset = this.findNextOffset(s, MARKER_0, 0);
        if (offset != -1) {
            return MARKER_0;
        }
        offset = this.findNextOffset(s, MARKER_1, 0);
        return offset == -1 ? null : MARKER_1;
    }

    private int findNextOffset(byte[] s, byte[] marker, int pos) throws IOException {
        for (int i = pos; i < s.length - marker.length; ++i) {
            boolean found = true;
            for (int q = 0; q < marker.length; ++q) {
                if (marker[q] == s[i + q]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i + marker.length;
        }
        return -1;
    }
}

