/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;

public class APNGWriter
extends FormatWriter {
    private static final byte[] PNG_SIG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private RandomAccessOutputStream out;
    private int numFrames = 0;
    private long numFramesPointer = 0L;
    private int nextSequenceNumber;
    private boolean littleEndian;

    public APNGWriter() {
        super("Animated PNG", "png");
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        byte[] b;
        if (buf == null) {
            throw new FormatException("Byte array is null");
        }
        MetadataRetrieve meta = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(meta, series);
        int pixelType = FormatTools.pixelTypeFromString(meta.getPixelsPixelType(series, 0));
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        boolean signed = FormatTools.isSigned(pixelType);
        this.littleEndian = meta.getPixelsBigEndian(0, 0) == false;
        boolean indexed = this.getColorModel() instanceof IndexColorModel;
        Integer channels = meta.getLogicalChannelSamplesPerPixel(series, 0);
        if (channels == null) {
            this.warn("SamplesPerPixel #0 is null.  It is assumed to be 1.");
        }
        int nChannels = channels == null ? 1 : channels;
        int width = meta.getPixelsSizeX(series, 0);
        int height = meta.getPixelsSizeY(series, 0);
        if (!this.initialized) {
            this.out = new RandomAccessOutputStream(this.currentId);
            this.out.write(PNG_SIG);
            this.out.writeInt(13);
            b = new byte[17];
            b[0] = 73;
            b[1] = 72;
            b[2] = 68;
            b[3] = 82;
            DataTools.unpackBytes(width, b, 4, 4, false);
            DataTools.unpackBytes(height, b, 8, 4, false);
            b[12] = (byte)(bytesPerPixel * 8);
            if (indexed) {
                b[13] = 3;
            } else if (nChannels == 1) {
                b[13] = 0;
            } else if (nChannels == 2) {
                b[13] = 4;
            } else if (nChannels == 3) {
                b[13] = 2;
            } else if (nChannels == 4) {
                b[13] = 6;
            }
            b[14] = 0;
            b[15] = 0;
            b[16] = 0;
            this.out.write(b);
            this.out.writeInt(this.crc(b));
            this.out.writeInt(8);
            this.out.writeBytes("acTL");
            this.numFramesPointer = this.out.getFilePointer();
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.writeFCTL(width, height);
            this.writePLTE();
            this.writePixels("IDAT", buf, width, height, nChannels, signed);
            this.initialized = true;
        } else {
            this.writeFCTL(width, height);
            this.writePixels("fdAT", buf, width, height, nChannels, signed);
        }
        ++this.numFrames;
        if (last) {
            this.out.writeInt(0);
            this.out.writeBytes("IEND");
            this.out.writeInt(this.crc("IEND".getBytes()));
            this.out.seek(this.numFramesPointer);
            this.out.writeInt(this.numFrames);
            this.out.skipBytes(4);
            b = new byte[12];
            b[0] = 97;
            b[1] = 99;
            b[2] = 84;
            b[3] = 76;
            DataTools.unpackBytes(this.numFrames, b, 4, 4, false);
            DataTools.unpackBytes(0L, b, 8, 4, false);
            this.out.writeInt(this.crc(b));
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes() {
        return new int[]{0, 1, 2, 3};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
        this.numFrames = 0;
    }

    private int crc(byte[] buf) {
        return this.crc(buf, 0, buf.length);
    }

    private int crc(byte[] buf, int off, int len) {
        CRC32 crc = new CRC32();
        crc.update(buf, off, len);
        return (int)crc.getValue();
    }

    private void writeFCTL(int width, int height) throws IOException {
        this.out.writeInt(26);
        byte[] b = new byte[30];
        b[0] = 102;
        b[1] = 99;
        b[2] = 84;
        b[3] = 76;
        DataTools.unpackBytes(this.nextSequenceNumber++, b, 4, 4, false);
        DataTools.unpackBytes(width, b, 8, 4, false);
        DataTools.unpackBytes(height, b, 12, 4, false);
        DataTools.unpackBytes(0L, b, 16, 4, false);
        DataTools.unpackBytes(0L, b, 20, 4, false);
        DataTools.unpackBytes(1L, b, 24, 2, false);
        DataTools.unpackBytes(this.fps, b, 26, 2, false);
        b[28] = 1;
        b[29] = 0;
        this.out.write(b);
        this.out.writeInt(this.crc(b));
    }

    private void writePLTE() throws IOException {
        if (!(this.getColorModel() instanceof IndexColorModel)) {
            return;
        }
        IndexColorModel model = (IndexColorModel)this.getColorModel();
        byte[][] lut = new byte[3][256];
        model.getReds(lut[0]);
        model.getGreens(lut[1]);
        model.getBlues(lut[2]);
        this.out.writeInt(768);
        byte[] b = new byte[772];
        b[0] = 80;
        b[1] = 76;
        b[2] = 84;
        b[3] = 69;
        for (int i = 0; i < lut[0].length; ++i) {
            for (int j = 0; j < lut.length; ++j) {
                b[i * lut.length + j + 4] = lut[j][i];
            }
        }
        this.out.write(b);
        this.out.writeInt(this.crc(b));
    }

    private void writePixels(String chunk, byte[] stream, int width, int height, int sizeC, boolean signed) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        s.write(chunk.getBytes());
        if (chunk.equals("fdAT")) {
            s.write(DataTools.intToBytes(this.nextSequenceNumber++, false));
        }
        DeflaterOutputStream deflater = new DeflaterOutputStream(s);
        int planeSize = stream.length / sizeC;
        int rowLen = stream.length / height;
        int bytesPerPixel = stream.length / (width * height * sizeC);
        byte[] rowBuf = new byte[rowLen];
        for (int i = 0; i < height; ++i) {
            deflater.write(0);
            if (this.interleaved) {
                System.arraycopy(stream, i * rowLen, rowBuf, 0, rowLen);
            } else {
                int max = (int)Math.pow(2.0, bytesPerPixel * 8 - 1);
                for (int col = 0; col < width; ++col) {
                    for (int c = 0; c < sizeC; ++c) {
                        int offset = c * planeSize + (i * width + col) * bytesPerPixel;
                        int pixel = DataTools.bytesToInt(stream, offset, bytesPerPixel, this.littleEndian);
                        if (signed) {
                            pixel = pixel < max ? (pixel += max) : (pixel -= max);
                        }
                        int output = (col * sizeC + c) * bytesPerPixel;
                        DataTools.unpackBytes(pixel, rowBuf, output, bytesPerPixel, false);
                    }
                }
            }
            deflater.write(rowBuf);
        }
        deflater.finish();
        byte[] b = s.toByteArray();
        this.out.writeInt(b.length - 4);
        this.out.write(b);
        this.out.writeInt(this.crc(b));
    }
}

