/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import loci.common.LogTools;
import loci.formats.FormatException;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffRational;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFD
extends HashMap<Integer, Object> {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_TIFF = 1;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int IFD = 13;
    public static final int LONG8 = 16;
    public static final int SLONG8 = 17;
    public static final int IFD8 = 18;
    private static final int[] BYTES_PER_ELEMENT = new int[]{-1, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, 4, -1, -1, 8, 8, 8};
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int SUBFILE_TYPE = 255;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRIC_INTERPRETATION = 262;
    public static final int THRESHHOLDING = 263;
    public static final int CELL_WIDTH = 264;
    public static final int CELL_LENGTH = 265;
    public static final int FILL_ORDER = 266;
    public static final int DOCUMENT_NAME = 269;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIP_OFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNTS = 279;
    public static final int MIN_SAMPLE_VALUE = 280;
    public static final int MAX_SAMPLE_VALUE = 281;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int PAGE_NAME = 285;
    public static final int X_POSITION = 286;
    public static final int Y_POSITION = 287;
    public static final int FREE_OFFSETS = 288;
    public static final int FREE_BYTE_COUNTS = 289;
    public static final int GRAY_RESPONSE_UNIT = 290;
    public static final int GRAY_RESPONSE_CURVE = 291;
    public static final int T4_OPTIONS = 292;
    public static final int T6_OPTIONS = 293;
    public static final int RESOLUTION_UNIT = 296;
    public static final int PAGE_NUMBER = 297;
    public static final int TRANSFER_FUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int ARTIST = 315;
    public static final int HOST_COMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int WHITE_POINT = 318;
    public static final int PRIMARY_CHROMATICITIES = 319;
    public static final int COLOR_MAP = 320;
    public static final int HALFTONE_HINTS = 321;
    public static final int TILE_WIDTH = 322;
    public static final int TILE_LENGTH = 323;
    public static final int TILE_OFFSETS = 324;
    public static final int TILE_BYTE_COUNTS = 325;
    public static final int INK_SET = 332;
    public static final int INK_NAMES = 333;
    public static final int NUMBER_OF_INKS = 334;
    public static final int DOT_RANGE = 336;
    public static final int TARGET_PRINTER = 337;
    public static final int EXTRA_SAMPLES = 338;
    public static final int SAMPLE_FORMAT = 339;
    public static final int S_MIN_SAMPLE_VALUE = 340;
    public static final int S_MAX_SAMPLE_VALUE = 341;
    public static final int TRANSFER_RANGE = 342;
    public static final int JPEG_TABLES = 347;
    public static final int JPEG_PROC = 512;
    public static final int JPEG_INTERCHANGE_FORMAT = 513;
    public static final int JPEG_INTERCHANGE_FORMAT_LENGTH = 514;
    public static final int JPEG_RESTART_INTERVAL = 515;
    public static final int JPEG_LOSSLESS_PREDICTORS = 517;
    public static final int JPEG_POINT_TRANSFORMS = 518;
    public static final int JPEG_Q_TABLES = 519;
    public static final int JPEG_DC_TABLES = 520;
    public static final int JPEG_AC_TABLES = 521;
    public static final int Y_CB_CR_COEFFICIENTS = 529;
    public static final int Y_CB_CR_SUB_SAMPLING = 530;
    public static final int Y_CB_CR_POSITIONING = 531;
    public static final int REFERENCE_BLACK_WHITE = 532;
    public static final int COPYRIGHT = 33432;
    public static final int EXIF = 34665;

    public IFD() {
    }

    public IFD(IFD ifd) {
        super(ifd);
    }

    public boolean isBigTiff() throws FormatException {
        return (Boolean)this.getIFDValue(1, false, Boolean.class);
    }

    public boolean isLittleEndian() throws FormatException {
        return (Boolean)this.getIFDValue(0, true, Boolean.class);
    }

    public Object getIFDValue(int tag) {
        return this.get(new Integer(tag));
    }

    public Object getIFDValue(int tag, boolean checkNull, Class checkClass) throws FormatException {
        Object value = this.get(new Integer(tag));
        if (checkNull && value == null) {
            throw new FormatException(loci.formats.tiff.IFD.getIFDTagName(tag) + " directory entry not found");
        }
        if (checkClass != null && value != null && !checkClass.isInstance(value)) {
            Class<?> cType = checkClass.getComponentType();
            Object array = null;
            if (cType == value.getClass()) {
                array = Array.newInstance(value.getClass(), 1);
                Array.set(array, 0, value);
            }
            if (cType == Boolean.TYPE && value instanceof Boolean) {
                array = Array.newInstance(Boolean.TYPE, 1);
                Array.setBoolean(array, 0, (Boolean)value);
            } else if (cType == Byte.TYPE && value instanceof Byte) {
                array = Array.newInstance(Byte.TYPE, 1);
                Array.setByte(array, 0, (Byte)value);
            } else if (cType == Character.TYPE && value instanceof Character) {
                array = Array.newInstance(Character.TYPE, 1);
                Array.setChar(array, 0, ((Character)value).charValue());
            } else if (cType == Double.TYPE && value instanceof Double) {
                array = Array.newInstance(Double.TYPE, 1);
                Array.setDouble(array, 0, (Double)value);
            } else if (cType == Float.TYPE && value instanceof Float) {
                array = Array.newInstance(Float.TYPE, 1);
                Array.setFloat(array, 0, ((Float)value).floatValue());
            } else if (cType == Integer.TYPE && value instanceof Integer) {
                array = Array.newInstance(Integer.TYPE, 1);
                Array.setInt(array, 0, (Integer)value);
            } else if (cType == Long.TYPE && value instanceof Long) {
                array = Array.newInstance(Long.TYPE, 1);
                Array.setLong(array, 0, (Long)value);
            } else if (cType == Short.TYPE && value instanceof Short) {
                array = Array.newInstance(Short.TYPE, 1);
                Array.setShort(array, 0, (Short)value);
            }
            if (array != null) {
                return array;
            }
            throw new FormatException(loci.formats.tiff.IFD.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected " + checkClass.getName());
        }
        return value;
    }

    public long getIFDLongValue(int tag, boolean checkNull, long defaultValue) throws FormatException {
        long value = defaultValue;
        Number number = (Number)this.getIFDValue(tag, checkNull, Number.class);
        if (number != null) {
            value = number.longValue();
        }
        return value;
    }

    public int getIFDIntValue(int tag) {
        int value = -1;
        try {
            value = this.getIFDIntValue(tag, false, -1);
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return value;
    }

    public int getIFDIntValue(int tag, boolean checkNull, int defaultValue) throws FormatException {
        int value = defaultValue;
        Number number = (Number)this.getIFDValue(tag, checkNull, Number.class);
        if (number != null) {
            value = number.intValue();
        }
        return value;
    }

    public TiffRational getIFDRationalValue(int tag, boolean checkNull) throws FormatException {
        return (TiffRational)this.getIFDValue(tag, checkNull, TiffRational.class);
    }

    public String getIFDStringValue(int tag, boolean checkNull) throws FormatException {
        return (String)this.getIFDValue(tag, checkNull, String.class);
    }

    public String getIFDTextValue(int tag) {
        String value = null;
        Object o = this.getIFDValue(tag);
        if (o instanceof String[]) {
            StringBuilder sb = new StringBuilder();
            String[] s = (String[])o;
            for (int i = 0; i < s.length; ++i) {
                sb.append(s[i]);
                if (i >= s.length - 1) continue;
                sb.append("\n");
            }
            value = sb.toString();
        } else if (o instanceof short[]) {
            StringBuffer sb = new StringBuffer();
            for (short s : (short[])o) {
                if (!Character.isISOControl((char)s)) {
                    sb.append((char)s);
                    continue;
                }
                sb.append("\n");
            }
            value = sb.toString();
        } else if (o != null) {
            value = o.toString();
        }
        if (value != null) {
            value = value.replaceAll("\r\n", "\n");
            value = value.replaceAll("\r", "\n");
        }
        return value;
    }

    public long[] getIFDLongArray(int tag, boolean checkNull) throws FormatException {
        Object value = this.getIFDValue(tag, checkNull, null);
        long[] results = null;
        if (value instanceof long[]) {
            results = (long[])value;
        } else if (value instanceof Number) {
            results = new long[]{((Number)value).longValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new long[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].longValue();
            }
        } else if (value instanceof int[]) {
            int[] integers = (int[])value;
            results = new long[integers.length];
            for (int i = 0; i < integers.length; ++i) {
                results[i] = integers[i];
            }
        } else if (value != null) {
            throw new FormatException(loci.formats.tiff.IFD.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, long[], Number[] or int[])");
        }
        return results;
    }

    public int[] getIFDIntArray(int tag, boolean checkNull) throws FormatException {
        Object value = this.getIFDValue(tag, checkNull, null);
        int[] results = null;
        if (value instanceof int[]) {
            results = (int[])value;
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            results = new int[v.length];
            for (int i = 0; i < v.length; ++i) {
                results[i] = (int)v[i];
            }
        } else if (value instanceof Number) {
            results = new int[]{((Number)value).intValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new int[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].intValue();
            }
        } else if (value != null) {
            throw new FormatException(loci.formats.tiff.IFD.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, int[] or Number[])");
        }
        return results;
    }

    public short[] getIFDShortArray(int tag, boolean checkNull) throws FormatException {
        Object value = this.getIFDValue(tag, checkNull, null);
        short[] results = null;
        if (value instanceof short[]) {
            results = (short[])value;
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            results = new short[v.length];
            for (int i = 0; i < v.length; ++i) {
                results[i] = (short)v[i];
            }
        } else if (value instanceof Number) {
            results = new short[]{((Number)value).shortValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new short[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].shortValue();
            }
        } else if (value != null) {
            throw new FormatException(loci.formats.tiff.IFD.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, short[] or Number[])");
        }
        return results;
    }

    public String getComment() {
        return this.getIFDTextValue(270);
    }

    public long getTileWidth() throws FormatException {
        long tileWidth = this.getIFDLongValue(322, false, 0L);
        return tileWidth == 0L ? this.getImageWidth() : tileWidth;
    }

    public long getTileLength() throws FormatException {
        long tileLength = this.getIFDLongValue(323, false, 0L);
        return tileLength == 0L ? this.getRowsPerStrip()[0] : tileLength;
    }

    public long getTilesPerRow() throws FormatException {
        long tileWidth = this.getTileWidth();
        long imageWidth = this.getImageWidth();
        long nTiles = imageWidth / tileWidth;
        if (nTiles * tileWidth < imageWidth) {
            ++nTiles;
        }
        return nTiles;
    }

    public long getTilesPerColumn() throws FormatException {
        long tileLength = this.getTileLength();
        long imageLength = this.getImageLength();
        long nTiles = imageLength / tileLength;
        if (nTiles * tileLength < imageLength) {
            ++nTiles;
        }
        return nTiles;
    }

    public boolean isTiled() throws FormatException {
        Object offsets = this.get(new Integer(273));
        Object tileWidth = this.get(new Integer(322));
        return offsets == null || tileWidth != null;
    }

    public long getImageWidth() throws FormatException {
        long width = this.getIFDLongValue(256, true, 0L);
        if (width > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth > 2147483647 is not supported.");
        }
        return width;
    }

    public long getImageLength() throws FormatException {
        long length = this.getIFDLongValue(257, true, 0L);
        if (length > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageLength > 2147483647 is not supported.");
        }
        return length;
    }

    public int[] getBitsPerSample() throws FormatException {
        int samplesPerPixel;
        int[] bitsPerSample = this.getIFDIntArray(258, false);
        if (bitsPerSample == null) {
            bitsPerSample = new int[]{1};
        }
        if (bitsPerSample.length < (samplesPerPixel = this.getSamplesPerPixel())) {
            throw new FormatException("BitsPerSample length (" + bitsPerSample.length + ") does not match SamplesPerPixel (" + samplesPerPixel + ")");
        }
        int nSamples = Math.min(bitsPerSample.length, samplesPerPixel);
        for (int i = 0; i < nSamples; ++i) {
            if (bitsPerSample[i] >= 1) continue;
            throw new FormatException("Illegal BitsPerSample (" + bitsPerSample[i] + ")");
        }
        return bitsPerSample;
    }

    public int getPixelType() throws FormatException {
        int bps = this.getBitsPerSample()[0];
        int bitFormat = this.getIFDIntValue(339);
        while (bps % 8 != 0) {
            ++bps;
        }
        if (bps == 24 && bitFormat != 3) {
            bps = 32;
        }
        switch (bps) {
            case 16: {
                if (bitFormat == 3) {
                    return 6;
                }
                return bitFormat == 2 ? 2 : 3;
            }
            case 24: {
                return 6;
            }
            case 64: {
                return 7;
            }
            case 32: {
                if (bitFormat == 3) {
                    return 6;
                }
                return bitFormat == 2 ? 4 : 5;
            }
        }
        return bitFormat == 2 ? 0 : 1;
    }

    public int[] getBytesPerSample() throws FormatException {
        int[] bitsPerSample = this.getBitsPerSample();
        int[] bps = new int[bitsPerSample.length];
        for (int i = 0; i < bitsPerSample.length; ++i) {
            bps[i] = bitsPerSample[i];
            while (bps[i] % 8 != 0) {
                int n = i;
                bps[n] = bps[n] + 1;
            }
            int n = i;
            bps[n] = bps[n] / 8;
            if (bps[i] != 0) continue;
            bps[i] = 1;
        }
        return bps;
    }

    public int getSamplesPerPixel() throws FormatException {
        return this.getIFDIntValue(277, false, 1);
    }

    public int getCompression() throws FormatException {
        int compression = this.getIFDIntValue(259, false, 1);
        if (compression == 0) {
            compression = 1;
        }
        return compression;
    }

    public int getPhotometricInterpretation() throws FormatException {
        int photoInterp = this.getIFDIntValue(262, true, 0);
        PhotoInterp.checkPI(photoInterp);
        return photoInterp;
    }

    public int getPlanarConfiguration() throws FormatException {
        int planarConfig = this.getIFDIntValue(284, false, 1);
        if (planarConfig != 1 && planarConfig != 2) {
            throw new FormatException("Sorry, PlanarConfiguration (" + planarConfig + ") not supported.");
        }
        return planarConfig;
    }

    public long[] getStripOffsets() throws FormatException {
        int tag = this.isTiled() ? 324 : 273;
        long[] offsets = this.getIFDLongArray(tag, false);
        if (this.isTiled() && offsets == null) {
            offsets = this.getIFDLongArray(273, false);
        }
        if (this.isTiled()) {
            return offsets;
        }
        long rowsPerStrip = this.getRowsPerStrip()[0];
        long numStrips = (this.getImageLength() + rowsPerStrip - 1L) / rowsPerStrip;
        if (this.getPlanarConfiguration() == 2) {
            numStrips *= (long)this.getSamplesPerPixel();
        }
        if ((long)offsets.length < numStrips) {
            throw new FormatException("StripOffsets length (" + offsets.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        return offsets;
    }

    public long[] getStripByteCounts() throws FormatException {
        int tag = this.isTiled() ? 325 : 279;
        long[] byteCounts = this.getIFDLongArray(tag, false);
        if (this.isTiled() && byteCounts == null) {
            byteCounts = this.getIFDLongArray(279, false);
        }
        if (byteCounts == null) {
            long[] offsets = this.getStripOffsets();
            int bytesPerSample = this.getBytesPerSample()[0];
            long imageWidth = this.getImageWidth();
            long imageLength = this.getImageLength();
            byteCounts = new long[offsets.length];
            int samples = this.getSamplesPerPixel();
            long imageSize = imageWidth * imageLength * (long)bytesPerSample * (long)(this.getPlanarConfiguration() == 2 ? 1 : samples);
            long count = imageSize / (long)byteCounts.length;
            Arrays.fill(byteCounts, count);
        }
        long[] counts = new long[byteCounts.length];
        if (this.getCompression() == 5) {
            for (int i = 0; i < byteCounts.length; ++i) {
                counts[i] = byteCounts[i] * 2L;
            }
        } else {
            System.arraycopy(byteCounts, 0, counts, 0, counts.length);
        }
        if (this.isTiled()) {
            return counts;
        }
        long rowsPerStrip = this.getRowsPerStrip()[0];
        long numStrips = (this.getImageLength() + rowsPerStrip - 1L) / rowsPerStrip;
        if (this.getPlanarConfiguration() == 2) {
            numStrips *= (long)this.getSamplesPerPixel();
        }
        if ((long)counts.length < numStrips) {
            throw new FormatException("StripByteCounts length (" + counts.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        return counts;
    }

    public long[] getRowsPerStrip() throws FormatException {
        if (this.isTiled()) {
            return new long[]{this.getImageLength()};
        }
        long[] rowsPerStrip = this.getIFDLongArray(278, false);
        if (rowsPerStrip == null) {
            return new long[]{this.getImageLength()};
        }
        long imageLength = this.getImageLength();
        for (int i = 0; i < rowsPerStrip.length; ++i) {
            rowsPerStrip[i] = Math.min(rowsPerStrip[i], imageLength);
        }
        long rows = rowsPerStrip[0];
        for (int i = 1; i < rowsPerStrip.length; ++i) {
            if (rows == rowsPerStrip[i]) continue;
            throw new FormatException("Sorry, non-uniform RowsPerStrip is not supported");
        }
        return rowsPerStrip;
    }

    public void putIFDValue(int tag, Object value) {
        this.put(new Integer(tag), value);
    }

    public void putIFDValue(int tag, short value) {
        this.putIFDValue(tag, new Short(value));
    }

    public void putIFDValue(int tag, int value) {
        this.putIFDValue(tag, new Integer(value));
    }

    public void putIFDValue(int tag, long value) {
        this.putIFDValue(tag, new Long(value));
    }

    public void printIFD() {
        if (!LogTools.isDebug()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("IFD directory entry values:");
        Integer[] tags = this.keySet().toArray(new Integer[0]);
        for (int entry = 0; entry < tags.length; ++entry) {
            sb.append("\n\t");
            sb.append(loci.formats.tiff.IFD.getIFDTagName(tags[entry]));
            sb.append("=");
            Object value = this.get(tags[entry]);
            if (value instanceof Boolean || value instanceof Number || value instanceof String) {
                sb.append(value);
                continue;
            }
            int nElements = Array.getLength(value);
            for (int i = 0; i < nElements; ++i) {
                sb.append(Array.get(value, i));
                if (i >= nElements - 1) continue;
                sb.append(",");
            }
        }
        LogTools.debug(sb.toString());
    }

    public static String getIFDTagName(int tag) {
        return loci.formats.tiff.IFD.getFieldName(tag);
    }

    public static String getIFDTypeName(int type) {
        return loci.formats.tiff.IFD.getFieldName(type);
    }

    public static int getIFDTypeLength(int type) {
        if (type < 0 || type >= BYTES_PER_ELEMENT.length) {
            return -1;
        }
        return BYTES_PER_ELEMENT[type];
    }

    public static String getFieldName(int value) {
        Field[] fields = IFD.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getInt(null) != value) continue;
                return fields[i].getName();
            }
            catch (IllegalAccessException exc) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "" + value;
    }
}

