/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1Data;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1GetData {
    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileContainingData> ");
        System.out.println("<OffsetToData> obtained from GribIndexer ");
        System.out.println("<DeciamlScale> obtained from GribIndexer ");
        System.out.println("<true/false> does bmsExists from Grib1Indexer ");
        System.out.println("<output file>");
        System.out.println();
        System.out.println("java -Xmx256m ucar/grib/grib1/" + className + " <GribFileContainingData> <OffsetToData> <DecimalScale> <output file>");
        System.exit(0);
    }

    public static void main(String[] args) {
        Grib1GetData func = new Grib1GetData();
        if (args.length < 4) {
            Class<?> cl = func.getClass();
            Grib1GetData.usage(cl.getName());
        }
        TimeZone tz = TimeZone.getTimeZone("127");
        TimeZone.setDefault(tz);
        Date now = Calendar.getInstance().getTime();
        try {
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            long offset = 0L;
            boolean bmsExists = true;
            int decimalScale = 1;
            if (args.length == 4 || args.length == 5) {
                raf = new RandomAccessFile(args[0], "r");
                raf.order(0);
                offset = Long.decode(args[1]);
                decimalScale = Integer.parseInt(args[2]);
                Boolean B = Boolean.valueOf(args[3]);
                bmsExists = B;
            } else {
                System.exit(0);
            }
            if (args.length == 5) {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[4], false)));
            }
            long start = System.currentTimeMillis();
            Grib1Data g1d = new Grib1Data(raf);
            float[] data = g1d.getData(offset, decimalScale, bmsExists);
            System.out.println("getting data size " + data.length + " took " + (System.currentTimeMillis() - start) + " msec");
            if (data != null) {
                for (int j = 0; j < data.length; ++j) {
                    ps.println("data[ " + j + " ]=" + data[j]);
                }
            }
            raf.close();
            ps.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        now = Calendar.getInstance().getTime();
    }
}

