/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.ProxyReader;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissingImpl;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureDS
extends Structure
implements VariableEnhanced {
    private EnhancementsImpl proxy;
    private EnhanceScaleMissingImpl smProxy;
    private boolean isEnhanced = false;
    protected Structure orgVar;

    public StructureDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName, String dims, String units, String desc) {
        super(ds, group, parentStructure, shortName);
        this.setDimensions(dims);
        this.proxy = new EnhancementsImpl(this, units, desc);
        this.smProxy = new EnhanceScaleMissingImpl();
        if (units != null) {
            this.addAttribute(new Attribute("units", units));
        }
        if (desc != null) {
            this.addAttribute(new Attribute("long_name", desc));
        }
    }

    public StructureDS(Group g, Structure orgVar, boolean reparent) {
        super(orgVar, reparent);
        this.group = g;
        this.orgVar = orgVar;
        this.proxy = new EnhancementsImpl(this);
        this.smProxy = new EnhanceScaleMissingImpl();
    }

    @Override
    protected Variable copy() {
        return new StructureDS(null, this, false);
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Override
    public void setOriginalVariable(Variable orgVar) {
        if (!(orgVar instanceof Structure)) {
            throw new IllegalArgumentException("STructureDS must wrap a Structure; name=" + orgVar.getName());
        }
        this.orgVar = (Structure)orgVar;
    }

    public DataType getOriginalDataType() {
        return DataType.STRUCTURE;
    }

    @Override
    public void setProxyReader(ProxyReader proxyReader) {
        this.postReader = proxyReader;
    }

    @Override
    public ProxyReader getProxyReader() {
        return this.postReader;
    }

    @Override
    protected Array _read() throws IOException {
        Array result;
        if (this.hasCachedData()) {
            result = super._read();
        } else if (this.postReader != null) {
            result = this.postReader.read(this, null);
        } else if (this.orgVar != null) {
            result = this.orgVar.read();
        } else {
            Object data = this.smProxy.getFillValue(this.getDataType());
            return Array.factoryConstant(this.dataType.getPrimitiveClassType(), this.getShape(), data);
        }
        ArrayStructure as = (ArrayStructure)result;
        return as;
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        Array result;
        if (this.hasCachedData()) {
            result = super._read(section);
        } else if (this.postReader != null) {
            result = this.postReader.read(this, section, null);
        } else if (this.orgVar != null) {
            result = this.orgVar.read(section);
        } else {
            Object data = this.smProxy.getFillValue(this.getDataType());
            return Array.factoryConstant(this.dataType.getPrimitiveClassType(), section.getShape(), data);
        }
        ArrayStructure as = (ArrayStructure)result;
        return as;
    }

    @Override
    public void enhance() {
        for (Variable mv : this.getVariables()) {
            if (mv instanceof VariableDS) {
                ((VariableDS)mv).enhance();
                continue;
            }
            if (!(mv instanceof StructureDS)) continue;
            ((StructureDS)mv).enhance();
        }
        this.isEnhanced = true;
    }

    public boolean isEnhanced() {
        return this.isEnhanced;
    }

    @Override
    public void addCoordinateSystem(CoordinateSystem p0) {
        this.proxy.addCoordinateSystem(p0);
    }

    @Override
    public void removeCoordinateSystem(CoordinateSystem p0) {
        this.proxy.removeCoordinateSystem(p0);
    }

    @Override
    public List<CoordinateSystem> getCoordinateSystems() {
        return this.proxy.getCoordinateSystems();
    }

    @Override
    public String getDescription() {
        return this.proxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.proxy.getUnitsString();
    }

    @Override
    public double getValidMax() {
        return this.smProxy.getValidMax();
    }

    @Override
    public double getValidMin() {
        return this.smProxy.getValidMin();
    }

    @Override
    public boolean hasFillValue() {
        return this.smProxy.hasFillValue();
    }

    @Override
    public boolean hasInvalidData() {
        return this.smProxy.hasInvalidData();
    }

    @Override
    public boolean hasMissing() {
        return this.smProxy.hasMissing();
    }

    @Override
    public boolean hasMissingValue() {
        return this.smProxy.hasMissingValue();
    }

    @Override
    public boolean hasScaleOffset() {
        return this.smProxy.hasScaleOffset();
    }

    @Override
    public boolean isFillValue(double p0) {
        return this.smProxy.isFillValue(p0);
    }

    @Override
    public boolean isInvalidData(double p0) {
        return this.smProxy.isInvalidData(p0);
    }

    @Override
    public boolean isMissing(double p0) {
        return this.smProxy.isMissing(p0);
    }

    @Override
    public boolean isMissingValue(double p0) {
        return this.smProxy.isMissingValue(p0);
    }

    @Override
    public void setFillValueIsMissing(boolean p0) {
        this.smProxy.setFillValueIsMissing(p0);
    }

    @Override
    public void setInvalidDataIsMissing(boolean p0) {
        this.smProxy.setInvalidDataIsMissing(p0);
    }

    @Override
    public void setMissingDataIsMissing(boolean p0) {
        this.smProxy.setMissingDataIsMissing(p0);
    }

    @Override
    public void setUseNaNs(boolean useNaNs) {
        this.smProxy.setUseNaNs(useNaNs);
    }

    @Override
    public double convertScaleOffsetMissing(byte value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(short value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(int value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(long value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(double value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    public double convertScalarDouble(StructureData sdata, StructureMembers.Member m) {
        VariableDS mv = (VariableDS)this.findVariable(m.getName());
        DataType dt = m.getDataType();
        if (dt == DataType.FLOAT) {
            return mv.convertScaleOffsetMissing(sdata.getScalarFloat(m));
        }
        if (dt == DataType.DOUBLE) {
            return mv.convertScaleOffsetMissing(sdata.getScalarDouble(m));
        }
        if (dt == DataType.BYTE) {
            return mv.convertScaleOffsetMissing(sdata.getScalarByte(m));
        }
        if (dt == DataType.SHORT) {
            return mv.convertScaleOffsetMissing(sdata.getScalarShort(m));
        }
        if (dt == DataType.INT) {
            return mv.convertScaleOffsetMissing(sdata.getScalarInt(m));
        }
        if (dt == DataType.LONG) {
            return mv.convertScaleOffsetMissing(sdata.getScalarLong(m));
        }
        if (dt == DataType.CHAR) {
            return mv.convertScaleOffsetMissing(sdata.getScalarChar(m));
        }
        throw new ForbiddenConversionException();
    }
}

