/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;

public class DeltavisionReader
extends FormatReader {
    public static final int DV_MAGIC_BYTES_1 = 41152;
    public static final int DV_MAGIC_BYTES_2 = 49312;
    public static final String DATE_FORMAT = "EEE MMM  d HH:mm:ss yyyy";
    private static final short LITTLE_ENDIAN = -16224;
    private static final int HEADER_LENGTH = 1024;
    private static final String[] IMAGE_TYPES = new String[]{"normal", "Tilt-series", "Stereo tilt-series", "Averaged images", "Averaged stereo pairs"};
    private int extSize;
    protected int wSize;
    protected int zSize;
    protected int tSize;
    protected int numIntsPerSection;
    protected int numFloatsPerSection;
    protected DVExtHdrFields[][][] extHdrFields = null;
    private Double[] ndFilters;
    private String logFile;
    private String deconvolutionLogFile;

    public DeltavisionReader() {
        super("Deltavision", new String[]{"dv", "r3d", "r3d_d3d", "dv.log"});
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (DeltavisionReader.checkSuffix(name, "dv.log") || name.endsWith("_log.txt")) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 98;
        if (!FormatTools.validStream(stream, 98, false)) {
            return false;
        }
        stream.seek(96L);
        int magic = stream.readShort() & 0xFFFF;
        return magic == 41152 || magic == 49312;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        if (!noPixels) {
            files.add(this.currentId);
        }
        if (this.logFile != null) {
            files.add(this.logFile);
        }
        if (this.deconvolutionLogFile != null) {
            files.add(this.deconvolutionLogFile);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        long planeOffset = (long)FormatTools.getPlaneSize(this) * (long)no;
        this.in.seek((long)(1024 + this.extSize) + planeOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tSize = 0;
            this.zSize = 0;
            this.wSize = 0;
            this.extSize = 0;
            this.numFloatsPerSection = 0;
            this.numIntsPerSection = 0;
            this.extHdrFields = null;
            this.ndFilters = null;
            this.deconvolutionLogFile = null;
            this.logFile = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        boolean logFound;
        int i;
        String pixel;
        String imageSequence;
        this.debug("DeltavisionReader.initFile(" + id + ")");
        if (DeltavisionReader.checkSuffix(id, "dv.log")) {
            id = id.substring(0, id.lastIndexOf("."));
        } else if (id.endsWith("_log.txt")) {
            id = id.substring(0, id.lastIndexOf("_")) + ".dv";
        }
        super.initFile(id);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        this.status("Reading header");
        this.in = new RandomAccessInputStream(id);
        this.in.seek(96L);
        this.in.order(true);
        boolean little = this.in.readShort() == -16224;
        this.in.order(little);
        this.in.seek(0L);
        int sizeX = this.in.readInt();
        int sizeY = this.in.readInt();
        int imageCount = this.in.readInt();
        int filePixelType = this.in.readInt();
        int subImageStartX = this.in.readInt();
        int subImageStartY = this.in.readInt();
        int subImageStartZ = this.in.readInt();
        int pixelSamplingX = this.in.readInt();
        int pixelSamplingY = this.in.readInt();
        int pixelSamplingZ = this.in.readInt();
        float pixX = this.in.readFloat();
        float pixY = this.in.readFloat();
        float pixZ = this.in.readFloat();
        float xAxisAngle = this.in.readFloat();
        float yAxisAngle = this.in.readFloat();
        float zAxisAngle = this.in.readFloat();
        int xAxisSeq = this.in.readInt();
        int yAxisSeq = this.in.readInt();
        int zAxisSeq = this.in.readInt();
        float[] minWave = new float[5];
        float[] maxWave = new float[5];
        minWave[0] = this.in.readFloat();
        maxWave[0] = this.in.readFloat();
        float meanIntensity = this.in.readFloat();
        int spaceGroupNumber = this.in.readInt();
        this.extSize = this.in.readInt();
        this.in.seek(128L);
        this.numIntsPerSection = this.in.readShort();
        this.numFloatsPerSection = this.in.readShort();
        short numSubResSets = this.in.readShort();
        short zAxisReductionQuotient = this.in.readShort();
        for (int i2 = 1; i2 <= 3; ++i2) {
            minWave[i2] = this.in.readFloat();
            maxWave[i2] = this.in.readFloat();
        }
        short type = this.in.readShort();
        short lensID = this.in.readShort();
        this.in.seek(172L);
        minWave[4] = this.in.readFloat();
        maxWave[4] = this.in.readFloat();
        short rawSizeT = this.in.readShort();
        short sizeT = rawSizeT == 0 ? (short)1 : rawSizeT;
        short sequence = this.in.readShort();
        float xTiltAngle = this.in.readFloat();
        float yTiltAngle = this.in.readFloat();
        float zTiltAngle = this.in.readFloat();
        int rawSizeC = this.in.readShort();
        int sizeC = rawSizeC == 0 ? 1 : rawSizeC;
        short[] waves = new short[5];
        for (int i3 = 0; i3 < waves.length; ++i3) {
            waves[i3] = this.in.readShort();
        }
        float xOrigin = this.in.readFloat();
        float yOrigin = this.in.readFloat();
        float zOrigin = this.in.readFloat();
        this.in.skipBytes(4);
        String[] title = new String[10];
        for (int i4 = 0; i4 < title.length; ++i4) {
            title[i4] = this.in.readString(80).replaceAll("\u0000", "");
        }
        String imageType = type < IMAGE_TYPES.length ? IMAGE_TYPES[type] : "unknown";
        switch (sequence) {
            case 0: {
                imageSequence = "ZTW";
                break;
            }
            case 1: {
                imageSequence = "WZT";
                break;
            }
            case 2: {
                imageSequence = "ZWT";
                break;
            }
            case 65536: {
                imageSequence = "WZT";
                break;
            }
            default: {
                imageSequence = "ZTW";
            }
        }
        int sizeZ = imageCount / (sizeC * sizeT);
        String imageDesc = title[0];
        if (imageDesc != null && imageDesc.length() == 0) {
            imageDesc = null;
        }
        this.status("Populating core metadata");
        this.core[0].littleEndian = little;
        this.core[0].sizeX = sizeX;
        this.core[0].sizeY = sizeY;
        this.core[0].imageCount = imageCount;
        switch (filePixelType) {
            case 0: {
                pixel = "8 bit unsigned integer";
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                pixel = "16 bit signed integer";
                this.core[0].pixelType = 2;
                break;
            }
            case 2: {
                pixel = "32 bit floating point";
                this.core[0].pixelType = 6;
                break;
            }
            case 3: {
                pixel = "16 bit complex";
                this.core[0].pixelType = 2;
                break;
            }
            case 4: {
                pixel = "64 bit complex";
                this.core[0].pixelType = 6;
                break;
            }
            case 6: {
                pixel = "16 bit unsigned integer";
                this.core[0].pixelType = 3;
                break;
            }
            default: {
                pixel = "unknown";
                this.core[0].pixelType = 1;
            }
        }
        this.core[0].sizeT = sizeT;
        this.core[0].dimensionOrder = "XY" + imageSequence.replaceAll("W", "C");
        this.core[0].sizeC = sizeC;
        this.core[0].sizeZ = sizeZ;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.status("Populating original metadata");
        this.addGlobalMeta("ImageWidth", sizeX);
        this.addGlobalMeta("ImageHeight", sizeY);
        this.addGlobalMeta("NumberOfImages", imageCount);
        this.addGlobalMeta("PixelType", pixel);
        this.addGlobalMeta("Sub-image starting point (X)", subImageStartX);
        this.addGlobalMeta("Sub-image starting point (Y)", subImageStartY);
        this.addGlobalMeta("Sub-image starting point (Z)", subImageStartZ);
        this.addGlobalMeta("Pixel sampling size (X)", pixelSamplingX);
        this.addGlobalMeta("Pixel sampling size (Y)", pixelSamplingY);
        this.addGlobalMeta("Pixel sampling size (Z)", pixelSamplingZ);
        this.addGlobalMeta("X element length (in um)", pixX);
        this.addGlobalMeta("Y element length (in um)", pixY);
        this.addGlobalMeta("Z element length (in um)", pixZ);
        this.addGlobalMeta("X axis angle", xAxisAngle);
        this.addGlobalMeta("Y axis angle", yAxisAngle);
        this.addGlobalMeta("Z axis angle", zAxisAngle);
        this.addGlobalMeta("Column axis sequence", xAxisSeq);
        this.addGlobalMeta("Row axis sequence", yAxisSeq);
        this.addGlobalMeta("Section axis sequence", zAxisSeq);
        this.addGlobalMeta("Image Type", imageType);
        this.addGlobalMeta("Lens ID Number", (int)lensID);
        this.addGlobalMeta("Number of timepoints", (int)rawSizeT);
        this.addGlobalMeta("Image sequence", imageSequence);
        this.addGlobalMeta("X axis tilt angle", xTiltAngle);
        this.addGlobalMeta("Y axis tilt angle", yTiltAngle);
        this.addGlobalMeta("Z axis tilt angle", zTiltAngle);
        this.addGlobalMeta("Number of wavelengths", rawSizeC);
        this.addGlobalMeta("Number of focal planes", sizeZ);
        for (i = 0; i < waves.length; ++i) {
            this.addGlobalMeta("Wavelength " + (i + 1) + " (in nm)", waves[i]);
        }
        this.addGlobalMeta("X origin (in um)", xOrigin);
        this.addGlobalMeta("Y origin (in um)", yOrigin);
        this.addGlobalMeta("Z origin (in um)", zOrigin);
        for (i = 0; i < title.length; ++i) {
            this.addGlobalMeta("Title " + (i + 1), title[i]);
        }
        for (i = 0; i < minWave.length; ++i) {
            this.addGlobalMeta("Wavelength " + (i + 1) + " min. intensity", minWave[i]);
            this.addGlobalMeta("Wavelength " + (i + 1) + " max. intensity", maxWave[i]);
        }
        this.addGlobalMeta("Wavelength 1 mean intensity", meanIntensity);
        this.addGlobalMeta("Space group number", spaceGroupNumber);
        this.addGlobalMeta("Number of Sub-resolution sets", numSubResSets);
        this.addGlobalMeta("Z axis reduction quotient", zAxisReductionQuotient);
        this.status("Populating OME metadata");
        MetadataTools.populatePixels(store, this, true);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        if (store instanceof IMinMaxStore) {
            IMinMaxStore minMaxStore = (IMinMaxStore)((Object)store);
            for (int i5 = 0; i5 < minWave.length; ++i5) {
                minMaxStore.setChannelGlobalMinMax(0, minWave[i5], maxWave[i5], i5);
            }
        }
        store.setDimensionsPhysicalSizeX(new Double(pixX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Double(pixY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Double(pixZ), 0, 0);
        store.setImageDescription(imageDesc, 0);
        this.status("Reading extended header");
        this.setOffsetInfo(sequence, sizeZ, sizeC, sizeT);
        this.extHdrFields = new DVExtHdrFields[sizeZ][sizeC][sizeT];
        this.ndFilters = new Double[sizeC];
        boolean bl = logFound = this.isGroupFiles() ? this.parseLogFile(store) : false;
        if (this.isGroupFiles()) {
            this.parseDeconvolutionLog(store);
        }
        int offset = 1024 + this.numIntsPerSection * 4;
        for (int i6 = 0; i6 < imageCount; ++i6) {
            DVExtHdrFields hdr;
            int[] coords = this.getZCTCoords(i6);
            int z = coords[0];
            int w = coords[1];
            int t = coords[2];
            this.in.seek(offset + this.getTotalOffset(z, w, t));
            this.extHdrFields[z][w][t] = hdr = new DVExtHdrFields(this.in);
            String prefix = "Extended header Z" + z + " W" + w + " T" + t;
            this.addGlobalMeta(prefix, hdr);
            if (!logFound) {
                store.setPlaneTimingDeltaT(new Double(hdr.timeStampSeconds), 0, 0, i6);
            }
            store.setPlaneTimingExposureTime(new Double(hdr.expTime), 0, 0, i6);
            if (logFound) continue;
            store.setStagePositionPositionX(new Double(hdr.stageXCoord), 0, 0, i6);
            store.setStagePositionPositionY(new Double(hdr.stageYCoord), 0, 0, i6);
            store.setStagePositionPositionZ(new Double(hdr.stageZCoord), 0, 0, i6);
        }
        for (int w = 0; w < sizeC; ++w) {
            DVExtHdrFields hdrC = this.extHdrFields[0][w][0];
            store.setLogicalChannelEmWave(new Integer(waves[w]), 0, w);
            if ((int)hdrC.exWavelen > 0) {
                store.setLogicalChannelExWave(new Integer((int)hdrC.exWavelen), 0, w);
            }
            if (this.ndFilters[w] == null) {
                this.ndFilters[w] = new Double(hdrC.ndFilter);
            }
            store.setLogicalChannelNdFilter(this.ndFilters[w], 0, w);
        }
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
            }
        }
    }

    private int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    private boolean parseLogFile(MetadataStore store) throws IOException {
        if (this.getCurrentFile().endsWith("_D3D.dv")) {
            this.logFile = this.getCurrentFile();
            this.logFile = this.logFile.substring(0, this.logFile.indexOf("_D3D.dv")) + ".dv.log";
        } else {
            this.logFile = this.getCurrentFile() + ".log";
        }
        if (!new Location(this.logFile).exists()) {
            this.logFile = null;
            return false;
        }
        this.status("Parsing log file");
        String[] lines = DataTools.readFile(this.logFile).split("[\r\n]");
        String value = "";
        String prefix = "";
        int currentImage = 0;
        for (String line : lines) {
            String date;
            int colon = line.indexOf(":");
            if (colon != -1) {
                String key;
                if (line.startsWith("Created")) {
                    key = "Created";
                    colon = 6;
                } else {
                    key = line.substring(0, colon).trim();
                }
                value = line.substring(colon + 1).trim();
                if (value.equals("") && !key.equals("")) {
                    prefix = key;
                }
                this.addGlobalMeta(prefix + " " + key, value);
                if (key.equals("Objective")) {
                    int space = value.indexOf(" ");
                    if (space == -1) continue;
                    String manufacturer = value.substring(0, space);
                    String extra = value.substring(space + 1);
                    String[] tokens = extra.split(",");
                    store.setObjectiveManufacturer(manufacturer, 0, 0);
                    String magnification = "";
                    String na = "";
                    if (tokens.length >= 1) {
                        int start;
                        int end = tokens[0].indexOf("X");
                        if (end > 0) {
                            magnification = tokens[0].substring(0, end);
                        }
                        if ((start = tokens[0].indexOf("/")) >= 0) {
                            na = tokens[0].substring(start + 1);
                        }
                    }
                    try {
                        store.setObjectiveNominalMagnification(new Integer(magnification), 0, 0);
                    }
                    catch (NumberFormatException e) {
                        this.warn("Could not parse magnification '" + magnification + "'");
                    }
                    try {
                        store.setObjectiveLensNA(new Double(na), 0, 0);
                    }
                    catch (NumberFormatException e) {
                        this.warn("Could not parse N.A. '" + na + "'");
                    }
                    if (tokens.length >= 2) {
                        store.setObjectiveCorrection(tokens[1], 0, 0);
                    }
                    if (tokens.length <= 3) continue;
                    store.setObjectiveModel(tokens[3], 0, 0);
                    continue;
                }
                if (key.equals("Lens ID")) {
                    if (value.indexOf(",") != -1) {
                        value = value.substring(0, value.indexOf(","));
                    }
                    String objectiveID = "Objective:" + value;
                    store.setObjectiveID(objectiveID, 0, 0);
                    store.setObjectiveSettingsObjective(objectiveID, 0);
                    store.setObjectiveCorrection("Unknown", 0, 0);
                    store.setObjectiveImmersion("Unknown", 0, 0);
                    continue;
                }
                if (key.equals("Pixel Size")) {
                    String[] pixelSizes = value.split(" ");
                    for (int q = 0; q < pixelSizes.length; ++q) {
                        Double size = null;
                        try {
                            size = new Double(pixelSizes[q].trim());
                        }
                        catch (NumberFormatException e) {
                            this.warn("Could not parse pixel size '" + pixelSizes[q].trim() + "'");
                        }
                        if (q == 0) {
                            store.setDimensionsPhysicalSizeX(size, 0, 0);
                        }
                        if (q == 1) {
                            store.setDimensionsPhysicalSizeY(size, 0, 0);
                        }
                        if (q != 2) continue;
                        store.setDimensionsPhysicalSizeZ(size, 0, 0);
                    }
                    continue;
                }
                if (key.equals("Binning")) {
                    store.setDetectorType("Unknown", 0, 0);
                    String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                    store.setDetectorID(detectorID, 0, 0);
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        store.setDetectorSettingsBinning(value, 0, c);
                        store.setDetectorSettingsDetector(detectorID, 0, c);
                    }
                    continue;
                }
                if (key.equals("Type")) {
                    store.setDetectorModel(value, 0, 0);
                    continue;
                }
                if (key.equals("Gain")) {
                    value = value.replaceAll("X", "");
                    try {
                        for (int c = 0; c < this.getSizeC(); ++c) {
                            store.setDetectorSettingsGain(new Double(value), 0, c);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.warn("Could not parse gain '" + value + "'");
                        continue;
                    }
                }
                if (key.equals("Speed")) {
                    value = value.replaceAll("KHz", "");
                    try {
                        double mhz = Double.parseDouble(value) / 1000.0;
                        for (int c = 0; c < this.getSizeC(); ++c) {
                            store.setDetectorSettingsReadOutRate(new Double(mhz), 0, c);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.warn("Could not parse read-out rate '" + value + "'");
                        continue;
                    }
                }
                if (key.equals("Temp Setting")) {
                    value = value.replaceAll("C", "").trim();
                    continue;
                }
                if (key.equals("Time Point")) {
                    int space = value.indexOf(" ");
                    if (space >= 0) {
                        value = value.substring(0, space);
                    }
                    try {
                        if (currentImage >= this.getImageCount()) continue;
                        store.setPlaneTimingDeltaT(new Double(value), 0, 0, currentImage);
                    }
                    catch (NumberFormatException e) {
                        this.warn("Could not parse timestamp '" + value + "'");
                    }
                    continue;
                }
                if (key.equals("EM filter")) {
                    int cIndex = 0;
                    try {
                        cIndex = this.getZCTCoords(currentImage)[1];
                    }
                    catch (IllegalArgumentException e) {
                        this.traceDebug(e);
                    }
                    store.setLogicalChannelName(value, 0, cIndex);
                    continue;
                }
                if (key.equals("ND filter")) {
                    value = value.replaceAll("%", "");
                    try {
                        int cIndex = this.getZCTCoords(currentImage)[1];
                        double nd = Double.parseDouble(value);
                        this.ndFilters[cIndex] = new Double(Math.pow(10.0, -1.0 * nd));
                    }
                    catch (NumberFormatException exc) {
                        this.warn("Could not parse ND filter '" + value + "'");
                    }
                    catch (IllegalArgumentException e) {
                        this.traceDebug(e);
                    }
                    continue;
                }
                if (!key.equals("Stage coordinates")) continue;
                if (value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                String[] coords = value.split(",");
                for (int i = 0; i < coords.length; ++i) {
                    Double p = null;
                    try {
                        p = new Double(coords[i].trim());
                    }
                    catch (NumberFormatException e) {
                        this.warn("Could not parse stage coordinate '" + coords[i] + "'");
                    }
                    if (currentImage >= this.getImageCount()) continue;
                    if (i == 0) {
                        store.setStagePositionPositionX(p, 0, 0, currentImage);
                    }
                    if (i == 1) {
                        store.setStagePositionPositionY(p, 0, 0, currentImage);
                    }
                    if (i != 2) continue;
                    store.setStagePositionPositionZ(p, 0, 0, currentImage);
                }
                ++currentImage;
                continue;
            }
            if (line.startsWith("Image")) {
                prefix = line;
                continue;
            }
            if (!line.startsWith("Created")) continue;
            if (line.length() > 8) {
                line = line.substring(8).trim();
            }
            if ((date = DateTools.formatDate(line, DATE_FORMAT)) != null) {
                store.setImageCreationDate(date, 0);
                continue;
            }
            this.warn("Could not parse date '" + line + "'");
        }
        return true;
    }

    private void parseDeconvolutionLog(MetadataStore store) throws IOException {
        int dot = this.getCurrentFile().lastIndexOf(".");
        String base = this.getCurrentFile().substring(0, dot);
        if (!new Location(base + "_log.txt").exists()) {
            return;
        }
        this.status("Parsing deconvolution log file");
        this.deconvolutionLogFile = base + "_log.txt";
        RandomAccessInputStream s = new RandomAccessInputStream(this.deconvolutionLogFile);
        boolean doStatistics = false;
        int cc = 0;
        int tt = 0;
        String previousLine = null;
        while (s.getFilePointer() < s.length() - 1L) {
            int index;
            String line = s.readLine();
            if (line == null || line.length() == 0) continue;
            if (doStatistics) {
                String[] keys = line.split("  ");
                Vector<String> realKeys = new Vector<String>();
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = keys[i].trim();
                    if (keys[i].length() <= 0) continue;
                    realKeys.add(keys[i]);
                }
                keys = realKeys.toArray(new String[0]);
                s.readLine();
                line = s.readLine().trim();
                while (line != null && line.length() != 0) {
                    String[] values = line.split(" ");
                    Vector<String> realValues = new Vector<String>();
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].trim();
                        if (values[i].length() <= 0) continue;
                        realValues.add(values[i]);
                    }
                    values = realValues.toArray(new String[0]);
                    try {
                        if (values.length > 0) {
                            int zz = Integer.parseInt(values[0]) - 1;
                            int index2 = this.getIndex(zz, cc, tt);
                            for (int i = 1; i < keys.length; ++i) {
                                this.addGlobalMeta("Plane " + index2 + " " + keys[i], values[i]);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        this.warn("Could not parse Z position '" + values[0] + "'");
                    }
                    catch (IllegalArgumentException iae) {
                        this.traceDebug(iae);
                    }
                    line = s.readLine().trim();
                }
            } else {
                int index3 = line.indexOf(".\t");
                if (index3 != -1) {
                    String key = line.substring(0, index3).trim();
                    String value = line.substring(index3 + 2).trim();
                    while (key.endsWith(".")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if (previousLine != null && (previousLine.endsWith("Deconvolution Results:") || previousLine.endsWith("open OTF"))) {
                        this.addGlobalMeta(previousLine + " " + key, value);
                    } else {
                        this.addGlobalMeta(key, value);
                    }
                }
            }
            if (line.indexOf("correcting time point\t") != -1 && (index = line.indexOf("time point\t") + 11) > 10) {
                String t = line.substring(index, line.indexOf(",", index));
                try {
                    tt = Integer.parseInt(t) - 1;
                }
                catch (NumberFormatException e) {
                    this.warn("Could not parse timepoint '" + t + "'");
                }
                index = line.indexOf("wavelength\t") + 11;
                if (index > 10) {
                    String c = line.substring(index, line.indexOf(".", index));
                    try {
                        cc = Integer.parseInt(c) - 1;
                    }
                    catch (NumberFormatException e) {
                        this.warn("Could not parse channel position '" + c + "'");
                    }
                }
            }
            if (line.length() > 0 && line.indexOf(".") == -1) {
                previousLine = line;
            }
            doStatistics = line.endsWith("- reading image data...");
        }
        s.close();
    }

    private void readWavelength(int channel, MetadataStore store) throws FormatException, IOException {
        float min = this.in.readFloat();
        float max = this.in.readFloat();
        this.addGlobalMeta("Wavelength " + (channel + 1) + " min. intensity", min);
        this.addGlobalMeta("Wavelength " + (channel + 1) + " max. intensity", max);
        if (store instanceof IMinMaxStore) {
            ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(0, min, max, channel);
        }
    }

    private class DVExtHdrFields {
        private int offsetWithInts;
        private float oDFilter;
        public float photosensorReading;
        public float timeStampSeconds;
        public float stageXCoord;
        public float stageYCoord;
        public float stageZCoord;
        public float minInten;
        public float maxInten;
        public float expTime;
        public float ndFilter;
        public float exWavelen;
        public float emWavelen;
        public float intenScaling;
        public float energyConvFactor;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("photosensorReading: ");
            sb.append(this.photosensorReading);
            sb.append("\ntimeStampSeconds: ");
            sb.append(this.timeStampSeconds);
            sb.append("\nstageXCoord: ");
            sb.append(this.stageXCoord);
            sb.append("\nstageYCoord: ");
            sb.append(this.stageYCoord);
            sb.append("\nstageZCoord: ");
            sb.append(this.stageZCoord);
            sb.append("\nminInten: ");
            sb.append(this.minInten);
            sb.append("\nmaxInten: ");
            sb.append(this.maxInten);
            sb.append("\nexpTime: ");
            sb.append(this.expTime);
            sb.append("\nndFilter: ");
            sb.append(this.ndFilter);
            sb.append("\nexWavelen: ");
            sb.append(this.exWavelen);
            sb.append("\nemWavelen: ");
            sb.append(this.emWavelen);
            sb.append("\nintenScaling: ");
            sb.append(this.intenScaling);
            sb.append("\nenergyConvFactor: ");
            sb.append(this.energyConvFactor);
            return sb.toString();
        }

        private DVExtHdrFields(RandomAccessInputStream in) {
            try {
                this.photosensorReading = in.readFloat();
                this.timeStampSeconds = in.readFloat();
                this.stageXCoord = in.readFloat();
                this.stageYCoord = in.readFloat();
                this.stageZCoord = in.readFloat();
                this.minInten = in.readFloat();
                this.maxInten = in.readFloat();
                in.skipBytes(4);
                this.expTime = in.readFloat();
                this.ndFilter = in.readFloat();
                this.exWavelen = in.readFloat();
                this.emWavelen = in.readFloat();
                this.intenScaling = in.readFloat();
                this.energyConvFactor = in.readFloat();
            }
            catch (IOException e) {
                DeltavisionReader.this.traceDebug(e);
            }
        }
    }
}

