/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class LiFlimReader
extends FormatReader {
    public static final String VERSION_KEY = "FLIMIMAGE: INFO - version";
    public static final String COMPRESSION_KEY = "FLIMIMAGE: INFO - compression";
    public static final String DATATYPE_KEY = "FLIMIMAGE: LAYOUT - datatype";
    public static final String C_KEY = "FLIMIMAGE: LAYOUT - channels";
    public static final String X_KEY = "FLIMIMAGE: LAYOUT - x";
    public static final String Y_KEY = "FLIMIMAGE: LAYOUT - y";
    public static final String Z_KEY = "FLIMIMAGE: LAYOUT - z";
    public static final String P_KEY = "FLIMIMAGE: LAYOUT - phases";
    public static final String F_KEY = "FLIMIMAGE: LAYOUT - frequencies";
    public static final String T_KEY = "FLIMIMAGE: LAYOUT - timestamps";
    public static final String TIMESTAMP_KEY = "FLIMIMAGE: TIMESTAMPS - t";
    public static final String BG_DATATYPE_KEY = "FLIMIMAGE: BACKGROUND - datatype";
    public static final String BG_C_KEY = "FLIMIMAGE: BACKGROUND - channels";
    public static final String BG_X_KEY = "FLIMIMAGE: BACKGROUND - x";
    public static final String BG_Y_KEY = "FLIMIMAGE: BACKGROUND - y";
    public static final String BG_Z_KEY = "FLIMIMAGE: BACKGROUND - z";
    public static final String BG_P_KEY = "FLIMIMAGE: BACKGROUND - phases";
    public static final String BG_F_KEY = "FLIMIMAGE: BACKGROUND - frequencies";
    public static final String BG_T_KEY = "FLIMIMAGE: BACKGROUND - timestamps";
    public static final String[] KNOWN_VERSIONS = new String[]{"1.0"};
    public static final String COMPRESSION_NONE = "0";
    public static final String COMPRESSION_GZIP = "1";
    public static final String DATATYPE_UINT8 = "UINT8";
    public static final String DATATYPE_INT8 = "INT8";
    public static final String DATATYPE_UINT16 = "UINT16";
    public static final String DATATYPE_INT16 = "INT16";
    public static final String DATATYPE_UINT32 = "UINT32";
    public static final String DATATYPE_INT32 = "INT32";
    public static final String DATATYPE_REAL32 = "REAL32";
    public static final String DATATYPE_REAL64 = "REAL64";
    private long dataOffset;
    private IniList ini;
    private String version;
    private String compression;
    private String datatype;
    private String channels;
    private String xLen;
    private String yLen;
    private String zLen;
    private String phases;
    private String frequencies;
    private String timestamps;
    private String backgroundDatatype;
    private String backgroundX;
    private String backgroundY;
    private String backgroundC;
    private String backgroundZ;
    private String backgroundT;
    private String backgroundP;
    private String backgroundF;
    private int numRegions = 0;
    private Hashtable<Integer, ROI> rois;
    private Hashtable<Integer, String> stampValues;
    private Double exposureTime;
    private boolean gzip;
    private DataInputStream gz;
    private int gzPos;
    private int gzSeries;

    public LiFlimReader() {
        super("LI-FLIM", "fli");
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bytesPerPlane = FormatTools.getPlaneSize(this);
        if (this.gzip) {
            this.prepareGZipStream(no);
            byte[] bytes = new byte[bytesPerPlane];
            this.gz.readFully(bytes);
            RandomAccessInputStream s = new RandomAccessInputStream(bytes);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
        } else {
            this.in.seek(this.dataOffset + (long)(bytesPerPlane * no));
            if (this.getSeries() == 1) {
                this.setSeries(0);
                int imageCount = this.getImageCount();
                int planeSize = FormatTools.getPlaneSize(this);
                this.setSeries(1);
                this.in.skipBytes(imageCount * planeSize);
            }
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.dataOffset = 0L;
            this.ini = null;
            this.gzip = false;
            if (this.gz != null) {
                this.gz.close();
            }
            this.gz = null;
            this.gzPos = 0;
            this.gzSeries = 0;
            this.version = null;
            this.compression = null;
            this.datatype = null;
            this.channels = null;
            this.xLen = null;
            this.yLen = null;
            this.zLen = null;
            this.phases = null;
            this.frequencies = null;
            this.timestamps = null;
            this.backgroundDatatype = null;
            this.backgroundX = null;
            this.backgroundY = null;
            this.backgroundC = null;
            this.backgroundZ = null;
            this.backgroundT = null;
            this.backgroundP = null;
            this.backgroundF = null;
            this.numRegions = 0;
            this.rois = null;
            this.stampValues = null;
            this.exposureTime = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("LiFlimReader.initFile(" + id + ")");
        super.initFile(id);
        this.status("Parsing header");
        this.in = new RandomAccessInputStream(id);
        this.parseHeader();
        this.status("Parsing metadata");
        this.initOriginalMetadata();
        this.initCoreMetadata();
        this.initOMEMetadata();
    }

    private void parseHeader() throws IOException {
        String headerData = this.in.findString("{END}");
        this.dataOffset = this.in.getFilePointer();
        IniParser parser = new IniParser();
        this.ini = parser.parseINI(new BufferedReader(new StringReader(headerData)));
    }

    private void initOriginalMetadata() {
        this.rois = new Hashtable();
        this.stampValues = new Hashtable();
        for (IniTable table : this.ini) {
            String name = (String)table.get("header");
            for (String key : table.keySet()) {
                if (key.equals("header")) continue;
                String value = (String)table.get(key);
                String metaKey = name + " - " + key;
                this.addGlobalMeta(metaKey, value);
                if (metaKey.equals(VERSION_KEY)) {
                    this.version = value;
                    continue;
                }
                if (metaKey.equals(COMPRESSION_KEY)) {
                    this.compression = value;
                    continue;
                }
                if (metaKey.equals(DATATYPE_KEY)) {
                    this.datatype = value;
                    continue;
                }
                if (metaKey.equals(C_KEY)) {
                    this.channels = value;
                    continue;
                }
                if (metaKey.equals(X_KEY)) {
                    this.xLen = value;
                    continue;
                }
                if (metaKey.equals(Y_KEY)) {
                    this.yLen = value;
                    continue;
                }
                if (metaKey.equals(Z_KEY)) {
                    this.zLen = value;
                    continue;
                }
                if (metaKey.equals(P_KEY)) {
                    this.phases = value;
                    continue;
                }
                if (metaKey.equals(F_KEY)) {
                    this.frequencies = value;
                    continue;
                }
                if (metaKey.equals(T_KEY)) {
                    this.timestamps = value;
                    continue;
                }
                if (metaKey.equals(BG_DATATYPE_KEY)) {
                    this.backgroundDatatype = value;
                    continue;
                }
                if (metaKey.equals(BG_C_KEY)) {
                    this.backgroundC = value;
                    continue;
                }
                if (metaKey.equals(BG_X_KEY)) {
                    this.backgroundX = value;
                    continue;
                }
                if (metaKey.equals(BG_Y_KEY)) {
                    this.backgroundY = value;
                    continue;
                }
                if (metaKey.equals(BG_Z_KEY)) {
                    this.backgroundZ = value;
                    continue;
                }
                if (metaKey.equals(BG_T_KEY)) {
                    this.backgroundT = value;
                    continue;
                }
                if (metaKey.equals(BG_P_KEY)) {
                    this.backgroundP = value;
                    continue;
                }
                if (metaKey.equals(BG_F_KEY)) {
                    this.backgroundF = value;
                    continue;
                }
                if (metaKey.startsWith(TIMESTAMP_KEY)) {
                    int index = Integer.parseInt(metaKey.replaceAll(TIMESTAMP_KEY, ""));
                    this.stampValues.put(new Integer(index), value);
                    continue;
                }
                if (metaKey.equals("ROI: INFO - numregions")) {
                    this.numRegions = Integer.parseInt(value);
                    continue;
                }
                if (metaKey.startsWith("ROI: ROI")) {
                    int end;
                    int start = metaKey.lastIndexOf("ROI") + 3;
                    Integer index = new Integer(metaKey.substring(start, end = metaKey.indexOf(" ", start)));
                    ROI roi = this.rois.get(index);
                    if (roi == null) {
                        roi = new ROI();
                    }
                    if (metaKey.endsWith("name")) {
                        roi.name = value;
                    } else if (metaKey.indexOf(" - p") >= 0) {
                        String p = metaKey.substring(metaKey.indexOf(" - p") + 4);
                        Integer pointIndex = new Integer(p);
                        roi.points.put(pointIndex, value.replaceAll(" ", ","));
                    }
                    this.rois.put(index, roi);
                    continue;
                }
                if (!metaKey.endsWith("ExposureTime")) continue;
                String exp = value;
                double expTime = Double.parseDouble(exp.substring(0, exp.indexOf(" ")));
                String units = exp.substring(exp.indexOf(" ") + 1).toLowerCase();
                if (units.equals("ms")) {
                    expTime /= 1000.0;
                }
                this.exposureTime = new Double(expTime);
            }
        }
    }

    private void initCoreMetadata() throws FormatException {
        int f;
        int p;
        if (DataTools.indexOf(KNOWN_VERSIONS, this.version) < 0) {
            LogTools.warnDebug("Warning: unknown LI-FLIM version: " + this.version);
        }
        if (COMPRESSION_NONE.equals(this.compression)) {
            this.gzip = false;
        } else if (COMPRESSION_GZIP.equals(this.compression)) {
            this.gzip = true;
        } else {
            throw new FormatException("Unknown compression type: " + this.compression);
        }
        int sizeP = Integer.parseInt(this.phases);
        if (sizeP > 1) {
            throw new FormatException("Sorry, multiple phases not supported");
        }
        int sizeF = Integer.parseInt(this.frequencies);
        if (sizeF > 1) {
            throw new FormatException("Sorry, multiple frequencies not supported");
        }
        int n = p = this.backgroundP == null ? 1 : Integer.parseInt(this.backgroundP);
        if (p > 1) {
            throw new FormatException("Sorry, multiple phases not supported");
        }
        int n2 = f = this.backgroundF == null ? 1 : Integer.parseInt(this.backgroundF);
        if (f > 1) {
            throw new FormatException("Sorry, multiple frequencies not supported");
        }
        if (this.backgroundDatatype != null) {
            this.core = new CoreMetadata[2];
            this.core[0] = new CoreMetadata();
            this.core[1] = new CoreMetadata();
        }
        this.core[0].sizeX = Integer.parseInt(this.xLen);
        this.core[0].sizeY = Integer.parseInt(this.yLen);
        this.core[0].sizeZ = Integer.parseInt(this.zLen);
        this.core[0].sizeC = Integer.parseInt(this.channels);
        this.core[0].sizeT = Integer.parseInt(this.timestamps);
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * sizeP * sizeF;
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = this.getPixelType(this.datatype);
        this.core[0].littleEndian = true;
        this.core[0].interleaved = true;
        this.core[0].falseColor = false;
        if (this.core.length > 1) {
            this.core[1].sizeX = Integer.parseInt(this.backgroundX);
            this.core[1].sizeY = Integer.parseInt(this.backgroundY);
            this.core[1].sizeZ = Integer.parseInt(this.backgroundZ);
            this.core[1].sizeC = Integer.parseInt(this.backgroundC);
            this.core[1].sizeT = Integer.parseInt(this.backgroundT);
            this.core[1].imageCount = this.core[1].sizeZ * this.core[1].sizeT * p * f;
            this.core[1].rgb = this.core[1].sizeC > 1;
            this.core[1].indexed = false;
            this.core[1].dimensionOrder = "XYCZT";
            this.core[1].pixelType = this.getPixelType(this.backgroundDatatype);
            this.core[1].littleEndian = true;
            this.core[1].interleaved = true;
            this.core[1].falseColor = false;
        }
    }

    private void initOMEMetadata() {
        int times = this.timestamps == null ? 0 : Integer.parseInt(this.timestamps);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, times > 0);
        store.setImageName(this.getCurrentFile() + " Primary Image", 0);
        if (this.getSeriesCount() > 1) {
            store.setImageName(this.getCurrentFile() + " Background Image", 1);
        }
        long firstStamp = 0L;
        for (int t = 0; t < times && this.stampValues.get(t) != null; ++t) {
            Double deltaT;
            String[] stampWords = this.stampValues.get(t).split(" ");
            long stampHi = Long.parseLong(stampWords[0]);
            long stampLo = Long.parseLong(stampWords[1]);
            long stamp = DateTools.getMillisFromTicks(stampHi, stampLo);
            if (t == 0) {
                String date = DateTools.convertDate(stamp, 1);
                store.setImageCreationDate(date, 0);
                firstStamp = stamp;
                deltaT = new Double(0.0);
            } else {
                long ms = stamp - firstStamp;
                deltaT = new Double((double)ms / 1000.0);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    int index = this.getIndex(z, c, t);
                    store.setPlaneTimingDeltaT(deltaT, 0, 0, index);
                    store.setPlaneTimingExposureTime(this.exposureTime, 0, 0, index);
                }
            }
        }
        if (firstStamp == 0L) {
            MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        }
        StringBuilder points = new StringBuilder();
        Object[] roiIndices = this.rois.keySet().toArray(new Integer[this.rois.size()]);
        Arrays.sort(roiIndices);
        for (int roi = 0; roi < roiIndices.length; ++roi) {
            points.setLength(0);
            ROI r = this.rois.get(roiIndices[roi]);
            Object[] pointIndices = r.points.keySet().toArray(new Integer[0]);
            Arrays.sort(pointIndices);
            for (Object point : pointIndices) {
                if (point == null) continue;
                String p = r.points.get(point);
                if (points.length() > 0) {
                    points.append(" ");
                }
                points.append(p);
            }
            store.setPolygonPoints(points.toString(), 0, roi, 0);
        }
    }

    private int getPixelType(String type) throws FormatException {
        if (DATATYPE_UINT8.equals(type)) {
            return 1;
        }
        if (DATATYPE_INT8.equals(type)) {
            return 0;
        }
        if (DATATYPE_UINT16.equals(type)) {
            return 3;
        }
        if (DATATYPE_INT16.equals(type)) {
            return 2;
        }
        if (DATATYPE_UINT32.equals(type)) {
            return 5;
        }
        if (DATATYPE_INT32.equals(type)) {
            return 4;
        }
        if (DATATYPE_REAL32.equals(type)) {
            return 6;
        }
        if (DATATYPE_REAL64.equals(type)) {
            return 7;
        }
        throw new FormatException("Unknown data type: " + type);
    }

    private void prepareGZipStream(int no) throws IOException {
        int bytesPerPlane = FormatTools.getPlaneSize(this);
        if (this.gz == null || no < this.gzPos && this.getSeries() == this.gzSeries || this.gzSeries > this.getSeries()) {
            if (this.gz != null) {
                this.gz.close();
            }
            String path = Location.getMappedId(this.currentId);
            FileInputStream fis = new FileInputStream(path);
            this.skip(fis, this.dataOffset);
            this.gz = new DataInputStream(new GZIPInputStream(fis));
            this.gzPos = 0;
            this.gzSeries = 0;
        }
        if (this.getSeries() == 1 && this.gzSeries == 0) {
            this.setSeries(0);
            int nPlanes = this.getImageCount() - this.gzPos;
            int nBytes = FormatTools.getPlaneSize(this) * nPlanes;
            this.setSeries(1);
            this.skip(this.gz, nBytes);
            this.gzSeries = 1;
            this.gzPos = 0;
        }
        this.skip(this.gz, bytesPerPlane * (no - this.gzPos));
        this.gzPos = no + 1;
    }

    private void skip(InputStream is, long num) throws IOException {
        long skip;
        for (long skipLeft = num; skipLeft > 0L; skipLeft -= skip) {
            skip = is.skip(skipLeft);
            if (skip > 0L) continue;
            throw new IOException("Cannot skip bytes");
        }
    }

    private class ROI {
        public String name;
        public Hashtable<Integer, String> points = new Hashtable();

        private ROI() {
        }
    }
}

