/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class MRCReader
extends FormatReader {
    private static final String[] TYPES = new String[]{"mono", "tilt", "tilts", "lina", "lins"};
    private int bpp = 0;
    private int extHeaderSize = 0;
    private boolean isFloat = false;

    public MRCReader() {
        super("Medical Research Council", "mrc");
        this.domains = new String[]{"Medical Imaging", "Light Microscopy"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(1024 + this.extHeaderSize + no * FormatTools.getPlaneSize(this));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.extHeaderSize = 0;
            this.bpp = 0;
            this.isFloat = false;
        }
    }

    public void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("MRCReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Reading header");
        this.in.seek(212L);
        this.core[0].littleEndian = this.in.read() == 68;
        this.in.seek(0L);
        this.in.order(this.core[0].littleEndian);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.core[0].sizeZ = this.in.readInt();
        this.core[0].sizeC = 1;
        int mode = this.in.readInt();
        switch (mode) {
            case 0: {
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                this.core[0].pixelType = 2;
                break;
            }
            case 6: {
                this.core[0].pixelType = 3;
                break;
            }
            case 2: {
                this.isFloat = true;
                this.core[0].pixelType = 6;
                break;
            }
            case 3: {
                this.core[0].pixelType = 5;
                break;
            }
            case 4: {
                this.isFloat = true;
                this.core[0].pixelType = 7;
                break;
            }
            case 16: {
                this.core[0].sizeC = 3;
                this.core[0].pixelType = 3;
            }
        }
        this.bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        this.in.skipBytes(12);
        int mx = this.in.readInt();
        int my = this.in.readInt();
        int mz = this.in.readInt();
        float xlen = this.in.readFloat();
        float ylen = this.in.readFloat();
        float zlen = this.in.readFloat();
        this.addGlobalMeta("Pixel size (X)", xlen / (float)mx);
        this.addGlobalMeta("Pixel size (Y)", ylen / (float)my);
        this.addGlobalMeta("Pixel size (Z)", zlen / (float)mz);
        this.addGlobalMeta("Alpha angle", this.in.readFloat());
        this.addGlobalMeta("Beta angle", this.in.readFloat());
        this.addGlobalMeta("Gamma angle", this.in.readFloat());
        this.in.skipBytes(12);
        this.addGlobalMeta("Minimum pixel value", this.in.readFloat());
        this.addGlobalMeta("Maximum pixel value", this.in.readFloat());
        this.addGlobalMeta("Mean pixel value", this.in.readFloat());
        this.in.skipBytes(4);
        this.extHeaderSize = this.in.readInt();
        this.in.skipBytes(64);
        short idtype = this.in.readShort();
        String type = idtype >= 0 && idtype < TYPES.length ? TYPES[idtype] : "unknown";
        this.addGlobalMeta("Series type", type);
        this.addGlobalMeta("Lens", this.in.readShort());
        this.addGlobalMeta("ND1", this.in.readShort());
        this.addGlobalMeta("ND2", this.in.readShort());
        this.addGlobalMeta("VD1", this.in.readShort());
        this.addGlobalMeta("VD2", this.in.readShort());
        for (i = 0; i < 6; ++i) {
            this.addGlobalMeta("Angle " + (i + 1), this.in.readFloat());
        }
        this.in.skipBytes(24);
        this.addGlobalMeta("Number of useful labels", this.in.readInt());
        for (i = 0; i < 10; ++i) {
            this.addGlobalMeta("Label " + (i + 1), this.in.readString(80));
        }
        this.in.skipBytes(this.extHeaderSize);
        this.status("Populating metadata");
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYZTC";
        this.core[0].imageCount = this.getSizeZ();
        this.core[0].rgb = false;
        this.core[0].interleaved = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        double x = (double)(xlen / (float)mx) == Double.POSITIVE_INFINITY ? 1.0 : (double)(xlen / (float)mx);
        double y = (double)(ylen / (float)my) == Double.POSITIVE_INFINITY ? 1.0 : (double)(ylen / (float)my);
        double z = (double)(zlen / (float)mz) == Double.POSITIVE_INFINITY ? 1.0 : (double)(zlen / (float)mz);
        store.setDimensionsPhysicalSizeX(new Double(x), 0, 0);
        store.setDimensionsPhysicalSizeY(new Double(y), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Double(z), 0, 0);
    }
}

