/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import java.io.IOException;
import loci.common.Location;
import loci.plugins.prefs.OptionsList;
import loci.plugins.prefs.StringOption;
import loci.plugins.util.LibraryChecker;

public class ImporterOptions
extends OptionsList {
    public static final String KEY_AUTOSCALE = "autoscale";
    public static final String KEY_COLORIZE = "colorize";
    public static final String KEY_CONCATENATE = "concatenate";
    public static final String KEY_CROP = "crop";
    public static final String KEY_CUSTOM_COLORIZE = "customColorize";
    public static final String KEY_FIRST = "firstTime";
    public static final String KEY_FORCE_THUMBS = "forceThumbnails";
    public static final String KEY_GROUP_FILES = "groupFiles";
    public static final String KEY_UNGROUP_FILES = "ungroupFiles";
    public static final String KEY_ID = "id";
    public static final String KEY_LOCATION = "location";
    public static final String KEY_MERGE_CHANNELS = "mergeChannels";
    public static final String KEY_MERGE_OPTION = "mergeOption";
    public static final String KEY_OPEN_ALL_SERIES = "openAllSeries";
    public static final String KEY_QUIET = "quiet";
    public static final String KEY_RECORD = "record";
    public static final String KEY_SERIES = "series";
    public static final String KEY_SHOW_METADATA = "showMetadata";
    public static final String KEY_SHOW_OME_XML = "showOMEXML";
    public static final String KEY_SHOW_ROIS = "showROIs";
    public static final String KEY_SPECIFY_RANGES = "specifyRanges";
    public static final String KEY_SPLIT_Z = "splitFocalPlanes";
    public static final String KEY_SPLIT_T = "splitTimepoints";
    public static final String KEY_SPLIT_C = "splitWindows";
    public static final String KEY_STACK_FORMAT = "stackFormat";
    public static final String KEY_STACK_ORDER = "stackOrder";
    public static final String KEY_SWAP_DIMS = "swapDimensions";
    public static final String KEY_UPGRADE_CHECK = "upgradeCheck";
    public static final String KEY_VIRTUAL = "virtual";
    public static final String KEY_WINDOWLESS = "windowless";
    public static final String LOCATION_LOCAL = "Local machine";
    public static final String LOCATION_HTTP = "Internet";
    public static final String LOCATION_OME = "OME server";
    public static final String LOCATION_OMERO = "OMERO server";
    public static final String VIEW_NONE = "Metadata only";
    public static final String VIEW_STANDARD = "Standard ImageJ";
    public static final String VIEW_HYPERSTACK = "Hyperstack";
    public static final String VIEW_BROWSER = "Data Browser";
    public static final String VIEW_VISBIO = "VisBio";
    public static final String VIEW_IMAGE_5D = "Image5D";
    public static final String VIEW_VIEW_5D = "View5D";
    private static final String CLASS_VISBIO = "loci.visbio.VisBio";
    private static final String CLASS_IMAGE_5D = "i5d.Image5D";
    private static final String CLASS_VIEW_5D = "view5d.View5D_";
    public static final String ORDER_DEFAULT = "Default";
    public static final String ORDER_XYZCT = "XYZCT";
    public static final String ORDER_XYZTC = "XYZTC";
    public static final String ORDER_XYCZT = "XYCZT";
    public static final String ORDER_XYTCZ = "XYTCZ";
    public static final String ORDER_XYCTZ = "XYCTZ";
    public static final String ORDER_XYTZC = "XYTZC";

    public ImporterOptions() throws IOException {
        super("importer-options.txt", ImporterOptions.class);
        StringOption stackFormat = this.getStringOption(KEY_STACK_FORMAT);
        if (!LibraryChecker.checkClass(CLASS_VISBIO)) {
            stackFormat.removePossible(VIEW_VISBIO);
        }
        if (!LibraryChecker.checkClass(CLASS_IMAGE_5D)) {
            stackFormat.removePossible(VIEW_IMAGE_5D);
        }
        if (!LibraryChecker.checkClass(CLASS_VIEW_5D)) {
            stackFormat.removePossible(VIEW_VIEW_5D);
        }
    }

    public void parseArg(String arg) {
        if (arg == null || arg.length() == 0) {
            return;
        }
        if (new Location(arg).exists()) {
            this.setLocation(LOCATION_LOCAL);
            this.setId(arg);
            this.setQuiet(true);
        } else {
            this.parseOptions(arg);
        }
    }

    public String getAutoscaleInfo() {
        return this.getInfo(KEY_AUTOSCALE);
    }

    public boolean isAutoscale() {
        return this.isSet(KEY_AUTOSCALE);
    }

    public void setAutoscale(boolean b) {
        this.setValue(KEY_AUTOSCALE, b);
    }

    public String getColorizeInfo() {
        return this.getInfo(KEY_COLORIZE);
    }

    public boolean isColorize() {
        return this.isSet(KEY_COLORIZE);
    }

    public void setColorize(boolean b) {
        this.setValue(KEY_COLORIZE, b);
    }

    public String getConcatenateInfo() {
        return this.getInfo(KEY_CONCATENATE);
    }

    public boolean isConcatenate() {
        return this.isSet(KEY_CONCATENATE);
    }

    public void setConcatenate(boolean b) {
        this.setValue(KEY_CONCATENATE, b);
    }

    public String getCropInfo() {
        return this.getInfo(KEY_CROP);
    }

    public boolean doCrop() {
        return this.isSet(KEY_CROP);
    }

    public void setCrop(boolean b) {
        this.setValue(KEY_CROP, b);
    }

    public String getCustomColorizeInfo() {
        return this.getInfo(KEY_CUSTOM_COLORIZE);
    }

    public boolean isCustomColorize() {
        return this.isSet(KEY_CUSTOM_COLORIZE);
    }

    public void setCustomColorize(boolean b) {
        this.setValue(KEY_CUSTOM_COLORIZE, b);
    }

    public String getFirstTimeInfo() {
        return this.getInfo(KEY_FIRST);
    }

    public boolean isFirstTime() {
        return this.isSet(KEY_FIRST);
    }

    public void setFirstTime(boolean b) {
        this.setValue(KEY_FIRST, b);
    }

    public String getForceThumbnailsInfo() {
        return this.getInfo(KEY_FORCE_THUMBS);
    }

    public boolean isForceThumbnails() {
        return this.isSet(KEY_FORCE_THUMBS);
    }

    public void setForceThumbnails(boolean b) {
        this.setValue(KEY_FORCE_THUMBS, b);
    }

    public String getGroupFilesInfo() {
        return this.getInfo(KEY_GROUP_FILES);
    }

    public boolean isGroupFiles() {
        return this.isSet(KEY_GROUP_FILES);
    }

    public void setGroupFiles(boolean b) {
        this.setValue(KEY_GROUP_FILES, b);
    }

    public String getUngroupFilesInfo() {
        return this.getInfo(KEY_UNGROUP_FILES);
    }

    public boolean isUngroupFiles() {
        return this.isSet(KEY_UNGROUP_FILES);
    }

    public void setUngroupFiles(boolean b) {
        this.setValue(KEY_UNGROUP_FILES, b);
    }

    public String getIdInfo() {
        return this.getInfo(KEY_ID);
    }

    public String getId() {
        return this.getValue(KEY_ID);
    }

    public void setId(String s) {
        this.setValue(KEY_ID, s);
    }

    public String getLocationInfo() {
        return this.getInfo(KEY_LOCATION);
    }

    public String getLocation() {
        return this.getValue(KEY_LOCATION);
    }

    public String[] getLocations() {
        return this.getPossible(KEY_LOCATION);
    }

    public boolean isLocal() {
        return LOCATION_LOCAL.equals(this.getLocation());
    }

    public boolean isHTTP() {
        return LOCATION_HTTP.equals(this.getLocation());
    }

    public boolean isOME() {
        return LOCATION_OME.equals(this.getLocation());
    }

    public boolean isOMERO() {
        return LOCATION_OMERO.equals(this.getLocation());
    }

    public void setLocation(String s) {
        this.setValue(KEY_LOCATION, s);
    }

    public String getMergeChannelsInfo() {
        return this.getInfo(KEY_MERGE_CHANNELS);
    }

    public boolean isMergeChannels() {
        return this.isSet(KEY_MERGE_CHANNELS);
    }

    public void setMergeChannels(boolean b) {
        this.setValue(KEY_MERGE_CHANNELS, b);
    }

    public String getMergeOptionInfo() {
        return this.getInfo(KEY_MERGE_OPTION);
    }

    public String getMergeOption() {
        return this.getValue(KEY_MERGE_OPTION);
    }

    public void setMergeOption(String s) {
        this.setValue(KEY_MERGE_OPTION, s);
    }

    public String getOpenAllSeriesInfo() {
        return this.getInfo(KEY_OPEN_ALL_SERIES);
    }

    public boolean openAllSeries() {
        return this.isSet(KEY_OPEN_ALL_SERIES);
    }

    public void setOpenAllSeries(boolean b) {
        this.setValue(KEY_OPEN_ALL_SERIES, b);
    }

    public String getQuietInfo() {
        return this.getInfo(KEY_QUIET);
    }

    public boolean isQuiet() {
        return this.isSet(KEY_QUIET);
    }

    public void setQuiet(boolean b) {
        this.setValue(KEY_QUIET, b);
    }

    public String getRecordInfo() {
        return this.getInfo(KEY_RECORD);
    }

    public boolean isRecord() {
        return this.isSet(KEY_RECORD);
    }

    public void setRecord(boolean b) {
        this.setValue(KEY_RECORD, b);
    }

    public String getSeriesInfo() {
        return this.getInfo(KEY_SERIES);
    }

    public String getSeries() {
        return this.getValue(KEY_SERIES);
    }

    public void setSeries(String s) {
        this.setValue(KEY_SERIES, s);
    }

    public String getShowMetadataInfo() {
        return this.getInfo(KEY_SHOW_METADATA);
    }

    public boolean isShowMetadata() {
        return this.isSet(KEY_SHOW_METADATA);
    }

    public void setShowMetadata(boolean b) {
        this.setValue(KEY_SHOW_METADATA, b);
    }

    public String getShowOMEXMLInfo() {
        return this.getInfo(KEY_SHOW_OME_XML);
    }

    public boolean isShowOMEXML() {
        return this.isSet(KEY_SHOW_OME_XML);
    }

    public void setShowOMEXML(boolean b) {
        this.setValue(KEY_SHOW_OME_XML, b);
    }

    public String getShowROIsInfo() {
        return this.getInfo(KEY_SHOW_ROIS);
    }

    public boolean showROIs() {
        return this.isSet(KEY_SHOW_ROIS);
    }

    public void setShowROIs(boolean b) {
        this.setValue(KEY_SHOW_ROIS, b);
    }

    public String getSpecifyRangesInfo() {
        return this.getInfo(KEY_SPECIFY_RANGES);
    }

    public boolean isSpecifyRanges() {
        return this.isSet(KEY_SPECIFY_RANGES);
    }

    public void setSpecifyRanges(boolean b) {
        this.setValue(KEY_SPECIFY_RANGES, b);
    }

    public String getSplitFocalPlanesInfo() {
        return this.getInfo(KEY_SPLIT_Z);
    }

    public boolean isSplitFocalPlanes() {
        return this.isSet(KEY_SPLIT_Z);
    }

    public void setSplitFocalPlanes(boolean b) {
        this.setValue(KEY_SPLIT_Z, b);
    }

    public String getSplitTimepointsInfo() {
        return this.getInfo(KEY_SPLIT_T);
    }

    public boolean isSplitTimepoints() {
        return this.isSet(KEY_SPLIT_T);
    }

    public void setSplitTimepoints(boolean b) {
        this.setValue(KEY_SPLIT_T, b);
    }

    public String getSplitChannelsInfo() {
        return this.getInfo(KEY_SPLIT_C);
    }

    public boolean isSplitChannels() {
        return this.isSet(KEY_SPLIT_C);
    }

    public void setSplitChannels(boolean b) {
        this.setValue(KEY_SPLIT_C, b);
    }

    public String getStackFormatInfo() {
        return this.getInfo(KEY_STACK_FORMAT);
    }

    public String getStackFormat() {
        return this.getValue(KEY_STACK_FORMAT);
    }

    public String[] getStackFormats() {
        return this.getPossible(KEY_STACK_FORMAT);
    }

    public boolean isViewNone() {
        return VIEW_NONE.equals(this.getStackFormat());
    }

    public boolean isViewStandard() {
        return VIEW_STANDARD.equals(this.getStackFormat());
    }

    public boolean isViewHyperstack() {
        return VIEW_HYPERSTACK.equals(this.getStackFormat());
    }

    public boolean isViewBrowser() {
        return VIEW_BROWSER.equals(this.getStackFormat());
    }

    public boolean isViewVisBio() {
        return VIEW_VISBIO.equals(this.getStackFormat());
    }

    public boolean isViewImage5D() {
        return VIEW_IMAGE_5D.equals(this.getStackFormat());
    }

    public boolean isViewView5D() {
        return VIEW_VIEW_5D.equals(this.getStackFormat());
    }

    public void setStackFormat(String s) {
        this.setValue(KEY_STACK_FORMAT, s);
    }

    public String getStackOrderInfo() {
        return this.getInfo(KEY_STACK_ORDER);
    }

    public String getStackOrder() {
        return this.getValue(KEY_STACK_ORDER);
    }

    public String[] getStackOrders() {
        return this.getPossible(KEY_STACK_ORDER);
    }

    public void setStackOrder(String s) {
        this.setValue(KEY_STACK_ORDER, s);
    }

    public String getSwapDimensionsInfo() {
        return this.getInfo(KEY_SWAP_DIMS);
    }

    public boolean isSwapDimensions() {
        return this.isSet(KEY_SWAP_DIMS);
    }

    public void setSwapDimensions(boolean b) {
        this.setValue(KEY_SWAP_DIMS, b);
    }

    public String getUpgradeCheckInfo() {
        return this.getInfo(KEY_UPGRADE_CHECK);
    }

    public boolean doUpgradeCheck() {
        return this.isSet(KEY_UPGRADE_CHECK);
    }

    public void setUpgradeCheck(boolean b) {
        this.setValue(KEY_UPGRADE_CHECK, b);
    }

    public String getVirtualInfo() {
        return this.getInfo(KEY_VIRTUAL);
    }

    public boolean isVirtual() {
        return this.isSet(KEY_VIRTUAL);
    }

    public void setVirtual(boolean b) {
        this.setValue(KEY_VIRTUAL, b);
    }

    public String getWindowlessInfo() {
        return this.getInfo(KEY_WINDOWLESS);
    }

    public boolean isWindowless() {
        return this.isSet(KEY_WINDOWLESS);
    }

    public void setWindowless(boolean b) {
        this.setValue(KEY_WINDOWLESS, b);
    }
}

