/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1BitMapSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1BinaryDataSection {
    private static final float UNDEFINED = -9999.0f;
    private int length;
    private int bitBuf = 0;
    private int bitPos = 0;
    private float[] values;
    private boolean isConstant = false;

    public Grib1BinaryDataSection(RandomAccessFile raf, int decimalscale) throws IOException, NotSupportedException {
        this(raf, decimalscale, null);
    }

    public Grib1BinaryDataSection(RandomAccessFile raf, int decimalscale, Grib1BitMapSection bms) throws IOException, NotSupportedException {
        this.length = GribNumbers.uint3(raf);
        int unusedbits = raf.read();
        if ((unusedbits & 0xC0) != 0) {
            throw new NotSupportedException("BDS: (octet 4, 1st half) not grid point data and simple packing ");
        }
        unusedbits &= 0xF;
        int binscale = GribNumbers.int2(raf);
        float refvalue = GribNumbers.float4(raf);
        int numbits = raf.read();
        if (numbits == 0) {
            this.isConstant = true;
        }
        float ref = (float)(Math.pow(10.0, -decimalscale) * (double)refvalue);
        float scale = (float)(Math.pow(10.0, -decimalscale) * Math.pow(2.0, binscale));
        if (bms != null) {
            boolean[] bitmap = bms.getBitmap();
            this.values = new float[bitmap.length];
            for (int i = 0; i < bitmap.length; ++i) {
                if (bitmap[i]) {
                    if (!this.isConstant) {
                        this.values[i] = ref + scale * (float)this.bits2UInt(numbits, raf);
                        continue;
                    }
                    this.values[i] = ref;
                    continue;
                }
                this.values[i] = -9999.0f;
            }
        } else if (!this.isConstant) {
            this.values = new float[((this.length - 11) * 8 - unusedbits) / numbits];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ref + scale * (float)this.bits2UInt(numbits, raf);
            }
        } else {
            short x = 0;
            short y = 0;
            raf.seek(raf.getFilePointer() - 53L);
            this.length = GribNumbers.uint3(raf);
            if (this.length == 42) {
                raf.skipBytes(3);
                x = raf.readShort();
                y = raf.readShort();
            } else {
                raf.skipBytes(7);
                this.length = GribNumbers.uint3(raf);
                if (this.length == 32) {
                    raf.skipBytes(3);
                    x = raf.readShort();
                    y = raf.readShort();
                } else {
                    y = 1;
                    x = 1;
                    System.out.println("BDS constant value, can't determine array size");
                }
            }
            this.values = new float[x * y];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ref;
            }
        }
    }

    private int bits2UInt(int nb, RandomAccessFile raf) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public final float[] getValues() {
        return this.values;
    }
}

