/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.TiffReader;
import loci.formats.meta.IMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

public class OMETiffReader
extends FormatReader {
    protected OMETiffPlane[][] info;
    protected String[] used;
    private int lastPlane;

    public OMETiffReader() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        boolean validHeader = tp.isValidHeader();
        if (!validHeader) {
            return false;
        }
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String comment = ifd.getComment();
        if (comment == null) {
            return false;
        }
        return comment.trim().endsWith("</OME>");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.info[this.series][this.lastPlane] == null || this.info[this.series][this.lastPlane].reader == null || this.info[this.series][this.lastPlane].id == null) {
            return null;
        }
        this.info[this.series][this.lastPlane].reader.setId(this.info[this.series][this.lastPlane].id);
        return this.info[this.series][this.lastPlane].reader.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.info[this.series][this.lastPlane] == null || this.info[this.series][this.lastPlane].reader == null || this.info[this.series][this.lastPlane].id == null) {
            return null;
        }
        this.info[this.series][this.lastPlane].reader.setId(this.info[this.series][this.lastPlane].id);
        return this.info[this.series][this.lastPlane].reader.get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastPlane = no;
        IFormatReader r = this.info[this.series][no].reader;
        r.setId(this.info[this.series][no].id);
        return r.openBytes(this.info[this.series][no].ifd, buf, x, y, w, h);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        return noPixels ? null : this.used;
    }

    public int fileGroupOption(String id) {
        return 0;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.info = null;
            this.used = null;
            this.lastPlane = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("OMETiffReader.initFile(" + id + ")");
        super.initFile(this.normalizeFilename(null, id));
        id = this.currentId;
        String dir = new File(id).getParent();
        String fileName = new Location(id).getAbsoluteFile().getAbsolutePath();
        RandomAccessInputStream ras = new RandomAccessInputStream(fileName);
        TiffParser tp = new TiffParser(ras);
        IFD firstIFD = tp.getFirstIFD();
        ras.close();
        String xml = firstIFD.getComment();
        IMetadata meta = MetadataTools.createOMEXMLMetadata(xml);
        Hashtable<String, String> originalMetadata = MetadataTools.getOriginalMetadata(meta);
        if (originalMetadata != null) {
            this.metadata = originalMetadata;
        }
        this.debug(xml, 3);
        if (meta == null) {
            throw new FormatException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://loci.wisc.edu/ome/formats-library.html");
        }
        if (meta.getRoot() == null) {
            throw new FormatException("Could not parse OME-XML from TIFF comment");
        }
        String currentUUID = meta.getUUID();
        MetadataTools.convertMetadata(meta, this.metadataStore);
        int seriesCount = 0;
        int imageCount = meta.getImageCount();
        for (i = 0; i < imageCount; ++i) {
            seriesCount += meta.getPixelsCount(i);
        }
        this.core = new CoreMetadata[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            this.core[i] = new CoreMetadata();
        }
        this.info = new OMETiffPlane[seriesCount][];
        Hashtable<String, String> files = new Hashtable<String, String>();
        boolean needSearch = false;
        for (int i2 = 0; i2 < imageCount; ++i2) {
            int pixelsCount = meta.getPixelsCount(i2);
            for (int p = 0; p < pixelsCount; ++p) {
                int tiffDataCount = meta.getTiffDataCount(i2, p);
                for (int td = 0; td < tiffDataCount; ++td) {
                    String uuid = meta.getTiffDataUUID(i2, p, td);
                    String filename = null;
                    if (uuid == null) {
                        uuid = "";
                        filename = id;
                    } else {
                        filename = meta.getTiffDataFileName(i2, p, td);
                        if (filename == null) {
                            if (uuid.equals(currentUUID)) {
                                filename = id;
                            } else {
                                filename = "";
                                needSearch = true;
                            }
                        } else {
                            filename = this.normalizeFilename(dir, filename);
                        }
                    }
                    String existing = (String)files.get(uuid);
                    if (existing == null) {
                        files.put(uuid, filename);
                        continue;
                    }
                    if (existing.equals(filename)) continue;
                    throw new FormatException("Inconsistent UUID filenames");
                }
            }
        }
        if (needSearch) {
            Enumeration en = files.keys();
            while (en.hasMoreElements()) {
                String uuid = (String)en.nextElement();
                String filename = (String)files.get(uuid);
                if (!filename.equals("")) continue;
                throw new FormatException("Unmatched UUID: " + uuid);
            }
        }
        Enumeration en = files.keys();
        int numUUIDs = files.size();
        HashSet<String> fileSet = new HashSet<String>();
        for (int i3 = 0; i3 < numUUIDs; ++i3) {
            String uuid = (String)en.nextElement();
            String filename = (String)files.get(uuid);
            fileSet.add(filename);
        }
        this.used = new String[fileSet.size()];
        Iterator iter = fileSet.iterator();
        for (int i4 = 0; i4 < this.used.length; ++i4) {
            this.used[i4] = (String)iter.next();
        }
        Hashtable<String, IFormatReader> readers = new Hashtable<String, IFormatReader>();
        int s = 0;
        for (int i5 = 0; i5 < imageCount; ++i5) {
            this.debug("Image[" + i5 + "] {");
            this.debug("  id = " + meta.getImageID(i5));
            int pixelsCount = meta.getPixelsCount(i5);
            int p = 0;
            while (p < pixelsCount) {
                int effSizeC;
                this.debug("  Pixels[" + p + "] {");
                this.debug("    id = " + meta.getPixelsID(i5, p));
                String order = meta.getPixelsDimensionOrder(i5, p);
                Integer samplesPerPixel = meta.getLogicalChannelSamplesPerPixel(i5, 0);
                int samples = samplesPerPixel == null ? -1 : samplesPerPixel;
                int tiffSamples = firstIFD.getSamplesPerPixel();
                if (samples != tiffSamples) {
                    this.warn("SamplesPerPixel mismatch: OME=" + samples + ", TIFF=" + tiffSamples);
                    samples = tiffSamples;
                }
                if ((effSizeC = meta.getPixelsSizeC(i5, p) / samples) == 0) {
                    effSizeC = 1;
                }
                if (effSizeC * samples != meta.getPixelsSizeC(i5, p)) {
                    effSizeC = meta.getPixelsSizeC(i5, p);
                }
                int sizeT = meta.getPixelsSizeT(i5, p);
                int sizeZ = meta.getPixelsSizeZ(i5, p);
                int num = effSizeC * sizeT * sizeZ;
                OMETiffPlane[] planes = new OMETiffPlane[num];
                for (int no = 0; no < num; ++no) {
                    planes[no] = new OMETiffPlane();
                }
                int tiffDataCount = meta.getTiffDataCount(i5, p);
                for (int td = 0; td < tiffDataCount; ++td) {
                    int no;
                    Location file;
                    int count;
                    int z;
                    this.debug("    TiffData[" + td + "] {");
                    String filename = meta.getTiffDataFileName(i5, p, td);
                    String uuid = meta.getTiffDataUUID(i5, p, td);
                    Integer tdIFD = meta.getTiffDataIFD(i5, p, td);
                    int ifd = tdIFD == null ? 0 : tdIFD;
                    Integer numPlanes = meta.getTiffDataNumPlanes(i5, p, td);
                    Integer firstC = meta.getTiffDataFirstC(i5, p, td);
                    Integer firstT = meta.getTiffDataFirstT(i5, p, td);
                    Integer firstZ = meta.getTiffDataFirstZ(i5, p, td);
                    int c = firstC == null ? 0 : firstC;
                    int t = firstT == null ? 0 : firstT;
                    int n = z = firstZ == null ? 0 : firstZ;
                    if (c >= effSizeC) {
                        --c;
                    }
                    if (z >= sizeZ) {
                        --z;
                    }
                    if (t >= sizeT) {
                        --t;
                    }
                    int index = FormatTools.getIndex(order, sizeZ, effSizeC, sizeT, num, z, c, t);
                    int n2 = count = numPlanes == null ? 1 : numPlanes;
                    if (count == 0) {
                        this.core[s] = null;
                        break;
                    }
                    filename = filename == null ? (uuid == null ? id : (String)files.get(uuid)) : this.normalizeFilename(dir, filename);
                    IFormatReader r = (IFormatReader)readers.get(filename);
                    if (r == null) {
                        r = new TiffReader();
                        readers.put(filename, r);
                    }
                    if (!(file = new Location(filename)).exists()) {
                        filename = filename.substring(filename.lastIndexOf(File.separator) + 1);
                        filename = dir + File.separator + filename;
                    }
                    for (int q = 0; q < count; ++q) {
                        int no2 = index + q;
                        planes[no2].reader = r;
                        planes[no2].id = filename;
                        planes[no2].ifd = ifd + q;
                        planes[no2].certain = true;
                        this.debug("      Plane[" + no2 + "]: file=" + planes[no2].id + ", IFD=" + planes[no2].ifd);
                    }
                    if (numPlanes == null) {
                        for (no = index + 1; no < num && !planes[no].certain; ++no) {
                            planes[no].reader = r;
                            planes[no].id = filename;
                            planes[no].ifd = planes[no - 1].ifd + 1;
                            this.debug("      Plane[" + no + "]: FILLED");
                        }
                    } else {
                        for (no = index + count; no < num && !planes[no].certain; ++no) {
                            planes[no].reader = null;
                            planes[no].id = null;
                            planes[no].ifd = -1;
                            this.debug("      Plane[" + no + "]: CLEARED");
                        }
                    }
                    this.debug("    }");
                }
                if (this.core[s] != null) {
                    this.debug("    --------------------------------");
                    for (int no = 0; no < num; ++no) {
                        this.debug("    Plane[" + no + "]: file=" + planes[no].id + ", IFD=" + planes[no].ifd);
                        if (planes[no].reader != null) continue;
                        this.warn("Pixels ID '" + meta.getPixelsID(i5, p) + "': missing plane #" + no + ".  Using TiffReader to determine the number of planes.");
                        TiffReader r = new TiffReader();
                        r.setId(this.currentId);
                        planes = new OMETiffPlane[r.getImageCount()];
                        for (int plane = 0; plane < planes.length; ++plane) {
                            planes[plane] = new OMETiffPlane();
                            planes[plane].id = this.currentId;
                            planes[plane].reader = r;
                            planes[plane].ifd = plane;
                        }
                        num = planes.length;
                    }
                    this.debug("  }");
                    this.info[s] = planes;
                    try {
                        this.core[s].sizeX = meta.getPixelsSizeX(i5, p);
                        int tiffWidth = (int)firstIFD.getImageWidth();
                        if (this.core[s].sizeX != tiffWidth) {
                            this.warn("SizeX mismatch: OME=" + this.core[s].sizeX + ", TIFF=" + tiffWidth);
                        }
                        this.core[s].sizeY = meta.getPixelsSizeY(i5, p);
                        int tiffHeight = (int)firstIFD.getImageLength();
                        if (this.core[s].sizeY != tiffHeight) {
                            this.warn("SizeY mismatch: OME=" + this.core[s].sizeY + ", TIFF=" + tiffHeight);
                        }
                        this.core[s].sizeZ = meta.getPixelsSizeZ(i5, p);
                        this.core[s].sizeC = meta.getPixelsSizeC(i5, p);
                        this.core[s].sizeT = meta.getPixelsSizeT(i5, p);
                        this.core[s].pixelType = FormatTools.pixelTypeFromString(meta.getPixelsPixelType(i5, p));
                        int tiffPixelType = firstIFD.getPixelType();
                        if (this.core[s].pixelType != tiffPixelType) {
                            this.warn("PixelType mismatch: OME=" + this.core[s].pixelType + ", TIFF=" + tiffPixelType);
                            this.core[s].pixelType = tiffPixelType;
                        }
                        this.core[s].imageCount = num;
                        this.core[s].dimensionOrder = meta.getPixelsDimensionOrder(i5, p);
                        this.core[s].orderCertain = true;
                        int photo = firstIFD.getPhotometricInterpretation();
                        boolean bl = this.core[s].rgb = samples > 1 || photo == 2;
                        if (samples != this.core[s].sizeC && samples % this.core[s].sizeC != 0 && this.core[s].sizeC % samples != 0) {
                            this.core[s].sizeC *= samples;
                        }
                        if (this.core[s].sizeZ * this.core[s].sizeT * this.core[s].sizeC > this.core[s].imageCount && !this.core[s].rgb) {
                            if (this.core[s].sizeZ == this.core[s].imageCount) {
                                this.core[s].sizeT = 1;
                                this.core[s].sizeC = 1;
                            } else if (this.core[s].sizeT == this.core[s].imageCount) {
                                this.core[s].sizeZ = 1;
                                this.core[s].sizeC = 1;
                            } else if (this.core[s].sizeC == this.core[s].imageCount) {
                                this.core[s].sizeT = 1;
                                this.core[s].sizeZ = 1;
                            }
                        }
                        this.core[s].littleEndian = meta.getPixelsBigEndian(i5, p) == false;
                        boolean tiffLittleEndian = firstIFD.isLittleEndian();
                        if (this.core[s].littleEndian != tiffLittleEndian) {
                            this.warn("BigEndian mismatch: OME=" + !this.core[s].littleEndian + ", TIFF=" + !tiffLittleEndian);
                        }
                        this.core[s].interleaved = false;
                        boolean bl2 = this.core[s].indexed = photo == 3 && firstIFD.getIFDValue(320) != null;
                        if (this.core[s].indexed) {
                            this.core[s].rgb = false;
                        }
                        this.core[s].falseColor = false;
                        this.core[s].metadataComplete = true;
                    }
                    catch (NullPointerException exc) {
                        throw new FormatException("Incomplete Pixels metadata", exc);
                    }
                }
                ++p;
                ++s;
            }
            this.debug("}");
        }
        Vector<CoreMetadata> series = new Vector<CoreMetadata>();
        Vector<OMETiffPlane[]> planeInfo = new Vector<OMETiffPlane[]>();
        for (int i6 = 0; i6 < this.core.length; ++i6) {
            if (this.core[i6] == null) continue;
            series.add(this.core[i6]);
            planeInfo.add(this.info[i6]);
        }
        this.core = series.toArray(new CoreMetadata[series.size()]);
        this.info = (OMETiffPlane[][])planeInfo.toArray((T[])new OMETiffPlane[0][0]);
    }

    private IFormatReader getReader(int no) throws FormatException, IOException {
        FormatTools.checkPlaneNumber(this, no);
        IFormatReader r = this.info[this.series][no].reader;
        r.setId(this.info[this.series][no].id);
        return r;
    }

    private String normalizeFilename(String dir, String name) {
        File file = new File(dir, name);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return new Location(name).getAbsolutePath();
    }

    private class OMETiffPlane {
        public IFormatReader reader;
        public String id;
        public int ifd = -1;
        public boolean certain = false;

        private OMETiffPlane() {
        }
    }
}

