/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.CodecOptions;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffRational;

public class TiffParser {
    protected RandomAccessInputStream in;
    private byte[] cachedTileBuffer;

    public TiffParser(RandomAccessInputStream in) {
        this.in = in;
    }

    public RandomAccessInputStream getStream() {
        return this.in;
    }

    public boolean isValidHeader() {
        try {
            return this.checkHeader() != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Boolean checkHeader() throws IOException {
        boolean bigEndian;
        if (this.in.length() < 4L) {
            return null;
        }
        this.in.seek(0L);
        int endianOne = this.in.read();
        int endianTwo = this.in.read();
        boolean littleEndian = endianOne == 73 && endianTwo == 73;
        boolean bl = bigEndian = endianOne == 77 && endianTwo == 77;
        if (!littleEndian && !bigEndian) {
            return null;
        }
        this.in.order(littleEndian);
        short magic = this.in.readShort();
        if (magic != 42 && magic != 43) {
            return null;
        }
        return new Boolean(littleEndian);
    }

    public IFDList getIFDs() throws IOException {
        IFD ifd;
        Boolean result = this.checkHeader();
        if (result == null) {
            return null;
        }
        this.in.seek(2L);
        boolean bigTiff = this.in.readShort() == 43;
        long offset = this.getFirstOffset(bigTiff);
        long ifdMax = (this.in.length() - 8L) / 18L;
        IFDList ifds = new IFDList();
        for (long ifdNum = 0L; ifdNum < ifdMax && (ifd = this.getIFD(ifdNum, offset, bigTiff)) != null && ifd.size() > 1; ++ifdNum) {
            ifds.add(ifd);
            long l = offset = bigTiff ? this.in.readLong() : (long)this.in.readInt() & 0xFFFFFFFFL;
            if (offset > 0L && offset < this.in.length()) continue;
            if (offset == 0L) break;
            LogTools.debug("getIFDs: invalid IFD offset: " + offset);
            break;
        }
        return ifds;
    }

    public IFD getFirstIFD() throws IOException {
        Boolean result = this.checkHeader();
        if (result == null) {
            return null;
        }
        this.in.seek(2L);
        boolean bigTiff = this.in.readShort() == 43;
        long offset = this.getFirstOffset(bigTiff);
        IFD ifd = this.getIFD(0L, offset, bigTiff);
        if (ifd != null) {
            ifd.put(new Integer(1), new Boolean(bigTiff));
        }
        return ifd;
    }

    public TiffIFDEntry getFirstIFDEntry(int tag) throws IOException {
        Boolean result = this.checkHeader();
        if (result == null) {
            return null;
        }
        this.in.seek(2L);
        boolean bigTiff = this.in.readShort() == 43;
        long offset = this.getFirstOffset(bigTiff);
        this.in.seek(offset);
        long numEntries = bigTiff ? this.in.readLong() : (long)(this.in.readShort() & 0xFFFF);
        int i = 0;
        while ((long)i < numEntries) {
            this.in.seek(offset + 2L + (long)((bigTiff ? 20 : 12) * i));
            int entryTag = this.in.readShort() & 0xFFFF;
            if (entryTag == tag) {
                int valueCount;
                int entryType = this.in.readShort() & 0xFFFF;
                int n = valueCount = bigTiff ? (int)(this.in.readLong() & 0xFFFFFFFFFFFFFFFFL) : this.in.readInt();
                if (valueCount < 0) {
                    throw new RuntimeException("Count of '" + valueCount + "' unexpected.");
                }
                long valueOffset = bigTiff ? this.in.readLong() : (long)this.in.readInt();
                return new TiffIFDEntry(entryTag, entryType, valueCount, valueOffset);
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown tag: " + tag);
    }

    public long getFirstOffset() throws IOException {
        return this.getFirstOffset(false);
    }

    public long getFirstOffset(boolean bigTiff) throws IOException {
        if (bigTiff) {
            this.in.skipBytes(4);
        }
        return bigTiff ? this.in.readLong() : (long)this.in.readInt();
    }

    public IFD getIFD(long ifdNum, long offset) throws IOException {
        return this.getIFD(ifdNum, offset, false);
    }

    public IFD getIFD(long ifdNum, long offset, boolean bigTiff) throws IOException {
        IFD ifd = new IFD();
        ifd.put(new Integer(0), new Boolean(this.in.isLittleEndian()));
        ifd.put(new Integer(1), new Boolean(bigTiff));
        LogTools.debug("getIFDs: seeking IFD #" + ifdNum + " at " + offset);
        this.in.seek(offset);
        long numEntries = bigTiff ? this.in.readLong() : (long)(this.in.readShort() & 0xFFFF);
        LogTools.debug("getIFDs: " + numEntries + " directory entries to read");
        if (numEntries == 0L || numEntries == 1L) {
            return ifd;
        }
        int bytesPerEntry = bigTiff ? 20 : 12;
        int baseOffset = bigTiff ? 8 : 2;
        int threshhold = bigTiff ? 8 : 4;
        int i = 0;
        while ((long)i < numEntries) {
            int j;
            this.in.seek(offset + (long)baseOffset + (long)(bytesPerEntry * i));
            int tag = this.in.readShort() & 0xFFFF;
            int type = this.in.readShort() & 0xFFFF;
            int count = bigTiff ? (int)(this.in.readLong() & 0xFFFFFFFFFFFFFFFFL) : this.in.readInt();
            LogTools.debug("getIFDs: read " + IFD.getIFDTagName(tag) + " (type=" + IFD.getIFDTypeName(type) + "; count=" + count + ")");
            if (count < 0) {
                return null;
            }
            Object value = null;
            int bpe = IFD.getIFDTypeLength(type);
            if (bpe <= 0) {
                return null;
            }
            if (count > threshhold / bpe) {
                long pointer = bigTiff ? this.in.readLong() : (long)this.in.readInt() & 0xFFFFFFFFL;
                LogTools.debug("getIFDs: seeking to offset: " + pointer);
                this.in.seek(pointer);
            }
            long inputLen = this.in.length();
            long inputPointer = this.in.getFilePointer();
            if ((long)(count * bpe) + inputPointer > inputLen) {
                int oldCount = count;
                count = (int)((inputLen - inputPointer) / (long)bpe);
                LogTools.debug("getIFDs: truncated " + (oldCount - count) + " array elements for tag " + tag);
            }
            if (type == 1) {
                if (count == 1) {
                    value = new Short(this.in.readByte());
                } else {
                    byte[] bytes = new byte[count];
                    this.in.readFully(bytes);
                    short[] shorts = new short[count];
                    for (j = 0; j < count; ++j) {
                        shorts[j] = (short)(bytes[j] & 0xFF);
                    }
                    value = shorts;
                }
            } else if (type == 2) {
                byte[] ascii = new byte[count];
                this.in.read(ascii);
                int nullCount = 0;
                for (j = 0; j < count; ++j) {
                    if (ascii[j] != 0 && j != count - 1) continue;
                    ++nullCount;
                }
                String[] strings = nullCount == 1 ? null : new String[nullCount];
                Object s = null;
                int c = 0;
                int ndx = -1;
                for (int j2 = 0; j2 < count; ++j2) {
                    if (ascii[j2] == 0) {
                        s = new String(ascii, ndx + 1, j2 - ndx - 1);
                        ndx = j2;
                    } else {
                        s = j2 == count - 1 ? new String(ascii, ndx + 1, j2 - ndx) : null;
                    }
                    if (strings == null || s == null) continue;
                    strings[c++] = s;
                }
                value = strings == null ? s : strings;
            } else if (type == 3) {
                if (count == 1) {
                    value = new Integer(this.in.readShort() & 0xFFFF);
                } else {
                    int[] shorts = new int[count];
                    for (int j3 = 0; j3 < count; ++j3) {
                        shorts[j3] = this.in.readShort() & 0xFFFF;
                    }
                    value = shorts;
                }
            } else if (type == 4 || type == 13) {
                if (count == 1) {
                    value = new Long(this.in.readInt());
                } else {
                    long[] longs = new long[count];
                    for (int j4 = 0; j4 < count; ++j4) {
                        longs[j4] = this.in.readInt();
                    }
                    value = longs;
                }
            } else if (type == 16 || type == 17 || type == 18) {
                if (count == 1) {
                    value = new Long(this.in.readLong());
                } else {
                    long[] longs = new long[count];
                    for (int j5 = 0; j5 < count; ++j5) {
                        longs[j5] = this.in.readLong();
                    }
                    value = longs;
                }
            } else if (type == 5 || type == 10) {
                if (count == 1) {
                    value = new TiffRational(this.in.readInt(), this.in.readInt());
                } else {
                    TiffRational[] rationals = new TiffRational[count];
                    for (int j6 = 0; j6 < count; ++j6) {
                        rationals[j6] = new TiffRational(this.in.readInt(), this.in.readInt());
                    }
                    value = rationals;
                }
            } else if (type == 6 || type == 7) {
                if (count == 1) {
                    value = new Byte(this.in.readByte());
                } else {
                    byte[] sbytes = new byte[count];
                    this.in.read(sbytes);
                    value = sbytes;
                }
            } else if (type == 8) {
                if (count == 1) {
                    value = new Short(this.in.readShort());
                } else {
                    short[] sshorts = new short[count];
                    for (int j7 = 0; j7 < count; ++j7) {
                        sshorts[j7] = this.in.readShort();
                    }
                    value = sshorts;
                }
            } else if (type == 9) {
                if (count == 1) {
                    value = new Integer(this.in.readInt());
                } else {
                    int[] slongs = new int[count];
                    for (int j8 = 0; j8 < count; ++j8) {
                        slongs[j8] = this.in.readInt();
                    }
                    value = slongs;
                }
            } else if (type == 11) {
                if (count == 1) {
                    value = new Float(this.in.readFloat());
                } else {
                    float[] floats = new float[count];
                    for (int j9 = 0; j9 < count; ++j9) {
                        floats[j9] = this.in.readFloat();
                    }
                    value = floats;
                }
            } else if (type == 12) {
                if (count == 1) {
                    value = new Double(this.in.readDouble());
                } else {
                    double[] doubles = new double[count];
                    for (int j10 = 0; j10 < count; ++j10) {
                        doubles[j10] = this.in.readDouble();
                    }
                    value = doubles;
                }
            }
            if (value != null) {
                ifd.put(new Integer(tag), value);
            }
            ++i;
        }
        this.in.seek(offset + (long)baseOffset + (long)bytesPerEntry * numEntries);
        return ifd;
    }

    public String getComment() throws IOException {
        IFD firstIFD = this.getFirstIFD();
        return firstIFD == null ? null : firstIFD.getComment();
    }

    public byte[] getTile(IFD ifd, int row, int col) throws FormatException, IOException {
        int samplesPerPixel = ifd.getSamplesPerPixel();
        if (ifd.getPlanarConfiguration() == 2) {
            samplesPerPixel = 1;
        }
        int bpp = ifd.getBytesPerSample()[0];
        int width = (int)ifd.getTileWidth();
        int height = (int)ifd.getTileLength();
        byte[] buf = new byte[width * height * samplesPerPixel * bpp];
        return this.getTile(ifd, buf, row, col);
    }

    public byte[] getTile(IFD ifd, byte[] buf, int row, int col) throws FormatException, IOException {
        int size;
        byte[] jpegTable = (byte[])ifd.getIFDValue(347, false, null);
        CodecOptions options = new CodecOptions();
        options.interleaved = true;
        options.littleEndian = ifd.isLittleEndian();
        long tileWidth = ifd.getTileWidth();
        long tileLength = ifd.getTileLength();
        int samplesPerPixel = ifd.getSamplesPerPixel();
        int planarConfig = ifd.getPlanarConfiguration();
        int compression = ifd.getCompression();
        long numTileCols = ifd.getTilesPerRow();
        int pixel = ifd.getBytesPerSample()[0];
        int effectiveChannels = planarConfig == 2 ? 1 : samplesPerPixel;
        long[] stripOffsets = ifd.getStripOffsets();
        long[] stripByteCounts = ifd.getStripByteCounts();
        int tileNumber = (int)((long)row * numTileCols + (long)col);
        byte[] tile = new byte[(int)stripByteCounts[tileNumber]];
        this.in.seek(stripOffsets[tileNumber] & 0xFFFFFFFFL);
        this.in.read(tile);
        options.maxBytes = size = (int)(tileWidth * tileLength * (long)pixel * (long)effectiveChannels);
        if (jpegTable != null) {
            byte[] q = new byte[jpegTable.length + tile.length - 4];
            System.arraycopy(jpegTable, 0, q, 0, jpegTable.length - 2);
            System.arraycopy(tile, 2, q, jpegTable.length - 2, tile.length - 2);
            tile = TiffCompression.uncompress(q, compression, options);
        } else {
            tile = TiffCompression.uncompress(tile, compression, options);
        }
        TiffCompression.undifference(tile, ifd);
        TiffParser.unpackBytes(buf, 0, tile, ifd);
        return buf;
    }

    public byte[][] getSamples(IFD ifd) throws FormatException, IOException {
        return this.getSamples(ifd, 0, 0, (int)ifd.getImageWidth(), (int)ifd.getImageLength());
    }

    public byte[][] getSamples(IFD ifd, int x, int y, int w, int h) throws FormatException, IOException {
        int samplesPerPixel = ifd.getSamplesPerPixel();
        int bpp = ifd.getBytesPerSample()[0];
        long width = ifd.getImageWidth();
        long length = ifd.getImageLength();
        byte[] b = new byte[w * h * samplesPerPixel * bpp];
        this.getSamples(ifd, b, x, y, w, h);
        byte[][] samples = new byte[samplesPerPixel][w * h * bpp];
        for (int i = 0; i < samplesPerPixel; ++i) {
            System.arraycopy(b, i * w * h * bpp, samples[i], 0, samples[i].length);
        }
        b = null;
        return samples;
    }

    public byte[] getSamples(IFD ifd, byte[] buf) throws FormatException, IOException {
        long width = ifd.getImageWidth();
        long length = ifd.getImageLength();
        return this.getSamples(ifd, buf, 0, 0, width, length);
    }

    public byte[] getSamples(IFD ifd, byte[] buf, int x, int y, long width, long height) throws FormatException, IOException {
        LogTools.debug("parsing IFD entries");
        boolean littleEndian = ifd.isLittleEndian();
        this.in.order(littleEndian);
        int samplesPerPixel = ifd.getSamplesPerPixel();
        long tileWidth = ifd.getTileWidth();
        long tileLength = ifd.getTileLength();
        long numTileRows = ifd.getTilesPerColumn();
        long numTileCols = ifd.getTilesPerRow();
        int planarConfig = ifd.getPlanarConfiguration();
        ifd.printIFD();
        if (width * height > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth x ImageLength > 2147483647 is not supported (" + width + " x " + height + ")");
        }
        int numSamples = (int)(width * height);
        LogTools.debug("reading image data (samplesPerPixel=" + samplesPerPixel + "; numSamples=" + numSamples + ")");
        int pixel = ifd.getBytesPerSample()[0];
        int effectiveChannels = planarConfig == 2 ? 1 : samplesPerPixel;
        long nrows = numTileRows;
        if (planarConfig == 2) {
            numTileRows *= (long)samplesPerPixel;
        }
        Region imageBounds = new Region(x, y, (int)width, (int)(height * (long)(samplesPerPixel / effectiveChannels)));
        int endX = (int)width + x;
        int endY = (int)height + y;
        int rowLen = pixel * (int)tileWidth;
        int tileSize = (int)((long)rowLen * tileLength);
        int planeSize = (int)(width * height * (long)pixel);
        int outputRowLen = (int)((long)pixel * width);
        int bufferSizeSamplesPerPixel = samplesPerPixel;
        if (ifd.getPlanarConfiguration() == 2) {
            bufferSizeSamplesPerPixel = 1;
        }
        int bpp = ifd.getBytesPerSample()[0];
        int bufferSize = (int)tileWidth * (int)tileLength * bufferSizeSamplesPerPixel * bpp;
        if (this.cachedTileBuffer == null || this.cachedTileBuffer.length != bufferSize) {
            this.cachedTileBuffer = new byte[bufferSize];
        }
        int row = 0;
        while ((long)row < numTileRows) {
            int col = 0;
            while ((long)col < numTileCols) {
                Region tileBounds = new Region(col * (int)tileWidth, (int)((long)row * tileLength), (int)tileWidth, (int)tileLength);
                if (imageBounds.intersects(tileBounds)) {
                    if (planarConfig == 2) {
                        tileBounds.y = (int)((long)row % nrows * tileLength);
                    }
                    this.getTile(ifd, this.cachedTileBuffer, row, col);
                    int tileX = Math.max(tileBounds.x, x);
                    int tileY = Math.max(tileBounds.y, y);
                    int realX = tileX % (int)tileWidth;
                    int realY = tileY % (int)tileLength;
                    int twidth = (int)Math.min((long)(endX - tileX), tileWidth - (long)realX);
                    int theight = (int)Math.min((long)(endY - tileY), tileLength - (long)realY);
                    int copy = pixel * twidth;
                    realX *= pixel;
                    realY *= rowLen;
                    for (int q = 0; q < effectiveChannels; ++q) {
                        int src = q * tileSize + realX + realY;
                        int dest = q * planeSize + pixel * (tileX - x) + outputRowLen * (tileY - y);
                        if (planarConfig == 2) {
                            dest = (int)((long)dest + (long)planeSize * ((long)row / nrows));
                        }
                        for (int tileRow = 0; tileRow < theight; ++tileRow) {
                            System.arraycopy(this.cachedTileBuffer, src, buf, dest, copy);
                            src += rowLen;
                            dest += outputRowLen;
                        }
                    }
                }
                ++col;
            }
            ++row;
        }
        return buf;
    }

    public static void planarUnpack(byte[] samples, int startIndex, byte[] bytes, IFD ifd) throws FormatException {
        int numBytes;
        BitBuffer bb = new BitBuffer(bytes);
        int realBytes = numBytes = ifd.getBytesPerSample()[0];
        if (numBytes == 3) {
            ++numBytes;
        }
        int bitsPerSample = ifd.getBitsPerSample()[0];
        boolean littleEndian = ifd.isLittleEndian();
        int photoInterp = ifd.getPhotometricInterpretation();
        for (int j = 0; j < bytes.length / realBytes; ++j) {
            int value = bb.getBits(bitsPerSample);
            if (littleEndian) {
                value = DataTools.swap(value) >> 32 - bitsPerSample;
            }
            if (photoInterp == 0) {
                value = (int)(Math.pow(2.0, bitsPerSample) - 1.0 - (double)value);
            } else if (photoInterp == 5) {
                value = Integer.MAX_VALUE - value;
            }
            if (numBytes * (startIndex + j) >= samples.length) continue;
            DataTools.unpackBytes(value, samples, numBytes * (startIndex + j), numBytes, littleEndian);
        }
    }

    public static void unpackBytes(byte[] samples, int startIndex, byte[] bytes, IFD ifd) throws FormatException {
        if (ifd.getPlanarConfiguration() == 2) {
            TiffParser.planarUnpack(samples, startIndex, bytes, ifd);
            return;
        }
        int compression = ifd.getCompression();
        int photoInterp = ifd.getPhotometricInterpretation();
        if (compression == 7) {
            photoInterp = 2;
        }
        int[] bitsPerSample = ifd.getBitsPerSample();
        int nChannels = bitsPerSample.length;
        int nSamples = samples.length / nChannels;
        int totalBits = 0;
        for (int i = 0; i < nChannels; ++i) {
            totalBits += bitsPerSample[i];
        }
        int sampleCount = 8 * bytes.length / totalBits;
        if (photoInterp == 6) {
            sampleCount *= 3;
        }
        LogTools.debug("unpacking " + sampleCount + " samples (startIndex=" + startIndex + "; totalBits=" + totalBits + "; numBytes=" + bytes.length + ")");
        long imageWidth = ifd.getImageWidth();
        int bps0 = bitsPerSample[0];
        int numBytes = ifd.getBytesPerSample()[0];
        boolean noDiv8 = bps0 % 8 != 0;
        boolean bps8 = bps0 == 8;
        boolean bps16 = bps0 == 16;
        int row = startIndex / (int)imageWidth;
        boolean col = false;
        boolean cw = false;
        boolean ch = false;
        boolean littleEndian = ifd.isLittleEndian();
        int[] reference = ifd.getIFDIntArray(532, false);
        int[] subsampling = ifd.getIFDIntArray(530, false);
        TiffRational[] coefficients = (TiffRational[])ifd.getIFDValue(529);
        boolean count = false;
        BitBuffer bb = new BitBuffer(bytes);
        if ((bps8 || bps16) && bytes.length <= samples.length && nChannels == 1 && photoInterp != 0 && photoInterp != 5 && photoInterp != 6) {
            System.arraycopy(bytes, 0, samples, 0, bytes.length);
            return;
        }
        block1: for (int j = 0; j < sampleCount; ++j) {
            for (int i = 0; i < nChannels; ++i) {
                int index = numBytes * (j * nChannels + i);
                int ndx = startIndex + j;
                if (ndx >= nSamples) continue block1;
                int outputIndex = i * nSamples + ndx * numBytes;
                if (noDiv8) {
                    short s = 0;
                    if (i == 0 && photoInterp == 3 || photoInterp != 32803 && photoInterp != 3) {
                        s = (short)(bb.getBits(bps0) & 0xFFFF);
                        if ((long)ndx % imageWidth == imageWidth - 1L && bps0 < 8) {
                            bb.skipBits(imageWidth * (long)bps0 * (long)sampleCount % 8L);
                        }
                    }
                    if (photoInterp == 0 || photoInterp == 5) {
                        s = (short)(Math.pow(2.0, bitsPerSample[0]) - 1.0 - (double)s);
                    }
                    if (outputIndex + numBytes > samples.length) continue;
                    DataTools.unpackBytes(s, samples, outputIndex, numBytes, littleEndian);
                    continue;
                }
                if (bps8) {
                    if (outputIndex >= samples.length) continue block1;
                    if (photoInterp != 6) {
                        samples[outputIndex] = (byte)(bytes[index] & 0xFF);
                    }
                    if (photoInterp == 0) {
                        samples[outputIndex] = (byte)(255 - samples[outputIndex]);
                        continue;
                    }
                    if (photoInterp == 5) {
                        samples[outputIndex] = (byte)(Integer.MAX_VALUE - samples[outputIndex]);
                        continue;
                    }
                    if (photoInterp != 6 || i != bitsPerSample.length - 1) continue;
                    float lumaRed = 0.299f;
                    float lumaGreen = 0.587f;
                    float lumaBlue = 0.114f;
                    if (coefficients != null) {
                        lumaRed = coefficients[0].floatValue();
                        lumaGreen = coefficients[1].floatValue();
                        lumaBlue = coefficients[2].floatValue();
                    }
                    int subX = subsampling == null ? 2 : subsampling[0];
                    int subY = subsampling == null ? 2 : subsampling[1];
                    int block = subX * subY;
                    int lumaIndex = j + 2 * (j / block);
                    int chromaIndex = j / block * (block + 2) + block;
                    if (chromaIndex + 1 >= bytes.length) continue block1;
                    int tile = ndx / block;
                    int nTiles = (int)(imageWidth / (long)subX);
                    int pixel = ndx % block;
                    long r = subY * (tile / nTiles) + pixel / subX;
                    long c = subX * (tile % nTiles) + pixel % subX;
                    int idx = (int)(r * imageWidth + c);
                    if (idx >= nSamples) continue;
                    int y = (bytes[lumaIndex] & 0xFF) - reference[0];
                    int cb = (bytes[chromaIndex] & 0xFF) - reference[2];
                    int cr = (bytes[chromaIndex + 1] & 0xFF) - reference[4];
                    int red = (int)((float)cr * (2.0f - 2.0f * lumaRed) + (float)y);
                    int blue = (int)((float)cb * (2.0f - 2.0f * lumaBlue) + (float)y);
                    int green = (int)(((float)y - lumaBlue * (float)blue - lumaRed * (float)red) / lumaGreen);
                    samples[idx] = (byte)red;
                    samples[nSamples + idx] = (byte)green;
                    samples[2 * nSamples + idx] = (byte)blue;
                    continue;
                }
                int offset = numBytes + index < bytes.length ? index : bytes.length - numBytes;
                long v = DataTools.bytesToLong(bytes, offset, numBytes, littleEndian);
                if (photoInterp == 0) {
                    long max = (long)Math.pow(2.0, numBytes * 8) - 1L;
                    v = max - v;
                } else if (photoInterp == 5) {
                    v = Integer.MAX_VALUE - v;
                }
                if (ndx * numBytes >= nSamples) continue block1;
                DataTools.unpackBytes(v, samples, i * nSamples + ndx * numBytes, numBytes, littleEndian);
            }
        }
    }
}

