/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CloseListener
extends WindowAdapter {
    private String message;
    private String title;
    private Action closeAction;
    private boolean disposeOnClose = false;

    public CloseListener(String message, String title) {
        this(message, title, null);
    }

    public CloseListener(Action closeAction) {
        this(null, null, closeAction);
    }

    public CloseListener(String message, String title, Action closeAction) {
        this.message = message;
        this.title = title;
        this.closeAction = closeAction;
    }

    public void setDisposeOnClose(boolean disposeOnClose) {
        this.disposeOnClose = disposeOnClose;
    }

    public void windowClosing(WindowEvent e) {
        JFrame frame = (JFrame)e.getComponent();
        if (!this.confirmWindowClosing(frame)) {
            frame.setDefaultCloseOperation(0);
            return;
        }
        if (this.disposeOnClose) {
            frame.setDefaultCloseOperation(2);
        } else {
            frame.setDefaultCloseOperation(3);
        }
        if (this.closeAction != null) {
            ActionEvent ae = new ActionEvent(frame, 1001, "");
            this.closeAction.actionPerformed(ae);
        }
    }

    private boolean confirmWindowClosing(JFrame frame) {
        if (this.message == null) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(frame, this.message, this.title, 0);
        return result == 0;
    }
}

