/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import omeroconnect.Main;
import omerouploader.ProjectDatasetPickerUI;
import omerouploader.SessionDetails;
import omerouploader.TagPanelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditProjectDatasetUI
extends JFrame {
    List<String> tags = new ArrayList<String>();
    private ProjectDatasetPickerUI parent;
    private Main omeroserver;
    private SessionDetails sessiondetails;
    private long objID;
    private int mode;
    private JButton cancelButton;
    private JLabel descriptionLabel;
    private JTextArea descriptionTextArea;
    private JCheckBox inheritProjTagsCheckBox;
    private JScrollPane jScrollPane1;
    private JTextField nameField;
    private JLabel nameLabel;
    private JButton okButton;
    private JButton setTagsButton;

    public EditProjectDatasetUI(ProjectDatasetPickerUI p, Main os_, String objectype, SessionDetails sd) {
        this.initComponents();
        this.parent = p;
        this.omeroserver = os_;
        this.sessiondetails = sd;
        this.mode = -1;
        this.tags.clear();
        if (objectype.equals("Project")) {
            this.setTitle("OMEROUploader - Edit Project");
            this.mode = 0;
            this.inheritProjTagsCheckBox.setVisible(false);
            this.objID = this.parent.getSelectedProjectId();
        } else if (objectype.equals("Dataset")) {
            this.setTitle("OMEROUploader - Edit Dataset");
            this.mode = 1;
            this.objID = this.parent.getSelectedDatasetId();
        }
        System.out.println("objID: " + this.objID);
        if (this.mode == 0) {
            System.out.println("Retrieving Project data...");
        } else if (this.mode == 1) {
            System.out.println("Retrieving Dataset data...");
        }
        boolean ia = this.omeroserver.isAlive();
        if (ia) {
            System.out.println("Connection alive: TRUE");
        } else {
            System.out.println("Connection alive: FALSE");
        }
        int success = -1;
        success = !ia ? -1 : 1;
        if (!ia) {
            try {
                success = this.omeroserver.initConnectionDetails(this.sessiondetails.serveraddress, this.sessiondetails.username, this.sessiondetails.password);
            }
            catch (Exception ex) {
                System.out.println("ERROR: Connection Failed!");
            }
        }
        if (success == 1) {
            String name = "";
            String desc = "";
            if (this.mode == 0) {
                try {
                    name = this.omeroserver.getProject(this.objID).getName().getValue();
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Retrieving Project name failed");
                }
                try {
                    desc = this.omeroserver.getProject(this.objID).getDescription().getValue();
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Retrieving Project description failed");
                }
            } else if (this.mode == 1) {
                try {
                    name = this.omeroserver.getDataset(this.objID).getName().getValue();
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Retrieving Dataset name failed");
                }
                try {
                    desc = this.omeroserver.getDataset(this.objID).getDescription().getValue();
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Retrieving Dataset description failed");
                }
            }
            this.nameField.setText(name);
            this.descriptionTextArea.setText(desc);
        } else if (success == -1) {
            System.out.println("ERROR: Failed to reach the server.");
        } else if (success == -2) {
            System.out.println("ERROR: Incorrect Username/Password.");
        } else if (success == -3) {
            System.out.println("ERROR: Server Error.");
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.setTagsButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.nameField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.inheritProjTagsCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.nameLabel.setText("Name:");
        this.descriptionLabel.setText("Description:");
        this.setTagsButton.setText("Set TAGS");
        this.setTagsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditProjectDatasetUI.this.setTagsButtonActionPerformed(evt);
            }
        });
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.descriptionTextArea);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditProjectDatasetUI.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditProjectDatasetUI.this.cancelButtonActionPerformed(evt);
            }
        });
        this.inheritProjTagsCheckBox.setText("Inherit from Project");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 442, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nameField, -1, 264, Short.MAX_VALUE).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addGap(221, 221, 221))).addGap(23, 23, 23)).addGroup(layout.createSequentialGroup().addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inheritProjTagsCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.setTagsButton)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.descriptionLabel)).addGroup(layout.createSequentialGroup().addComponent(this.inheritProjTagsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setTagsButton, -2, 48, -2))).addGap(10, 10, 10).addComponent(this.jScrollPane1, -1, 110, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addGap(19, 19, 19)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.nameField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Please specify at least a Name value.", "ERROR", 0);
            return;
        }
        boolean ia = this.omeroserver.isAlive();
        if (ia) {
            System.out.println("Connection alive: TRUE");
        } else {
            System.out.println("Connection alive: FALSE");
        }
        int success = -1;
        success = !ia ? -1 : 1;
        if (!ia) {
            try {
                success = this.omeroserver.initConnectionDetails(this.sessiondetails.serveraddress, this.sessiondetails.username, this.sessiondetails.password);
            }
            catch (Exception ex) {
                System.out.println("ERROR: Connection Failed!");
            }
        }
        if (success == 1) {
            String name = this.nameField.getText();
            String desc = this.descriptionTextArea.getText();
            if (this.mode == 0) {
                try {
                    System.out.println("Saving Project name and description...");
                    this.omeroserver.setName(this.omeroserver.getProject(this.objID), name);
                    this.omeroserver.setDescription(this.omeroserver.getProject(this.objID), desc);
                    for (int i = 0; i < this.tags.size(); ++i) {
                        this.omeroserver.addTag(this.omeroserver.getProject(this.objID), this.tags.get(i));
                    }
                    this.parent.getProjectsFromOMERO(this.objID);
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Editing PROJECT failed!");
                }
            } else if (this.mode == 1) {
                try {
                    System.out.println("Saving Dataset name and description...");
                    this.omeroserver.setName(this.omeroserver.getDataset(this.objID), name);
                    this.omeroserver.setDescription(this.omeroserver.getDataset(this.objID), desc);
                    for (int i = 0; i < this.tags.size(); ++i) {
                        this.omeroserver.addTag(this.omeroserver.getDataset(this.objID), this.tags.get(i));
                    }
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Editing DATASET failed!");
                }
            }
        } else if (success == -1) {
            System.out.println("ERROR: Failed to reach the server.");
        } else if (success == -2) {
            System.out.println("ERROR: Incorrect Username/Password.");
        } else if (success == -3) {
            System.out.println("ERROR: Server Error.");
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void setTagsButtonActionPerformed(ActionEvent evt) {
        if (this.nameField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Please specify at least a Name value.", "ERROR", 0);
            return;
        }
        long projID = -1L;
        long dsID = -1L;
        if (this.mode == 0) {
            projID = this.objID;
        } else if (this.mode == 1) {
            if (this.inheritProjTagsCheckBox.isSelected()) {
                projID = this.parent.getSelectedProjectId();
            }
            dsID = this.objID;
        }
        TagPanelUI tagpanelUI = new TagPanelUI(this, this.omeroserver, 3, projID, dsID, this.sessiondetails);
        tagpanelUI.setTagButtons(this.tags);
    }

    public void setTags(List<String> tgs) {
        this.tags = tgs;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }
}

