/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import omerouploader.AddRemoveFilesUI;
import omerouploader.CloseListener;
import omerouploader.ImportThread;
import omerouploader.LocalFileBrowserUI;
import omerouploader.LoggingOutputStream;
import omerouploader.LoginFrameUI;
import omerouploader.ProjectDatasetPickerUI;
import omerouploader.QueueItemList;
import omerouploader.QuitImportUI;
import omerouploader.SessionDetails;
import omerouploader.StdOutErrLevel;
import omerouploader.UploadFileQueueUI;

public class Main
extends JFrame {
    private SessionDetails sessiondetails = new SessionDetails();
    private omeroconnect.Main omeroserver = new omeroconnect.Main();
    private LoginFrameUI loginUI;
    private JLabel statusLabel;
    private LocalFileBrowserUI localfileUI;
    private UploadFileQueueUI uploadfileUI;
    private AddRemoveFilesUI addremoveUI;
    private QuitImportUI quitimportUI;
    private ProjectDatasetPickerUI projdspickerUI;
    private JTextArea logTextArea;
    private File[] localfileUI_selectedfiles = null;
    private boolean importing = false;
    private ExecutorService threadpool = Executors.newFixedThreadPool(4);
    private int importqueuesize = 0;
    public QueueItemList processqueue = new QueueItemList();

    public Main() {
        this.initComponents();
        this.redirectOutputStreams();
    }

    private void initComponents() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.setSize(1024, 600);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setTitle("OMEROUploader v1.0");
        this.statusLabel = new JLabel();
        this.statusLabel.setText("Waiting for Login...");
        this.localfileUI = new LocalFileBrowserUI(this);
        this.uploadfileUI = new UploadFileQueueUI(this);
        this.addremoveUI = new AddRemoveFilesUI(this);
        this.quitimportUI = new QuitImportUI(this);
        JPanel panel1 = new JPanel(false);
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 20;
        c.ipady = 20;
        Container importcont = new Container();
        Container logcont = new Container();
        tabbedPane.addTab("Importer", null, importcont, "Importer");
        tabbedPane.addTab("Log", null, logcont, "Log");
        tabbedPane.setTabLayoutPolicy(1);
        this.add(tabbedPane);
        importcont.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 23;
        importcont.add((Component)this.localfileUI, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.1;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 10;
        importcont.add((Component)this.addremoveUI, c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 24;
        importcont.add((Component)this.uploadfileUI, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.1;
        c.fill = 2;
        c.anchor = 20;
        importcont.add((Component)this.statusLabel, c);
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.1;
        c.fill = 0;
        c.anchor = 26;
        importcont.add((Component)this.quitimportUI, c);
        logcont.setLayout(new GridBagLayout());
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.1;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 10;
        this.logTextArea = new JTextArea();
        this.logTextArea.setEditable(false);
        JScrollPane pScroll = new JScrollPane(this.logTextArea, 20, 30);
        logcont.add((Component)pScroll, c);
        CloseListener cl = new CloseListener("Are you sure you want to exit the application", "Exit Application");
        this.addWindowListener(cl);
        this.setVisible(false);
        this.loginUI = new LoginFrameUI(this);
        this.loginUI.setLocationRelativeTo(this);
        this.loginUI.setVisible(true);
    }

    private void readLogFile() {
        try {
            this.logTextArea.read(new FileReader("logfile.log"), null);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    private void redirectOutputStreams() {
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        Logger logger = Logger.getLogger("stdout");
        LoggingOutputStream los = new LoggingOutputStream(logger, StdOutErrLevel.STDOUT, this.logTextArea);
        System.setOut(new PrintStream(los, true));
        FileHandler fh = null;
        try {
            fh = new FileHandler("logfile.log", 0x100000, 1, true);
            logger.addHandler(fh);
            logger.setLevel(Level.ALL);
            SimpleFormatter formatter = new SimpleFormatter();
            fh.setFormatter(formatter);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        String os = System.getProperty("os.name");
        if (os.equals("Windows XP")) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new Main();
            }
        });
    }

    public void loginUI_loginButton(SessionDetails ld) {
        this.sessiondetails.username = ld.username;
        this.sessiondetails.password = ld.password;
        this.sessiondetails.serveraddress = ld.serveraddress;
        int success = -1;
        try {
            success = this.omeroserver.initConnectionDetails(this.sessiondetails.serveraddress, this.sessiondetails.username, this.sessiondetails.password);
        }
        catch (Exception ex) {
            this.statusLabel.setText("ERROR: Connection Failed!");
        }
        if (success == 1) {
            this.statusLabel.setText("Connected to: " + this.sessiondetails.serveraddress);
            this.loginUI.setVisible(false);
            this.loginUI.dispose();
            this.setVisible(true);
        } else if (success == -1) {
            this.loginUI.setMessageLabel("ERROR: Failed to reach the server.");
            this.statusLabel.setText("ERROR: Connection Failed!");
        } else if (success == -2) {
            this.loginUI.setMessageLabel("ERROR: Incorrect Username/Password.");
            this.statusLabel.setText("ERROR: Connection Failed!");
        } else if (success == -3) {
            this.loginUI.setMessageLabel("ERROR: Server Error.");
            this.statusLabel.setText("ERROR: Connection Failed!");
        }
    }

    public void loginUI_quitButton() {
        this.loginUI.setVisible(false);
        this.loginUI.dispose();
        System.exit(0);
    }

    public void quitimportUI_quit() {
        WindowEvent windowClosing = new WindowEvent(this, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(windowClosing);
    }

    public void quitimportUI_import() {
        for (int i = 0; i < this.processqueue.items.size(); ++i) {
            final QueueItemList.QueueItem item = this.processqueue.items.get(i);
            final Object obj = this.uploadfileUI.getItem(i);
            String objstr = (String)obj;
            if (!objstr.contains("pending.")) continue;
            System.out.println("index: " + i + " pending.");
            System.out.println("obj: " + objstr);
            this.uploadfileUI.setQueuedItem(obj);
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    Main.this.importing = true;
                    String str = (String)obj;
                    str = str.replace("/ pending.", "/ queued.");
                    Main.this.uploadfileUI.setImportItem(str);
                    return new ImportThread(item);
                }

                public void done() {
                    if (!this.isCancelled()) {
                        String str = (String)obj;
                        str = str.replace("/ pending.", "/ importing...");
                        int index = Main.this.uploadfileUI.setDoneItem(str);
                        str = str.replace("/ importing...", "/ finished.");
                        if (Main.this.importqueuesize == index + 1) {
                            Main.this.importing = false;
                            System.out.println("FINISHED IMPORT QUEUE!");
                        }
                    }
                }
            };
            this.threadpool.execute(worker);
        }
    }

    public void quitimportUI_clearfinished() {
        int i;
        ArrayList<QueueItemList.QueueItem> objectstodelete1 = new ArrayList<QueueItemList.QueueItem>();
        ArrayList<Object> objectstodelete2 = new ArrayList<Object>();
        for (i = 0; i < this.processqueue.items.size(); ++i) {
            Object obj = this.uploadfileUI.getItem(i);
            String objstr = (String)obj;
            if (!objstr.contains("finished.")) continue;
            QueueItemList.QueueItem obj1 = this.processqueue.items.get(i);
            Object obj2 = this.uploadfileUI.getItem(i);
            objectstodelete1.add(obj1);
            objectstodelete2.add(obj2);
        }
        for (i = 0; i < objectstodelete1.size(); ++i) {
            this.processqueue.removeItem(objectstodelete1.get(i));
            this.uploadfileUI.removeItem(objectstodelete2.get(i));
        }
    }

    public void localfileUI_selectedFiles(File[] files) {
        this.localfileUI_selectedfiles = files;
    }

    public void projdspickerUI_okButton(long projid, long dsid) {
        this.localfileUI_selectedfiles = this.processqueue.getUniqueFiles(this.localfileUI_selectedfiles);
        this.processqueue.addItems(this.localfileUI_selectedfiles, projid, dsid, this.projdspickerUI.getTags());
        this.uploadfileUI.addItems(this.localfileUI_selectedfiles);
        this.localfileUI_selectedfiles = null;
        this.projdspickerUI.dispose();
        System.out.println("Import Queue: Objects Added");
        this.processqueue.printItems();
        System.out.println(this.threadpool.isTerminated());
        if (this.importing) {
            System.out.println(this.processqueue.items.size());
            this.importqueuesize = this.processqueue.items.size();
            this.quitimportUI_import();
        }
    }

    public void addremoveUI_addtoQueue() {
        if (this.localfileUI_selectedfiles != null) {
            this.projdspickerUI = new ProjectDatasetPickerUI(this, this.omeroserver, this.processqueue, this.sessiondetails);
            this.projdspickerUI.setLocationRelativeTo(this);
            this.projdspickerUI.setVisible(true);
            this.sessiondetails.localpath = this.localfileUI.getLocalPath();
            this.sessiondetails.saveLoginfile();
        }
    }

    public void addremoveUI_removefromQueue() {
        this.uploadfileUI.removeItems();
        System.out.println("Import Queue: Objects Removed");
        this.processqueue.printItems();
    }
}

