/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import omeroconnect.Main;
import omerouploader.ProjectDatasetPickerUI;
import omerouploader.SessionDetails;
import omerouploader.TagPanelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProjectDatasetUI
extends JFrame {
    List<String> tags = new ArrayList<String>();
    private ProjectDatasetPickerUI parent;
    private Main omeroserver;
    private SessionDetails sessiondetails;
    private int mode;
    private JButton cancelButton;
    private JLabel descriptionLabel;
    private JTextArea descriptionTextArea;
    private JCheckBox inheritProjTagsCheckBox;
    private JScrollPane jScrollPane1;
    private JTextField nameField;
    private JLabel nameLabel;
    private JButton okButton;
    private JButton setTagsButton;

    public NewProjectDatasetUI(ProjectDatasetPickerUI p, Main os_, String objectype, SessionDetails sd) {
        this.initComponents();
        this.parent = p;
        this.omeroserver = os_;
        this.sessiondetails = sd;
        this.mode = -1;
        this.tags.clear();
        if (objectype.equals("Project")) {
            this.setTitle("OMEROUploader - New Project");
            this.mode = 0;
            this.inheritProjTagsCheckBox.setVisible(false);
        } else if (objectype.equals("Dataset")) {
            this.setTitle("OMEROUploader - New Dataset");
            this.mode = 1;
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.setTagsButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.nameField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.inheritProjTagsCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.nameLabel.setText("Name:");
        this.descriptionLabel.setText("Description:");
        this.setTagsButton.setText("Set TAGS");
        this.setTagsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewProjectDatasetUI.this.setTagsButtonActionPerformed(evt);
            }
        });
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.descriptionTextArea);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewProjectDatasetUI.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewProjectDatasetUI.this.cancelButtonActionPerformed(evt);
            }
        });
        this.inheritProjTagsCheckBox.setText("Inherit from Project");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 442, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nameField, -1, 264, Short.MAX_VALUE).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addGap(221, 221, 221))).addGap(23, 23, 23)).addGroup(layout.createSequentialGroup().addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inheritProjTagsCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.setTagsButton)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.descriptionLabel)).addGroup(layout.createSequentialGroup().addComponent(this.inheritProjTagsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setTagsButton, -2, 48, -2))).addGap(10, 10, 10).addComponent(this.jScrollPane1, -1, 110, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addGap(19, 19, 19)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.nameField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Please specify at least a Name value.", "ERROR", 0);
            return;
        }
        boolean ia = this.omeroserver.isAlive();
        if (ia) {
            System.out.println("Connection alive: TRUE");
        } else {
            System.out.println("Connection alive: FALSE");
        }
        int success = -1;
        success = !ia ? -1 : 1;
        if (!ia) {
            try {
                success = this.omeroserver.initConnectionDetails(this.sessiondetails.serveraddress, this.sessiondetails.username, this.sessiondetails.password);
            }
            catch (Exception ex) {
                System.out.println("ERROR: Connection Failed!");
            }
        }
        if (success == 1) {
            int i;
            if (this.mode == 0) {
                try {
                    System.out.println("Creating a new Project...");
                    long projectid = this.omeroserver.createProject(this.nameField.getText(), this.descriptionTextArea.getText()).getId().getValue();
                    System.out.println("Setting tags to the new Project...");
                    for (i = 0; i < this.tags.size(); ++i) {
                        this.omeroserver.addTag(this.omeroserver.getProject(projectid), this.tags.get(i));
                    }
                    this.parent.getProjectsDatasetsFromOMERO();
                    this.parent.setSelectedProject(projectid);
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Creating new PROJECT failed!");
                }
            }
            if (this.mode == 1) {
                try {
                    System.out.println("Creating a new Dataset...");
                    long datasetid = this.omeroserver.createDataset(this.nameField.getText(), this.descriptionTextArea.getText()).getId().getValue();
                    System.out.println("Setting tags to the new Dataset...");
                    for (i = 0; i < this.tags.size(); ++i) {
                        this.omeroserver.addTag(this.omeroserver.getDataset(datasetid), this.tags.get(i));
                    }
                    this.omeroserver.attachDatasetToProject(this.omeroserver.getProject(this.parent.getSelectedProjectId()), this.omeroserver.getDataset(datasetid));
                    this.parent.setSelectedDataset(datasetid);
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Creating new DATASET failed!");
                }
            }
        } else if (success == -1) {
            System.out.println("ERROR: Failed to reach the server.");
        } else if (success == -2) {
            System.out.println("ERROR: Incorrect Username/Password.");
        } else if (success == -3) {
            System.out.println("ERROR: Server Error.");
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void setTagsButtonActionPerformed(ActionEvent evt) {
        if (this.nameField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Please specify at least a Name value.", "ERROR", 0);
            return;
        }
        long projID = -1L;
        long dsID = -1L;
        if (this.inheritProjTagsCheckBox.isSelected()) {
            projID = this.parent.getSelectedProjectId();
        }
        TagPanelUI tagpanelUI = new TagPanelUI(this, this.omeroserver, 1, projID, dsID, this.sessiondetails);
        tagpanelUI.setTagButtons(this.tags);
    }

    public void setTags(List<String> tgs) {
        this.tags = tgs;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }
}

