/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueItemList {
    List<QueueItem> items = new ArrayList<QueueItem>();

    QueueItemList() {
    }

    public void addItems(File[] files, long projid, long dsid, List<String> tgs) {
        int offset = this.items.size();
        for (int i = 0; i < files.length; ++i) {
            this.items.add(new QueueItem(files[i]));
            this.items.get((int)(offset + i)).projectid = projid;
            this.items.get((int)(offset + i)).datasetid = dsid;
            this.items.get((int)(offset + i)).tags = tgs;
            this.items.get((int)(offset + i)).optdata = files[i].isDirectory();
        }
    }

    public void removeItem(int index) {
        this.items.remove(index);
    }

    public void removeItem(Object obj) {
        this.items.remove(obj);
    }

    public File[] getUniqueFiles(File[] infiles) {
        ArrayList<File> outfiles = new ArrayList<File>();
        for (int j = 0; j < infiles.length; ++j) {
            int unique_flag = 1;
            for (int i = 0; i < this.items.size(); ++i) {
                QueueItem item = this.items.get(i);
                if (!item.fileobj.getPath().equals(infiles[j].getPath())) continue;
                unique_flag = -1;
            }
            if (unique_flag != true) continue;
            outfiles.add(infiles[j]);
        }
        return outfiles.toArray(new File[0]);
    }

    public void printItems() {
        if (this.items.isEmpty()) {
            return;
        }
        System.out.println("--------------------IMPORT QUEUE------------------------");
        for (int i = 0; i < this.items.size(); ++i) {
            QueueItem item = this.items.get(i);
            System.out.println("Item: " + (i + 1) + " of " + this.items.size());
            System.out.println();
            System.out.println("\tfilename: " + item.fileobj.getName());
            System.out.println("\tpath: " + item.fileobj.getPath());
            System.out.println("\tisOPT: " + item.optdata);
            System.out.println("\tTAGS: ");
            for (int j = 0; j < item.tags.size(); ++j) {
                String tag = item.tags.get(j);
                System.out.println("\t\t" + tag);
            }
            System.out.println("\tProjectID: " + item.projectid);
            System.out.println("\tDatasetID: " + item.datasetid);
        }
        System.out.println("--------------------------------------------------------");
    }

    public class QueueItem {
        public boolean optdata;
        public File fileobj;
        public List<String> tags;
        public long projectid;
        public long datasetid;

        QueueItem(File file) {
            this.fileobj = file;
            this.tags = new ArrayList<String>();
            this.projectid = -1L;
            this.datasetid = -1L;
        }
    }
}

