/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import omeroconnect.Main;
import omerouploader.EditProjectDatasetUI;
import omerouploader.NewProjectDatasetUI;
import omerouploader.ProjectDatasetPickerUI;
import omerouploader.SessionDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagPanelUI
extends JFrame {
    private JFrame parent;
    private Main omeroserver;
    private List<Main.TagSets> tagsets;
    private List<String> projectTags;
    private List<String> datasetTags;
    private List<JLabel> tagsetLabels = null;
    private List<List<JToggleButton>> tagToggleButtons = null;
    private SessionDetails sessiondetails;
    private int mode;

    public TagPanelUI(JFrame p, Main os, int m, long iProjID, long iDsID, SessionDetails sd) {
        this.setTitle("OMEROUploader - TAG Selector");
        this.parent = p;
        this.omeroserver = os;
        this.mode = m;
        this.sessiondetails = sd;
        boolean ia = this.omeroserver.isAlive();
        if (ia) {
            System.out.println("Connection alive: TRUE");
        } else {
            System.out.println("Connection alive: FALSE");
        }
        int success = -1;
        success = !ia ? -1 : 1;
        if (!ia) {
            try {
                success = this.omeroserver.initConnectionDetails(this.sessiondetails.serveraddress, this.sessiondetails.username, this.sessiondetails.password);
            }
            catch (Exception ex) {
                System.out.println("ERROR: Connection Failed!");
            }
        }
        if (success == 1) {
            try {
                this.projectTags = new ArrayList<String>();
                this.datasetTags = new ArrayList<String>();
                this.tagsets = this.omeroserver.getTagsetsAndTags();
                if (iProjID != -1L) {
                    this.projectTags = this.omeroserver.getTags(this.omeroserver.getProject(iProjID));
                }
                if (iDsID != -1L) {
                    this.datasetTags = this.omeroserver.getTags(this.omeroserver.getDataset(iDsID));
                }
            }
            catch (Exception ex) {
                System.out.println("ERROR: Failed to retrieve tagsets and tags.");
                System.out.println(ex.getMessage());
            }
        } else if (success == -1) {
            System.out.println("ERROR: Failed to reach the server.");
        } else if (success == -2) {
            System.out.println("ERROR: Incorrect Username/Password.");
        } else if (success == -3) {
            System.out.println("ERROR: Server Error.");
        }
        this.initComponents();
    }

    public void setTagButtons(List<String> tgs) {
        for (int i = 0; i < this.tagToggleButtons.size(); ++i) {
            for (int j = 0; j < this.tagToggleButtons.get(i).size(); ++j) {
                for (int k = 0; k < tgs.size(); ++k) {
                    if (!tgs.get(k).equals(this.tagToggleButtons.get(i).get(j).getText())) continue;
                    this.tagToggleButtons.get(i).get(j).setSelected(true);
                }
            }
        }
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        this.tagsetLabels = new ArrayList<JLabel>();
        this.tagToggleButtons = new ArrayList<List<JToggleButton>>();
        Container maincontainer = new Container();
        GridBagLayout layout = new GridBagLayout();
        maincontainer.setLayout(layout);
        int maxtags = 0;
        for (int i = 0; i < this.tagsets.size(); ++i) {
            Main.TagSets tagset = this.tagsets.get(i);
            if (tagset.tags.isEmpty()) continue;
            c.ipadx = 10;
            c.ipady = 10;
            c.gridy = i;
            c.fill = 1;
            c.anchor = 10;
            c.insets = i == 0 ? new Insets(40, 20, 10, 10) : new Insets(10, 20, 10, 10);
            this.tagsetLabels.add(new JLabel());
            this.tagsetLabels.get(i).setText(tagset.tagset);
            this.tagsetLabels.get(i).setHorizontalAlignment(4);
            this.tagsetLabels.get(i).setForeground(Color.DARK_GRAY);
            maincontainer.add((Component)this.tagsetLabels.get(i), c);
            this.tagToggleButtons.add(new ArrayList());
            for (int j = 0; j < tagset.tags.size(); ++j) {
                int k;
                this.tagToggleButtons.get(i).add(new JToggleButton());
                this.tagToggleButtons.get(i).get(j).setText((String)tagset.tags.get(j));
                this.tagToggleButtons.get(i).get(j).setBorder(BorderFactory.createEtchedBorder());
                for (k = 0; k < this.projectTags.size(); ++k) {
                    if (!this.projectTags.get(k).equals(tagset.tags.get(j))) continue;
                    this.tagToggleButtons.get(i).get(j).setSelected(true);
                }
                for (k = 0; k < this.datasetTags.size(); ++k) {
                    if (!this.datasetTags.get(k).equals(tagset.tags.get(j))) continue;
                    this.tagToggleButtons.get(i).get(j).setSelected(true);
                }
                c.insets = i == 0 ? new Insets(40, 1, 1, 1) : new Insets(1, 1, 1, 1);
                maincontainer.add((Component)this.tagToggleButtons.get(i).get(j), c);
            }
            if (maxtags >= tagset.tags.size()) continue;
            maxtags = tagset.tags.size();
        }
        Container okcancelcontainer = new Container();
        okcancelcontainer.setLayout(new FlowLayout());
        JButton okButton = new JButton();
        okButton.setText("OK");
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        okcancelcontainer.add(cancelButton);
        okcancelcontainer.add(okButton);
        c.gridx = maxtags + 1;
        c.gridy = this.tagsets.size();
        c.fill = 1;
        c.anchor = 26;
        maincontainer.add((Component)okcancelcontainer, c);
        JScrollPane pScroll = new JScrollPane(maincontainer, 20, 30);
        pScroll.setBorder(BorderFactory.createEtchedBorder());
        this.add(pScroll);
        this.pack();
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagPanelUI.this.okButtonActionPerformed(evt);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagPanelUI.this.cancelButtonActionPerformed(evt);
            }
        });
        this.setLocationRelativeTo(this.parent.getContentPane());
        this.setVisible(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.tagsetLabels == null) {
            return;
        }
        if (this.tagToggleButtons == null) {
            return;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (int i = 0; i < this.tagsetLabels.size(); ++i) {
            for (int j = 0; j < this.tagToggleButtons.get(i).size(); ++j) {
                if (!this.tagToggleButtons.get(i).get(j).isSelected()) continue;
                tags.add(this.tagToggleButtons.get(i).get(j).getText());
            }
        }
        if (this.mode == 1) {
            System.out.println("Setting tags for NewProjectDatasetUI object");
            NewProjectDatasetUI newprojdatasetUI = (NewProjectDatasetUI)this.parent;
            newprojdatasetUI.setTags(tags);
        } else if (this.mode == 2) {
            System.out.println("Setting tags for ProjectDatasetPickerUI object");
            ProjectDatasetPickerUI projectdatasetpickerUI = (ProjectDatasetPickerUI)this.parent;
            projectdatasetpickerUI.setTags(tags);
        } else if (this.mode == 3) {
            System.out.println("Setting tags for EditProjectDatasetUI object");
            EditProjectDatasetUI editprojdatasetUI = (EditProjectDatasetUI)this.parent;
            editprojdatasetUI.setTags(tags);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

